/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.repos;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ExtensionRegistry;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.jndi.Names;
import oracle.jdevimpl.vcs.svn.AlreadyExistsException;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.repos.SVNConnectionFileConstansts;
import oracle.jdevimpl.vcs.svn.repos.io.ObjectFactory;
import oracle.jdevimpl.vcs.svn.repos.io.SvnRepositoriesType;
import oracle.jdevimpl.vcs.svn.repos.io.SvnRepositoryType;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNRepositoryManager
implements SVNConnectionFileConstansts {
    public static final String STORE_URL_BINDING_NAME = SVNRepositoryManager.class.getName() + ".storeUrl";
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNRepositoryManager.class.getName());
    private static SVNRepositoryManager sInstance;
    private JAXBContext _ioContext;
    private final Map<String, SVNRepositoryInfo> _index = new HashMap<String, SVNRepositoryInfo>(5);
    private URL _storeUrl;
    private boolean _loaded = false;

    public static synchronized SVNRepositoryManager getInstance() {
        if (sInstance == null) {
            sInstance = new SVNRepositoryManager();
        }
        return sInstance;
    }

    public synchronized void add(SVNRepositoryInfo reposInfo) throws AlreadyExistsException {
        SVNUrl url = reposInfo.getURL();
        if (url == null) {
            throw new NullPointerException();
        }
        if (this.getIndex().containsKey(reposInfo.getAlias())) {
            throw new AlreadyExistsException(Resource.get("NAV_CONNECTION_WIZARD_COMMIT_NON_UNIQUE"));
        }
        Map<String, SVNRepositoryInfo> data = this.getIndex();
        Iterator<String> it = data.keySet().iterator();
        while (it.hasNext()) {
            SVNRepositoryInfo info = data.get(it.next());
            if (!info.getURL().equals((Object)reposInfo.getURL())) continue;
            throw new AlreadyExistsException(Resource.get("NAV_CONNECTION_WIZARD_COMMIT_NON_UNIQUE_URL"));
        }
        this.getIndex().put(reposInfo.getAlias(), reposInfo);
    }

    public synchronized SVNRepositoryInfo get(String name) {
        return this.getIndex().get(name);
    }

    public synchronized void remove(String name) {
        this._index.remove(name);
    }

    public synchronized Collection list() {
        if (this.getIndex().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SVNRepositoryInfo> l = new ArrayList<SVNRepositoryInfo>(this._index.size() * 2);
        Iterator<Map.Entry<String, SVNRepositoryInfo>> it = this._index.entrySet().iterator();
        while (it.hasNext()) {
            l.add(it.next().getValue());
        }
        Collections.sort(l, new Comparator(){

            public int compare(Object o1, Object o2) {
                SVNRepositoryInfo repos1 = (SVNRepositoryInfo)o1;
                SVNRepositoryInfo repos2 = (SVNRepositoryInfo)o2;
                String comparable1 = repos1.getAlias() != null ? repos1.getAlias() : repos1.getURL().toString();
                String comparable2 = repos2.getAlias() != null ? repos2.getAlias() : repos2.getURL().toString();
                return comparable1.compareTo(comparable2);
            }
        });
        return Collections.unmodifiableList(l);
    }

    public synchronized boolean isEmpty() {
        return this.getIndex().isEmpty();
    }

    public synchronized void clear() {
        this.getIndex().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void load() {
        try {
            if (this._ioContext == null) {
                throw new JAXBException("jaxb context unavalable");
            }
            this._index.clear();
            this.indexIoStructures(this.unmarshall());
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "unable to load repositories.xml", e);
        }
        finally {
            this._loaded = true;
        }
    }

    public synchronized void reload() {
        this.clear();
        this._loaded = false;
        this.load();
    }

    public synchronized void save() {
        try {
            if (this._ioContext == null) {
                throw new JAXBException("jaxb context unavailable");
            }
            ObjectFactory objectFact = new ObjectFactory();
            this.marshall(this.createIoStructures(objectFact), objectFact);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "unable to write repositories.xml", e);
        }
    }

    public boolean existsName(SVNRepositoryInfo reposInfo) {
        return this.getIndex().containsKey(reposInfo.getAlias());
    }

    protected URL getLocation() {
        return this._storeUrl;
    }

    private Map<String, SVNRepositoryInfo> getIndex() {
        if (!this._loaded) {
            this.load();
        }
        return this._index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List unmarshall() throws JAXBException, IOException {
        if (!URLFileSystem.exists((URL)this._storeUrl)) {
            return Collections.EMPTY_LIST;
        }
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine("loading repository information from " + URLFileSystem.getPlatformPathName((URL)this._storeUrl));
        }
        Unmarshaller ioWorker = this._ioContext.createUnmarshaller();
        InputStream is = null;
        try {
            is = new BufferedInputStream(URLFileSystem.openInputStream((URL)this._storeUrl));
            JAXBElement jaxBElm = (JAXBElement)ioWorker.unmarshal(is);
            SvnRepositoriesType repositories = (SvnRepositoriesType)jaxBElm.getValue();
            List<SvnRepositoryType> list = repositories.getSvnRepository();
            return list;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshall(List<SvnRepositoryType> ioStructures, ObjectFactory objectFact) throws JAXBException, IOException {
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine("writing repository information to " + URLFileSystem.getPlatformPathName((URL)this._storeUrl));
        }
        Marshaller ioWorker = this._ioContext.createMarshaller();
        ioWorker.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        SvnRepositoriesType repositories = objectFact.createSvnRepositoriesType();
        repositories.getSvnRepository().addAll(ioStructures);
        JAXBElement<SvnRepositoriesType> jaxBElm = objectFact.createSvnRepositories(repositories);
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(URLFileSystem.getPlatformPathName((URL)this._storeUrl), false));
            ioWorker.marshal(jaxBElm, os);
            os.flush();
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private void indexIoStructures(List ioStructures) {
        Iterator it = ioStructures.iterator();
        while (it.hasNext()) {
            try {
                SvnRepositoryType reposType = (SvnRepositoryType)it.next();
                SVNRepositoryInfo reposInfo = SVNUtil.toReposInfo(reposType);
                this._index.put(reposInfo.getAlias(), reposInfo);
            }
            catch (MalformedURLException e) {
                sLogger.log(Level.WARNING, "ignoring repository with invalid url", e);
            }
        }
    }

    private List<SvnRepositoryType> createIoStructures(ObjectFactory objectFact) {
        if (this._index.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SvnRepositoryType> ioStructures = new ArrayList<SvnRepositoryType>(this._index.size() * 2);
        Iterator<Map.Entry<String, SVNRepositoryInfo>> it = this._index.entrySet().iterator();
        while (it.hasNext()) {
            SVNRepositoryInfo reposInfo = it.next().getValue();
            ioStructures.add(SVNUtil.toReposType(reposInfo, objectFact));
        }
        return ioStructures;
    }

    private SVNRepositoryManager() {
        String location = null;
        try {
            location = (String)Names.lookup((Context)new InitialContext(), (String)STORE_URL_BINDING_NAME);
            if (location == null) {
                throw new NamingException();
            }
        }
        catch (NamingException ne) {
            location = System.getProperty("user.home", ".");
        }
        this._storeUrl = URLFactory.newFileURL((String)(location + File.separator + "repositories.xml"));
        try {
            this._ioContext = JAXBContext.newInstance((String)"oracle.jdevimpl.vcs.svn.repos.io", (ClassLoader)ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.subversion"));
        }
        catch (JAXBException je) {
            sLogger.log(Level.WARNING, "unable to obtain binding context for repositories.xml", je);
        }
    }
}

