/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.ui;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ExtensionRegistry;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.controls.ConnectionImportExportPanel;
import oracle.jdevimpl.vcs.svn.AlreadyExistsException;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.repos.io.ObjectFactory;
import oracle.jdevimpl.vcs.svn.repos.io.SvnRepositoriesType;
import oracle.jdevimpl.vcs.svn.repos.io.SvnRepositoryType;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNReposInfoListRenderer;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public class SVNRepositoryImportExportPanel
extends ConnectionImportExportPanel {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNRepositoryImportExportPanel.class.getName());

    public SVNRepositoryImportExportPanel() {
        this.setConnectionsCellRenderer(new SVNReposInfoListRenderer());
    }

    protected Object[] getExportableConnections() {
        SVNRepositoryManager reposMgr = SVNRepositoryManager.getInstance();
        if (!reposMgr.isEmpty()) {
            Collection connections = reposMgr.list();
            ArrayList exportables = new ArrayList(connections.size() * 2);
            Iterator it = connections.iterator();
            while (it.hasNext()) {
                exportables.add(it.next());
            }
            return exportables.toArray(new Object[exportables.size()]);
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exportConnections(String filename) {
        OutputStream os = null;
        try {
            Object[] selectedConnections = this.getSelectedConnections();
            if (selectedConnections != null && selectedConnections.length > 0) {
                ObjectFactory of = new ObjectFactory();
                SvnRepositoriesType repositories = of.createSvnRepositoriesType();
                for (int i = 0; i < selectedConnections.length; ++i) {
                    repositories.getSvnRepository().add(SVNUtil.toReposType((SVNRepositoryInfo)selectedConnections[i], of));
                }
                JAXBElement<SvnRepositoriesType> jaxBElm = of.createSvnRepositories(repositories);
                os = new FileOutputStream(filename);
                JAXBContext ioContext = JAXBContext.newInstance((String)"oracle.jdevimpl.vcs.svn.repos.io", (ClassLoader)ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.subversion"));
                Marshaller ioWorker = ioContext.createMarshaller();
                ioWorker.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                ioWorker.marshal(jaxBElm, os);
                os.flush();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "failed to marshall repository connections", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception ex) {
                sLogger.log(Level.WARNING, "failed to close " + filename);
            }
        }
    }

    protected void filenameChanged(String filename) {
        File sourceFile = new File(filename);
        if (!this.isImportMode() || !sourceFile.exists()) {
            return;
        }
        try {
            JAXBContext ioContext = JAXBContext.newInstance((String)"oracle.jdevimpl.vcs.svn.repos.io", (ClassLoader)ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.subversion"));
            Unmarshaller ioWorker = ioContext.createUnmarshaller();
            JAXBElement jaxBElm = (JAXBElement)ioWorker.unmarshal(sourceFile);
            SvnRepositoriesType repositories = (SvnRepositoriesType)jaxBElm.getValue();
            List<SvnRepositoryType> reposList = repositories.getSvnRepository();
            if (reposList == null || reposList.isEmpty()) {
                this.setConnections(new Object[0]);
            } else {
                ArrayList<SVNRepositoryInfo> c = new ArrayList<SVNRepositoryInfo>(reposList.size() * 2);
                Iterator<SvnRepositoryType> it = reposList.iterator();
                while (it.hasNext()) {
                    c.add(SVNUtil.toReposInfo(it.next()));
                }
                this.setConnections(c.toArray(new Object[c.size()]));
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "failed to unmarshall repository connections", e);
        }
    }

    protected boolean importConnections() {
        Object[] selected = this.getSelectedConnections();
        if (selected != null && selected.length > 0) {
            SVNRepositoryNavigatorAPI api = SVNRepositoryNavigatorAPI.getInstance();
            for (int i = 0; i < selected.length; ++i) {
                SVNRepositoryInfo reposInfo = null;
                try {
                    reposInfo = (SVNRepositoryInfo)selected[i];
                    api.createRepositoryConnection(reposInfo);
                    continue;
                }
                catch (ClassCastException cce) {
                    sLogger.warning("cannot import repository connection object of type " + selected[i].getClass().getName());
                    continue;
                }
                catch (AlreadyExistsException aee) {
                    SVNRepositoryNode existingNode;
                    if (!this.confirmOverwrite(reposInfo) || (existingNode = api.getRepositoryNode(reposInfo.getURL())) == null) continue;
                    try {
                        api.removeRepositoryConnection(existingNode);
                        api.createRepositoryConnection(reposInfo);
                        continue;
                    }
                    catch (AlreadyExistsException aae2) {
                        throw new IllegalStateException(reposInfo.getURL().toString());
                    }
                }
            }
        }
        return true;
    }

    protected void setURLChooserFilter(URLChooser urc, URLFilter filter) {
        URLFilter[] filters = urc.getChooseableURLFilters();
        URLFilter xmlFilter = null;
        for (int i = 0; i < filters.length; ++i) {
            if (!filters[i].accept(URLFactory.newFileURL((String)"*.xml"))) continue;
            xmlFilter = filters[i];
        }
        urc.setURLFilter(xmlFilter);
    }

    private boolean confirmOverwrite(SVNRepositoryInfo reposInfo) {
        return MessageDialog.confirm((Component)((Object)this), (Object)Resource.format("REPOS_CONN_IMP_OVERWRITE_CONFIRM_MESSAGE", reposInfo.getURL().toString()), (String)Resource.get("REPOS_CONN_IMP_OVERWRITE_CONFIRM_TITLE"), (String)"f1_confirmoverwriteconnection_html");
    }
}

