/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.prefs.SVNEnvironmentPrefs;
import oracle.jdevimpl.vcs.svn.util.NullNotificationListener;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;

public final class SVNRepositoryInfoValidator {
    private static final NullNotificationListener sNullListener = new NullNotificationListener();
    private SVNRepositoryInfo _reposInfo;
    private ISVNClientAdapter _client;
    private ISVNNotifyListener _listener;

    public SVNRepositoryInfoValidator(SVNRepositoryInfo reposInfo, ISVNClientAdapter client) {
        if (reposInfo == null || client == null) {
            throw new NullPointerException();
        }
        this._reposInfo = reposInfo;
        this._client = client;
    }

    public SVNRepositoryInfoValidator(SVNRepositoryInfo reposInfo, ISVNClientAdapter client, ISVNNotifyListener notificationListener) {
        this(reposInfo, client);
        this._listener = notificationListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() throws TimeoutException {
        SVNEnvironmentPrefs prefs = SVNEnvironmentPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
        this._client.addNotifyListener(this.getNotificationListener());
        InfoRunnable ir = new InfoRunnable();
        try {
            SVNClientInteraction.getInstance().beginInteraction(this._client, this._reposInfo);
            Thread t = new Thread((Runnable)ir, "SVNRepositoryInfoValidator");
            t.start();
            t.join(prefs.getOperationTimeout() * 1000);
            if (ir._isRepoValid == null) {
                throw new TimeoutException();
            }
            boolean bl = ir._isRepoValid;
            return bl;
        }
        catch (TimeoutException te) {
            throw te;
        }
        catch (Exception e) {
            SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
            this._client.removeNotifyListener(this.getNotificationListener());
        }
    }

    private ISVNNotifyListener getNotificationListener() {
        return this._listener != null ? this._listener : sNullListener;
    }

    public static final class TimeoutException
    extends Exception {
    }

    private final class InfoRunnable
    implements Runnable {
        private Boolean _isRepoValid = null;

        private InfoRunnable() {
        }

        @Override
        public void run() {
            try {
                ISVNInfo info = SVNRepositoryInfoValidator.this._client.getInfo(SVNRepositoryInfoValidator.this._reposInfo.getURL());
                this._isRepoValid = info != null && info.getRevision() != null;
            }
            catch (Exception ie) {
                this._isRepoValid = false;
            }
        }
    }
}

