/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.usages.UsageData;
import oracle.ide.usages.UsagesTracker;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.codeex.Base64;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.nav.ConnectionNode;
import oracle.jdeveloper.vcs.nav.ConnectionNodeDecorator;
import oracle.jdeveloper.vcs.nav.ConnectionProvider;
import oracle.jdeveloper.vcs.spi.VCSSingleWorkingCopyLocator;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.svn.SVNAuthenticationManager;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.adapter.OISVNClientAdapter;
import oracle.jdevimpl.vcs.svn.client.SVNClient;
import oracle.jdevimpl.vcs.svn.client.SVNClientRegistry;
import oracle.jdevimpl.vcs.svn.model.SVNAuthInfo;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.op.SVNOperationCreateConnection;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.repos.io.ObjectFactory;
import oracle.jdevimpl.vcs.svn.repos.io.SvnRepositoryType;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNWorkingCopyNonProjectBased;
import oracle.security.misc.Checksum;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public final class SVNUtil {
    public static ISVNClientAdapter getIDEClientAdapter() throws SVNClientException {
        return SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID);
    }

    public static Collection<SVNStatus> getSVNStatus(SVNStatusClient client, URL dir) throws SVNException {
        final ArrayList<SVNStatus> statuses = new ArrayList<SVNStatus>();
        ISVNStatusHandler handler = new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) {
                statuses.add(status);
            }
        };
        ArrayList changelist = new ArrayList();
        long stat = client.doStatus(SVNUtil.toFile(dir), null, SVNDepth.FILES, false, true, true, false, handler, changelist);
        return statuses;
    }

    public static ISVNClientAdapter getClientAdapter(Object context) throws SVNClientException {
        return SVNUtil.getClientAdapter(context, context);
    }

    public static ISVNClientAdapter getClientAdapter(Object clientContext, Object adapterContext) throws SVNClientException {
        SVNClient client = SVNClientRegistry.getInstance().getContextClient(clientContext);
        return client.getManagedAdapter(adapterContext);
    }

    public static OISVNClientAdapter getIdeOISVNClientAdapter() throws SVNClientException {
        return SVNUtil.toOISVNClientAdapter(SVNUtil.getIDEClientAdapter());
    }

    public static URL getConfigDirectory() {
        SVNClient client = SVNClientRegistry.getInstance().getContextClient(SVNProfile.IDE_CLIENT_CONTEXT_ID);
        return client.getConfigUrl();
    }

    public static URL getConfigDirectory(Object clientContext) {
        SVNClient client = SVNClientRegistry.getInstance().getContextClient(clientContext);
        return client.getConfigUrl();
    }

    public static OISVNClientAdapter toOISVNClientAdapter(ISVNClientAdapter adapter) throws SVNClientException {
        if (adapter instanceof OISVNClientAdapter) {
            return (OISVNClientAdapter)adapter;
        }
        SVNProfile.getQualifiedLogger(SVNUtil.class.getName()).info("Error creating instance of OISVNClient ");
        throw new SVNClientException(Resource.get("ERROR_INIT_CLIENT"));
    }

    public static String getCompareIdentifier(URL source, SVNRevision revision) {
        return SVNUtil.getCompareIdentifier(URLFileSystem.getPlatformPathName((URL)source), revision);
    }

    public static String getCompareIdentifier(String path, SVNRevision revision) {
        if (SVNRevision.HEAD.equals((Object)revision)) {
            return Resource.format("HISTORICAL_RESOURCE_IDENTIFIER_HEAD", path);
        }
        return Resource.format("HISTORICAL_RESOURCE_IDENTIFIER_RNUM", revision.toString(), path);
    }

    public static String getPath(SVNUrl url) {
        if (url == null) {
            return null;
        }
        String[] segments = url.getPathSegments();
        FastStringBuffer buff = new FastStringBuffer(segments.length * 20);
        for (int i = 0; i < segments.length; ++i) {
            buff.append(segments[i]);
            if (i + 1 >= segments.length) continue;
            buff.append('/');
        }
        return buff.toString();
    }

    public static File toFile(URL sourceUrl) {
        return new File(URLFileSystem.getPlatformPathName((URL)sourceUrl));
    }

    public static File[] toFiles(URL[] urls) {
        if (urls == null) {
            return new File[0];
        }
        File[] files = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            files[i] = new File(URLFileSystem.getPlatformPathName((URL)urls[i]));
        }
        return files;
    }

    public static SVNUrl toSVNUrl(URL sourceUrl) throws MalformedURLException {
        if (sourceUrl == null) {
            return null;
        }
        if ("file".equals(sourceUrl.getProtocol())) {
            String path = URLFileSystem.getPlatformPathName((URL)sourceUrl);
            if ((path = path.replace(File.separatorChar, '/')).length() > 0 && path.charAt(0) == '/') {
                return new SVNUrl("file://" + path);
            }
            return new SVNUrl("file:///" + path);
        }
        return new SVNUrl(sourceUrl.toExternalForm());
    }

    public static SVNURL toSVNURL(SVNUrl url) {
        StringBuilder sb = new StringBuilder();
        String[] segments = url.getPathSegments();
        for (int s = 0; s < segments.length; ++s) {
            if (s > 0) {
                sb.append('/');
            }
            sb.append(segments[s]);
        }
        try {
            String host = url.getHost();
            if (host.contains("@")) {
                host = host.substring(host.indexOf(64) + 1, host.length());
            }
            return SVNURL.create((String)url.getProtocol(), null, (String)host, (int)url.getPort(), (String)sb.toString(), (boolean)false);
        }
        catch (SVNException e) {
            FeedbackManager.reportException((String)"Failed to convert SVNUrl to SVNURL", (Throwable)e);
            return null;
        }
    }

    public static SVNURL toSVNURL(URL url) {
        try {
            SVNURL surl = SVNURL.create((String)url.getProtocol(), (String)url.getUserInfo(), (String)url.getHost(), (int)url.getPort(), (String)url.getPath(), (boolean)false);
            return surl;
        }
        catch (SVNException e) {
            FeedbackManager.reportException((String)"Failed to convert url to SVNURL", (Throwable)e);
            return null;
        }
    }

    public static String encodeWhiteSpace(SVNUrl svnurl) {
        return svnurl.toString().replaceAll(" ", "%20");
    }

    public static URL toURL(File file) {
        if (file.isDirectory()) {
            return URLFactory.newDirURL((String)file.toString());
        }
        return URLFactory.newFileURL((String)file.toString());
    }

    public static URL[] toURLs(File[] files) {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            urls[i] = SVNUtil.toURL(files[i]);
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNNodeKind getSVNNodeKind(SVNUrl svnurl) {
        if (svnurl != null) {
            try {
                ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.SVNUTIL_ADAPTER_CONTEXT_ID);
                SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.resolveRepository(svnurl));
                ISVNInfo info = client.getInfo(svnurl);
                if (info == null) {
                    SVNNodeKind sVNNodeKind = null;
                    return sVNNodeKind;
                }
                SVNNodeKind sVNNodeKind = info.getNodeKind();
                return sVNNodeKind;
            }
            catch (SVNClientException e) {
                SVNProfile.getQualifiedLogger(SVNUtil.class.getName()).warning(e.getMessage());
            }
            finally {
                SVNClientInteraction.getInstance().endInteraction();
            }
        }
        return null;
    }

    public static boolean isRepositoryNavigatorView(Context context) {
        if (context != null) {
            return SVNUtil.isRepositoryNavigatorView(context.getView());
        }
        return false;
    }

    public static boolean isRepositoryNavigatorView(View view) {
        return ConnectionProvider.isVersioningConnectionView((View)view);
    }

    public static SVNRemoteNode getSVNRemoteNode(Context context) {
        SVNRemoteNode remoteNode = null;
        if (context != null) {
            ConnectionNode cNode;
            Node node = context.getNode();
            if (node != null && node instanceof ConnectionNodeDecorator && (cNode = ((ConnectionNodeDecorator)node).getConnectionNode()) instanceof SVNRemoteNode) {
                remoteNode = (SVNRemoteNode)cNode;
            }
            if (node != null && node instanceof SVNRemoteNode) {
                remoteNode = (SVNRemoteNode)node;
            }
        }
        return remoteNode;
    }

    public static SVNRemoteNode[] getSVNRemoteNodes(Context context) {
        Element[] selection;
        ArrayList<Element> nodes = null;
        if (context != null && (selection = context.getSelection()) != null) {
            for (int i = 0; i < selection.length; ++i) {
                if (!(selection[i] instanceof SVNRemoteNode)) continue;
                if (nodes == null) {
                    nodes = new ArrayList<Element>(selection.length * 2);
                }
                nodes.add(selection[i]);
            }
        }
        return nodes != null ? nodes.toArray(new SVNRemoteNode[nodes.size()]) : new SVNRemoteNode[]{};
    }

    public static void setAuthInfo(ISVNClientAdapter client, SVNRepositoryInfo repos) {
        if (repos != null) {
            SVNUtil.setAuthInfo(client, repos.getAuthInfo());
        }
    }

    public static void unsetAuthInfo(ISVNClientAdapter client) {
        if (client != null) {
            client.setUsername("");
            client.setPassword("");
        }
    }

    public static void setAuthInfo(ISVNClientAdapter client, SVNAuthInfo authInfo) {
        String username;
        if (authInfo != null && (username = authInfo.getUserName()) != null && username.length() > 0) {
            client.setUsername(username);
            char[] c = authInfo.getPassword();
            String s = new String(c);
            client.setPassword(s);
            s = null;
        }
    }

    public static SVNRepositoryInfo toReposInfo(SvnRepositoryType reposType) throws MalformedURLException {
        String password = reposType.getPassword();
        String p = null;
        if (password != null && password.length() > 0) {
            try {
                p = new String(Checksum.SHA((byte[])Base64.base64Decode((String)password), null), "UTF-8");
            }
            catch (Exception e) {
                SVNProfile.getQualifiedLogger(SVNUtil.class.getName()).warning(e.getMessage());
            }
        }
        SVNAuthInfo authInfo = new SVNAuthInfo(reposType.getUserName(), p == null ? "".toCharArray() : p.toCharArray());
        SVNRepositoryInfo reposInfo = new SVNRepositoryInfo(new SVNUrl(reposType.getUrl()), reposType.getAlias(), authInfo);
        return reposInfo;
    }

    public static SvnRepositoryType toReposType(SVNRepositoryInfo reposInfo, ObjectFactory factory) {
        SvnRepositoryType reposType = factory.createSvnRepositoryType();
        reposType.setUrl(reposInfo.getURL().toString());
        reposType.setAlias(reposInfo.getAlias());
        SVNAuthInfo authInfo = reposInfo.getAuthInfo();
        if (authInfo != null) {
            reposType.setUserName(authInfo.getUserName());
            char[] password = authInfo.getPassword();
            if (password != null && password.length > 0) {
                try {
                    char[] c = password;
                    String s = new String(c);
                    reposType.setPassword(Base64.base64Encode((byte[])Checksum.MD5((byte[])s.getBytes("UTF-8"), null)));
                    s = null;
                }
                catch (Exception e) {
                    SVNProfile.getQualifiedLogger(SVNUtil.class.getName()).warning(e.getMessage());
                    reposType.setPassword(null);
                }
            }
        }
        return reposType;
    }

    public static SVNRepositoryInfo getFirstAssociatedRepository(URL[] urls) throws SVNException, IOException {
        if (urls == null) {
            return null;
        }
        SVNRepositoryInfo repos = null;
        for (int i = 0; i < urls.length && repos == null; ++i) {
            repos = SVNUtil.getFirstAssociatedRepository(urls[i]);
        }
        return repos;
    }

    public static SVNRepositoryInfo getFirstAssociatedRepository(URL url) throws SVNException, IOException {
        if (url == null) {
            return null;
        }
        SVNRepositoryInfo repos = null;
        SVNUrl svnurl = SVNURLInfoCache.getInstance().getURL(url);
        svnurl = SVNUtil.canonicalizeSVNUrl(svnurl);
        repos = SVNUtil.resolveRepository(svnurl);
        return repos;
    }

    public static SVNRepositoryInfo resolveRepository(SVNUrl svnurl) {
        return SVNUtil.resolveRepository(svnurl, SVNRepositoryManager.getInstance().list());
    }

    public static SVNRepositoryInfo resolveRepository(SVNUrl svnurl, Collection<SVNRepositoryInfo> repositories) {
        for (SVNRepositoryInfo reposInfo : repositories) {
            if (!SVNUtil.equals(reposInfo.getURL(), svnurl)) continue;
            return reposInfo;
        }
        for (SVNRepositoryInfo reposInfo : repositories) {
            if (!SVNUtil.isBaseFor(reposInfo.getURL(), svnurl)) continue;
            return reposInfo;
        }
        return null;
    }

    public static SVNRepositoryInfo tryGetFirstMatchRepository(SVNUrl svnurl) {
        if (svnurl == null) {
            return null;
        }
        for (SVNRepositoryInfo reposInfo : SVNRepositoryManager.getInstance().list()) {
            if (!SVNUtil.isBaseFor(svnurl, reposInfo.getURL())) continue;
            return reposInfo;
        }
        return null;
    }

    public static final VCSSingleWorkingCopyLocator getWorkingCopyLocator() {
        return VCSSingleWorkingCopyLocator.getLocatorInstance((String)"oracle.jdeveloper.subversion", (String)".svn/");
    }

    public static URL resolveWorkingCopy(URL url) {
        if (!Product.isJDeveloper()) {
            if (SVNRepositoryManager.getInstance().isEmpty()) {
                return null;
            }
            return SVNWorkingCopyNonProjectBased.getInstance().getRootContaining(url);
        }
        return url != null ? SVNUtil.getWorkingCopyLocator().getRootContaining(url) : null;
    }

    public static URL resolveControlledParent(URL url) {
        return URLFileSystem.getParent((URL)url);
    }

    public static boolean insideWorkingCopy(URL url) {
        return SVNUtil.resolveWorkingCopy(url) != null;
    }

    public static boolean isWorkingCopy(URL directoryUrl) {
        return URLFileSystem.exists((URL)directoryUrl) && SVNUtil.insideWorkingCopy(directoryUrl);
    }

    public static boolean isModified(VCSStatus status, VCSProfile profile) {
        if (profile != null && "oracle.jdeveloper.subversion".equals(profile.getID())) {
            return status == profile.getStatusInstance("MODIFIED");
        }
        return false;
    }

    public static boolean isConflicted(VCSStatus status, VCSProfile profile) {
        if (profile != null && "oracle.jdeveloper.subversion".equals(profile.getID())) {
            return status == profile.getStatusInstance("CONFLICTS");
        }
        return false;
    }

    public static boolean isIgnored(VCSStatus status, VCSProfile profile) {
        if (profile != null && "oracle.jdeveloper.subversion".equals(profile.getID())) {
            return status == profile.getStatusInstance("IGNORED");
        }
        return false;
    }

    public static boolean isPropertiesModified(URL url) throws SVNException, IOException {
        return SVNStatusType.STATUS_MODIFIED == SVNURLInfoCache.getInstance().getPropStatus(url);
    }

    public static boolean isPropertiesConflicted(URL url) throws SVNException, IOException {
        return SVNStatusType.STATUS_CONFLICTED == SVNURLInfoCache.getInstance().getPropStatus(url);
    }

    public static boolean isTextModified(URL url) throws SVNException, IOException {
        return SVNStatusType.STATUS_MODIFIED == SVNURLInfoCache.getInstance().getTextStatus(url);
    }

    public static boolean isTextConflicted(URL url) throws SVNException, IOException {
        return SVNStatusType.STATUS_CONFLICTED == SVNURLInfoCache.getInstance().getTextStatus(url);
    }

    public static boolean isTreeConflicted(URL url) throws SVNException, IOException {
        return SVNURLInfoCache.getInstance().getTreeStatus(url);
    }

    public static URL suggestCheckoutDestination(URL localBase, SVNUrl source, boolean isReposRoot, String reposAlias) {
        String lastPathSegment = source.getLastPathSegment();
        String suggestion = null;
        if (isReposRoot) {
            suggestion = reposAlias;
            if (suggestion.indexOf("/") > -1 || suggestion.indexOf("\\") > -1) {
                suggestion = source.getHost();
            }
        } else {
            suggestion = lastPathSegment;
            if ("trunk".equals(suggestion) || "branches".equals(suggestion) || "tags".equals(suggestion)) {
                String[] pathSegments = source.getPathSegments();
                suggestion = pathSegments.length > 1 ? pathSegments[pathSegments.length - 2] : source.getHost();
            }
        }
        URL dir = URLFactory.newDirURL((URL)localBase, (String)suggestion);
        int i = 0;
        while (URLFileSystem.exists((URL)dir)) {
            dir = URLFactory.newDirURL((URL)localBase, (String)(suggestion + '_' + i++));
        }
        return dir;
    }

    public static boolean ensureRepositoryConnection(Context context) {
        Collection reposInfos = SVNRepositoryManager.getInstance().list();
        if (reposInfos.isEmpty()) {
            SVNOperationCreateConnection cmd = new SVNOperationCreateConnection();
            cmd.setContext(context);
            try {
                int success = CommandProcessor.getInstance().invoke((Command)cmd);
                return success == 0;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    static boolean equals(SVNUrl root, SVNUrl url) {
        if (root == null || url == null) {
            return false;
        }
        return root.equals((Object)url);
    }

    static boolean isBaseFor(SVNUrl root, SVNUrl url) {
        if (root == null || url == null) {
            return false;
        }
        if (root.equals((Object)url)) {
            return true;
        }
        String urlStr = url.toString();
        String rootStr = root.toString();
        if (urlStr.length() < rootStr.length()) {
            return false;
        }
        if (!rootStr.endsWith("/")) {
            rootStr = rootStr + '/';
        }
        return urlStr.indexOf(rootStr) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRemotelyExisiting(SVNUrl svnurl) {
        boolean isRemoteExisiting = false;
        if (svnurl != null) {
            try {
                ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.SVNUTIL_ADAPTER_CONTEXT_ID);
                SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.resolveRepository(svnurl));
                ISVNInfo info = client.getInfo(svnurl);
                if (info == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (SVNClientException e) {
                SVNProfile.getQualifiedLogger(SVNUtil.class.getName()).warning(e.getMessage());
            }
            finally {
                SVNClientInteraction.getInstance().endInteraction();
            }
        }
        return isRemoteExisiting;
    }

    public static boolean isLocked(URL url) throws SVNClientException {
        ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.SVNUTIL_ADAPTER_CONTEXT_ID);
        ISVNStatus status = client.getSingleStatus(SVNUtil.toFile(url));
        return status.getLockOwner() != null;
    }

    public static boolean allLocked(URL[] URLs) throws SVNClientException {
        return SVNUtil.allLocked(SVNUtil.toFiles(URLs));
    }

    public static boolean allLocked(File[] files) throws SVNClientException {
        ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.SVNUTIL_ADAPTER_CONTEXT_ID);
        for (int i = 0; i < files.length; ++i) {
            ISVNStatus status = client.getSingleStatus(files[i]);
            if (status.getLockOwner() != null) continue;
            return false;
        }
        return true;
    }

    public static boolean containsLocked(URL[] URLs) throws SVNClientException {
        ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.SVNUTIL_ADAPTER_CONTEXT_ID);
        for (int i = 0; i < URLs.length; ++i) {
            ISVNStatus status = client.getSingleStatus(SVNUtil.toFile(URLs[i]));
            if (status.getLockOwner() == null) continue;
            return true;
        }
        return false;
    }

    public static SVNUrl canonicalizeSVNUrl(SVNUrl svnurl) {
        if (svnurl == null) {
            return null;
        }
        String urlString = svnurl.toString();
        SVNUrl newurl = null;
        try {
            urlString = URLDecoder.decode(urlString, "UTF-8");
            newurl = new SVNUrl(urlString);
        }
        catch (MalformedURLException e) {
            newurl = svnurl;
        }
        catch (UnsupportedEncodingException e) {
            newurl = svnurl;
        }
        return newurl;
    }

    public static SVNURL canonicalizeSVNURL(SVNURL svnurl) {
        if (svnurl == null) {
            return null;
        }
        String urlString = svnurl.toString();
        SVNURL newurl = null;
        try {
            urlString = URLDecoder.decode(urlString, "UTF-8");
            newurl = SVNURL.parseURIEncoded((String)urlString);
        }
        catch (SVNException e) {
            newurl = svnurl;
        }
        catch (UnsupportedEncodingException e) {
            newurl = svnurl;
        }
        return newurl;
    }

    public static SVNUrl getCommonRootUrl(SVNUrl url0, SVNUrl url1) {
        if (!url0.getProtocol().equals(url1.getProtocol()) || !url0.getHost().equals(url1.getHost()) || url0.getPort() != url1.getPort()) {
            return null;
        }
        String baseurl = url0.getProtocol().equals("file") ? url0.getProtocol() + "://" : url0.getProtocol() + "://" + url0.getHost() + ":" + url0.getPort();
        String[] segs0 = url0.getPathSegments();
        String[] segs1 = url1.getPathSegments();
        int minLength = segs0.length >= segs1.length ? segs1.length : segs0.length;
        for (int i = 0; i < minLength && segs0[i].equals(segs1[i]); ++i) {
            baseurl = baseurl + "/" + segs0[i];
        }
        try {
            return new SVNUrl(baseurl);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static SVNUrl getCommonRootUrl(SVNUrl[] urls) {
        SVNUrl commonRoot = urls[0];
        for (int i = 0; i < urls.length; ++i) {
            if ((commonRoot = SVNUtil.getCommonRootUrl(commonRoot, urls[i])) != null) continue;
            return null;
        }
        return commonRoot;
    }

    public static SVNRepositoryNode getSVNRepositoryNode(Node node) {
        ConnectionNode cNode;
        if (node == null) {
            return null;
        }
        if (node instanceof SVNRepositoryNode) {
            return (SVNRepositoryNode)node;
        }
        if (node instanceof ConnectionNodeDecorator && (cNode = ((ConnectionNodeDecorator)node).getConnectionNode()) != null && cNode instanceof SVNRepositoryNode) {
            return (SVNRepositoryNode)cNode;
        }
        return null;
    }

    public static SVNRepositoryNode getSVNRepositoryNode(Context context) {
        return context == null ? null : SVNUtil.getSVNRepositoryNode(context.getNode());
    }

    public static void usageTrackerLog() {
        UsagesTracker tracker = UsagesTracker.getUsagesTracker();
        UsageData data = tracker.createUsageData();
        data.setEventSource("SCM");
        data.setProperty("scm-type", "Subversion");
        data.setEventId("CREATE_CONNECTION");
        tracker.report(data);
    }

    public static URL toURL(SVNURL svnurl) {
        return URLFactory.newURL((String)svnurl.getProtocol(), (String)svnurl.getUserInfo(), (String)svnurl.getHost(), (int)svnurl.getPort(), (String)svnurl.getPath(), null, null);
    }

    public static SVNStatusClient getStatusClient() {
        return SVNClientManager.newInstance().getStatusClient();
    }

    public static SVNStatusClient getStatusClient(SVNRepositoryInfo svnInfo) {
        SVNClientManager manager = SVNAuthenticationManager.getInstance().getSVNClientManager(svnInfo);
        return manager.getStatusClient();
    }

    public static SVNWCClient getWCClient(SVNRepositoryInfo svnInfo) {
        SVNClientManager manager = SVNAuthenticationManager.getInstance().getSVNClientManager(svnInfo);
        return manager.getWCClient();
    }

    public static SVNChangelistClient getChangeClient() {
        return SVNClientManager.newInstance().getChangelistClient();
    }

    public static SVNLogClient getLogClient(SVNRepositoryInfo svnInfo) {
        SVNClientManager manager = SVNAuthenticationManager.getInstance().getSVNClientManager(svnInfo);
        return manager.getLogClient();
    }
}

