/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.cache.StatusCacheEvent;
import oracle.jdeveloper.vcs.cache.StatusCacheListener;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;

class SVNWorkingCopyNonProjectBased {
    private Set<URL> _nonPrjSVNRoots = Collections.synchronizedSet(new LinkedHashSet());
    private static SVNWorkingCopyNonProjectBased _instance = null;

    private SVNWorkingCopyNonProjectBased() {
        this.addListener();
    }

    public static final synchronized SVNWorkingCopyNonProjectBased getInstance() {
        if (_instance == null) {
            _instance = new SVNWorkingCopyNonProjectBased();
        }
        return _instance;
    }

    public boolean underSVNRoot(URL url) {
        URL dir;
        if (url == null) {
            return false;
        }
        URL uRL = dir = URLFileSystem.isDirectoryPath((URL)url) ? url : URLFileSystem.getParent((URL)url);
        if (this.isSVNRoot(dir)) {
            return true;
        }
        return this.isAdminDir(dir);
    }

    URL getRootContaining(URL url) {
        if (this.underSVNRoot(url)) {
            for (URL root : this._nonPrjSVNRoots) {
                if (!URLFileSystem.isBaseURLFor((URL)root, (URL)url)) continue;
                return root;
            }
        }
        return null;
    }

    private void addListener() {
        VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion").getPolicyStatusCache().addCacheListener(new StatusCacheListener(){

            public final void statusesCleared(StatusCacheEvent e) {
                SVNWorkingCopyNonProjectBased.this.clear(e.getURLs(), e.getDepth());
            }
        });
    }

    private void clear(URL[] urls, Depth depth) {
        if (urls == null) {
            return;
        }
        for (URL url : urls) {
            URL parent = URLFileSystem.getParent((URL)url);
            this._nonPrjSVNRoots.remove(parent);
        }
    }

    private boolean isSVNRoot(URL dir) {
        for (URL url : this._nonPrjSVNRoots) {
            if (!URLFileSystem.isBaseURLFor((URL)url, (URL)dir)) continue;
            return true;
        }
        return false;
    }

    private boolean isAdminDir(URL dir) {
        URL svnAdmin = URLFactory.newURL((URL)dir, (String)".svn");
        if (URLFileSystem.exists((URL)svnAdmin)) {
            this._nonPrjSVNRoots.add(dir);
            return true;
        }
        URL parent = URLFileSystem.getParent((URL)dir);
        if (parent != null && !URLFileSystem.isRoot((URL)dir)) {
            return this.isAdminDir(parent);
        }
        return false;
    }
}

