/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.versiontree;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.ide.vhv.VHVBranchResource;
import oracle.ide.vhv.VHVCheckoutResource;
import oracle.ide.vhv.VHVMergeResource;
import oracle.ide.vhv.VHVQuery;
import oracle.ide.vhv.VHVResource;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.VHVVersionTree;
import oracle.ide.vhv.VHVVersionableResource;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.vcs.spi.VCSDetailException;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.svn.versiontree.SVNLogMessageCache;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;
import org.tmatesoft.svn.core.SVNException;

public class SVNVHVQuery
extends VHVQuery {
    private ISVNClientAdapter _client;
    private SVNLogMessageCache _svnLogMessageCache = null;
    private Map<String, VHVVersionableResource> _versionableResourceCache = null;
    private Map<String, VHVBranchResource> _branchResourceCache = null;
    private Collection<VHVMergeResource> _mergeResources = null;
    private VHVCheckoutResource _checkoutResource = null;
    private SVNRevision REV_0 = new SVNRevision.Number(0L);
    private SVNUrl _repoUrl;
    private SVNUrl _svnUrl;
    private Map<Pair<SVNUrl, SVNRevision>, String[]> _branchUrl = new HashMap<Pair<SVNUrl, SVNRevision>, String[]>();
    private Map<Pair<SVNUrl, SVNRevision>, ISVNLogMessage[]> _logMessage = new HashMap<Pair<SVNUrl, SVNRevision>, ISVNLogMessage[]>();
    Set<BranchObj> branchesSet = new HashSet<BranchObj>();

    public SVNVHVQuery() {
    }

    public SVNVHVQuery(SVNUrl svnurl) {
        this._svnUrl = svnurl;
    }

    protected VHVVersionTree getVersionTree(URL url) throws VHVResourceException {
        long revision = 0L;
        try {
            revision = SVNURLInfoCache.getInstance().getLastChangedRevision(url);
        }
        catch (SVNException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning("Version Tree failed get current revision label " + e.getMessage());
        }
        catch (IOException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning("Version Tree failed get current revision label " + e.getMessage());
        }
        SVNUrl svnUrl = this.getSVNUrl(url);
        VHVVersionTree versionTree = this.getVersionTree(svnUrl, revision);
        this._branchUrl.clear();
        this._logMessage.clear();
        return versionTree;
    }

    private VHVVersionTree getVersionTree(SVNUrl svnUrl, long revision) throws VHVResourceException {
        BranchObj[] branchObjs;
        if (svnUrl == null) {
            throw new VHVResourceException(Resource.get("ACTION_VERSIONTREE_RESOURCE_ERROR_MESSAGE"));
        }
        this.initCache();
        try {
            branchObjs = this.findBranches(svnUrl, SVNRevision.HEAD);
        }
        catch (SVNClientException e) {
            VCSDetailException de = new VCSDetailException(Resource.get("VERSION_TREE_ERROR_TITLE"), Resource.get("VERSION_TREE_ERROR"), (Exception)SVNExceptionWrapper.wrapSVNClientException((Exception)((Object)e)));
            new SVNExceptionHandler().handleException((Exception)de);
            this.cancel();
            return null;
        }
        if (branchObjs == null || branchObjs.length == 0) {
            if (this.isCanceled()) {
                return null;
            }
            throw new VHVResourceException(Resource.get("ACTION_VERSIONTREE_BRANCH_ERROR_MESSAGE"));
        }
        this.createVHVVersionableResources(branchObjs, revision);
        this.createMergedResource(branchObjs);
        VHVVersionTree versionTree = new VHVVersionTree(this._versionableResourceCache.values().toArray(new VHVVersionableResource[0]), this._mergeResources.toArray(new VHVMergeResource[0]), null);
        if (versionTree.getRootElement() == null) {
            throw new VHVResourceException(Resource.get("ACTION_VERSIONTREE_ROOT_NODE"), VHVResourceException.Severity.INFO);
        }
        for (VHVVersionableResource versionableResource : this._versionableResourceCache.values()) {
            versionableResource.setVersionTree(versionTree);
        }
        return versionTree;
    }

    protected boolean isCancelable() {
        return true;
    }

    private void initCache() {
        this._svnLogMessageCache = new SVNLogMessageCache();
        this._versionableResourceCache = new LinkedHashMap<String, VHVVersionableResource>();
        this._branchResourceCache = new LinkedHashMap<String, VHVBranchResource>();
        this._mergeResources = new ArrayList<VHVMergeResource>();
    }

    private SVNUrl getSVNUrl(URL url) throws VHVResourceException {
        if (this._svnUrl != null) {
            return this._svnUrl;
        }
        SVNUrl svnUrl = null;
        try {
            ISVNClientAdapter client = this.getClient();
            ISVNInfo info = client.getInfoFromWorkingCopy(SVNUtil.toFile(url));
            this._svnUrl = svnUrl = info.getUrl();
        }
        catch (SVNClientException e) {
            throw new VHVResourceException(e.getCause());
        }
        return this._svnUrl;
    }

    private ISVNLogMessage[] getLogMessage(SVNUrl svnUrl, SVNRevision peg, SVNRevision start, SVNRevision end, boolean stopOnCopy) throws VHVResourceException {
        String key = SVNLogMessageCache.getKey(svnUrl, peg, start, end);
        if (this._svnLogMessageCache.containsKey(key)) {
            return this._svnLogMessageCache.get(key);
        }
        ISVNLogMessage[] log = null;
        try {
            ISVNClientAdapter client = this.getClient();
            SVNRepositoryInfo reposInfo = SVNUtil.resolveRepository(svnUrl);
            SVNClientInteraction.getInstance().beginInteraction(client, reposInfo);
            log = client.getLogMessages(svnUrl, peg, start, end, stopOnCopy, true, 0L, true);
            if (log == null) {
                throw new VHVResourceException(Resource.format("ACTION_VERSIONTREE_LOG_READ_ERROR_MESSAGE", svnUrl.toString()));
            }
            this._svnLogMessageCache.put(key, log);
        }
        catch (SVNClientException e) {
            throw new VHVResourceException(e.getCause());
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
        return log;
    }

    private ISVNClientAdapter getClient() throws VHVResourceException {
        try {
            if (this._client == null) {
                this._client = SVNUtil.getIDEClientAdapter();
            }
        }
        catch (SVNClientException e) {
            throw new VHVResourceException(e.getCause());
        }
        return this._client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BranchObj[] findBranches(SVNUrl resourceSVNUrl, SVNRevision pegRevision) throws VHVResourceException, SVNClientException {
        if (this.isCanceled()) {
            return null;
        }
        String[] branchStrArr = null;
        try {
            ISVNClientAdapter client = this.getClient();
            Pair key = new Pair((Object)resourceSVNUrl, (Object)pegRevision);
            if (this._branchUrl.containsKey(key)) {
                branchStrArr = this._branchUrl.get(key);
                if (branchStrArr.length == 0) {
                    return new BranchObj[0];
                }
            } else {
                this.branchesSet.add(new BranchObj(resourceSVNUrl, pegRevision));
                try {
                    SVNRepositoryInfo reposInfo = SVNUtil.resolveRepository(resourceSVNUrl);
                    SVNClientInteraction.getInstance().beginInteraction(client, reposInfo);
                    branchStrArr = client.suggestMergeSources(resourceSVNUrl, pegRevision);
                    this._branchUrl.put((Pair<SVNUrl, SVNRevision>)key, branchStrArr);
                }
                catch (SVNClientException e) {
                    if (this.branchesSet.size() == 1) {
                        throw e;
                    }
                    BranchObj branchobj = null;
                    Iterator<BranchObj> it = this.branchesSet.iterator();
                    while (!(!it.hasNext() || (branchobj = it.next()).getBranchUrl().equals((Object)resourceSVNUrl) && branchobj.getPegRevision().equals((Object)pegRevision))) {
                    }
                    if (branchobj != null) {
                        this.branchesSet.remove(branchobj);
                    }
                    this._branchUrl.put((Pair<SVNUrl, SVNRevision>)key, new String[0]);
                    BranchObj[] branchObjArray = new BranchObj[]{};
                    return branchObjArray;
                }
                finally {
                    SVNClientInteraction.getInstance().endInteraction();
                }
            }
            String[] arr$ = branchStrArr;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                ISVNLogMessage log;
                ISVNLogMessageChangePath[] paths;
                ISVNLogMessage[] logs;
                String branchStr = arr$[i$];
                SVNUrl branchUrl = new SVNUrl(branchStr);
                if (this.isCanceled()) {
                    return null;
                }
                Pair keyMsg = new Pair((Object)resourceSVNUrl, (Object)pegRevision);
                if (this._logMessage.containsKey(keyMsg)) {
                    logs = this._logMessage.get(keyMsg);
                } else {
                    System.out.println("ISVNLogMessage " + resourceSVNUrl.toString() + " peg " + pegRevision);
                    logs = this.getLogMessage(resourceSVNUrl, pegRevision, this.REV_0, pegRevision, true);
                    this._logMessage.put((Pair<SVNUrl, SVNRevision>)keyMsg, logs);
                }
                pegRevision = SVNRevision.HEAD;
                if (logs.length > 0 && (paths = (log = logs[0]).getChangedPaths()).length > 0) {
                    for (ISVNLogMessageChangePath path : paths) {
                        if (path.getAction() != 'A' || path.getCopySrcPath() == null || path.getCopySrcRevision() == null) continue;
                        for (ISVNLogMessageChangePath delPath : paths) {
                            if (delPath.getAction() != 'D' || !delPath.getPath().equals(path.getCopySrcPath())) continue;
                            pegRevision = path.getCopySrcRevision();
                        }
                    }
                }
                if (!this.isInBranchSet(branchUrl, pegRevision)) {
                    BranchObj[] branchObjs = this.findBranches(branchUrl, pegRevision);
                    if (branchObjs == null) {
                        return null;
                    }
                    if (branchObjs.length > 0) {
                        this.branchesSet.addAll(Arrays.asList(branchObjs));
                    }
                }
                ++i$;
            }
            return this.branchesSet.toArray(new BranchObj[this.branchesSet.size()]);
        }
        catch (MalformedURLException ex) {
            throw new VHVResourceException(ex.getCause());
        }
    }

    private boolean isInBranchSet(SVNUrl svnurl, SVNRevision peg) {
        for (BranchObj branchObj : this.branchesSet) {
            if (!branchObj.getBranchUrl().equals((Object)svnurl) || !branchObj.getPegRevision().equals((Object)peg)) continue;
            return true;
        }
        return false;
    }

    private void createVHVVersionableResources(BranchObj[] branchObjs, long revision) throws VHVResourceException {
        this.createBranchResources(branchObjs);
        this.createVersionableResources(branchObjs, revision);
        this.fixBranchResourceParent(branchObjs, revision);
    }

    private void createBranchResources(BranchObj[] branchObjs) throws VHVResourceException {
        VHVBranchResource branchResource = null;
        for (BranchObj branchObj : branchObjs) {
            ISVNLogMessage[] logs = this.getLogMessage(branchObj.getBranchUrl(), branchObj.getPegRevision(), this.REV_0, branchObj.getPegRevision(), true);
            branchResource = new VHVBranchResource();
            branchResource.setPath(branchObj.getBranchUrl().toString());
            branchResource.setName(this.getBranchName(branchObj, branchObjs));
            branchResource.setDate(logs[0].getDate());
            branchResource.setUser(logs[0].getAuthor());
            this._branchResourceCache.put(branchObj.getBranchUrl().toString(), branchResource);
        }
    }

    private String getBranchName(BranchObj branchObj, BranchObj[] branchObjs) {
        SVNUrl branchUrl = branchObj.getBranchUrl();
        SVNUrl[] branchesUrls = new SVNUrl[branchObjs.length];
        for (int i = 0; i < branchesUrls.length; ++i) {
            branchesUrls[i] = branchObjs[i].getBranchUrl();
        }
        SVNUrl commonRootUrl = SVNUtil.getCommonRootUrl(branchesUrls);
        String branchName = SVNUrlUtils.getRelativePath((SVNUrl)commonRootUrl, (SVNUrl)branchUrl, (boolean)true);
        String longestSuffix = this.getLongestCommonSuffix(branchName, branchUrl, branchesUrls);
        if (!longestSuffix.equals("")) {
            branchName = branchName.substring(0, branchName.indexOf(longestSuffix)).concat("/.../").concat(branchUrl.getLastPathSegment());
        }
        if (branchName.equals("")) {
            branchName = "/" + SVNUtil.getPath(branchUrl);
        }
        return branchName;
    }

    private String getLongestCommonSuffix(String branchName, SVNUrl branchUrl, SVNUrl[] branchesUrls) {
        String longestSuffix = "";
        block0: for (SVNUrl url : branchesUrls) {
            if (url.equals((Object)branchUrl)) continue;
            String[] urlsegs = url.getPathSegments();
            for (int i = 0; i < urlsegs.length; ++i) {
                StringBuffer hitSB = new StringBuffer();
                for (int j = i; j < urlsegs.length; ++j) {
                    hitSB.append("/");
                    hitSB.append(urlsegs[j]);
                }
                String hitStr = hitSB.toString();
                if (branchName.indexOf(hitStr) <= -1 || hitStr.length() <= longestSuffix.length()) continue;
                longestSuffix = hitStr;
                continue block0;
            }
        }
        return longestSuffix;
    }

    private boolean hasParent(ISVNLogMessage[] logs) {
        return logs[0].getChangedPaths()[0].getCopySrcPath() != null;
    }

    private void createVersionableResources(BranchObj[] branchObjs, long revision) throws VHVResourceException {
        VHVVersionableResource versionableResource = null;
        VHVBranchResource branchResource = null;
        for (BranchObj branchObj : branchObjs) {
            branchResource = this._branchResourceCache.get(branchObj.getBranchUrl().toString());
            ISVNLogMessage[] logs = this.getLogMessage(branchObj.getBranchUrl(), branchObj.getPegRevision(), this.REV_0, branchObj.getPegRevision(), true);
            for (int i = 0; i < logs.length; ++i) {
                versionableResource = new VHVVersionableResource();
                versionableResource.setBranch(branchResource);
                versionableResource.setDate(logs[i].getDate());
                versionableResource.setFirstVersionOnBranch(i == 0);
                versionableResource.setVersionLabel(logs[i].getRevision().toString());
                versionableResource.setPath(branchObj.getBranchUrl().toString());
                versionableResource.setName(branchObj.getBranchUrl().getLastPathSegment());
                versionableResource.setUser(logs[i].getAuthor());
                versionableResource.setNotes(logs[i].getMessage());
                versionableResource.setVersionNumber((Comparable)logs[i].getRevision());
                versionableResource.setViewVersion(logs[i].getRevision().getNumber() == revision);
                versionableResource.setWorkareaName(SVNVHVQuery.class.getName());
                String resourceKey = this.getResourceKey(branchObj.getBranchUrl().toString(), logs[i].getRevision().toString());
                this._versionableResourceCache.put(resourceKey, versionableResource);
            }
        }
    }

    private void fixBranchResourceParent(BranchObj[] branchObjs, long revision) throws VHVResourceException {
        VHVBranchResource branchResource;
        for (BranchObj branchObj : branchObjs) {
            branchResource = this._branchResourceCache.get(branchObj.getBranchUrl().toString());
            ISVNLogMessage[] logs = this.getLogMessage(branchObj.getBranchUrl(), branchObj.getPegRevision(), this.REV_0, branchObj.getPegRevision(), true);
            ISVNLogMessageChangePath pInfo = this.getParentInfo(logs[0], branchResource.getPath());
            if (pInfo == null) continue;
            String sourcePath = pInfo.getCopySrcPath();
            String branchPath = pInfo.getPath();
            String branchUrlStr = branchObj.getBranchUrl().toString();
            branchUrlStr = branchUrlStr.replaceFirst(branchPath, sourcePath);
            String sourceRevision = String.valueOf(pInfo.getCopySrcRevision().getNumber());
            try {
                SVNUrl fullSourceSVNUrl = new SVNUrl(branchUrlStr);
                String resourceKey = this.getResourceKey(fullSourceSVNUrl.toString(), sourceRevision);
                VHVVersionableResource versionableResource = this._versionableResourceCache.get(resourceKey);
                if (versionableResource == null) {
                    versionableResource = new VHVVersionableResource();
                    long rev = pInfo.getCopySrcRevision().getNumber();
                    versionableResource.setBranch(this._branchResourceCache.get(branchUrlStr));
                    versionableResource.setDate(logs[0].getDate());
                    versionableResource.setFirstVersionOnBranch(false);
                    versionableResource.setVersionLabel(sourceRevision);
                    versionableResource.setPath(branchUrlStr);
                    versionableResource.setName(branchObj.getBranchUrl().getLastPathSegment());
                    versionableResource.setUser(logs[0].getAuthor());
                    versionableResource.setNotes(logs[0].getMessage());
                    versionableResource.setVersionNumber((Comparable)pInfo.getCopySrcRevision());
                    versionableResource.setViewVersion(rev == revision);
                    versionableResource.setWorkareaName(SVNVHVQuery.class.getName());
                    String resKey = this.getResourceKey(branchUrlStr, String.valueOf(rev));
                    this._versionableResourceCache.put(resKey, versionableResource);
                }
                if (versionableResource.getBranch() == null || versionableResource.getBranch().equals(branchResource)) continue;
                branchResource.setSource((VHVResource)versionableResource);
            }
            catch (NullPointerException npe) {
                throw new VHVResourceException(npe.getCause());
            }
            catch (MalformedURLException mfe) {
                throw new VHVResourceException(mfe.getCause());
            }
        }
        for (BranchObj branchObj : branchObjs) {
            branchResource = this._branchResourceCache.get(branchObj.getBranchUrl().toString());
            if (branchResource.getSource() != null) continue;
            branchResource.setName(branchObj.getBranchUrl().toString());
        }
    }

    private String getResourceKey(String resourceUrl, String resourceRevision) {
        return resourceUrl + "@r" + resourceRevision;
    }

    private void createMergedResource(BranchObj[] branchObjs) throws VHVResourceException {
        for (BranchObj branchObj : branchObjs) {
            ISVNLogMessage[] logs;
            for (ISVNLogMessage log : logs = this.getLogMessage(branchObj.getBranchUrl(), branchObj.getPegRevision(), this.REV_0, branchObj.getPegRevision(), true)) {
                ISVNLogMessage[] childLogs = log.getChildMessages();
                if (!log.hasChildren() || childLogs == null || childLogs.length <= 0) continue;
                SVNRevision.Number sourceRevision = childLogs[0].getRevision();
                SVNRevision.Number targeRevision = log.getRevision();
                SVNUrl repoUrl = this.getReposiotry(branchObj.getBranchUrl());
                for (ISVNLogMessageChangePath path : childLogs[0].getChangedPaths()) {
                    String targetKey;
                    VHVVersionableResource targetVersionableResource;
                    SVNUrl sourceUrl = repoUrl.appendPath(path.getPath());
                    SVNUrl targetUrl = branchObj.getBranchUrl();
                    String sourceKey = this.getResourceKey(sourceUrl.toString(), sourceRevision.toString());
                    VHVVersionableResource sourceVersionableResource = this._versionableResourceCache.get(sourceKey);
                    if (sourceVersionableResource == null || (targetVersionableResource = this._versionableResourceCache.get(targetKey = this.getResourceKey(targetUrl.toString(), targeRevision.toString()))) == null) continue;
                    VHVMergeResource mergeResource = new VHVMergeResource();
                    mergeResource.setDate(log.getDate());
                    mergeResource.setNotes(log.getMessage());
                    mergeResource.setName(log.getChangedPaths()[0].getPath());
                    mergeResource.setSource((VHVResource)sourceVersionableResource);
                    mergeResource.setTarget((VHVResource)targetVersionableResource);
                    mergeResource.setUser(log.getAuthor());
                    this._mergeResources.add(mergeResource);
                }
            }
        }
    }

    private SVNUrl getReposiotry(SVNUrl svnurl) throws VHVResourceException {
        if (this._repoUrl != null) {
            return this._repoUrl;
        }
        ISVNClientAdapter client = this.getClient();
        SVNUrl repoUrl = null;
        try {
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(svnurl);
            SVNClientInteraction.getInstance().beginInteraction(client, repoInfo);
            repoUrl = client.getInfo(svnurl).getRepository();
        }
        catch (SVNClientException e) {
            throw new VHVResourceException(e.getCause());
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
        if (repoUrl == null) {
            throw new VHVResourceException(Resource.format("ACTION_VERSIONTREE_REPO_ERROR_MESSAGE", svnurl.toString()));
        }
        return repoUrl;
    }

    private ISVNLogMessageChangePath getParentInfo(ISVNLogMessage log, String srcPath) {
        ISVNLogMessageChangePath[] paths = log.getChangedPaths();
        ArrayList<ISVNLogMessageChangePath> matched = new ArrayList<ISVNLogMessageChangePath>();
        for (ISVNLogMessageChangePath path : paths) {
            if (path.getCopySrcPath() == null || path.getAction() != 'A') continue;
            matched.add(path);
        }
        if (matched.isEmpty()) {
            return null;
        }
        if (matched.size() == 1) {
            return (ISVNLogMessageChangePath)matched.get(0);
        }
        for (ISVNLogMessageChangePath cPath : matched) {
            if (!srcPath.endsWith(cPath.getPath())) continue;
            return cPath;
        }
        return null;
    }

    private class BranchObj {
        private SVNUrl _branchUrl;
        private SVNRevision _pegRevision;

        public BranchObj(SVNUrl branchUrl, SVNRevision pegRevision) {
            this._branchUrl = branchUrl;
            this._pegRevision = pegRevision;
        }

        public void setBranchUrl(SVNUrl branchUrl) {
            this._branchUrl = branchUrl;
        }

        public SVNUrl getBranchUrl() {
            return this._branchUrl;
        }

        public void setPegRevision(SVNRevision pegRevision) {
            this._pegRevision = pegRevision;
        }

        public SVNRevision getPegRevision() {
            return this._pegRevision;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BranchObj)) {
                return false;
            }
            BranchObj target = (BranchObj)obj;
            return this._branchUrl.toString().equals(target.getBranchUrl().toString()) && this._pegRevision.equals((Object)target.getPegRevision());
        }
    }
}

