/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.bookmarks;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.bookmarks.BookmarkConstants;
import oracle.ide.bookmarks.BookmarkIcons;
import oracle.ide.bookmarks.BookmarkManager;
import oracle.ide.bookmarks.BookmarkOptions;
import oracle.ide.bookmarks.BookmarkOptionsPanel;
import oracle.ide.bookmarks.URLBookmark;
import oracle.ide.config.Preferences;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class BookmarkAddin
implements Addin {
    private static String extensionID;
    public static final String VIEW_TYPE = "BOOKMARKS_VIEW_TYPE";

    public BookmarkAddin() {
        extensionID = AddinManager.getAddinManager().getExtensionForAddin((Addin)this).getID();
        for (int i = 0; i < 10; ++i) {
            IdeAction quickToggleAction = IdeAction.find((int)BookmarkConstants.getToggleNumberedBookmarkCmdId(i));
            quickToggleAction.putValue("SmallIcon", (Object)BookmarkIcons.getIcon(i));
            IdeAction quickgotoAction = IdeAction.find((int)BookmarkConstants.getGoToNumberedBookmarkCmdId(i));
            quickgotoAction.putValue("SmallIcon", (Object)BookmarkIcons.getIcon(i));
        }
    }

    public void initialize() {
        Preferences prefs = Preferences.getPreferences();
        Ide.getSettings().putLegacyData("BookmarkOptions", (Copyable)BookmarkOptions.getInstance((PropertyStorage)prefs));
        BookmarkOptionsPanel.applyOptions(BookmarkOptions.getInstance((PropertyStorage)prefs));
        EditorManager.getEditorManager().addEditorListener(new EditorListener(){

            public void editorOpened(Editor editor) {
            }

            public void editorActivated(Editor editor) {
            }

            public void editorDeactivated(Editor editor) {
            }

            public void editorClosed(Editor editor) {
                BookmarkOptions bookmarkOptions = BookmarkOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                if (bookmarkOptions.getDiscardOnClose() && editor.getContext().getNode() != null && editor.getContext().getNode().getURL() != null) {
                    URL url = editor.getContext().getNode().getURL();
                    ArrayList<Bookmark> bookmarksToRemove = new ArrayList<Bookmark>();
                    for (Bookmark bookmark : BookmarkManager.getBookmarkManager().getAllBookmarks()) {
                        URL bookmarkURL;
                        if (!(bookmark instanceof URLBookmark) || !url.equals(bookmarkURL = ((URLBookmark)bookmark).getURL())) continue;
                        bookmarksToRemove.add(bookmark);
                    }
                    for (Bookmark bookmark : bookmarksToRemove) {
                        BookmarkManager.getBookmarkManager().removeBookmark(bookmark);
                    }
                }
            }
        });
    }

    public static String getExtensionID() {
        return extensionID;
    }
}

