/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.bookmarks;

import java.awt.Component;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.bookmarks.BookmarkPanel;
import oracle.ide.bookmarks.Bookmarks;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;

class BookmarkDockable
extends DockableWindow
implements ContextMenuListener {
    public static final String BOOKMARK_VIEW_ID = "BOOKMARK_VIEW_ID";
    private BookmarkPanel bookmarkPanel = new BookmarkPanel();

    public BookmarkDockable() {
        super("BOOKMARKS_VIEW_TYPE.BOOKMARK_VIEW_ID");
        this.getContextMenu().addContextMenuListener((ContextMenuListener)this);
    }

    public synchronized ContextMenu getContextMenu() {
        return this.bookmarkPanel.getContextMenu();
    }

    public String getTabName() {
        return StringUtils.stripMnemonic((String)Bookmarks.get("BOOKMARK_MENU_NAME"));
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public Component getGUI() {
        return this.bookmarkPanel;
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idedgotobookmark_html");
    }

    public void activate() {
        super.activate();
        this.bookmarkPanel.setActive(true);
    }

    public void deactivate() {
        super.deactivate();
        this.bookmarkPanel.setActive(false);
    }

    public Toolbar getToolbar() {
        return this.bookmarkPanel.getToolbar();
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this.bookmarkPanel.menuWillShow(contextMenu);
    }

    public void menuWillHide(ContextMenu contextMenu) {
        this.bookmarkPanel.menuWillHide(contextMenu);
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

