/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.Enumeration;
import oracle.bali.jle.PropertyManager;
import oracle.bali.share.collection.CompoundEnumeration;

public class CompoundPropertyManager
implements PropertyManager {
    private PropertyManager _primary;
    private PropertyManager _secondary;

    public CompoundPropertyManager(PropertyManager primary, PropertyManager secondary) {
        if (primary == null || secondary == null) {
            throw new IllegalArgumentException();
        }
        this._primary = primary;
        this._secondary = secondary;
    }

    public Object put(Object key, Object value) {
        Object result = this._primary.put(key, value);
        return result == REJECTED_VALUE ? this._secondary.put(key, value) : result;
    }

    public Object get(Object key) {
        Object result = this._primary.get(key);
        return result == PropertyManager.NOT_FOUND_OBJECT ? this._secondary.get(key) : result;
    }

    public Object remove(Object key) {
        Object result = this._primary.remove(key);
        return result == PropertyManager.NOT_FOUND_OBJECT ? this._secondary.remove(key) : result;
    }

    public int size() {
        return this._primary.size() + this._secondary.size();
    }

    public Enumeration keys() {
        return new CompoundEnumeration(this._primary.keys(), this._secondary.keys());
    }

    public void clear() {
        this._primary.clear();
        this._secondary.clear();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this._primary.addPropertyChangeListener(l);
        this._secondary.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this._primary.removePropertyChangeListener(l);
        this._secondary.removePropertyChangeListener(l);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this._primary.addVetoableChangeListener(l);
        this._secondary.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this._primary.removeVetoableChangeListener(l);
        this._secondary.removeVetoableChangeListener(l);
    }
}

