/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.util.ItemUtils;

public class AccessibleLayoutItem
extends AccessibleContext
implements AccessibleComponent {
    private LayoutItem _item;

    public AccessibleLayoutItem(LayoutItem item) {
        this._item = item;
    }

    public LayoutItem getItem() {
        return this._item;
    }

    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.PANEL;
    }

    public AccessibleStateSet getAccessibleStateSet() {
        return new AccessibleStateSet();
    }

    public int getAccessibleIndexInParent() {
        Accessible parent = this.getAccessibleParent();
        if (parent == null) {
            return -1;
        }
        AccessibleContext context = parent.getAccessibleContext();
        int count = context.getAccessibleChildrenCount();
        for (int i = 0; i < count; ++i) {
            if (context.getAccessibleChild(i) != this.getItem()) continue;
            return i;
        }
        return -1;
    }

    public int getAccessibleChildrenCount() {
        return this.getItem().getItemCount();
    }

    public Accessible getAccessibleChild(int i) {
        if (i < 0 || i >= this.getItem().getItemCount()) {
            return null;
        }
        LayoutItem item = this.getItem().getItem(i);
        if (item != null) {
            item.getAccessibleContext().setAccessibleParent(this.getItem());
        }
        return item;
    }

    public Locale getLocale() throws IllegalComponentStateException {
        if (this.getItem().getCanvas() != null) {
            return this.getItem().getCanvas().getLocale();
        }
        return Locale.getDefault();
    }

    public AccessibleComponent getAccessibleComponent() {
        return this;
    }

    public Color getBackground() {
        return null;
    }

    public void setBackground(Color c) {
    }

    public Color getForeground() {
        return null;
    }

    public void setForeground(Color c) {
    }

    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    public void setCursor(Cursor cursor) {
    }

    public Font getFont() {
        return null;
    }

    public void setFont(Font f) {
    }

    public FontMetrics getFontMetrics(Font f) {
        return null;
    }

    public boolean isEnabled() {
        return this.getItem().getCanvas() == null ? false : this.getItem().getCanvas().isEnabled();
    }

    public void setEnabled(boolean b) {
    }

    public boolean isVisible() {
        return this.getItem().getCanvas() == null ? false : this.getItem().getCanvas().isVisible();
    }

    public void setVisible(boolean b) {
    }

    public boolean isShowing() {
        return this.getItem().getCanvas() == null ? false : this.getItem().getCanvas().isShowing();
    }

    public boolean contains(Point p) {
        Rectangle bounds = this.getBounds();
        return bounds == null ? false : bounds.contains(p);
    }

    public Point getLocationOnScreen() {
        return ItemUtils.parentToDevice(this.getItem(), this.getItem().getItemLocation());
    }

    public Point getLocation() {
        Point2D point = this.getItem().getItemLocation();
        return new Point((int)point.getX(), (int)point.getY());
    }

    public void setLocation(Point p) {
    }

    public Rectangle getBounds() {
        Rectangle2D rect = this.getItem().getItemBounds();
        return rect.getBounds();
    }

    public void setBounds(Rectangle r) {
    }

    public Dimension getSize() {
        Dimension2D d = this.getItem().getItemSize();
        return new Dimension((int)d.getWidth(), (int)d.getHeight());
    }

    public void setSize(Dimension d) {
    }

    public Accessible getAccessibleAt(Point p) {
        return this.getItem().getItemAt(p.x, p.y);
    }

    public boolean isFocusTraversable() {
        return this.getItem().isFocusTraversable();
    }

    public void requestFocus() {
    }

    public void addFocusListener(FocusListener l) {
    }

    public void removeFocusListener(FocusListener l) {
    }
}

