/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Hashtable;
import javax.swing.JComponent;
import oracle.bali.jle.ComponentContainer;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Rectangle2D;

public class JComponentContainer
extends JComponent
implements ComponentContainer,
FocusListener {
    private JLECanvas _canvas;
    private Hashtable _items;
    private JComponent _childHolder;

    public JComponentContainer(JLECanvas canvas) {
        this.setLayout(null);
        this._canvas = canvas;
        this._items = new Hashtable();
        long mask = 60L;
        this.enableEvents(mask);
        this._childHolder = new ChildHolder();
        this.add(this._childHolder);
    }

    public Container getContainer() {
        return this;
    }

    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this._childHolder.reshape(x, y, width, height);
    }

    public boolean isShowing() {
        return true;
    }

    public void paint(Graphics g) {
    }

    public void repaint(long time, int x, int y, int width, int height) {
        if (this._canvas != null) {
            if (this._canvas.isZoomed()) {
                Dimension2D zoom = this._canvas.getZoom();
                double zoomWidth = zoom.getWidth();
                double zoomHeight = zoom.getHeight();
                int scaleX = (int)((double)x * zoomWidth);
                int scaleY = (int)((double)y * zoomHeight);
                int scaleWidth = (int)((double)width * zoomWidth);
                int scaleHeight = (int)((double)height * zoomHeight);
                this._canvas.repaintCanvas(scaleX, scaleY, scaleWidth, scaleHeight);
            } else {
                this._canvas.repaintCanvas(x, y, width, height);
            }
        }
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp == this._childHolder) {
            super.addImpl(comp, constraints, index);
        } else {
            this._turnOffDoubleBuffering(comp);
            this._childHolder.add(comp, index);
            this._items.put(comp, (LayoutItem)constraints);
            comp.addFocusListener(this);
        }
    }

    public void remove(int index) {
        Component comp = this.getComponent(index);
        comp.removeFocusListener(this);
        this._items.remove(comp);
        super.remove(index);
    }

    public void removeAll() {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].removeFocusListener(this);
            this._items.remove(comps[i]);
        }
        super.removeAll();
    }

    public void focusGained(FocusEvent e) {
        if (this._canvas != null) {
            LayoutItem item = (LayoutItem)this._items.get(e.getSource());
            if (item == null) {
                return;
            }
            this._canvas.setActualFocusedItem(item);
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Dimension getSize() {
        return this._canvas == null ? new Dimension(0, 0) : this._canvas.getSize();
    }

    private void _turnOffDoubleBuffering(Component comp) {
        if (comp instanceof JComponent) {
            JComponent temp = (JComponent)comp;
            temp.setDoubleBuffered(false);
            this._unBufferChildren(temp);
        } else if (comp instanceof Container) {
            this._unBufferChildren((Container)comp);
        }
    }

    private void _unBufferChildren(Container cont) {
        if (cont.getComponentCount() > 0) {
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this._turnOffDoubleBuffering(children[i]);
            }
        }
    }

    private class ChildHolder
    extends JComponent {
        private ChildHolder() {
        }

        public void paint(Graphics g) {
            Point origin = JComponentContainer.this._canvas.getCanvasOrigin();
            Rectangle2D viewBounds = JComponentContainer.this._canvas.getJLEExtentBounds();
            Rectangle devbounds = JComponentContainer.this._canvas.contentToDevice(viewBounds.getX(), viewBounds.getY(), viewBounds.getWidth(), viewBounds.getHeight());
            Rectangle b = g.getClipBounds();
            b = b.intersection(devbounds);
            b.translate(origin.x, origin.y);
            g.setClip(b.x, b.y, b.width, b.height);
            g.translate(origin.x, origin.y);
            this.paintChildren(g);
        }

        public boolean isOptimizedDrawingEnabled() {
            return false;
        }
    }
}

