/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.event.UndoableEditEvent;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.event.Cancelable;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.tool.BaseTool;
import oracle.bali.jle.tool.CreateToolEvent;
import oracle.bali.jle.tool.CreateToolListener;
import oracle.bali.jle.tool.CreateToolValidateEvent;
import oracle.bali.jle.tool.undo.CreateUndo;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.event.ListenerManager;

public abstract class CreateTool
extends BaseTool {
    public static final int DRAG_CREATE_MODE = 1;
    public static final int CLICK_CREATE_MODE = 2;
    public static final int ALL_CREATE_MODE = 3;
    private double _startX;
    private double _startY;
    private double _endX;
    private double _endY;
    private double _defaultWidth = 5.0;
    private double _defaultHeight = 5.0;
    private transient boolean _banding;
    private boolean _yields = true;
    private int _createMode = 1;
    private ListenerManager _listeners;

    protected CreateTool() {
    }

    public void drawHighlight(Graphics g) {
        if (this.isDrawingHighlight()) {
            JLECanvas canvas = this.getCanvas();
            Rectangle2D select2D = GeometryUtils.getDrawRect(this._startX, this._startY, this._endX, this._endY);
            Rectangle select = canvas.contentToDevice(select2D.getX(), select2D.getY(), select2D.getWidth(), select2D.getHeight());
            Color oldColor = g.getColor();
            g.setColor(Color.black);
            g.drawRect(select.x, select.y, select.width, select.height);
            g.setColor(oldColor);
        }
    }

    public void pickup(JLECanvas canvas, JLEEventSource eventSource) {
        super.pickup(canvas, eventSource);
        this._endY = 0.0;
        this._startY = 0.0;
        this._endX = 0.0;
        this._startX = 0.0;
        this.setDrawingHighlight(false);
    }

    public long getDefaultEnabledEvents() {
        return 48L;
    }

    public boolean getYieldsAfterUse() {
        return this._yields;
    }

    public void setYieldsAfterUse(boolean yield) {
        this._yields = yield;
    }

    public LayoutItem processCreate(LayoutItem parent, Point2D translation, Dimension2D size) {
        Rectangle2D.Double preSize = new Rectangle2D.Double(translation.getX(), translation.getY(), size == null ? 0.0 : size.getWidth(), size == null ? 0.0 : size.getHeight());
        if (!this.fireCreateToolEvent(1, null, parent, preSize)) {
            return null;
        }
        LayoutItem created = this.createNewItem();
        if (created == null) {
            return null;
        }
        if (size == null || size.getWidth() <= 0.0 || size.getHeight() <= 0.0) {
            Dimension2D currSize = created.getItemSize();
            size = currSize.getWidth() > 0.0 && currSize.getHeight() > 0.0 ? currSize : this.getDefaultCreateSize();
        }
        created.setItemSize(size.getWidth(), size.getHeight());
        AffineTransform trans = created.getItemTransform();
        trans.translate(translation.getX(), translation.getY());
        try {
            created.setItemTransform(trans);
        }
        catch (TransformException e) {
            return null;
        }
        if (!parent.allowsChildren()) {
            return null;
        }
        parent.addItem(created, 0);
        this.fireCreateToolEvent(2, created, parent, new Rectangle2D.Double(translation.getX(), translation.getY(), size.getWidth(), size.getHeight()));
        return created;
    }

    public void addCreateToolListener(CreateToolListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void removeCreateToolListener(CreateToolListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    public void setDefaultCreateSize(double defaultWidth, double defaultHeight) {
        if (defaultWidth <= 0.0 || defaultHeight <= 0.0) {
            throw new IllegalArgumentException("default size must be non-zero");
        }
        this._defaultWidth = defaultWidth;
        this._defaultHeight = defaultHeight;
    }

    public Dimension2D getDefaultCreateSize() {
        return new Dimension2D.Double(this._defaultWidth, this._defaultHeight);
    }

    public void setCreateMode(int modeMask) {
        if (modeMask < 1) {
            throw new IllegalArgumentException("invalid create mode");
        }
        this._createMode = modeMask;
    }

    public int getCreateMode() {
        return this._createMode;
    }

    protected abstract LayoutItem createNewItem();

    protected void processMousePressed(JLEEvent e) {
        if (e.isConsumed()) {
            return;
        }
        this._startX = e.getX();
        this._startY = e.getY();
        e.consume();
    }

    protected void processMouseReleased(JLEEvent e) {
        if (e.isConsumed()) {
            return;
        }
        LayoutItem created = null;
        LayoutItem parent = ItemUtils.getParentAt(this.getCanvas().getContentItem(), this._startX, this._startY);
        if (parent != null) {
            Dimension2D size = null;
            Point2D translate = null;
            boolean create = false;
            if ((this.getCreateMode() & 1) != 0 && this.isDrawingHighlight()) {
                Rectangle2D select = GeometryUtils.getDrawRect(this._startX, this._startY, this._endX, this._endY);
                select = ItemUtils.transformRect(this.getCanvas().getDeviceTransform(), select.getX(), select.getY(), select.getWidth(), select.getHeight(), false);
                select = ItemUtils.deviceToItem(parent, select);
                size = new Dimension2D.Double(select.getWidth(), select.getHeight());
                translate = new Point2D.Double(select.getX(), select.getY());
                create = true;
            } else if ((this.getCreateMode() & 2) != 0 && !this.isDrawingHighlight()) {
                translate = ItemUtils.transformPoint(this.getCanvas().getDeviceTransform(), new Point2D.Double(this._startX, this._startY), false);
                translate = ItemUtils.deviceToItem(parent, translate);
                create = true;
            }
            if (create) {
                created = this.processCreate(parent, translate, size);
                if (size == null) {
                    size = created.getItemSize();
                }
                JLECanvas canvas = this.getCanvas();
                if (created != null && canvas.hasUndoableEditListeners()) {
                    CreateUndo edit = new CreateUndo(created, parent);
                    canvas.processUndoableEditEvent(new UndoableEditEvent(this, edit));
                }
            }
        }
        this.setDrawingHighlight(false);
        this.setImmediateRect(null);
        this.updateImmediately();
        e.consume();
        if (this.getYieldsAfterUse() && created != null) {
            this.yield();
        }
    }

    protected void processMouseDragged(JLEEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if ((this.getCreateMode() & 1) == 0) {
            return;
        }
        this.setDrawingHighlight(true);
        this._endX = e.getX();
        this._endY = e.getY();
        Rectangle2D select = GeometryUtils.getDrawRect(this._startX, this._startY, this._endX, this._endY);
        this.addImmediateRect(select);
        this.updateImmediately();
        e.consume();
    }

    protected boolean fireCreateToolEvent(int id, LayoutItem item, LayoutItem parent, Rectangle2D bounds) {
        Enumeration listeners;
        CreateToolEvent event;
        boolean cancelable = false;
        if (id == 1) {
            event = new CreateToolValidateEvent(this, id, item, parent, bounds);
            cancelable = true;
        } else {
            event = new CreateToolEvent(this, id, item, parent, bounds);
        }
        Enumeration enumeration = listeners = this._listeners == null ? null : this._listeners.getListeners();
        if (listeners == null) {
            return true;
        }
        while (listeners.hasMoreElements()) {
            CreateToolListener listener = (CreateToolListener)listeners.nextElement();
            if (id == 1) {
                listener.itemCreating(event);
                continue;
            }
            if (id != 2) continue;
            listener.itemCreated(event);
        }
        return cancelable ? !((Cancelable)((Object)event)).isCancelled() : true;
    }

    protected final boolean isDrawingHighlight() {
        return this._banding;
    }

    protected final void setDrawingHighlight(boolean banding) {
        this._banding = banding;
    }

    protected final ListenerManager getCreateListeners() {
        return this._listeners;
    }
}

