/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.tool.BoundsPainter;
import oracle.bali.jle.tool.ControlPoint;

public class DefaultBoundsPainter
implements BoundsPainter {
    private static DefaultBoundsPainter _painter;
    private static int _controlPointSize;
    private static Color _color;

    public void drawSelection(Graphics g, LayoutItem item, int x, int y, int width, int height) {
    }

    public void drawMove(Graphics g, LayoutItem item, int x, int y, int width, int height) {
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        Color oldColor = g.getColor();
        g.setColor(_color);
        g.drawRect(x, y, width - 1, height - 1);
        g.setColor(oldColor);
    }

    public void drawResize(Graphics g, LayoutItem item, int x, int y, int width, int height) {
        this.drawMove(g, item, x, y, width, height);
    }

    public void drawControlPoint(Graphics g, ControlPoint point, int x, int y) {
        if (point == null) {
            return;
        }
        Color oldColor = g.getColor();
        g.setColor(_color);
        g.fillRect(x, y, _controlPointSize, _controlPointSize);
        g.setColor(oldColor);
    }

    public int getControlPointWidth() {
        return _controlPointSize;
    }

    public int getControlPointHeight() {
        return _controlPointSize;
    }

    public Cursor getMoveCursor() {
        return null;
    }

    public static DefaultBoundsPainter getPainter() {
        if (_painter == null) {
            _painter = new DefaultBoundsPainter();
        }
        return _painter;
    }

    public static void setPaintColor(Color paintColor) {
        _color = paintColor;
    }

    public static Color getPaintColor() {
        return _color;
    }

    protected DefaultBoundsPainter() {
    }

    static {
        _controlPointSize = 5;
        _color = Color.black;
    }
}

