/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.vcscore;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ide.extension.DeferredElementVisitorHook;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionRegistry;
import oracle.ideimpl.vcscore.VersioningRegisterHandler;
import oracle.ideimpl.vcscore.VersioningRegistration;

public final class VersioningRegistrations {
    private static VersioningRegistrations _instance;
    private static final Lock _instanceLock;
    private final List<VersioningRegistration> _registrations = new ArrayList<VersioningRegistration>();

    private VersioningRegistrations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersioningRegistrations getInstance() {
        _instanceLock.lock();
        try {
            if (_instance == null) {
                _instance = new VersioningRegistrations();
                DeferredElementVisitorHook hookHandler = (DeferredElementVisitorHook)ExtensionRegistry.getExtensionRegistry().getHook(VersioningRegisterHandler.NAME);
                hookHandler.attachElementVisitor((ElementVisitor)new VersioningRegisterHandler());
                ArrayList<VersioningRegistration> registrations = new ArrayList<VersioningRegistration>(VersioningRegistrations._instance._registrations);
                Collections.sort(registrations, new Comparator<VersioningRegistration>(){

                    @Override
                    public int compare(VersioningRegistration r1, VersioningRegistration r2) {
                        return Collator.getInstance().compare(r1.getVcsName(), r2.getVcsName());
                    }
                });
                for (int i = 0; i < registrations.size(); ++i) {
                    ((VersioningRegistration)registrations.get(i)).setComputedWeight(i);
                }
            }
            VersioningRegistrations versioningRegistrations = _instance;
            return versioningRegistrations;
        }
        finally {
            _instanceLock.unlock();
        }
    }

    public List<VersioningRegistration> getRegistrations() {
        return Collections.unmodifiableList(this._registrations);
    }

    final void register(VersioningRegistration registration) {
        this._registrations.add(registration);
    }

    public final VersioningRegistration lookup(String extensionId) {
        for (VersioningRegistration registration : this._registrations) {
            if (!registration.getExtensionID().equals(extensionId)) continue;
            return registration;
        }
        return null;
    }

    static {
        _instanceLock = new ReentrantLock();
    }
}

