/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.conn;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.listener.ListenerConnectionType;
import oracle.dbtools.raptor.cloud.connection.ui.ConnectionEditor;
import oracle.dbtools.raptor.cloud.controls.CloudConnectionComboBox;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.db.DBConnArb;

public class ManageConnectionsController
implements Controller {
    private static final String ADD_CMD = "Listener.AddConnection";
    private static final String REMOVE_CMD = "Listener.RemoveConnection";
    static final int ADD_CMD_ID = Ide.findOrCreateCmdID((String)"Listener.AddConnection");
    static final int REMOVE_CMD_ID = Ide.findOrCreateCmdID((String)"Listener.RemoveConnection");

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == ADD_CMD_ID) {
            ConnectionEditor.getInstance().createConnection((CConnectionType)ListenerConnectionType.getInstance());
            return true;
        }
        if (n == REMOVE_CMD_ID) {
            this.removeConnection();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == ADD_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == REMOVE_CMD_ID) {
            CConnections cConnections = CConnections.getInstance((CConnectionType)ListenerConnectionType.getInstance());
            ideAction.setEnabled(cConnections.listConnections().length > 0);
            return true;
        }
        return false;
    }

    private void removeConnection() {
        String string;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        CloudConnectionComboBox cloudConnectionComboBox = new CloudConnectionComboBox((CConnectionType)ListenerConnectionType.getInstance());
        ResourceUtils.resLabel((JLabel)jLabel, (Component)cloudConnectionComboBox.getComboBox(), (String)DBConnArb.getString((int)7));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)cloudConnectionComboBox.getComboBox(), LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        JPanel jPanel2 = LayoutControl.GBC.createDialogMainPanel((Component)jPanel);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel2, "f1_ordsadminremoveconn_html");
        if (OnePageWizardDialogFactory.runDialog((Component)jPanel2, (Component)cloudConnectionComboBox.getComboBox(), (String)ListenerArb.getString("TITLE_REMOVE_CONNECTION")) && (string = cloudConnectionComboBox.getCurrentConnectionName()) != null) {
            CConnections.getInstance((CConnectionType)ListenerConnectionType.getInstance()).removeConnection(string);
        }
    }
}

