/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerConnectionSettings;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.listener.ui.ListenerUIUtils;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.util.ResourceUtils;

public class ListenerConnectionPanel
extends ListenerSettings
implements ItemListener {
    private ListenerConnectionSettings.CONNECTION_TYPES[] _ctList = ListenerConnectionSettings.CONNECTION_TYPES.values();
    private JPanel _connTypePanel;
    private JTextField _username;
    private JPasswordField _password;
    private JComboBox _connType;
    private JTextField _hostname;
    private JTextField _port;
    private JTextField _sid;
    private JTextField _servicename;
    private JRadioButton _sidBtn;
    private JRadioButton _servicenameBtn;
    private JTextField _tnsAliasName;
    private JTextField _tnsDirectory;
    private JTextArea _customJDBC_URL;

    public ListenerConnectionPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(200, 275));
        this._username = new JTextField();
        this._password = new JPasswordField();
        this._connType = new JComboBox<String>(ListenerUIUtils.getConnectionTypes());
        this._hostname = new JTextField();
        this._port = new JTextField();
        this._sid = new JTextField();
        this._servicename = new JTextField();
        this._sidBtn = new JRadioButton();
        this._servicenameBtn = new JRadioButton();
        this._tnsAliasName = new JTextField();
        this._tnsDirectory = new JTextField();
        this._customJDBC_URL = new JTextArea();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._username, (String)ListenerArb.getString("USERNAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._password, (String)ListenerArb.getString("PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._connType, (String)ListenerArb.getString("CONN_TYPE"));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._username, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._password, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 3, 6), 0, 0));
        jPanel.add((Component)this._connType, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 0, 3, 8), 0, 0));
        this._connTypePanel = this.getConnTypePanel();
        n = 0;
        this.add((Component)jPanel, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 23, 2, new Insets(0, 8, 0, 8), 0, 0));
        this.add((Component)this._connTypePanel, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 23, 2, new Insets(3, 8, 0, 8), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLastRow(n);
    }

    private void changeConnTypePanel() {
        this.remove(this._connTypePanel);
        this._connTypePanel = this.getConnTypePanel();
        this.add((Component)this._connTypePanel, new GridBagConstraints(0, 1, 2, 1, 0.5, 0.5, 23, 1, new Insets(3, 8, 0, 8), 0, 0));
        this._connTypePanel.revalidate();
        this._connTypePanel.repaint();
    }

    private JPanel getConnTypePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        ListenerConnectionSettings.CONNECTION_TYPES cONNECTION_TYPES = this._ctList[this._connType.getSelectedIndex()];
        switch (cONNECTION_TYPES) {
            case TNS: {
                jPanel = this.getTNSConnectionPanel();
                break;
            }
            case ADVANCED: {
                jPanel = this.getCustomJDBCURLPanel();
                break;
            }
            default: {
                jPanel = this.getBasicConnectionPanel();
            }
        }
        return jPanel;
    }

    private JPanel getBasicConnectionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._hostname, (String)ListenerArb.getString("HOSTNAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._port, (String)ListenerArb.getString("PORT"));
        ResourceUtils.resButton((AbstractButton)this._sidBtn, (String)ListenerArb.getString("SID"));
        ResourceUtils.resButton((AbstractButton)this._servicenameBtn, (String)ListenerArb.getString("SERVICE_NAME"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._sidBtn);
        buttonGroup.add(this._servicenameBtn);
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 8, 0, 6), 0, 0));
        jPanel.add((Component)this._hostname, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(6, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 6), 0, 0));
        jPanel.add((Component)this._port, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)this._sidBtn, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 0, 6), 0, 0));
        jPanel.add((Component)this._sid, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)this._servicenameBtn, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 6, 6), 0, 0));
        jPanel.add((Component)this._servicename, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 0, 6, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)ListenerArb.getString("CONN_TYPE_BASIC"));
        return jPanel;
    }

    private JPanel getTNSConnectionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._tnsAliasName, (String)ListenerArb.getString("TNS_ALIAS_NAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._tnsDirectory, (String)ListenerArb.getString("TNS_DIRECTORY"));
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 6), 0, 0));
        jPanel.add((Component)this._tnsAliasName, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 8, 6), 0, 0));
        jPanel.add((Component)this._tnsDirectory, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 23, 2, new Insets(8, 0, 8, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)ListenerArb.getString("CONN_TYPE_TNS"));
        return jPanel;
    }

    private JPanel getCustomJDBCURLPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._customJDBC_URL, (String)ListenerArb.getString("CUSTOM_JDBC_URL"));
        this._customJDBC_URL.setRows(5);
        this._customJDBC_URL.setLineWrap(true);
        this._customJDBC_URL.setWrapStyleWord(true);
        Dimension dimension = new Dimension(100, 100);
        this._customJDBC_URL.setSize(dimension);
        this._customJDBC_URL.setPreferredSize(dimension);
        this._customJDBC_URL.setMinimumSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(this._customJDBC_URL, 22, 31);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 3, 8), 0, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 8, 8, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)ListenerArb.getString("CONN_TYPE_ADVANCED"));
        return jPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this._sid.setEnabled(this._sidBtn.isSelected());
        this._servicename.setEnabled(this._servicenameBtn.isSelected());
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "Connections");
        this.assignSettings(this._model);
        this._connType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    ListenerConnectionPanel.this.changeConnTypePanel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._sidBtn.addItemListener(this);
        this._servicenameBtn.addItemListener(this);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getConnectionSettings() != null) {
            ListenerConnectionSettings listenerConnectionSettings = listenerModel.getConnectionSettings();
            this._username.setText(listenerConnectionSettings.getUserName());
            this._password.setText(listenerConnectionSettings.getPassword());
            boolean bl = false;
            if (this._connType.getSelectedIndex() != listenerConnectionSettings.getConnectionType().ordinal()) {
                bl = true;
            }
            this._connType.setSelectedIndex(listenerConnectionSettings.getConnectionType().ordinal());
            this._hostname.setText(listenerConnectionSettings.getHost());
            this._port.setText(listenerConnectionSettings.getPort());
            this._sid.setText(listenerConnectionSettings.getSid());
            this._servicename.setText(listenerConnectionSettings.getServiceName());
            if (listenerConnectionSettings.getSid() != null && !listenerConnectionSettings.getSid().isEmpty()) {
                this._sidBtn.setSelected(true);
            } else if (listenerConnectionSettings.getServiceName() != null && !listenerConnectionSettings.getServiceName().isEmpty()) {
                this._servicenameBtn.setSelected(true);
            } else {
                this._sidBtn.setSelected(true);
            }
            this._tnsAliasName.setText(listenerConnectionSettings.getTNSAliasName());
            this._tnsDirectory.setText(listenerConnectionSettings.getTNSDirectory());
            this._customJDBC_URL.setText(listenerConnectionSettings.getCustomJDBCURL());
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
            if (bl) {
                this.changeConnTypePanel();
            }
        } else {
            this._connType.setSelectedIndex(0);
            this._sidBtn.setSelected(true);
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getConnectionSettings() != null) {
            ListenerConnectionSettings listenerConnectionSettings = this._model.getConnectionSettings();
            listenerConnectionSettings.setUserName(this._username.getText().trim());
            listenerConnectionSettings.setPassword(String.valueOf(this._password.getPassword()));
            listenerConnectionSettings.setConnectionType(this._ctList[this._connType.getSelectedIndex()]);
            listenerConnectionSettings.setHost(this._hostname.getText().trim());
            listenerConnectionSettings.setPort(this._port.getText().trim());
            if (this._sidBtn.isSelected()) {
                listenerConnectionSettings.setSid(this._sid.getText().trim());
                listenerConnectionSettings.setServiceName("");
            } else {
                listenerConnectionSettings.setServiceName(this._servicename.getText().trim());
                listenerConnectionSettings.setSid("");
            }
            listenerConnectionSettings.setTNSAliasName(this._tnsAliasName.getText().trim());
            listenerConnectionSettings.setTNSDirectory(this._tnsDirectory.getText().trim());
            listenerConnectionSettings.setCustomJDBCURL(this._customJDBC_URL.getText().trim());
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        this.updateTextHandler(this._username, listenerModel.getConnectionSettings().getUserName());
        this.updateTextHandler(this._hostname, listenerModel.getConnectionSettings().getHost());
        this.updateTextHandler(this._port, listenerModel.getConnectionSettings().getPort());
        this.updateTextHandler(this._sid, listenerModel.getConnectionSettings().getSid());
        this.updateTextHandler(this._servicename, listenerModel.getConnectionSettings().getServiceName());
        this.updateTextHandler(this._tnsAliasName, listenerModel.getConnectionSettings().getTNSAliasName());
        this.updateTextHandler(this._tnsDirectory, listenerModel.getConnectionSettings().getTNSDirectory());
        this.updateTextHandler(this._customJDBC_URL, listenerModel.getConnectionSettings().getCustomJDBCURL());
        this.updateTextHandler(this._password, listenerModel.getConnectionSettings().getPassword());
        this.updateComboBoxHandler(this._connType, listenerModel.getConnectionSettings().getConnectionType().ordinal());
    }

    @Override
    public boolean isGlobalSettingsChange() {
        if (this._parentModel == null) {
            ListenerConnectionSettings listenerConnectionSettings = this._model.getConnectionSettings();
            if (this._username.getText() != listenerConnectionSettings.getUserName() || String.valueOf(this._password.getPassword()) != String.valueOf(this._password.getPassword()) || this._hostname.getText() != listenerConnectionSettings.getHost() || this._port.getText() != listenerConnectionSettings.getPort() || this._sid.getText() != listenerConnectionSettings.getSid() || this._servicename.getText() != listenerConnectionSettings.getServiceName() || this._tnsAliasName.getText() != listenerConnectionSettings.getTNSAliasName() || this._tnsDirectory.getText() != listenerConnectionSettings.getTNSDirectory() || this._customJDBC_URL.getText() != listenerConnectionSettings.getCustomJDBCURL() || this._connType.getSelectedIndex() != listenerConnectionSettings.getConnectionType().ordinal()) {
                return true;
            }
        }
        return false;
    }
}

