/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerConnectionPanel;
import oracle.dbtools.listener.ui.ListenerUIUtils;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class ListenerNewDBSettingsDialog
extends JPanel
implements ActionListener {
    private JEWTDialog _dialog;
    private JTextField _name;
    private ListenerConnectionPanel _connPanel;
    private String _errMsg;
    private ListenerModel _model;
    private ListenerModel _parentModel;

    public ListenerNewDBSettingsDialog(ListenerModel listenerModel) {
        this._parentModel = listenerModel;
    }

    private void init() {
        JPanel jPanel = this.getDBSettingPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_listenernewdbsettings_html");
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)ListenerArb.getString("CREATE_DB_SETTING"), (int)14);
        this._dialog.addActionListener((ActionListener)this);
        Dimension dimension = new Dimension(450, 450);
        this._dialog.setMinimumSize(dimension);
        this._dialog.setPreferredSize(dimension);
        this._dialog.setSize(dimension);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._dialog);
    }

    private JPanel getDBSettingPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this._connPanel = new ListenerConnectionPanel();
        this._connPanel.assignSettings(this._parentModel, this._model);
        this._name = new JTextField();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        jLabel2 = new JLabel(ListenerArb.getString("CONNECTION_TITLE"));
        Font font = jLabel2.getFont();
        jLabel2.setFont(font.deriveFont(font.getStyle() | 1, font.getSize() + 2));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._name, (String)ListenerArb.getString("DB_SETTING_NAME"));
        int n = 0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 6), 0, 0));
        jPanel2.add((Component)this._name, new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        n = 0;
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, n, 2, 1, 1.0, 1.0, 23, 2, new Insets(8, 8, 8, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 2, new Insets(8, 8, 0, 8), 0, 0));
        jPanel.add((Component)this._connPanel, new GridBagConstraints(0, ++n, 2, 2, 1.0, 1.0, 23, 1, new Insets(8, 8, 8, 8), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 0.5, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void copyParentConnectionInfo() {
        this._model = new ListenerModel();
        try {
            this._model.setConnectionSettings(this._parentModel.getConnectionSettings().clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, cloneNotSupportedException.getStackTrace()[0].toString(), cloneNotSupportedException);
        }
    }

    private boolean validInfo() {
        String string = this._name.getText();
        if (string == null || string.isEmpty() || string.trim().length() == 0) {
            this._errMsg = ListenerArb.getString("DB_ERR_NAME_REQUIRED");
            return false;
        }
        if (ListenerUIUtils.isDuplicateName(string)) {
            this._errMsg = ListenerArb.getString("DB_ERR_NAME_EXIST");
            return false;
        }
        return true;
    }

    private void showError() {
        MessageDialog.error((Component)this._dialog, (Object)this._errMsg, (String)ListenerArb.getString("ADMIN_ERROR_TITLE"), null);
    }

    private ListenerModel getSettings() {
        this._model = this._connPanel.getSettings();
        this._model.setName(this._name.getText());
        return this._model;
    }

    public ListenerModel getModel() {
        return this._model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runDialog() {
        boolean bl = false;
        try {
            this.copyParentConnectionInfo();
            this.init();
            bl = WizardLauncher.runDialog((JDialog)this._dialog);
        }
        catch (Exception exception) {
        }
        finally {
            if (this._dialog != null) {
                this._dialog.removeActionListener((ActionListener)this);
                this._dialog.dispose();
                this._dialog = null;
            }
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.validInfo()) {
            this.getSettings();
            this._dialog.dispose();
        } else {
            this.showError();
        }
    }
}

