/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.ListenerController;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerTreePanel;
import oracle.ide.controls.Toolbar;
import oracle.ide.util.ResourceUtils;

public class ListenerPanel
extends JPanel {
    private static ListenerPanel _instance;
    private Toolbar _toolbar;
    private ListenerTreePanel _treePanel;
    private boolean _init = false;
    private JLabel _connName;

    public ListenerPanel() {
        super(new GridBagLayout());
    }

    public static synchronized ListenerPanel getInstance() {
        if (_instance == null) {
            _instance = new ListenerPanel();
        }
        return _instance;
    }

    public void init() {
        if (!this._init) {
            this._init = true;
            this.buildToolbar();
            this._treePanel = new ListenerTreePanel();
            ListenerController.getInstance().attachTreeToMouseListener(this._treePanel.getTree());
            this.add((Component)this.getToolbar(), new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._treePanel, new GridBagConstraints(0, 1, 5, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        }
    }

    private void addConnectionNameToToolbar() {
        this._toolbar.addSeparator();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        int n = 0;
        int n2 = 0;
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        this._connName = new JLabel();
        this._connName.setOpaque(false);
        this._connName.setText(ListenerArb.getString("NOT_CONNECTED"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._connName, (String)ListenerArb.getString("CONNECTION_LABEL"));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(n2, n, 1, 1, 1.0, 1.0, 25, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(++n2, n, 1, 1, 0.0, 0.0, 25, 0, new Insets(0, 6, 0, 8), 0, 0));
        jPanel.add((Component)this._connName, new GridBagConstraints(++n2, n, 1, 1, 0.0, 0.0, 25, 0, new Insets(0, 0, 0, 16), 0, 0));
        this._toolbar.add((Component)jPanel);
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    private void buildToolbar() {
        this._toolbar = new Toolbar();
        ListenerController.getInstance().createToolbar(this.getToolbar());
        this.addConnectionNameToToolbar();
    }

    public void newAdministration(ListenerModel listenerModel) {
        if (this._treePanel != null) {
            this._treePanel.newAdministration(listenerModel);
        }
    }

    public void loadAdministration(ListenerModel listenerModel, boolean bl) {
        if (this._treePanel != null) {
            this._treePanel.loadAdministration(listenerModel, bl);
        }
    }

    public void loadReports(ListenerModel listenerModel) {
        if (this._treePanel != null) {
            this._treePanel.loadReports(listenerModel);
        }
    }

    public void newDBSettings(ListenerModel listenerModel) {
        if (this._treePanel != null) {
            this._treePanel.newDBSettings(listenerModel, false);
        }
    }

    public void removeDBSettings(int n) {
        if (this._treePanel != null) {
            this._treePanel.removeDBSettings(n);
        }
    }

    public ListenerModel updateGlobalSettingsValues() {
        if (this._treePanel != null) {
            return this._treePanel.getGlobalSettingsUIValues();
        }
        return null;
    }

    public ListenerModel updateGlobalSettingsValues(String string) {
        if (this._treePanel != null) {
            return this._treePanel.getGlobalSettingsUIValues(string);
        }
        return null;
    }

    public ArrayList<String> getSettingNames() {
        if (this._treePanel != null) {
            return this._treePanel.getSettingNames();
        }
        return null;
    }

    public ListenerModel getAllSettingsValues() {
        if (this._treePanel != null) {
            return this._treePanel.getAllSettingsValues();
        }
        return null;
    }

    public boolean validateName() {
        if (this._treePanel != null) {
            return this._treePanel.validateName();
        }
        return false;
    }

    public void setConnectionName(String string) {
        if (this._connName != null) {
            this._connName.setText(string);
        }
    }

    public String getConnectionName() {
        if (this._connName != null) {
            return this._connName.getText();
        }
        return null;
    }

    public boolean refreshReports(ListenerModel listenerModel, boolean bl) {
        if (this._treePanel != null) {
            return this._treePanel.refreshReports(listenerModel, bl);
        }
        return false;
    }
}

