/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.IListenerSettings;
import oracle.dbtools.listener.ui.ListenerCheckBoxHandler;
import oracle.dbtools.listener.ui.ListenerComboBoxHandler;
import oracle.dbtools.listener.ui.ListenerNumericSpinBoxHandler;
import oracle.dbtools.listener.ui.ListenerResetSettingsPanel;
import oracle.dbtools.listener.ui.ListenerTextHandler;

public abstract class ListenerSettings
extends JPanel
implements IListenerSettings {
    protected ListenerModel _model;
    protected ListenerModel _parentModel;
    private int _row;
    protected HashMap<Integer, Object> _handlers = new HashMap();
    private String _type = "";

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
    }

    public void assignSettings(ListenerModel listenerModel) {
    }

    @Override
    public ListenerModel getSettings() {
        return null;
    }

    @Override
    public boolean resetSettings() {
        if (this._parentModel != null) {
            this.assignSettings(this._parentModel);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateSettings() {
        this.getSettings();
        return true;
    }

    @Override
    public void highlightGlobalValues() {
        this.highlightGlobalValues(this._parentModel);
    }

    public void highlightGlobalValues(ListenerModel listenerModel) {
    }

    @Override
    public boolean isGlobalSettingsChange() {
        return false;
    }

    public void setType(String string) {
        this._type = string;
    }

    @Override
    public String getType() {
        return this._type;
    }

    protected void initSettings(ListenerModel listenerModel, ListenerModel listenerModel2, String string) {
        this.setType(string);
        if (listenerModel2 == null) {
            this._model = listenerModel;
        } else {
            this._model = listenerModel2;
            this._parentModel = listenerModel;
            if (!this.isReportType(string)) {
                this.addResetPanel();
            }
        }
    }

    protected void addSettingsPanel(JPanel jPanel) {
        this._row = 0;
        this.add((Component)jPanel, new GridBagConstraints(0, this._row, 1, 1, 1.0, 1.0, 23, 1, new Insets(8, 8, 8, 8), 0, 0));
    }

    protected void addResetPanel() {
        JLabel jLabel = new JLabel();
        jLabel.setText(ListenerArb.getString("HIGHLIGHTED_FIELDS"));
        ListenerResetSettingsPanel listenerResetSettingsPanel = new ListenerResetSettingsPanel(this);
        int n = 0;
        int n2 = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 15), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(++n2, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        jPanel.add((Component)listenerResetSettingsPanel, new GridBagConstraints(++n2, n, 1, 1, 0.0, 0.0, 24, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 25, 2, new Insets(15, 8, 8, 8), 0, 0));
    }

    protected void setLastRow(int n) {
        this._row = n;
    }

    protected int getLastRow() {
        return this._row;
    }

    protected void addTextHandler(JTextComponent jTextComponent, String string) {
        ListenerTextHandler listenerTextHandler = new ListenerTextHandler(jTextComponent, string);
        jTextComponent.getDocument().addDocumentListener(listenerTextHandler);
        this._handlers.put(new Integer(jTextComponent.hashCode()), listenerTextHandler);
    }

    protected void removeTextHandler(JTextComponent jTextComponent) {
        ListenerTextHandler listenerTextHandler;
        if (jTextComponent != null && (listenerTextHandler = (ListenerTextHandler)this._handlers.get(new Integer(jTextComponent.hashCode()))) != null) {
            jTextComponent.getDocument().removeDocumentListener(listenerTextHandler);
        }
    }

    protected void updateTextHandler(JTextComponent jTextComponent, String string) {
        if (jTextComponent != null) {
            ListenerTextHandler listenerTextHandler = (ListenerTextHandler)this._handlers.get(new Integer(jTextComponent.hashCode()));
            if (listenerTextHandler != null) {
                listenerTextHandler.updateGlobalValue(string);
            } else {
                this.addTextHandler(jTextComponent, string);
            }
        }
    }

    protected void addComboBoxHandler(JComboBox jComboBox, int n) {
        ListenerComboBoxHandler listenerComboBoxHandler = new ListenerComboBoxHandler(jComboBox, n);
        jComboBox.addItemListener(listenerComboBoxHandler);
        this._handlers.put(new Integer(jComboBox.hashCode()), listenerComboBoxHandler);
    }

    protected void updateComboBoxHandler(JComboBox jComboBox, int n) {
        if (jComboBox != null) {
            ListenerComboBoxHandler listenerComboBoxHandler = (ListenerComboBoxHandler)this._handlers.get(new Integer(jComboBox.hashCode()));
            if (listenerComboBoxHandler != null) {
                listenerComboBoxHandler.updateGlobalValue(n);
            } else {
                this.addComboBoxHandler(jComboBox, n);
            }
        }
    }

    protected void addNumericSpinBoxHandler(NumericSpinBox numericSpinBox, int n) {
        ListenerNumericSpinBoxHandler listenerNumericSpinBoxHandler = new ListenerNumericSpinBoxHandler(numericSpinBox, n);
        numericSpinBox.addChangeListener((ChangeListener)listenerNumericSpinBoxHandler);
        this._handlers.put(new Integer(numericSpinBox.hashCode()), listenerNumericSpinBoxHandler);
    }

    protected void updateNumericSpinBoxHandler(NumericSpinBox numericSpinBox, int n) {
        if (numericSpinBox != null) {
            ListenerNumericSpinBoxHandler listenerNumericSpinBoxHandler = (ListenerNumericSpinBoxHandler)this._handlers.get(new Integer(numericSpinBox.hashCode()));
            if (listenerNumericSpinBoxHandler != null) {
                listenerNumericSpinBoxHandler.updateGlobalValue(n);
            } else {
                this.addNumericSpinBoxHandler(numericSpinBox, n);
            }
        }
    }

    protected void addCheckBoxHandler(JCheckBox jCheckBox, boolean bl) {
        ListenerCheckBoxHandler listenerCheckBoxHandler = new ListenerCheckBoxHandler(jCheckBox, bl);
        jCheckBox.addItemListener(listenerCheckBoxHandler);
        this._handlers.put(new Integer(jCheckBox.hashCode()), listenerCheckBoxHandler);
    }

    protected void updateCheckBoxHandler(JCheckBox jCheckBox, boolean bl) {
        if (jCheckBox != null) {
            ListenerCheckBoxHandler listenerCheckBoxHandler = (ListenerCheckBoxHandler)this._handlers.get(new Integer(jCheckBox.hashCode()));
            if (listenerCheckBoxHandler != null) {
                listenerCheckBoxHandler.updateGlobalValue(bl);
            } else {
                this.addCheckBoxHandler(jCheckBox, bl);
            }
        }
    }

    protected boolean isReportType(String string) {
        return string.equals("Reports") || string.equals("ReportSummaryStatistics") || string.equals("ReportSettingsStatistics") || string.equals("ErrorTracking") || string.equals("ReportLogging");
    }
}

