/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.listener.ListenerAddin;
import oracle.dbtools.listener.model.ListenerConnectionSettings;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerNodeConstants;
import oracle.dbtools.listener.ui.ListenerNodeInfo;
import oracle.dbtools.listener.ui.ListenerPanel;

public class ListenerUIUtils {
    private static Color BACKGROUND_COLOR;

    public static void createSettingNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = ((ListenerNodeInfo)defaultMutableTreeNode.getUserObject()).getKey();
        for (ListenerNodeConstants.SETTING_CHILD_NODES sETTING_CHILD_NODES : ListenerNodeConstants.SETTING_CHILD_NODES.values()) {
            if (n == 0 ? sETTING_CHILD_NODES.equals((Object)ListenerNodeConstants.SETTING_CHILD_NODES.REST_NODE) : sETTING_CHILD_NODES.equals((Object)ListenerNodeConstants.SETTING_CHILD_NODES.SECURITY_NODE) || sETTING_CHILD_NODES.equals((Object)ListenerNodeConstants.SETTING_CHILD_NODES.CACHE_FILE_NODE) || sETTING_CHILD_NODES.equals((Object)ListenerNodeConstants.SETTING_CHILD_NODES.ENVIRONMENT_NODE) || sETTING_CHILD_NODES.equals((Object)ListenerNodeConstants.SETTING_CHILD_NODES.EXCEL_NODE)) continue;
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ListenerNodeInfo(sETTING_CHILD_NODES.getName(), sETTING_CHILD_NODES.getType(), n));
            switch (sETTING_CHILD_NODES) {
                case CONNECTION_NODE: {
                    ListenerUIUtils.createConnectionNodes(defaultMutableTreeNode2);
                    break;
                }
                case SECURITY_NODE: {
                    ListenerUIUtils.createSecurityNodes(defaultMutableTreeNode2);
                    break;
                }
                case ENVIRONMENT_NODE: {
                    ListenerUIUtils.createEnvironmentNodes(defaultMutableTreeNode2);
                    break;
                }
                case CACHE_FILE_NODE: {
                    ListenerUIUtils.createCacheFileNodes(defaultMutableTreeNode2);
                }
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    public static void createConnectionNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = ((ListenerNodeInfo)defaultMutableTreeNode.getUserObject()).getKey();
        for (ListenerNodeConstants.CONNECTION_CHILD_NODES cONNECTION_CHILD_NODES : ListenerNodeConstants.CONNECTION_CHILD_NODES.values()) {
            if (cONNECTION_CHILD_NODES.equals((Object)ListenerNodeConstants.CONNECTION_CHILD_NODES.URL_MAPPING_NODE) && n == 0) continue;
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ListenerNodeInfo(cONNECTION_CHILD_NODES.getName(), cONNECTION_CHILD_NODES.getType(), n));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    public static void createSecurityNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = ((ListenerNodeInfo)defaultMutableTreeNode.getUserObject()).getKey();
        for (ListenerNodeConstants.SECURITY_CHILD_NODES sECURITY_CHILD_NODES : ListenerNodeConstants.SECURITY_CHILD_NODES.values()) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ListenerNodeInfo(sECURITY_CHILD_NODES.getName(), sECURITY_CHILD_NODES.getType(), n));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    public static void createEnvironmentNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = ((ListenerNodeInfo)defaultMutableTreeNode.getUserObject()).getKey();
        for (ListenerNodeConstants.ENVIRONMENT_CHILD_NODES eNVIRONMENT_CHILD_NODES : ListenerNodeConstants.ENVIRONMENT_CHILD_NODES.values()) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ListenerNodeInfo(eNVIRONMENT_CHILD_NODES.getName(), eNVIRONMENT_CHILD_NODES.getType(), n));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    public static void createCacheFileNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = ((ListenerNodeInfo)defaultMutableTreeNode.getUserObject()).getKey();
        for (ListenerNodeConstants.CACHE_CHILD_NODES cACHE_CHILD_NODES : ListenerNodeConstants.CACHE_CHILD_NODES.values()) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ListenerNodeInfo(cACHE_CHILD_NODES.getName(), cACHE_CHILD_NODES.getType(), n));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    public static void createReportingNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = ((ListenerNodeInfo)defaultMutableTreeNode.getUserObject()).getKey();
        for (ListenerNodeConstants.REPORT_SETTINGS_NODES rEPORT_SETTINGS_NODES : ListenerNodeConstants.REPORT_SETTINGS_NODES.values()) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ListenerNodeInfo(rEPORT_SETTINGS_NODES.getName(), rEPORT_SETTINGS_NODES.getType(), n));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    public static String[] getConnectionTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ListenerConnectionSettings.CONNECTION_TYPES cONNECTION_TYPES : ListenerConnectionSettings.CONNECTION_TYPES.values()) {
            arrayList.add(cONNECTION_TYPES.getNLSName());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] getJDBCDriverTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ListenerConnectionSettings.JDBC_DRIVER_TYPES jDBC_DRIVER_TYPES : ListenerConnectionSettings.JDBC_DRIVER_TYPES.values()) {
            arrayList.add(jDBC_DRIVER_TYPES.getNLSName());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static ListenerModel initializeDBSettingsValues(ListenerModel listenerModel, ListenerModel listenerModel2, boolean bl) throws CloneNotSupportedException {
        ListenerModel listenerModel3 = new ListenerModel();
        listenerModel3 = listenerModel.clone();
        listenerModel3.setName(listenerModel2.getName());
        listenerModel3.getCacheSettings().setTotalCacheEntries(0);
        listenerModel3.getSecuritySettings().setTotalCacheEntries(0);
        listenerModel3.getReportSettings().setTotalLogEntries(0);
        listenerModel3.getReportSettings().setTotalErrorEntries(0);
        listenerModel3.getConnectionSettings().setListenerPassword("");
        listenerModel3.getConnectionSettings().setRestPassword("");
        if (!bl) {
            listenerModel3.getConnectionSettings().setConnectionType(listenerModel2.getConnectionSettings().getConnectionType());
            listenerModel3.getConnectionSettings().setUserName(listenerModel2.getConnectionSettings().getUserName());
            listenerModel3.getConnectionSettings().setPassword(listenerModel2.getConnectionSettings().getPassword());
            listenerModel3.getConnectionSettings().setPort(listenerModel2.getConnectionSettings().getPort());
            listenerModel3.getConnectionSettings().setHost(listenerModel2.getConnectionSettings().getHost());
            listenerModel3.getConnectionSettings().setSid(listenerModel2.getConnectionSettings().getSid());
            listenerModel3.getConnectionSettings().setServiceName(listenerModel2.getConnectionSettings().getServiceName());
            listenerModel3.getConnectionSettings().setTNSAliasName(listenerModel2.getConnectionSettings().getTNSAliasName());
            listenerModel3.getConnectionSettings().setTNSDirectory(listenerModel2.getConnectionSettings().getTNSDirectory());
            listenerModel3.getConnectionSettings().setCustomJDBCURL(listenerModel2.getConnectionSettings().getCustomJDBCURL());
        }
        return listenerModel3;
    }

    public static boolean isDuplicateName(String string) {
        ArrayList<String> arrayList = ((ListenerPanel)ListenerAddin.getListenerWindow().getGUI()).getSettingNames();
        for (String string2 : arrayList) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static Color getHighlightBackgroundColor() {
        if (BACKGROUND_COLOR == null) {
            BACKGROUND_COLOR = new Color(232, 242, 254);
        }
        return BACKGROUND_COLOR;
    }

    public static String getCommaDelimited(List<String> list) {
        if (list != null && !list.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = list.size();
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append(list.get(i));
                if (i == n - 1) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static long getLongValue(Object object) {
        if (object != null) {
            try {
                return ((Number)object).longValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static String getStringValue(Object object) {
        if (object != null) {
            try {
                return (String)object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }
}

