/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.utils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerConnectionSettings;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerReportSettings;
import oracle.dbtools.listener.model.ListenerSecuritySettings;
import oracle.dbtools.raptor.utils.Closeables;
import oracle.jdbc.driver.OracleDriver;

public class ListenerValidator {
    private ListenerModel _model;
    private ArrayList<String> _messages;
    private Connection _conn = null;
    private static final String NEWLINE = System.getProperty("line.separator");
    private boolean _isDisplayedDBSettingName = false;
    private boolean _isDisplayedGlobalSettingHdr = false;

    public ListenerValidator(ListenerModel listenerModel) {
        this._model = listenerModel;
    }

    public boolean isValidDBSettings() {
        this._messages = new ArrayList();
        this.validateGlobalSettings();
        this.validateDBSettings();
        return this._messages.size() == 0;
    }

    private void validateGlobalSettings() {
        this.validateVirusScanning(this._model.getSecuritySettings());
        this.validateExcel(this._model.getReportSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDBSettings() {
        if (!this._model.hasChildren()) {
            this.adminErrorMessage(ListenerArb.getString("REQUIRES_DB_SETTING"));
            return;
        }
        if (this.isValidDBSettingNames()) {
            for (ListenerModel listenerModel : this._model.getChildren()) {
                this._isDisplayedDBSettingName = false;
                try {
                    this.validateSettings(listenerModel, listenerModel.getName());
                }
                catch (Exception exception) {}
                continue;
                finally {
                    if (this._conn == null) continue;
                    try {
                        if (this._conn.isClosed()) continue;
                        Closeables.close((Object)this._conn);
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    private boolean isValidDBSettingNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ListenerModel listenerModel : this._model.getChildren()) {
            int n = listenerModel.getID();
            String string = listenerModel.getName();
            if (this.isEmpty(string)) {
                arrayList.add(ListenerArb.format("DB_SETTINGS_HDR", listenerModel.getName()));
                arrayList.add(ListenerArb.getString("MISSING_DB_SETTING_NAME"));
                break;
            }
            boolean bl = false;
            for (ListenerModel listenerModel2 : this._model.getChildren()) {
                if (n == listenerModel2.getID() || !string.equalsIgnoreCase(listenerModel2.getName())) continue;
                arrayList.add(ListenerArb.format("DB_SETTINGS_HDR", listenerModel.getName()));
                arrayList.add(ListenerArb.getString("DUPLICATE_DB_SETTING_NAME"));
                bl = true;
            }
            if (!bl) continue;
            break;
        }
        if (arrayList.size() == 0) {
            return true;
        }
        this.adminErrorMessage(arrayList);
        return false;
    }

    private void validateSettings(ListenerModel listenerModel, String string) {
        block13: {
            boolean bl = false;
            try {
                bl = this.validateConnection(listenerModel.getConnectionSettings().getUserName(), listenerModel.getConnectionSettings().getPassword(), listenerModel.getConnectionSettings(), string);
            }
            catch (Exception exception) {
                this.displayDBSettingName(string);
                this.adminErrorMessage(ListenerArb.format("CONNECT_ERROR", listenerModel.getConnectionSettings().getUserName(), exception.getLocalizedMessage()));
            }
            try {
                if (!bl) break block13;
                if (!this.isEmpty(listenerModel.getConnectionSettings().getRestPassword()) && !this.isEmpty(listenerModel.getConnectionSettings().getListenerPassword())) {
                    try {
                        this.validateConnection(listenerModel.getConnectionSettings().getRestUserName(), listenerModel.getConnectionSettings().getRestPassword(), listenerModel.getConnectionSettings(), string);
                    }
                    catch (SQLException sQLException) {
                        this.displayDBSettingName(string);
                        this.adminErrorMessage(ListenerArb.format("CONNECT_ERROR", listenerModel.getConnectionSettings().getRestUserName(), sQLException.getLocalizedMessage()));
                    }
                    try {
                        this.validateConnection(listenerModel.getConnectionSettings().getListenerUsername(), listenerModel.getConnectionSettings().getListenerPassword(), listenerModel.getConnectionSettings(), string);
                    }
                    catch (SQLException sQLException) {
                        this.displayDBSettingName(string);
                        this.adminErrorMessage(ListenerArb.format("CONNECT_ERROR", listenerModel.getConnectionSettings().getListenerUsername(), sQLException.getLocalizedMessage()));
                    }
                } else if (!this.isEmpty(listenerModel.getConnectionSettings().getRestPassword()) && this.isEmpty(listenerModel.getConnectionSettings().getListenerPassword())) {
                    this.displayDBSettingName(string);
                    this.adminErrorMessage(ListenerArb.format("RESTFUL_PASSWORD_REQUIRED", ListenerArb.getString("APEX_LISTENER")));
                } else if (this.isEmpty(listenerModel.getConnectionSettings().getRestPassword()) && !this.isEmpty(listenerModel.getConnectionSettings().getListenerPassword())) {
                    this.displayDBSettingName(string);
                    this.adminErrorMessage(ListenerArb.format("RESTFUL_PASSWORD_REQUIRED", ListenerArb.getString("APEX_REST_PUBLIC_USER")));
                }
                this.validateValidationFunction(this._model.getSecuritySettings(), listenerModel.getConnectionSettings().getUserName(), string);
                this.validateProcedures(this._model.getProcedureSettings().getPreProcessProcedures(), listenerModel.getConnectionSettings().getUserName(), "PreProcessing", string);
                this.validateProcedures(this._model.getProcedureSettings().getPostProcessProcedures(), listenerModel.getConnectionSettings().getUserName(), "PostProcessing", string);
            }
            catch (Exception exception) {
                this.displayDBSettingName(string);
                this.adminErrorMessage(exception.getLocalizedMessage());
            }
        }
    }

    private void validateValidationFunction(ListenerSecuritySettings listenerSecuritySettings, String string, String string2) {
        ListenerValidateProcedure listenerValidateProcedure;
        String string3 = listenerSecuritySettings.getValidationFunction();
        if (this.isEmpty(string3) || listenerSecuritySettings.getValidationFunctionType() == ListenerSecuritySettings.VALIDATION_FUNCTION_TYPE.JAVASCRIPT) {
            return;
        }
        String string4 = listenerSecuritySettings.getValidationFunction();
        if (string3.indexOf("(") > 0) {
            string4 = string3.substring(0, string3.indexOf("("));
        }
        if ((listenerValidateProcedure = new ListenerValidateProcedure()).isValidProcedure(string4 = string4.trim(), string)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(NEWLINE);
        stringBuilder.append(ListenerArb.format("VALIDATION_FUNCTION_ERR", string2, string3)).append(NEWLINE);
        stringBuilder.append(ListenerArb.format("FIX_GLOBAL_SETTINGS", ListenerArb.getString("VALIDATION_FUNCTION_NODE")));
        stringBuilder.append(NEWLINE);
        this.adminErrorMessage(stringBuilder.toString());
    }

    private void validateVirusScanning(ListenerSecuritySettings listenerSecuritySettings) {
        if (!this.isEmpty(listenerSecuritySettings.getICAPPort()) && this.isEmpty(listenerSecuritySettings.getICAPServer())) {
            this.displayGlobalSettingHeader();
            this.adminErrorMessage(ListenerArb.getString("MISSING_ICAP_SERVER"));
        } else if (this.isEmpty(listenerSecuritySettings.getICAPPort()) && !this.isEmpty(listenerSecuritySettings.getICAPServer())) {
            this.displayGlobalSettingHeader();
            this.adminErrorMessage(ListenerArb.getString("MISSING_ICAP_PORT"));
        }
    }

    private void validateProcedures(List<String> list, String string, String string2, String string3) {
        if (list == null || list.size() == 0) {
            return;
        }
        int n = 0;
        ListenerValidateProcedure listenerValidateProcedure = new ListenerValidateProcedure();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : list) {
            String string5;
            String string6;
            if (this.isEmpty(string4) || listenerValidateProcedure.isValidProcedure(string4, string)) continue;
            if (n > 0) {
                stringBuilder.append(NEWLINE);
            }
            if (string2 == "PreProcessing") {
                string6 = ListenerArb.getString("PREPROCESS_PROC");
                string5 = ListenerArb.getString("PRE_PROCESSING_NODE");
            } else {
                string6 = ListenerArb.getString("POSTPROCESS_PROC");
                string5 = ListenerArb.getString("POST_PROCESSING_NODE");
            }
            stringBuilder.append(ListenerArb.format("PROCESS_PROC_ERR", string3, string6, string4));
            stringBuilder.append(NEWLINE);
            stringBuilder.append(ListenerArb.format("FIX_GLOBAL_SETTINGS", string5));
            stringBuilder.append(NEWLINE);
            ++n;
        }
        if (n > 0) {
            this.adminErrorMessage(stringBuilder.toString());
        }
    }

    private void validateExcel(ListenerReportSettings listenerReportSettings) {
        if (listenerReportSettings.isCreateCollectionFromExcelFile() && listenerReportSettings.isPutWorkSheetsInOneCollection() && this.isEmpty(listenerReportSettings.getCollectionName())) {
            this.displayGlobalSettingHeader();
            this.adminErrorMessage(ListenerArb.getString("MISSING_COLLECTION_NAME"));
        }
    }

    private boolean validateConnection(String string, String string2, ListenerConnectionSettings listenerConnectionSettings, String string3) throws SQLException {
        ArrayList<String> arrayList = this.getMissingConnectionInfo(string, string2, listenerConnectionSettings);
        if (arrayList.size() > 0) {
            this.displayDBSettingName(string3);
            this.adminErrorMessage(arrayList);
            return false;
        }
        String string4 = listenerConnectionSettings.getJDBCDriver().getType();
        if (string4 == null || string4.isEmpty()) {
            string4 = "thin";
        }
        String string5 = null;
        ListenerConnectionSettings.CONNECTION_TYPES cONNECTION_TYPES = listenerConnectionSettings.getConnectionType();
        switch (cONNECTION_TYPES) {
            case BASIC: {
                if (!this.isEmpty(listenerConnectionSettings.getServiceName())) {
                    string5 = "jdbc:oracle:" + string4 + ":@//" + listenerConnectionSettings.getHost() + ":" + listenerConnectionSettings.getPort() + "/" + listenerConnectionSettings.getServiceName();
                    break;
                }
                string5 = "jdbc:oracle:" + string4 + ":@" + listenerConnectionSettings.getHost() + ":" + listenerConnectionSettings.getPort() + ":" + listenerConnectionSettings.getSid();
                break;
            }
            case TNS: {
                if (this.isEmpty(listenerConnectionSettings.getTNSDirectory())) {
                    this.adminErrorMessage(ListenerArb.getString("TNS_DIR_REQUIRED"));
                    return false;
                }
                System.setProperty("oracle.net.tns_admin", listenerConnectionSettings.getTNSDirectory());
                string5 = "jdbc:oracle:" + string4 + ":@" + listenerConnectionSettings.getTNSAliasName();
                break;
            }
            case ADVANCED: {
                string5 = listenerConnectionSettings.getCustomJDBCURL();
            }
        }
        Connection connection = null;
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            connection = DriverManager.getConnection(string5, string, string2);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (string.equals("APEX_REST_PUBLIC_USER") || string.equals("APEX_LISTENER")) {
                if (connection != null && !connection.isClosed()) {
                    Closeables.close((Object)connection);
                }
            } else {
                this._conn = connection;
            }
        }
        return true;
    }

    private ArrayList<String> getMissingConnectionInfo(String string, String string2, ListenerConnectionSettings listenerConnectionSettings) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isEmpty(string)) {
            arrayList.add(ListenerArb.getString("USERNAME_REQUIRED"));
        }
        if (this.isEmpty(string2)) {
            arrayList.add(ListenerArb.format("PASSWORD_USER_REQUIRED", string));
        }
        ListenerConnectionSettings.CONNECTION_TYPES cONNECTION_TYPES = listenerConnectionSettings.getConnectionType();
        switch (cONNECTION_TYPES) {
            case BASIC: {
                if (this.isEmpty(listenerConnectionSettings.getHost())) {
                    arrayList.add(ListenerArb.getString("HOSTNAME_REQUIRED"));
                }
                if (this.isEmpty(listenerConnectionSettings.getPort())) {
                    arrayList.add(ListenerArb.getString("PORT_REQUIRED"));
                }
                if (!this.isEmpty(listenerConnectionSettings.getSid()) || !this.isEmpty(listenerConnectionSettings.getServiceName())) break;
                arrayList.add(ListenerArb.getString("SID_SERVICENAME_REQUIRED"));
                break;
            }
            case TNS: {
                if (this.isEmpty(listenerConnectionSettings.getTNSAliasName())) {
                    arrayList.add(ListenerArb.getString("TNS_REQUIRED"));
                }
                if (!this.isEmpty(listenerConnectionSettings.getTNSDirectory())) break;
                arrayList.add(ListenerArb.getString("TNS_DIR_REQUIRED"));
                break;
            }
            case ADVANCED: {
                if (!this.isEmpty(listenerConnectionSettings.getCustomJDBCURL())) break;
                arrayList.add(ListenerArb.getString("CUSTOM_JDBC_URL_REQUIRED"));
            }
        }
        return arrayList;
    }

    private boolean isValidRestUsersPassword(String string, String string2) {
        return this.isEmpty(string) && this.isEmpty(string2) || !this.isEmpty(string) && !this.isEmpty(string2);
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty() || string.trim().length() == 0 || string.equalsIgnoreCase("null");
    }

    private void adminErrorMessage(ArrayList<String> arrayList) {
        for (String string : arrayList) {
            this.adminErrorMessage(string);
        }
    }

    private void adminErrorMessage(String string) {
        if (this._messages == null) {
            this._messages = new ArrayList();
        }
        this._messages.add(string);
    }

    public String getAdminErrorMessage() {
        if (this._messages != null && this._messages.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Calendar.getInstance().getTime()).append(NEWLINE);
            for (String string : this._messages) {
                stringBuilder.append(string).append(NEWLINE);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private void displayGlobalSettingHeader() {
        if (this._isDisplayedGlobalSettingHdr) {
            return;
        }
        this.adminErrorMessage(NEWLINE);
        this.adminErrorMessage(ListenerArb.getString("GLOBAL_SETTINGS_HDR"));
        this._isDisplayedGlobalSettingHdr = true;
    }

    private void displayDBSettingName(String string) {
        if (this._isDisplayedDBSettingName) {
            return;
        }
        this.adminErrorMessage(NEWLINE);
        this.adminErrorMessage(ListenerArb.format("DB_SETTINGS_HDR", string));
        this._isDisplayedDBSettingName = true;
    }

    private class ListenerValidateProcedure {
        private static final String PUBLIC_OWNER = "PUBLIC";
        private static final String USER_PROCEDURE = "select sys_context('USERENV', 'SESSION_USER') owner, p.object_name object_name, p.procedure_name procedure_name from USER_PROCEDURES p where p.object_name = ? and (p.procedure_name is null)";
        private static final String PACKAGE_PROCEDURE = "SELECT * FROM SYS.ALL_PROCEDURES WHERE OBJECT_NAME = ? AND PROCEDURE_NAME = ?";
        private static final String OWNER_PACKAGE_PROCEDURE = "SELECT * FROM SYS.ALL_PROCEDURES WHERE OWNER = ? AND OBJECT_NAME = ? AND PROCEDURE_NAME = ?";
        private static final String ALL_SYNONYMS = "SELECT * FROM SYS.ALL_SYNONYMS WHERE (OWNER = ?) AND (SYNONYM_NAME = ?)";
        private static final String USER_SYNONYMS = "SELECT * FROM USER_SYNONYMS WHERE SYNONYM_NAME = ?";
        private static final String STANDALONE_PROCEDURE = "SELECT * FROM SYS.ALL_PROCEDURES WHERE (OWNER = ?) AND (OBJECT_NAME = ?)  AND (PROCEDURE_NAME IS NULL)";
        private String _rawName;
        private String _userName;
        private String _owner;
        private String _proc;
        private String _tableOwner;
        private String _tableName;
        private String _objectName;

        private ListenerValidateProcedure() {
        }

        public boolean isValidProcedure(String string, String string2) {
            this._rawName = string;
            this._userName = string2;
            return this.resolveName(string);
        }

        private boolean resolveName(String string) {
            this._rawName = string;
            boolean bl = false;
            String[] stringArray = this._rawName.split("\\.");
            if (stringArray.length == 3) {
                String string2 = stringArray[0].toUpperCase();
                String string3 = stringArray[1].toUpperCase();
                String string4 = stringArray[2].toUpperCase();
                return this.isProcedureExist(ListenerValidator.this._conn, OWNER_PACKAGE_PROCEDURE, string2, string3, string4);
            }
            if (stringArray.length == 2) {
                String string5 = stringArray[0].toUpperCase();
                String string6 = stringArray[1].toUpperCase();
                if (this.checkSynonym(ListenerValidator.this._conn, ALL_SYNONYMS, PUBLIC_OWNER, string5)) {
                    bl = this.isProcedureExist(ListenerValidator.this._conn, OWNER_PACKAGE_PROCEDURE, this._tableOwner, this._tableName, string6);
                    if (!bl && this.checkSynonym(ListenerValidator.this._conn, ALL_SYNONYMS, this._tableOwner, this._tableName)) {
                        bl = this.isProcedureExist(ListenerValidator.this._conn, OWNER_PACKAGE_PROCEDURE, this._tableOwner, this._tableName, string6);
                    }
                } else if (this.checkSynonym(ListenerValidator.this._conn, USER_SYNONYMS, string5, null)) {
                    bl = this.isProcedureExist(ListenerValidator.this._conn, PACKAGE_PROCEDURE, this._userName, this._tableName, null);
                    if (!bl && this.checkSynonym(ListenerValidator.this._conn, USER_SYNONYMS, this._tableName, null)) {
                        bl = this.isProcedureExist(ListenerValidator.this._conn, OWNER_PACKAGE_PROCEDURE, this._userName, this._tableName, string6);
                    }
                } else {
                    int n = this.checkProcedureExist(ListenerValidator.this._conn, PACKAGE_PROCEDURE, string5, string6, null);
                    if (n == 1) {
                        bl = true;
                    } else if (n > 1) {
                        // empty if block
                    }
                }
                if (bl && this._owner != null && this._objectName != null && this._proc != null) {
                    return true;
                }
                String string7 = stringArray[0].toUpperCase();
                string5 = stringArray[1].toUpperCase();
                bl = this.isProcedureExist(ListenerValidator.this._conn, STANDALONE_PROCEDURE, string7, string5, null);
                if (bl) {
                    this._proc = this._objectName;
                }
                return bl;
            }
            if (stringArray.length == 1) {
                String string8 = stringArray[0].toUpperCase();
                if (this.checkSynonym(ListenerValidator.this._conn, ALL_SYNONYMS, PUBLIC_OWNER, string8)) {
                    bl = this.isProcedureExist(ListenerValidator.this._conn, STANDALONE_PROCEDURE, this._tableOwner, this._tableName, null);
                    if (bl) {
                        this._proc = this._objectName;
                    }
                } else {
                    int n = this.checkProcedureExist(ListenerValidator.this._conn, USER_PROCEDURE, string8, null, null);
                    if (n == 1) {
                        bl = true;
                        this._proc = this._objectName;
                    } else if (n > 1) {
                        // empty if block
                    }
                }
                return bl;
            }
            return false;
        }

        private boolean isProcedureExist(Connection connection, String string, String string2, String string3, String string4) {
            int n = this.checkProcedureExist(connection, string, string2, string3, string4);
            return n > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int checkProcedureExist(Connection connection, String string, String string2, String string3, String string4) {
            int n;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            int n2 = 0;
            try {
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, string2);
                if (string3 != null) {
                    preparedStatement.setString(2, string3);
                }
                if (string4 != null) {
                    preparedStatement.setString(3, string4);
                }
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    this._owner = resultSet.getString("OWNER");
                    this._objectName = resultSet.getString("OBJECT_NAME");
                    this._proc = resultSet.getString("PROCEDURE_NAME");
                    ++n2;
                }
                n = n2;
            }
            catch (Exception exception) {
                int n3;
                try {
                    n3 = 0;
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new Wrapper[]{resultSet, preparedStatement});
                    throw throwable;
                }
                Closeables.close((Object[])new Wrapper[]{resultSet, preparedStatement});
                return n3;
            }
            Closeables.close((Object[])new Wrapper[]{resultSet, preparedStatement});
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkSynonym(Connection connection, String string, String string2, String string3) {
            boolean bl;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            boolean bl2 = false;
            try {
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, string2);
                if (string3 != null) {
                    preparedStatement.setString(2, string3);
                }
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    this._tableOwner = resultSet.getString("TABLE_OWNER");
                    this._tableName = resultSet.getString("TABLE_NAME");
                    bl2 = true;
                }
                bl = bl2;
            }
            catch (Exception exception) {
                boolean bl3;
                try {
                    bl3 = bl2;
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new Wrapper[]{resultSet, preparedStatement});
                    throw throwable;
                }
                Closeables.close((Object[])new Wrapper[]{resultSet, preparedStatement});
                return bl3;
            }
            Closeables.close((Object[])new Wrapper[]{resultSet, preparedStatement});
            return bl;
        }
    }
}

