/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.xml;

import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.listener.model.ListenerCacheSettings;
import oracle.dbtools.listener.model.ListenerConnectionSettings;
import oracle.dbtools.listener.model.ListenerEnvironmentSettings;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerProcedureSettings;
import oracle.dbtools.listener.model.ListenerReportSettings;
import oracle.dbtools.listener.model.ListenerSecuritySettings;
import oracle.dbtools.listener.model.ListenerURLMappings;
import oracle.dbtools.listener.xml.ListenerXMLConstants;
import oracle.ide.ProductInformation;
import oracle.ide.Version;

public class ListenerXMLUtils {
    private static ListenerXMLUtils _xmlUtil;
    private ListenerModel _model;
    private ListenerModel _parentModel;
    private StringBuffer _xmlFormat;
    private LinkedHashMap<String, String> _settingsMap = new LinkedHashMap();

    public static ListenerXMLUtils getInstance() {
        if (_xmlUtil == null) {
            _xmlUtil = new ListenerXMLUtils();
        }
        return _xmlUtil;
    }

    public String formatSettingsToXML(ListenerModel listenerModel, ListenerModel listenerModel2, Properties properties) {
        this.init(listenerModel, listenerModel2);
        this.xmlDeclaration();
        this.formatConnections();
        this.formatJDBC();
        if (listenerModel != null && listenerModel2 == null) {
            this.formatSecurity();
            this.formatCache();
            this.formatProcessingProcedures();
            this.formatEnvironment();
            this.formatExcel();
        }
        this.formatSQLDev();
        this.preserveUnsupportedSettingsProperties(properties);
        this.endTag("properties");
        return this.getFormattedXMLSettings();
    }

    public String formatRESTUserToXML(ListenerModel listenerModel, ListenerModel listenerModel2, int n, Properties properties) {
        this.init(listenerModel, listenerModel2);
        this.formatUserToXML(listenerModel2, n, properties);
        return this.getFormattedXMLSettings();
    }

    public String formatURLMappingsToXML(ListenerModel listenerModel) {
        this.init(listenerModel, null);
        this.formatURLMappings(listenerModel);
        return this.getFormattedXMLSettings();
    }

    private void init(ListenerModel listenerModel, ListenerModel listenerModel2) {
        if (listenerModel2 == null) {
            this._model = listenerModel;
            this._parentModel = null;
        } else {
            this._model = listenerModel2;
            this._parentModel = listenerModel;
        }
        this._xmlFormat = new StringBuffer();
        this._settingsMap = new LinkedHashMap();
    }

    private void formatConnections() {
        ListenerConnectionSettings listenerConnectionSettings;
        this._settingsMap.clear();
        ListenerConnectionSettings listenerConnectionSettings2 = this._model.getConnectionSettings();
        ListenerConnectionSettings listenerConnectionSettings3 = listenerConnectionSettings = this._parentModel == null ? null : this._parentModel.getConnectionSettings();
        if (!this.isEmpty(listenerConnectionSettings2.getUserName()) && (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getUserName(), listenerConnectionSettings2.getUserName()))) {
            this._settingsMap.put("db.username", listenerConnectionSettings2.getUserName());
        }
        if (!this.isEmpty(listenerConnectionSettings2.getPassword()) && (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getPassword(), listenerConnectionSettings2.getPassword()))) {
            this._settingsMap.put("db.password", this.convertValue(listenerConnectionSettings2.getPassword()));
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getConnectionType().getType(), listenerConnectionSettings2.getConnectionType().getType())) {
            this._settingsMap.put("db.connectionType", listenerConnectionSettings2.getConnectionType().getType());
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getHost(), listenerConnectionSettings2.getHost())) {
            this._settingsMap.put("db.hostname", listenerConnectionSettings2.getHost());
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getPort(), listenerConnectionSettings2.getPort())) {
            this._settingsMap.put("db.port", listenerConnectionSettings2.getPort());
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getSid(), listenerConnectionSettings2.getSid())) {
            this._settingsMap.put("db.sid", listenerConnectionSettings2.getSid());
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getServiceName(), listenerConnectionSettings2.getServiceName())) {
            this._settingsMap.put("db.servicename", listenerConnectionSettings2.getServiceName());
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getTNSAliasName(), listenerConnectionSettings2.getTNSAliasName())) {
            this._settingsMap.put("db.tnsAliasName", listenerConnectionSettings2.getTNSAliasName());
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getTNSDirectory(), listenerConnectionSettings2.getTNSDirectory())) {
            this._settingsMap.put("db.tnsDirectory", listenerConnectionSettings2.getTNSDirectory());
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getCustomJDBCURL(), listenerConnectionSettings2.getCustomJDBCURL())) {
            this._settingsMap.put("db.customURL", listenerConnectionSettings2.getCustomJDBCURL());
        }
        this.formatEntries(this._settingsMap, true);
    }

    private void formatJDBC() {
        ListenerConnectionSettings listenerConnectionSettings;
        this._settingsMap.clear();
        ListenerConnectionSettings listenerConnectionSettings2 = this._model.getConnectionSettings();
        ListenerConnectionSettings listenerConnectionSettings3 = listenerConnectionSettings = this._parentModel == null ? null : this._parentModel.getConnectionSettings();
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getJDBCDriver().getType(), listenerConnectionSettings2.getJDBCDriver().getType())) {
            this._settingsMap.put("jdbc.DriverType", listenerConnectionSettings2.getJDBCDriver().getType());
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getInitialPoolSize(), listenerConnectionSettings2.getInitialPoolSize())) {
            this._settingsMap.put("jdbc.InitialLimit", Integer.toString(listenerConnectionSettings2.getInitialPoolSize()));
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getMinimumConnections(), listenerConnectionSettings2.getMinimumConnections())) {
            this._settingsMap.put("jdbc.MinLimit", Integer.toString(listenerConnectionSettings2.getMinimumConnections()));
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getMaximumConnections(), listenerConnectionSettings2.getMaximumConnections())) {
            this._settingsMap.put("jdbc.MaxLimit", Integer.toString(listenerConnectionSettings2.getMaximumConnections()));
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getMaximumStatements(), listenerConnectionSettings2.getMaximumStatements())) {
            this._settingsMap.put("jdbc.MaxStatementsLimit", Integer.toString(listenerConnectionSettings2.getMaximumStatements()));
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getInactivityTimeout(), listenerConnectionSettings2.getInactivityTimeout())) {
            this._settingsMap.put("jdbc.InactivityTimeout", Integer.toString(listenerConnectionSettings2.getInactivityTimeout()));
        }
        if (listenerConnectionSettings == null || this.acceptValue(listenerConnectionSettings.getAbandonedConnectionTimeout(), listenerConnectionSettings2.getAbandonedConnectionTimeout())) {
            this._settingsMap.put("jdbc.statementTimeout", Integer.toString(listenerConnectionSettings2.getAbandonedConnectionTimeout()));
        }
        this.formatEntries(this._settingsMap, true);
    }

    private void formatSecurity() {
        ListenerSecuritySettings listenerSecuritySettings;
        this._settingsMap.clear();
        ListenerSecuritySettings listenerSecuritySettings2 = this._model.getSecuritySettings();
        ListenerSecuritySettings listenerSecuritySettings3 = listenerSecuritySettings = this._parentModel == null ? null : this._parentModel.getSecuritySettings();
        if (listenerSecuritySettings == null || this.acceptValue(this.getCommaDelimited(listenerSecuritySettings.getAllowedProcedures()), this.getCommaDelimited(listenerSecuritySettings2.getAllowedProcedures()))) {
            this._settingsMap.put("security.inclusionList", this.getCommaDelimited(listenerSecuritySettings2.getAllowedProcedures()));
        }
        if (listenerSecuritySettings == null || this.acceptValue(this.getCommaDelimited(listenerSecuritySettings.getBlockedProcedures()), this.getCommaDelimited(listenerSecuritySettings2.getBlockedProcedures()))) {
            this._settingsMap.put("security.exclusionList", this.getCommaDelimited(listenerSecuritySettings2.getBlockedProcedures()));
        }
        if (listenerSecuritySettings == null || this.acceptValue(listenerSecuritySettings.isDisableExclusionList(), listenerSecuritySettings2.isDisableExclusionList())) {
            this._settingsMap.put("security.disableDefaultExclusionList", Boolean.toString(listenerSecuritySettings2.isDisableExclusionList()));
        }
        if (listenerSecuritySettings == null || this.acceptValue(listenerSecuritySettings.getValidationFunctionType().getValue(), listenerSecuritySettings2.getValidationFunctionType().getValue())) {
            this._settingsMap.put("security.validationFunctionType", listenerSecuritySettings2.getValidationFunctionType().getValue());
        }
        if (listenerSecuritySettings == null || this.acceptValue(listenerSecuritySettings.getValidationFunction(), listenerSecuritySettings2.getValidationFunction())) {
            this._settingsMap.put("security.requestValidationFunction", this.convertXMLReservedCharacters(listenerSecuritySettings2.getValidationFunction()));
        }
        if (listenerSecuritySettings == null || this.acceptValue(listenerSecuritySettings.getMaximumCacheEntries(), listenerSecuritySettings2.getMaximumCacheEntries())) {
            this._settingsMap.put("security.maxEntries", Integer.toString(listenerSecuritySettings2.getMaximumCacheEntries()));
        }
        if (listenerSecuritySettings == null || this.acceptValue(listenerSecuritySettings.isVerifySSLRequests(), listenerSecuritySettings2.isVerifySSLRequests())) {
            this._settingsMap.put("security.verifySSL", Boolean.toString(listenerSecuritySettings2.isVerifySSLRequests()));
        }
        this.formatEntries(this._settingsMap, true);
        this._settingsMap.clear();
        String string = null;
        String string2 = null;
        if (listenerSecuritySettings == null || this.acceptValue(listenerSecuritySettings.getICAPServer(), listenerSecuritySettings2.getICAPServer())) {
            string2 = listenerSecuritySettings2.getICAPServer();
        }
        if (listenerSecuritySettings == null || this.acceptValue(listenerSecuritySettings.getICAPPort(), listenerSecuritySettings2.getICAPPort())) {
            string = listenerSecuritySettings2.getICAPPort();
        }
        if (!this.isEmpty(string) && !this.isEmpty(string2)) {
            this._settingsMap.put("icap.port", listenerSecuritySettings2.getICAPPort());
            this._settingsMap.put("icap.server", listenerSecuritySettings2.getICAPServer());
        }
        this.formatEntries(this._settingsMap, true);
    }

    private void formatCache() {
        ListenerCacheSettings listenerCacheSettings;
        this._settingsMap.clear();
        ListenerCacheSettings listenerCacheSettings2 = this._model.getCacheSettings();
        ListenerCacheSettings listenerCacheSettings3 = listenerCacheSettings = this._parentModel == null ? null : this._parentModel.getCacheSettings();
        if (listenerCacheSettings == null || this.acceptValue(listenerCacheSettings.isCaching(), listenerCacheSettings2.isCaching())) {
            this._settingsMap.put("cache.caching", Boolean.toString(listenerCacheSettings2.isCaching()));
        }
        if (listenerCacheSettings == null || this.acceptValue(this.getCommaDelimited(listenerCacheSettings.getCacheProcedures()), this.getCommaDelimited(listenerCacheSettings2.getCacheProcedures()))) {
            this._settingsMap.put("cache.procedureNameList", this.getCommaDelimited(listenerCacheSettings2.getCacheProcedures()));
        }
        if (listenerCacheSettings == null || this.acceptValue(listenerCacheSettings.getCacheType().getType(), listenerCacheSettings2.getCacheType().getType())) {
            this._settingsMap.put("cache.type", listenerCacheSettings2.getCacheType().getType());
        }
        if (listenerCacheSettings == null || this.acceptValue(listenerCacheSettings.getMaxCacheEntries(), listenerCacheSettings2.getMaxCacheEntries())) {
            this._settingsMap.put("cache.maxEntries", Integer.toString(listenerCacheSettings2.getMaxCacheEntries()));
        }
        if (listenerCacheSettings == null || this.acceptValue(listenerCacheSettings.getExpiration(), listenerCacheSettings2.getExpiration())) {
            this._settingsMap.put("cache.expiration", Integer.toString(listenerCacheSettings2.getExpiration()));
        }
        if (listenerCacheSettings == null || this.acceptValue(listenerCacheSettings.getDuration().getValue(), listenerCacheSettings2.getDuration().getValue())) {
            this._settingsMap.put("cache.duration", listenerCacheSettings2.getDuration().getValue());
        }
        if (listenerCacheSettings == null || this.acceptValue(listenerCacheSettings.getDirectory(), listenerCacheSettings2.getDirectory())) {
            this._settingsMap.put("cache.directory", listenerCacheSettings2.getDirectory());
        }
        this.formatEntries(this._settingsMap, true);
    }

    private void formatEnvironment() {
        ListenerReportSettings listenerReportSettings;
        ListenerEnvironmentSettings listenerEnvironmentSettings;
        this._settingsMap.clear();
        ListenerEnvironmentSettings listenerEnvironmentSettings2 = this._model.getEnvironmentSettings();
        ListenerEnvironmentSettings listenerEnvironmentSettings3 = listenerEnvironmentSettings = this._parentModel == null ? null : this._parentModel.getEnvironmentSettings();
        if (listenerEnvironmentSettings == null || this.acceptValue(listenerEnvironmentSettings.getDefaultWebPage(), listenerEnvironmentSettings2.getDefaultWebPage())) {
            this._settingsMap.put("misc.defaultPage", listenerEnvironmentSettings2.getDefaultWebPage());
        }
        if (listenerEnvironmentSettings == null || this.acceptValue(listenerEnvironmentSettings.getDocTable(), listenerEnvironmentSettings2.getDocTable())) {
            this._settingsMap.put("apex.docTable", listenerEnvironmentSettings2.getDocTable());
        }
        if (listenerEnvironmentSettings == null || this.acceptValue(listenerEnvironmentSettings.getExtensionClasses(), listenerEnvironmentSettings2.getExtensionClasses())) {
            this._settingsMap.put("apex.extensions", listenerEnvironmentSettings2.getExtensionClasses());
        }
        if (listenerEnvironmentSettings == null || this.acceptValue(listenerEnvironmentSettings.isRecordProcedure(), listenerEnvironmentSettings2.isRecordProcedure())) {
            this._settingsMap.put("log.procedure", Boolean.toString(listenerEnvironmentSettings2.isRecordProcedure()));
        }
        ListenerReportSettings listenerReportSettings2 = this._model.getReportSettings();
        ListenerReportSettings listenerReportSettings3 = listenerReportSettings = this._parentModel == null ? null : this._parentModel.getReportSettings();
        if (listenerReportSettings == null || listenerReportSettings.getDebugOutput() != listenerReportSettings2.getDebugOutput()) {
            String string = "off";
            if (listenerReportSettings2.getDebugOutput() == ListenerReportSettings.DEBUG_OUTPUT.CONSOLE) {
                string = "console";
            } else if (listenerReportSettings2.getDebugOutput() == ListenerReportSettings.DEBUG_OUTPUT.LOGGER) {
                string = "logger";
            }
            this._settingsMap.put("debug.output", string);
        }
        if (listenerReportSettings == null || this.acceptValue(listenerReportSettings.isDisplayErrorMessages(), listenerReportSettings2.isDisplayErrorMessages())) {
            this._settingsMap.put("debug.printDebugToScreen", Boolean.toString(listenerReportSettings2.isDisplayErrorMessages()));
        }
        if (listenerReportSettings == null || this.acceptValue(listenerReportSettings.isKeepErrorMessages(), listenerReportSettings2.isKeepErrorMessages())) {
            this._settingsMap.put("error.keepErrorMessages", Boolean.toString(listenerReportSettings2.isKeepErrorMessages()));
        }
        if (listenerReportSettings == null || this.acceptValue(listenerReportSettings.getMaxErrorEntries(), listenerReportSettings2.getMaxErrorEntries())) {
            this._settingsMap.put("error.maxEntries", Integer.toString(listenerReportSettings2.getMaxErrorEntries()));
        }
        if (listenerReportSettings == null || this.acceptValue(listenerReportSettings.isLogging(), listenerReportSettings2.isLogging())) {
            this._settingsMap.put("log.logging", Boolean.toString(listenerReportSettings2.isLogging()));
        }
        if (listenerReportSettings == null || this.acceptValue(listenerReportSettings.getMaxLogEntries(), listenerReportSettings2.getMaxLogEntries())) {
            this._settingsMap.put("log.maxEntries", Integer.toString(listenerReportSettings2.getMaxLogEntries()));
        }
        if (listenerReportSettings == null || this.acceptValue(listenerReportSettings.isReporting(), listenerReportSettings2.isReporting())) {
            this._settingsMap.put("status.statistics", Boolean.toString(listenerReportSettings2.isReporting()));
        }
        this.formatEntries(this._settingsMap, true);
    }

    private void formatProcessingProcedures() {
        ListenerProcedureSettings listenerProcedureSettings;
        this._settingsMap.clear();
        ListenerProcedureSettings listenerProcedureSettings2 = this._model.getProcedureSettings();
        ListenerProcedureSettings listenerProcedureSettings3 = listenerProcedureSettings = this._parentModel == null ? null : this._parentModel.getProcedureSettings();
        if (listenerProcedureSettings == null || this.acceptValue(this.getCommaDelimited(listenerProcedureSettings.getPreProcessProcedures()), this.getCommaDelimited(listenerProcedureSettings2.getPreProcessProcedures()))) {
            this._settingsMap.put("procedure.preProcess", this.getCommaDelimited(listenerProcedureSettings2.getPreProcessProcedures()));
        }
        if (listenerProcedureSettings == null || this.acceptValue(this.getCommaDelimited(listenerProcedureSettings.getPostProcessProcedures()), this.getCommaDelimited(listenerProcedureSettings2.getPostProcessProcedures()))) {
            this._settingsMap.put("procedure.postProcess", this.getCommaDelimited(listenerProcedureSettings2.getPostProcessProcedures()));
        }
        this.formatEntries(this._settingsMap, true);
    }

    private void formatExcel() {
        ListenerReportSettings listenerReportSettings;
        this._settingsMap.clear();
        ListenerReportSettings listenerReportSettings2 = this._model.getReportSettings();
        ListenerReportSettings listenerReportSettings3 = listenerReportSettings = this._parentModel == null ? null : this._parentModel.getReportSettings();
        if (listenerReportSettings == null || this.acceptValue(listenerReportSettings.isCreateCollectionFromExcelFile(), listenerReportSettings2.isCreateCollectionFromExcelFile())) {
            this._settingsMap.put("apex.excel2collection", Boolean.toString(listenerReportSettings2.isCreateCollectionFromExcelFile()));
        }
        if (listenerReportSettings == null || this.acceptValue(listenerReportSettings.isPutWorkSheetsInOneCollection(), listenerReportSettings2.isPutWorkSheetsInOneCollection())) {
            this._settingsMap.put("apex.excel2collection.onecollection", Boolean.toString(listenerReportSettings2.isPutWorkSheetsInOneCollection()));
        }
        if (listenerReportSettings == null || this.acceptValue(listenerReportSettings.isUseWorkSheetNameAsCollectionName(), listenerReportSettings2.isUseWorkSheetNameAsCollectionName())) {
            this._settingsMap.put("apex.excel2collection.useSheetName", Boolean.toString(listenerReportSettings2.isUseWorkSheetNameAsCollectionName()));
        }
        if (listenerReportSettings == null || this.acceptValue(listenerReportSettings.getCollectionName(), listenerReportSettings2.getCollectionName())) {
            this._settingsMap.put("apex.excel2collection.name", listenerReportSettings2.getCollectionName());
        }
        this.formatEntries(this._settingsMap, true);
    }

    private void formatSQLDev() {
        this._settingsMap.clear();
        boolean bl = this._parentModel == null;
        this._settingsMap.put("sqldev.name", this._model.getName());
        this._settingsMap.put("sqldev.description", this.convertXMLReservedCharacters(this._model.getDescription()));
        if (bl) {
            this._settingsMap.put("sqldev.version", this._model.getSqlDevVersion());
        }
        this.formatEntries(this._settingsMap, true);
    }

    private void formatUserToXML(ListenerModel listenerModel, int n, Properties properties) {
        this.xmlDeclaration();
        this._settingsMap.clear();
        ListenerConnectionSettings listenerConnectionSettings = listenerModel.getConnectionSettings();
        String string = null;
        String string2 = null;
        String string3 = null;
        if (n == 1) {
            this._settingsMap.put("db.username", listenerConnectionSettings.getListenerUsername());
            string2 = listenerConnectionSettings.getListenerPassword();
        } else if (n == 2) {
            this._settingsMap.put("db.username", listenerConnectionSettings.getRestUserName());
            string2 = listenerConnectionSettings.getRestPassword();
        }
        if (this._parentModel != null && this._parentModel.getConnectionSettings() != null) {
            string3 = this._parentModel.getConnectionSettings().getPassword();
        }
        if (!(this.isEmpty(string2) || string3 != null && string2.equals(string3) || this.isEmpty(string = this.convertValue(string2)))) {
            this._settingsMap.put("db.password", string);
        }
        this.formatEntries(this._settingsMap, true);
        this.preserveUnsupportedRESTProperties(properties);
        this.endTag("properties");
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty() || string.trim().length() == 0;
    }

    private void formatURLMappings(ListenerModel listenerModel) {
        this._settingsMap.clear();
        this._xmlFormat.append("<pool-config xmlns=\"http://xmlns.oracle.com/apex/pool-config\">").append("\n");
        for (ListenerModel listenerModel2 : listenerModel.getChildren()) {
            String string = listenerModel2.getName();
            List<ListenerURLMappings.URLPattern> list = listenerModel2.getUrlMappings().getURLPatterns();
            if (list == null) continue;
            for (ListenerURLMappings.URLPattern uRLPattern : list) {
                this._xmlFormat.append("   ").append("<pool name=\"").append(string).append("\"\n");
                this._xmlFormat.append("      ").append(uRLPattern.getRuleType().getType()).append("=\"").append(uRLPattern.getURLPattern()).append("\"");
                this._xmlFormat.append(" workspace-id=\"").append(uRLPattern.getSchema() == null ? "" : uRLPattern.getSchema()).append("\"");
                this._xmlFormat.append("/>\n");
            }
        }
        this._xmlFormat.append("</pool-config>");
        this.formatEntries(this._settingsMap, true);
    }

    private void xmlDeclaration() {
        this._xmlFormat.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this._xmlFormat.append("<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">\n");
        this._xmlFormat.append("<properties>\n\n");
        this._xmlFormat.append("<comment>").append("\n");
        this._xmlFormat.append("   Listener Administration").append("\n");
        this._xmlFormat.append("   ").append(this.getProductNameVersion()).append("\n");
        this._xmlFormat.append("   ").append("Last Update: ").append(Calendar.getInstance().getTime()).append("\n");
        this._xmlFormat.append("</comment>").append("\n\n");
    }

    private void endTag(String string) {
        this._xmlFormat.append("</").append(string).append(">");
    }

    private boolean acceptValue(String string, String string2) {
        String string3;
        String string4 = string == null ? "" : string.trim();
        String string5 = string3 = string2 == null ? "" : string2.trim();
        return !string4.equals(string3);
    }

    private boolean acceptValue(int n, int n2) {
        return n2 != n;
    }

    private boolean acceptValue(boolean bl, boolean bl2) {
        return bl2 != bl;
    }

    private void formatEntries(LinkedHashMap<String, String> linkedHashMap, boolean bl) {
        if (linkedHashMap == null || linkedHashMap.isEmpty()) {
            return;
        }
        for (String string : linkedHashMap.keySet()) {
            String string2 = linkedHashMap.get(string);
            this._xmlFormat.append(this.formatEntry(string, string2));
        }
        if (bl) {
            this._xmlFormat.append("\n");
        }
    }

    private String formatEntry(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<entry key=\"").append(string).append("\"");
        if (string2 != null && !string2.isEmpty()) {
            stringBuffer.append(">").append(string2).append("</entry>");
        } else {
            stringBuffer.append("/>");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getFormattedXMLSettings() {
        return this._xmlFormat.toString();
    }

    private String getCommaDelimited(List<String> list) {
        if (list != null && !list.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = list.size();
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append(list.get(i));
                if (i == n - 1) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private String getProductNameVersion() {
        return ProductInformation.getProductInformation().getName() + " " + Version.VER_FULL;
    }

    private String convertXMLReservedCharacters(String string) {
        if (string != null && string.length() != 0) {
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n);
            block6: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '&': {
                        stringBuilder.append("&amp;");
                        continue block6;
                    }
                    case '<': {
                        stringBuilder.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        stringBuilder.append("&gt;");
                        continue block6;
                    }
                    case '\"': {
                        stringBuilder.append("&quot;");
                        continue block6;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private String convertValue(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return "@" + Passwords.goingOut((String)string);
    }

    private void preserveUnsupportedSettingsProperties(Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            this._settingsMap.clear();
            for (Object object : properties.keySet()) {
                String string = (String)object;
                if (ListenerXMLConstants.SUPPORTED_PROPERTIES.contains(string)) continue;
                String string2 = (String)properties.get(string);
                this._settingsMap.put(string, string2);
            }
            this.formatEntries(this._settingsMap, true);
        }
    }

    private void preserveUnsupportedRESTProperties(Properties properties) {
        if (properties != null && !properties.isEmpty()) {
            this._settingsMap.clear();
            for (Object object : properties.keySet()) {
                String string = (String)object;
                if (string.equals("db.username") || string.equals("db.password")) continue;
                String string2 = (String)properties.get(string);
                this._settingsMap.put(string, string2);
            }
            this.formatEntries(this._settingsMap, true);
        }
    }
}

