/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.jcip.annotations.GuardedBy;
import oracle.ide.file.AbstractFileSetTable;
import oracle.ide.file.FileChange;
import oracle.ide.file.FileSet;
import oracle.ide.file.FileSetFilters;
import oracle.ide.file.FileTable;
import oracle.ide.file.InvalidFileTableException;
import oracle.ide.natives.DirectoryWatcher;
import oracle.ide.net.SymlinkCycleDetector;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLKey;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.persistence.Storage;
import oracle.ide.util.IntHashMap;
import oracle.ideimpl.file.InvalidationQueue;
import oracle.ideimpl.file.InvalidationRecord;
import oracle.ideimpl.file.Utils;

final class DirectoryFileTable
extends AbstractFileSetTable {
    static final int ROOT_DIRECTORY_ID = 0;
    private static final boolean DELAYED_INVALIDATION = !Boolean.getBoolean("oracle.ide.file.immediate.invalidation");
    @GuardedBy(value="this")
    private DirectoryFileSystemListener directoryFileSystemListener;
    private final ReentrantLock invalidationLock = new ReentrantLock();
    @GuardedBy(value="invalidationLock")
    private InvalidationQueue queue = new InvalidationQueue();
    @GuardedBy(value="invalidationLock")
    private Future lastScheduledRefresh;
    @GuardedBy(value="invalidationLock")
    private boolean active;

    DirectoryFileTable(Storage storage, FileSet fileSet) {
        super(storage, fileSet);
    }

    @Override
    public void invalidate() {
        this.invalidateDirectoryImpl(this.fileSet.getRoot(), true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void activateImpl() {
        this.invalidationLock.lock();
        try {
            this.active = true;
        }
        finally {
            this.invalidationLock.unlock();
        }
        URL root = this.fileSet.getRoot();
        this.directoryFileSystemListener = new DirectoryFileSystemListener();
        URLFileSystem.addURLFileSystemListener((URL)root, (URLFileSystemListener)this.directoryFileSystemListener);
        if (DirectoryFileTable.getRefreshAutomatically() && URLFileSystem.isLocal((URL)root)) {
            DirectoryWatcher watcher = DirectoryWatcher.createDirectoryWatcher((URL)root, (DirectoryWatcher.DirectoryListener)this.directoryFileSystemListener);
            this.directoryFileSystemListener.setDirectoryWatcher(watcher);
        }
    }

    @Override
    protected synchronized void deactivateImpl() {
        URLFileSystem.removeURLFileSystemListener((URL)this.fileSet.getRoot(), (URLFileSystemListener)this.directoryFileSystemListener);
        if (DirectoryFileTable.getRefreshAutomatically()) {
            this.directoryFileSystemListener.removeDirectoryWatcher();
        }
        this.directoryFileSystemListener = null;
        try {
            this.run(new CancelRefreshOperation(), false, false, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invalidateFileImpl(URL file, boolean isBufferChange) {
        block12: {
            assert (!URLFileSystem.isDirectoryPath((URL)file));
            try {
                if (DELAYED_INVALIDATION) {
                    this.invalidationLock.lock();
                    try {
                        if (this.active && this.queue.invalidateFile(file, isBufferChange)) {
                            this.reschedule();
                        }
                        break block12;
                    }
                    finally {
                        this.invalidationLock.unlock();
                    }
                }
                try {
                    this.refreshFile(file, isBufferChange);
                }
                catch (Exception e) {}
            }
            catch (RejectedExecutionException e) {
                try {
                    this.run(new RefreshFileOperation(file, isBufferChange), true, false);
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invalidateDirectoryImpl(URL directory, boolean includeSubdirectories, URL renameHintOldURL, URL renameHintNewURL) {
        block12: {
            assert (URLFileSystem.isDirectoryPath((URL)directory));
            try {
                if (DELAYED_INVALIDATION) {
                    this.invalidationLock.lock();
                    try {
                        if (this.active && this.queue.invalidateDirectory(directory, includeSubdirectories, renameHintOldURL, renameHintNewURL)) {
                            this.reschedule();
                        }
                        break block12;
                    }
                    finally {
                        this.invalidationLock.unlock();
                    }
                }
                try {
                    this.refreshDirectory(directory, includeSubdirectories, renameHintOldURL, renameHintNewURL);
                }
                catch (Exception e) {}
            }
            catch (RejectedExecutionException e) {
                try {
                    this.run(new RefreshDirectoryOperation(directory, includeSubdirectories, renameHintOldURL, renameHintNewURL), true, false);
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
        }
    }

    private void reschedule() throws RejectedExecutionException {
        if (this.lastScheduledRefresh != null) {
            this.lastScheduledRefresh.cancel(false);
        }
        RefreshTask task = new RefreshTask();
        this.lastScheduledRefresh = SCHEDULER.schedule(task, 2L, DELAY_UNIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean hasPendingValidation() {
        if (this.invalidationLock.tryLock()) {
            try {
                boolean bl = this.lastScheduledRefresh != null && !this.lastScheduledRefresh.isDone() || !this.queue.isEmpty();
                return bl;
            }
            finally {
                this.invalidationLock.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearInvalidationQueue() throws InterruptedException {
        this.invalidationLock.lockInterruptibly();
        try {
            this.queue.clear();
        }
        finally {
            this.invalidationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInvalidationQueue(AbstractFileSetTable.Session session) throws InterruptedException, IOException {
        InvalidationQueue localQueue = null;
        this.invalidationLock.lockInterruptibly();
        try {
            if (session.wasRefreshed) {
                this.queue.clear();
            } else {
                localQueue = this.queue.drain();
            }
        }
        finally {
            this.invalidationLock.unlock();
        }
        if (localQueue != null) {
            try {
                localQueue.coalesce();
                Iterator<InvalidationRecord> iterator = localQueue.iterator();
                while (iterator.hasNext()) {
                    InvalidationRecord record = iterator.next();
                    try {
                        if (record.isSingleFileInvalid()) {
                            for (Map.Entry<URLKey, Boolean> file : record.getFiles().entrySet()) {
                                new RefreshFileOperation(file.getKey().toURL(), file.getValue()).run(session);
                            }
                        } else {
                            new RefreshDirectoryOperation(record.getDirectory(), record.isRecursive(), record.getFiles(), record.getRenameHints()).run(session);
                        }
                        iterator.remove();
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        iterator.remove();
                        throw e;
                    }
                    catch (Exception e) {
                        iterator.remove();
                        throw new IOException(e);
                    }
                    DirectoryFileTable.checkInterrupt();
                }
            }
            finally {
                if (!localQueue.isEmpty()) {
                    this.invalidationLock.lock();
                    try {
                        this.queue.mergeFrom(localQueue);
                    }
                    finally {
                        this.invalidationLock.unlock();
                    }
                }
            }
        }
    }

    @Override
    protected void refreshFile(URL file, boolean isBufferChange) throws InterruptedException, IOException {
        try {
            this.run(new RefreshFileOperation(file, isBufferChange));
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected exception in file table " + this, e);
        }
    }

    @Override
    protected void refreshDirectory(URL directory, boolean includeSubdirectories, URL renameHintOldURL, URL renameHintNewURL) throws InterruptedException, IOException {
        try {
            this.run(new RefreshDirectoryOperation(directory, includeSubdirectories, renameHintOldURL, renameHintNewURL));
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected exception in file table " + this, e);
        }
    }

    @Override
    protected URL getFileURL(int id) throws InvalidFileTableException {
        return id == -1 ? null : this.getURL(this.nameStore.getFilePath(id));
    }

    @Override
    protected URL getURL(String path) throws InvalidFileTableException {
        URL root = this.fileSet.getRoot();
        String rootPath = root.getPath();
        return URLFactory.replacePathPart((URL)root, (String)(rootPath + path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullRefresh(AbstractFileSetTable.Session session) throws InvalidFileTableException {
        PerformanceLogger.get().startTiming("DirectoryFileTable.fullRefresh");
        try {
            session.info.dirty = true;
            session.saveInfo();
            if (shutdown) {
                LOGGER.fine("Refresh of " + this + " aborted due to shutdown.");
                return;
            }
            session.info.hasNodeTimestamps = false;
            IntHashMap visited = session.version > 0 ? new IntHashMap() : null;
            int rootId = this.getOrCreateDirectoryId(session, 0, "");
            SymlinkCycleDetector cycleDetector = SymlinkCycleDetector.getInstance((URL)this.fileSet.getRoot());
            this.refresh(session, this.fileSet.getRoot(), rootId, "", visited, true, Collections.<URLKey, Boolean>emptyMap(), Collections.<URLKey, URLKey>emptyMap(), cycleDetector);
            if (visited != null) {
                this.removeUnvisited(session, visited);
            }
            session.info.dirty = false;
            session.info.ideSessionKey = IDE_SESSION_KEY;
            if (!session.hasChanges) {
                session.saveInfo();
            }
            session.wasRefreshed = true;
        }
        finally {
            PerformanceLogger.get().stopTiming("DirectoryFileTable.fullRefresh", "Refreshed " + this);
        }
    }

    private void refresh(AbstractFileSetTable.Session session, URL dir, int dirId, String relativePath, IntHashMap visited, boolean recurse, Map<URLKey, Boolean> bufferChanges, Map<URLKey, URLKey> renameHints, SymlinkCycleDetector cycleDetector) throws InvalidFileTableException {
        URLFileSystem.FileInfo[] infos = URLFileSystem.ls((URL)dir);
        if (infos != null) {
            if (cycleDetector != null && cycleDetector.isSymlinkCycle(dir, infos)) {
                return;
            }
            if (visited != null) {
                visited.put(dirId, (Object)session);
            }
            Map<String, Integer> entries = this.nameStore.getFileMap(relativePath);
            Map<URLKey, URLKey> reversedRenameHints = null;
            ArrayList<URLFileSystem.FileInfo> subdirs = new ArrayList<URLFileSystem.FileInfo>();
            for (URLFileSystem.FileInfo info : infos) {
                URLKey hintKey;
                URL hint;
                int id;
                long lastModified;
                String name;
                URL url;
                if (info.isDirectory()) {
                    if (recurse) {
                        subdirs.add(info);
                        continue;
                    }
                    url = info.getURL();
                    name = URLFileSystem.getFileName((URL)url);
                    if (name.startsWith(".")) continue;
                    int subdirId = this.nameStore.getDirectoryId(dirId, name);
                    if (subdirId == -1) {
                        subdirs.add(info);
                        continue;
                    }
                    visited.put(subdirId, (Object)session);
                    continue;
                }
                url = info.getURL();
                name = URLFileSystem.getFileName((URL)url);
                if (name.startsWith(".") || !session.filter.acceptFile(relativePath + name)) continue;
                String filename = URLFileSystem.getFileName((URL)url);
                long nodeLastModified = this.getNodeLastModified(url);
                boolean isNodeTimestamp = false;
                if (nodeLastModified == -1L) {
                    lastModified = info.lastModified();
                } else {
                    lastModified = nodeLastModified;
                    if (info.lastModified() != nodeLastModified) {
                        session.info.hasNodeTimestamps = true;
                        isNodeTimestamp = true;
                    }
                }
                Integer idInteger = entries.remove(filename);
                int n = id = idInteger == null ? -1 : idInteger;
                if (id != -1 && this.nameStore.getFileChangeType(id) != FileChange.Type.REMOVED) {
                    long oldLastModified = session.dataStore.getLastModified(id);
                    if (oldLastModified == lastModified) continue;
                    session.dataStore.setLastModified(id, session.version + 1, lastModified, info.length(), isNodeTimestamp);
                    Boolean b = bufferChanges.get(URLKey.getInstance((URL)url));
                    boolean isBufferChange = b == null ? false : b;
                    FileChange.Type type = isBufferChange ? FileChange.Type.BUFFER_MODIFIED : FileChange.Type.MODIFIED;
                    this.nameStore.setFileChangeType(id, type);
                    if (session.delta != null) {
                        session.delta.addImpl(new FileTable.FileChangeImpl(this, id, url, null, lastModified, type));
                    }
                    session.hasChanges = true;
                    continue;
                }
                if (id != -1) {
                    this.nameStore.setFileChangeType(id, FileChange.Type.ADDED);
                    session.dataStore.setLastModified(id, session.version + 1, lastModified, info.length(), isNodeTimestamp);
                } else {
                    id = this.nameStore.addFile(dirId, new String(filename));
                    session.dataStore.add(session.version + 1, lastModified, info.length(), isNodeTimestamp);
                }
                if (reversedRenameHints == null) {
                    reversedRenameHints = Utils.reverse(renameHints);
                }
                URL uRL = hint = (hintKey = reversedRenameHints.get(URLKey.getInstance((URL)url))) == null ? null : hintKey.toURL();
                if (session.delta != null) {
                    session.delta.addImpl(new FileTable.FileChangeImpl(this, id, url, hint, lastModified, FileChange.Type.ADDED));
                }
                session.hasChanges = true;
            }
            for (Map.Entry<String, Integer> entry : entries.entrySet()) {
                URL hint;
                int id = entry.getValue();
                if (this.nameStore.getFileChangeType(id) == FileChange.Type.REMOVED) continue;
                session.dataStore.setLastModified(id, session.version + 1, -1L, -1L, false);
                URL url = URLFactory.newURL((URL)dir, (String)entry.getKey());
                URLKey hintKey = renameHints.get(URLKey.getInstance((URL)url));
                URL uRL = hint = hintKey == null ? null : hintKey.toURL();
                if (session.delta != null) {
                    session.delta.addImpl(new FileTable.FileChangeImpl(this, id, url, hint, -1L, FileChange.Type.REMOVED));
                }
                this.nameStore.setFileChangeType(id, FileChange.Type.REMOVED);
                session.hasChanges = true;
            }
            for (URLFileSystem.FileInfo info : subdirs) {
                String path;
                URL url = info.getURL();
                String name = URLFileSystem.getFileName((URL)url);
                if (name.startsWith(".") || !session.filter.acceptDirectory(path = relativePath + name + "/")) continue;
                int subdirId = this.getOrCreateDirectoryId(session, dirId, new String(name));
                this.refresh(session, info.getURL(), subdirId, path, visited, recurse, bufferChanges, renameHints, cycleDetector);
            }
        }
    }

    void removeUnvisited(AbstractFileSetTable.Session session, IntHashMap visited) throws InvalidFileTableException {
        this.removeAll(session, this.nameStore.removeUnvisited(visited));
    }

    void removeUnvisited(AbstractFileSetTable.Session session, IntHashMap visited, int dirId, boolean recurse) throws InvalidFileTableException {
        this.removeAll(session, this.nameStore.removeUnvisited(visited, dirId, recurse));
    }

    void removeAll(AbstractFileSetTable.Session session, IntHashMap remove) throws InvalidFileTableException {
        if (!remove.isEmpty()) {
            session.hasChanges = true;
            Set removeSet = remove.keySet();
            Iterator i$ = removeSet.iterator();
            while (i$.hasNext()) {
                int id = (Integer)i$.next();
                session.dataStore.setLastModified(id, session.version + 1, -1L, -1L, false);
                if (session.delta == null) continue;
                session.delta.addImpl(new FileTable.FileChangeImpl(this, id, this.getFileURL(id), null, -1L, FileChange.Type.REMOVED));
            }
        }
    }

    @Override
    protected void refresh(AbstractFileSetTable.Session session, AbstractFileSetTable.Operation operation) throws InvalidFileTableException, InterruptedException, IOException {
        if (this.isFullRefreshRequired(session, operation)) {
            this.clearInvalidationQueue();
            this.fullRefresh(session);
        } else {
            this.refreshNodeTimestamps(session);
            if (!(operation instanceof AbstractFileSetTable.RefreshOperation)) {
                this.processInvalidationQueue(session);
            }
        }
    }

    private void refreshNodeTimestamps(AbstractFileSetTable.Session session) throws InvalidFileTableException {
        if (session.info.hasNodeTimestamps && session.info.ideSessionKey != IDE_SESSION_KEY) {
            session.info.hasNodeTimestamps = false;
            session.info.ideSessionKey = IDE_SESSION_KEY;
            session.hasChanges = true;
            for (int i = 0; i < this.nameStore.getSize(); ++i) {
                if (!session.dataStore.isNodeTimestamp(i)) continue;
                URL url = this.getFileURL(i);
                long lastModified = URLFileSystem.lastModified((URL)url);
                long nodeLastModified = this.getNodeLastModified(url);
                boolean isNodeTimestamp = false;
                if (nodeLastModified != -1L && lastModified != nodeLastModified) {
                    lastModified = nodeLastModified;
                    isNodeTimestamp = true;
                    session.info.hasNodeTimestamps = true;
                }
                session.dataStore.setLastModified(i, session.version + 1, lastModified, URLFileSystem.getLength((URL)url), isNodeTimestamp);
            }
        }
    }

    private final class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        @Override
        public void run() {
            try {
                DirectoryFileTable.this.run(new ProcessInvalidationOperation(), true, false);
            }
            catch (InterruptedException e) {
            }
            catch (IOException e) {
            }
            catch (Exception e) {
                FileTable.LOGGER.log(Level.SEVERE, "Unexpected exception in file table " + DirectoryFileTable.this, e);
            }
        }
    }

    private final class ProcessInvalidationOperation
    implements AbstractFileSetTable.RefreshOperation {
        private ProcessInvalidationOperation() {
        }

        @Override
        public Void run(AbstractFileSetTable.Session session) throws Exception {
            DirectoryFileTable.this.processInvalidationQueue(session);
            return null;
        }
    }

    private final class DirectoryFileSystemListener
    implements URLFileSystemListener,
    DirectoryWatcher.DirectoryListener {
        private DirectoryWatcher watcher;

        private DirectoryFileSystemListener() {
        }

        private synchronized void setDirectoryWatcher(DirectoryWatcher watcher) {
            this.watcher = watcher;
        }

        private synchronized void removeDirectoryWatcher() {
            if (this.watcher != null) {
                DirectoryWatcher.destroyDirectoryWatcher((DirectoryWatcher)this.watcher);
            }
        }

        public void notifyEvent(URLFileSystemEvent event) {
            int type = event.getEventType();
            switch (type) {
                case 4: 
                case 12: {
                    URL parent;
                    URL oldUrl = event.getOldURL();
                    URL newUrl = event.getURL();
                    if (this.accept(oldUrl)) {
                        parent = URLFileSystem.getParent((URL)oldUrl);
                        DirectoryFileTable.this.invalidateDirectoryImpl(parent, false, oldUrl, newUrl);
                    }
                    if (!this.accept(newUrl)) break;
                    parent = URLFileSystem.getParent((URL)newUrl);
                    DirectoryFileTable.this.invalidateDirectoryImpl(parent, false, oldUrl, newUrl);
                    break;
                }
                case 1: 
                case 3: 
                case 10: 
                case 11: {
                    URL url = event.getURL();
                    if (!this.accept(url)) break;
                    URL parent = URLFileSystem.getParent((URL)url);
                    DirectoryFileTable.this.invalidateDirectoryImpl(parent, false, url, null);
                    break;
                }
                case 2: {
                    URL url = event.getURL();
                    if (!this.accept(url)) break;
                    DirectoryFileTable.this.invalidateFileImpl(url, false);
                }
            }
        }

        public void directoryUpdate(DirectoryWatcher.DirectoryEvent event) {
            int type = event.getEventType();
            switch (type) {
                case 4: {
                    URL parent;
                    URL oldUrl = this.getFileUrl(event.getOldFileName());
                    URL newUrl = this.getFileUrl(event.getFileName());
                    if (this.accept(oldUrl)) {
                        parent = URLFileSystem.getParent((URL)oldUrl);
                        DirectoryFileTable.this.invalidateDirectoryImpl(parent, false, oldUrl, newUrl);
                    }
                    if (!this.accept(newUrl)) break;
                    parent = URLFileSystem.getParent((URL)newUrl);
                    DirectoryFileTable.this.invalidateDirectoryImpl(parent, false, oldUrl, newUrl);
                    break;
                }
                case 1: 
                case 2: {
                    URL url = this.getFileUrl(event.getFileName());
                    if (!this.accept(url)) break;
                    URL parent = URLFileSystem.getParent((URL)url);
                    DirectoryFileTable.this.invalidateDirectoryImpl(parent, false, url, null);
                    break;
                }
                case 3: {
                    URL url = this.getFileUrl(event.getFileName());
                    if (URLFileSystem.isDirectoryPath((URL)url) || !this.accept(url)) break;
                    DirectoryFileTable.this.invalidateFileImpl(url, false);
                    break;
                }
            }
        }

        public synchronized void watchCancelled(DirectoryWatcher.DirectoryEvent event) {
            this.watcher = null;
        }

        private boolean accept(URL url) {
            return url != null && DirectoryFileTable.this.fileSet.contains(url) && FileSetFilters.getGlobalFilter().acceptFile(url.getPath());
        }

        private URL getFileUrl(String relativePath) {
            return URLFactory.newURL((URL)DirectoryFileTable.this.fileSet.getRoot(), (String)relativePath.replace('\\', '/'));
        }
    }

    private final class CancelRefreshOperation
    implements AbstractFileSetTable.Operation<Void> {
        private CancelRefreshOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run(AbstractFileSetTable.Session session) throws Exception {
            block7: {
                DirectoryFileTable.this.invalidationLock.lock();
                try {
                    DirectoryFileTable.this.active = false;
                    if (DirectoryFileTable.this.lastScheduledRefresh == null) break block7;
                    DirectoryFileTable.this.lastScheduledRefresh.cancel(true);
                    try {
                        DirectoryFileTable.this.lastScheduledRefresh.get();
                    }
                    catch (CancellationException e) {
                    }
                    catch (ExecutionException e) {
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    session.info.dirty = true;
                    session.saveInfo();
                }
                finally {
                    DirectoryFileTable.this.invalidationLock.unlock();
                }
            }
            return null;
        }
    }

    private final class RefreshDirectoryOperation
    implements AbstractFileSetTable.RefreshOperation {
        private final URL directory;
        private final boolean recurse;
        private final Map<URLKey, Boolean> bufferChanges;
        private final Map<URLKey, URLKey> renameHints;

        public RefreshDirectoryOperation(URL directory, boolean recurse, URL file, URL renameHint) {
            this.directory = directory;
            this.recurse = recurse;
            this.bufferChanges = Collections.emptyMap();
            if (renameHint != null) {
                this.renameHints = new HashMap<URLKey, URLKey>();
                this.renameHints.put(URLKey.getInstance((URL)file), URLKey.getInstance((URL)renameHint));
            } else {
                this.renameHints = Collections.emptyMap();
            }
        }

        public RefreshDirectoryOperation(URL directory, boolean recurse, Map<URLKey, Boolean> bufferChanges, Map<URLKey, URLKey> renameHints) {
            this.directory = directory;
            this.recurse = recurse;
            this.bufferChanges = bufferChanges;
            this.renameHints = renameHints;
        }

        @Override
        public Void run(AbstractFileSetTable.Session session) throws Exception {
            int dirId;
            if (session.wasRefreshed) {
                return null;
            }
            session.info.dirty = true;
            session.saveInfo();
            if (AbstractFileSetTable.shutdown) {
                FileTable.LOGGER.fine("Refresh of " + this + " aborted due to shutdown.");
                return null;
            }
            String relativePath = DirectoryFileTable.this.fileSet.getRelativePath(this.directory);
            if (relativePath != null && (dirId = DirectoryFileTable.this.nameStore.getClosestDirectoryId(relativePath)) != -1) {
                IntHashMap visited = new IntHashMap();
                relativePath = DirectoryFileTable.this.nameStore.getDirectoryPath(dirId);
                URL root = DirectoryFileTable.this.fileSet.getRoot();
                String rootPath = root.getPath();
                URL url = URLFactory.replacePathPart((URL)root, (String)(rootPath + relativePath));
                DirectoryFileTable.this.refresh(session, url, dirId, relativePath, visited, this.recurse, this.bufferChanges, this.renameHints, SymlinkCycleDetector.getInstance((URL)root));
                if (session.version > 0) {
                    DirectoryFileTable.this.removeUnvisited(session, visited, dirId, this.recurse);
                }
            }
            session.info.dirty = false;
            if (!session.hasChanges) {
                session.saveInfo();
            }
            return null;
        }
    }

    private final class RefreshFileOperation
    implements AbstractFileSetTable.RefreshOperation {
        private final URL file;
        private final boolean isBufferChange;

        public RefreshFileOperation(URL file, boolean isBufferChange) {
            this.file = file;
            this.isBufferChange = isBufferChange;
        }

        @Override
        public Void run(AbstractFileSetTable.Session session) throws Exception {
            long lastModified;
            if (session.wasRefreshed) {
                return null;
            }
            session.info.dirty = true;
            session.saveInfo();
            if (AbstractFileSetTable.shutdown) {
                FileTable.LOGGER.fine("Refresh of " + this + " aborted due to shutdown.");
                return null;
            }
            boolean isNodeTimestamp = false;
            long nodeLastModified = DirectoryFileTable.this.getNodeLastModified(this.file);
            if (this.isBufferChange && nodeLastModified != -1L) {
                lastModified = nodeLastModified;
                session.info.hasNodeTimestamps = true;
                isNodeTimestamp = true;
            } else {
                lastModified = URLFileSystem.lastModified((URL)this.file);
                if (nodeLastModified != -1L && lastModified != nodeLastModified) {
                    lastModified = nodeLastModified;
                    session.info.hasNodeTimestamps = true;
                    isNodeTimestamp = true;
                }
            }
            String relativePath = DirectoryFileTable.this.fileSet.getRelativePath(this.file);
            int id = DirectoryFileTable.this.nameStore.getFileId(relativePath);
            if (id != -1) {
                long oldLastModified = session.dataStore.getLastModified(id);
                if (oldLastModified != lastModified) {
                    long length = URLFileSystem.getLength((URL)this.file);
                    session.dataStore.setLastModified(id, session.version + 1, lastModified, length, isNodeTimestamp);
                    FileChange.Type type = this.isBufferChange ? FileChange.Type.BUFFER_MODIFIED : FileChange.Type.MODIFIED;
                    DirectoryFileTable.this.nameStore.setFileChangeType(id, type);
                    if (session.delta != null) {
                        session.delta.addImpl(new FileTable.FileChangeImpl(DirectoryFileTable.this, id, this.file, null, lastModified, type));
                    }
                    session.hasChanges = true;
                }
            } else if (lastModified != -1L) {
                URL directory = URLFileSystem.getParent((URL)this.file);
                new RefreshDirectoryOperation(directory, false, this.file, null).run(session);
            }
            session.info.dirty = false;
            if (!session.hasChanges) {
                session.saveInfo();
            }
            return null;
        }
    }
}

