/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipError;
import net.jcip.annotations.GuardedBy;
import oracle.ide.file.AbstractFileSetTable;
import oracle.ide.file.FileChange;
import oracle.ide.file.FileSet;
import oracle.ide.file.FileSetFilter;
import oracle.ide.file.FileTable;
import oracle.ide.file.InvalidFileTableException;
import oracle.ide.file.NameStore;
import oracle.ide.natives.FileWatcher;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLKey;
import oracle.ide.net.URLTempFile;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.persistence.Storage;
import oracle.javatools.buffer.ReadWriteLock;

final class JarFileTable
extends AbstractFileSetTable {
    private static final boolean FILTER_JAR_FILES = Boolean.getBoolean("oracle.ide.file.filter.jars");
    @GuardedBy(value="JarFileTable.class")
    private static long lastJarInvalidation = -1L;
    private final URL jarFileURL;
    private final String rootPath;
    private final ReentrantLock invalidationLock = new ReentrantLock();
    @GuardedBy(value="invalidationLock")
    private boolean invalid;
    @GuardedBy(value="invalidationLock")
    private Map<URLKey, URLKey> renameHints = new HashMap<URLKey, URLKey>();
    @GuardedBy(value="invalidationLock")
    private Future lastScheduledRefresh;
    @GuardedBy(value="invalidationLock")
    private long lastTimestampCheck;
    @GuardedBy(value="this")
    private FileSystemListener fileSystemListener;
    private URLTempFile tempFile;
    @GuardedBy(value="invalidationLock")
    private boolean active;

    public static synchronized void invalidateJarFileTables() {
        lastJarInvalidation = System.currentTimeMillis();
    }

    private static synchronized long getLastJarInvalidation() {
        return lastJarInvalidation;
    }

    JarFileTable(Storage storage, FileSet fileSet) {
        super(storage, fileSet);
        this.jarFileURL = JarUtil.getJarFileURL((URL)fileSet.getRoot());
        if (!URLFileSystem.equals((URL)this.jarFileURL, (URL)fileSet.getRoot())) {
            String path = fileSet.getRoot().getPath();
            int bang = path.indexOf(33);
            if (bang == -1 || path.charAt(bang + 1) != '/') {
                bang = path.indexOf("!/");
            }
            this.rootPath = path.substring(bang + 2);
        } else {
            this.rootPath = null;
        }
    }

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        this.invalidationLock.lock();
        try {
            if (this.active) {
                this.invalid = true;
                this.reschedule();
            }
        }
        finally {
            this.invalidationLock.unlock();
        }
    }

    @Override
    protected void invalidateFileImpl(URL file, boolean isBufferChange) {
        this.invalidate();
    }

    @Override
    protected void invalidateDirectoryImpl(URL directory, boolean includeSubdirectories, URL renameHintOldURL, URL renameHintNewURL) {
        this.addDirectoryInvalidation(renameHintOldURL, renameHintNewURL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void activateImpl() {
        this.invalidationLock.lock();
        try {
            this.active = true;
        }
        finally {
            this.invalidationLock.unlock();
        }
        URL parent = URLFileSystem.getParent((URL)this.jarFileURL);
        if (parent != null) {
            this.fileSystemListener = new FileSystemListener();
            URLFileSystem.addURLFileSystemListener((URL)parent, (URLFileSystemListener)this.fileSystemListener);
            if (JarFileTable.getRefreshAutomatically() && URLFileSystem.isLocal((URL)this.jarFileURL)) {
                FileWatcher fileWatcher = FileWatcher.createFileWatcher((URL)this.jarFileURL, (FileWatcher.FileListener)this.fileSystemListener);
                this.fileSystemListener.setFileWatcher(fileWatcher);
            }
        }
    }

    @Override
    protected synchronized void deactivateImpl() {
        URL parent = URLFileSystem.getParent((URL)this.jarFileURL);
        if (parent != null) {
            if (JarFileTable.getRefreshAutomatically()) {
                this.fileSystemListener.removeFileWatcher();
            }
            URLFileSystem.removeURLFileSystemListener((URL)parent, (URLFileSystemListener)this.fileSystemListener);
            try {
                this.run(new CancelRefreshOperation(), false, false, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshFile(URL file, boolean isBufferChange) throws InterruptedException, IOException {
        this.invalidationLock.lock();
        try {
            this.invalid = true;
        }
        finally {
            this.invalidationLock.unlock();
        }
        this.refresh(null);
    }

    @Override
    protected void refreshDirectory(URL directory, boolean includeSubdirectories, URL renameHintOldURL, URL renameHintNewURL) throws InterruptedException, IOException {
        this.addDirectoryInvalidation(renameHintOldURL, renameHintNewURL, false);
        this.refresh(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refresh(AbstractFileSetTable.Session session, AbstractFileSetTable.Operation operation) throws InvalidFileTableException, InterruptedException, IOException {
        Map<URLKey, URLKey> localRenameHints;
        boolean localInvalid;
        this.invalidationLock.lock();
        try {
            localInvalid = this.invalid;
            localRenameHints = this.renameHints;
            this.invalid = false;
            this.renameHints = new HashMap<URLKey, URLKey>();
        }
        finally {
            this.invalidationLock.unlock();
        }
        if (localInvalid || this.isFullRefreshRequired(session, operation)) {
            this.refreshImpl(session, localRenameHints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isFullRefreshRequired(AbstractFileSetTable.Session session, AbstractFileSetTable.Operation operation) {
        this.invalidationLock.lock();
        try {
            this.lastTimestampCheck = JarFileTable.getLastJarInvalidation();
        }
        finally {
            this.invalidationLock.unlock();
        }
        long timestamp = URLFileSystem.lastModified((URL)this.jarFileURL);
        if (timestamp != session.info.jarTimeStamp) {
            session.info.jarTimeStamp = timestamp;
            session.hasChanges = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean hasPendingValidation() {
        if (this.invalidationLock.tryLock()) {
            try {
                boolean bl = this.invalid || this.lastTimestampCheck != JarFileTable.getLastJarInvalidation();
                return bl;
            }
            finally {
                this.invalidationLock.unlock();
            }
        }
        return true;
    }

    @Override
    protected URL getFileURL(int id) throws InvalidFileTableException {
        return id == -1 ? null : URLFactory.newURL((URL)this.fileSet.getRoot(), (String)this.nameStore.getFilePath(id));
    }

    @Override
    protected URL getURL(String path) throws InvalidFileTableException {
        return this.getJarURL(path);
    }

    @Override
    protected FileSetFilter getFilter() {
        return FILTER_JAR_FILES ? super.getFilter() : this.fileSet.getFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshImpl(AbstractFileSetTable.Session session, Map<URLKey, URLKey> renameHints) throws InvalidFileTableException {
        PerformanceLogger.get().startTiming("JarFileTable.fullRefresh");
        try {
            ReadWriteLock lock = JarUtil.getLock((URL)this.jarFileURL);
            lock.readLock();
            Map<String, Integer> fileMap = this.nameStore.getFileMap();
            try {
                File file;
                if (this.tempFile == null) {
                    this.tempFile = new URLTempFile(this.jarFileURL);
                }
                if ((file = this.tempFile.getFile()) == null) {
                    throw new IOException("Unable to download JAR to temp file");
                }
                JarFile jar = new JarFile(file);
                try {
                    this.getOrCreateDirectoryId(session, 0, "");
                    int lastDirId = 0;
                    String lastDirPath = "";
                    Enumeration<JarEntry> e = jar.entries();
                    while (e.hasMoreElements()) {
                        int id;
                        JarEntry entry = e.nextElement();
                        String name = entry.getName();
                        if (this.rootPath != null) {
                            if (!name.startsWith(this.rootPath)) continue;
                            name = name.substring(this.rootPath.length());
                        }
                        if (name.endsWith("/")) {
                            int next;
                            int i;
                            if (!session.filter.acceptDirectory(name)) continue;
                            int current = 0;
                            String[] segments = NameStore.split(name, '/');
                            for (i = 0; i < segments.length && (next = this.nameStore.getDirectoryId(current, segments[i])) != -1; ++i) {
                                current = next;
                            }
                            while (i < segments.length) {
                                current = this.nameStore.addDirectory(current, new String(segments[i]));
                                session.hasChanges = true;
                                ++i;
                            }
                            lastDirPath = name;
                            lastDirId = current;
                            continue;
                        }
                        if (!session.filter.acceptFile(name)) continue;
                        long lastModified = entry.getTime();
                        long length = entry.getSize();
                        Integer idInteger = fileMap.remove(name);
                        int n = id = idInteger == null ? -1 : idInteger;
                        if (id != -1 && this.nameStore.getFileChangeType(id) != FileChange.Type.REMOVED) {
                            long oldLastModified = session.dataStore.getLastModified(id);
                            if (oldLastModified == lastModified) continue;
                            session.dataStore.setLastModified(id, session.version + 1, lastModified, length, false);
                            if (session.delta != null) {
                                session.delta.addImpl(new FileTable.FileChangeImpl(id, this.getJarURL(name), null, lastModified, FileChange.Type.MODIFIED));
                            }
                            this.nameStore.setFileChangeType(id, FileChange.Type.MODIFIED);
                            session.hasChanges = true;
                            continue;
                        }
                        if (id != -1) {
                            this.nameStore.setFileChangeType(id, FileChange.Type.ADDED);
                            session.dataStore.setLastModified(id, session.version + 1, lastModified, length, false);
                            if (session.delta != null) {
                                URL url = this.getJarURL(name);
                                URLKey hint = renameHints.get(URLKey.getInstance((URL)url));
                                URL hintURL = hint == null ? null : hint.toURL();
                                session.delta.addImpl(new FileTable.FileChangeImpl(id, url, hintURL, lastModified, FileChange.Type.ADDED));
                            }
                            session.hasChanges = true;
                            continue;
                        }
                        int dirId = 0;
                        String dirPath = "";
                        int lastSlash = name.lastIndexOf(47);
                        if (lastSlash != -1) {
                            dirPath = name.substring(0, lastSlash + 1);
                            name = name.substring(lastSlash + 1);
                            if (dirPath.equals(lastDirPath)) {
                                dirId = lastDirId;
                            } else {
                                int next;
                                int i;
                                int current = 0;
                                String[] segments = NameStore.split(dirPath, '/');
                                for (i = 0; i < segments.length && (next = this.nameStore.getDirectoryId(current, segments[i])) != -1; ++i) {
                                    current = next;
                                }
                                while (i < segments.length) {
                                    current = this.nameStore.addDirectory(current, new String(segments[i]));
                                    session.hasChanges = true;
                                    ++i;
                                }
                                dirId = current;
                            }
                            lastDirPath = dirPath;
                            lastDirId = dirId;
                        }
                        id = this.nameStore.addFile(dirId, new String(name));
                        session.dataStore.add(session.version + 1, lastModified, length, false);
                        if (session.delta != null) {
                            URL url = this.getJarURL(name);
                            URLKey hint = renameHints.get(URLKey.getInstance((URL)url));
                            URL hintURL = hint == null ? null : hint.toURL();
                            session.delta.addImpl(new FileTable.FileChangeImpl(id, url, hintURL, lastModified, FileChange.Type.ADDED));
                        }
                        session.hasChanges = true;
                    }
                }
                finally {
                    jar.close();
                }
            }
            catch (ZipError e) {
            }
            catch (IOException e) {
            }
            finally {
                lock.readUnlock();
            }
            for (Map.Entry<String, Integer> entry : fileMap.entrySet()) {
                int id = entry.getValue();
                if (this.nameStore.getFileChangeType(id) == FileChange.Type.REMOVED) continue;
                session.dataStore.setLastModified(id, session.version + 1, -1L, -1L, false);
                if (session.delta != null) {
                    URL url = this.getJarURL(entry.getKey());
                    URLKey hint = renameHints.get(URLKey.getInstance((URL)url));
                    URL hintURL = hint == null ? null : hint.toURL();
                    session.delta.addImpl(new FileTable.FileChangeImpl(id, url, hintURL, -1L, FileChange.Type.REMOVED));
                }
                this.nameStore.setFileChangeType(id, FileChange.Type.REMOVED);
                session.hasChanges = true;
            }
        }
        finally {
            PerformanceLogger.get().stopTiming("JarFileTable.fullRefresh", "Refreshed " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDirectoryInvalidation(URL renameHintOldURL, URL renameHintNewURL, boolean reschedule) {
        this.invalidationLock.lock();
        try {
            if (this.active || !reschedule) {
                this.invalid = true;
                URLKey oldKey = URLKey.getInstance((URL)renameHintOldURL);
                URLKey newKey = URLKey.getInstance((URL)renameHintNewURL);
                this.renameHints.put(oldKey, newKey);
                this.renameHints.put(newKey, oldKey);
                if (reschedule) {
                    this.reschedule();
                }
            }
        }
        finally {
            this.invalidationLock.unlock();
        }
    }

    private void reschedule() {
        try {
            if (this.lastScheduledRefresh != null) {
                this.lastScheduledRefresh.cancel(false);
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        JarFileTable.this.run(new AbstractFileSetTable.Operation<Void>(){

                            @Override
                            public Void run(AbstractFileSetTable.Session session) {
                                return null;
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.lastScheduledRefresh = SCHEDULER.schedule(r, 2L, DELAY_UNIT);
        }
        catch (RejectedExecutionException e) {
            try {
                this.refresh(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private URL getJarURL(String path) {
        StringBuilder builder = new StringBuilder(100);
        builder.append(this.jarFileURL.toString());
        builder.append("!/");
        if (this.rootPath != null) {
            builder.append(this.rootPath);
        }
        builder.append(path);
        try {
            return new URL("jar", "", builder.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private final class CancelRefreshOperation
    implements AbstractFileSetTable.Operation<Void> {
        private CancelRefreshOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run(AbstractFileSetTable.Session session) throws Exception {
            block7: {
                JarFileTable.this.invalidationLock.lock();
                try {
                    JarFileTable.this.active = false;
                    if (JarFileTable.this.lastScheduledRefresh == null) break block7;
                    JarFileTable.this.lastScheduledRefresh.cancel(true);
                    try {
                        JarFileTable.this.lastScheduledRefresh.get();
                    }
                    catch (CancellationException e) {
                    }
                    catch (ExecutionException e) {
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    session.info.dirty = true;
                    session.saveInfo();
                }
                finally {
                    JarFileTable.this.invalidationLock.unlock();
                }
            }
            return null;
        }
    }

    private final class FileSystemListener
    implements URLFileSystemListener,
    FileWatcher.FileListener {
        private FileWatcher watcher;

        private FileSystemListener() {
        }

        void setFileWatcher(FileWatcher watcher) {
            this.watcher = watcher;
        }

        void removeFileWatcher() {
            if (this.watcher != null) {
                FileWatcher.destroyFileWatcher((FileWatcher)this.watcher);
            }
        }

        public void notifyEvent(URLFileSystemEvent event) {
            int type = event.getEventType();
            switch (type) {
                case 4: {
                    URL oldUrl = event.getOldURL();
                    URL newUrl = event.getURL();
                    if (!URLFileSystem.equals((URL)oldUrl, (URL)JarFileTable.this.jarFileURL) && !URLFileSystem.equals((URL)newUrl, (URL)JarFileTable.this.jarFileURL)) break;
                    JarFileTable.this.invalidate();
                    break;
                }
                case 1: 
                case 3: {
                    URL url = event.getURL();
                    if (!URLFileSystem.equals((URL)url, (URL)JarFileTable.this.jarFileURL)) break;
                    JarFileTable.this.invalidate();
                    break;
                }
                case 2: {
                    URL url = event.getURL();
                    if (!URLFileSystem.equals((URL)url, (URL)JarFileTable.this.jarFileURL)) break;
                    JarFileTable.this.invalidate();
                }
            }
        }

        public void fileUpdate(FileWatcher.FileEvent event) {
            if (URLFileSystem.equals((URL)event.getFileURL(), (URL)JarFileTable.this.jarFileURL)) {
                JarFileTable.this.invalidate();
            }
        }

        public void watchCancelled(FileWatcher.FileEvent event) {
        }
    }
}

