/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import oracle.ide.file.FileChange;
import oracle.ide.file.FileTableStringPool;
import oracle.ide.persistence.NameSpace;
import oracle.ide.util.IntHashMap;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.RunLengthEncodedIntArrayFactory;
import oracle.javatools.assembly.StringFactory;
import oracle.javatools.util.NullArgumentException;

class NameBlock {
    private static final String[] EXTENSION_TABLE = new String[]{"", ".class", ".cpx", ".css", ".dtd", ".gif", ".groovy", ".htm", ".html", ".java", ".jpg", ".jpeg", ".jpx", ".js", ".jsff", ".jsp", ".jspf", ".jspx", ".MF", ".pl", ".png", ".properties", ".rts", ".sql", ".sqlj", ".txt", ".wsdl", ".xml", ".xq", ".xquery", ".xql", ".xrts", ".xsl", ".xsd", ".xsql"};
    private static final ObjectFactory FILE_NAME_ASSEMBLY_FACTORY = new AssemblyFactory(false);
    private static final ObjectFactory DIRECTORY_NAME_ASSEMBLY_FACTORY = new AssemblyFactory(true);
    private int[] directoryIds;
    private String[] names;
    private FileChange.Type[] types;
    private int size;
    private boolean dirty;
    private final boolean isDirectoryBlock;

    public static NameBlock getFileNameBlock(byte[] data) throws AssemblyException {
        return (NameBlock)FILE_NAME_ASSEMBLY_FACTORY.assemble(data);
    }

    public static NameBlock getDirectoryNameBlock(byte[] data) throws AssemblyException {
        return (NameBlock)DIRECTORY_NAME_ASSEMBLY_FACTORY.assemble(data);
    }

    public static NameBlock getEmptyDirectoryBlock() {
        return NameBlock.getDirectoryBlock(new int[0], new String[0], new FileChange.Type[0], 0);
    }

    public static NameBlock getDirectoryBlock(@NotNull int[] directoryIds, @NotNull String[] names, @NotNull FileChange.Type[] types, int numEntries) {
        if (directoryIds == null) {
            throw new NullArgumentException("null directoryIds");
        }
        if (names == null) {
            throw new NullArgumentException("null entries");
        }
        if (numEntries > directoryIds.length) {
            throw new IllegalArgumentException("number of entries (" + numEntries + ") is greater than id array size (" + directoryIds.length + ")");
        }
        if (numEntries > names.length) {
            throw new IllegalArgumentException("number of entries (" + numEntries + ") is greater than name array size (" + names.length + ")");
        }
        return new NameBlock(directoryIds, names, types, numEntries, true);
    }

    public static NameBlock getFileBlock(@NotNull int[] directoryIds, @NotNull String[] names, @NotNull FileChange.Type[] types, int numEntries) {
        if (directoryIds == null) {
            throw new NullArgumentException("null directoryIds");
        }
        if (names == null) {
            throw new NullArgumentException("null entries");
        }
        if (types == null) {
            throw new NullArgumentException("null types");
        }
        if (numEntries > directoryIds.length) {
            throw new IllegalArgumentException("number of entries (" + numEntries + ") is greater than id array size (" + directoryIds.length + ")");
        }
        if (numEntries > names.length) {
            throw new IllegalArgumentException("number of entries (" + numEntries + ") is greater than name array size (" + names.length + ")");
        }
        return new NameBlock(directoryIds, names, types, numEntries, false);
    }

    private NameBlock(int[] directoryIds, String[] names, FileChange.Type[] types, boolean isDirectoryBlock) {
        this(directoryIds, names, types, names.length, isDirectoryBlock);
    }

    private NameBlock(int[] directoryIds, String[] names, FileChange.Type[] types, int numEntries, boolean isDirectoryBlock) {
        this.directoryIds = directoryIds;
        this.names = names;
        this.types = types;
        this.size = numEntries;
        this.isDirectoryBlock = isDirectoryBlock;
    }

    public byte[] toByteArray() throws AssemblyException {
        return this.getAssemblyFactory().disassemble((Object)this);
    }

    public void putRecord(NameSpace namespace, String key) throws AssemblyException {
        RecordStream os = new RecordStream();
        DataOutputStream dos = new DataOutputStream(os);
        this.getAssemblyFactory().disassemble((Object)this, (DataOutput)dos);
        os.putRecord(namespace, key);
    }

    public int getSize() {
        return this.size;
    }

    public String[] getNames() {
        if (this.size == this.names.length) {
            return this.names;
        }
        String[] copy = new String[this.size];
        System.arraycopy(this.names, 0, copy, 0, this.size);
        return copy;
    }

    public int[] getParentIds() {
        if (this.size == this.directoryIds.length) {
            return this.directoryIds;
        }
        int[] copy = new int[this.size];
        System.arraycopy(this.directoryIds, 0, copy, 0, this.size);
        return copy;
    }

    FileChange.Type[] getTypes() {
        if (this.size == this.types.length) {
            return this.types;
        }
        FileChange.Type[] copy = new FileChange.Type[this.size];
        System.arraycopy(this.types, 0, copy, 0, this.size);
        return copy;
    }

    void add(int parentId, String name) {
        int newSize;
        if (this.size == this.names.length) {
            newSize = this.size * 3 / 2 + 1;
            this.names = Arrays.copyOf(this.names, newSize);
        }
        if (this.size == this.directoryIds.length) {
            newSize = this.size * 3 / 2 + 1;
            this.directoryIds = Arrays.copyOf(this.directoryIds, newSize);
        }
        if (this.size == this.types.length) {
            newSize = this.size * 3 / 2 + 1;
            this.types = Arrays.copyOf(this.types, newSize);
        }
        if (this.isDirectoryBlock) {
            name = FileTableStringPool.intern(name);
        }
        this.names[this.size] = name;
        this.types[this.size] = FileChange.Type.ADDED;
        this.directoryIds[this.size++] = parentId;
        this.dirty = true;
    }

    void setType(int id, FileChange.Type type) {
        if (this.types[id] != type) {
            this.types[id] = type;
            this.dirty = true;
        }
    }

    FileChange.Type getType(int id) {
        return this.types[id];
    }

    int locate(int parentId, String name) {
        if (this.isDirectoryBlock) {
            String interned = FileTableStringPool.get(name);
            if (interned == null) {
                return -1;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.directoryIds[i] != parentId || interned != this.names[i]) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.directoryIds[i] != parentId || !name.equals(this.names[i])) continue;
                return i;
            }
        }
        return -1;
    }

    boolean isDirty() {
        boolean wasDirty = this.dirty;
        this.dirty = false;
        return wasDirty;
    }

    void keepOnlyChildren(IntHashMap keep, IntHashMap removed) {
        for (int i = 0; i < this.size; ++i) {
            if (keep.containsKey(this.directoryIds[i])) continue;
            removed.put(i, (Object)this);
            this.setType(i, FileChange.Type.REMOVED);
        }
    }

    void keepOnly(IntHashMap keep) {
        for (int i = 0; i < this.size; ++i) {
            if (keep.containsKey(i)) continue;
            this.setType(i, FileChange.Type.REMOVED);
        }
    }

    void removeChildren(IntHashMap remove, IntHashMap removed) {
        for (int i = 0; i < this.size; ++i) {
            if (!remove.containsKey(this.directoryIds[i]) || this.types[i] == FileChange.Type.REMOVED) continue;
            removed.put(i, (Object)this);
            this.setType(i, FileChange.Type.REMOVED);
        }
    }

    IntHashMap getUnvisited(IntHashMap visited, int dirId, boolean recurse) {
        IntHashMap unvisited = new IntHashMap();
        if (recurse) {
            IntHashMap subdirs = new IntHashMap();
            for (int i = 0; i < this.directoryIds.length; ++i) {
                if (dirId == this.directoryIds[i] || subdirs.containsKey(this.directoryIds[i])) {
                    subdirs.put(i, (Object)subdirs);
                }
                if (dirId != i && !subdirs.containsKey(i) || visited.containsKey(i)) continue;
                unvisited.put(i, (Object)this);
            }
        } else {
            for (int i = 0; i < this.directoryIds.length; ++i) {
                if (dirId != i && dirId != this.directoryIds[i] || visited.containsKey(i)) continue;
                unvisited.put(i, (Object)this);
            }
        }
        return unvisited;
    }

    private ObjectFactory getAssemblyFactory() {
        return this.isDirectoryBlock ? DIRECTORY_NAME_ASSEMBLY_FACTORY : FILE_NAME_ASSEMBLY_FACTORY;
    }

    private static final class RecordStream
    extends ByteArrayOutputStream {
        private RecordStream() {
        }

        void putRecord(NameSpace namespace, String key) {
            namespace.putRecord(key, this.buf, 0, this.count);
        }
    }

    private static class AssemblyFactory
    extends ObjectFactory {
        private final boolean isDirectoryFactory;

        AssemblyFactory(boolean isDirectoryFactory) {
            this.isDirectoryFactory = isDirectoryFactory;
        }

        public byte getObjectCode() {
            return -17;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            int[] directoryIds = (int[])RunLengthEncodedIntArrayFactory.RUN_LENGTH_ENCODED_INT_ARRAY_FACTORY.assemble(input);
            int length = directoryIds.length;
            String[] names = new String[length];
            for (int i = 0; i < length; ++i) {
                names[i] = (String)StringFactory.STRING_FACTORY.assemble(input);
            }
            byte[] typeBytes = new byte[length];
            FileChange.Type[] types = new FileChange.Type[length];
            input.readFully(typeBytes, 0, length);
            for (int i = 0; i < length; ++i) {
                byte e;
                int b = typeBytes[i] & 0xFF;
                types[i] = FileChange.Type.MODIFIED;
                if ((b & 0xFFFFFFC0) == 192) {
                    types[i] = FileChange.Type.BUFFER_MODIFIED;
                } else if ((b & 0xFFFFFF80) != 0) {
                    types[i] = FileChange.Type.REMOVED;
                } else if ((b & 0x40) != 0) {
                    types[i] = FileChange.Type.ADDED;
                }
                names[i] = this.isDirectoryFactory ? FileTableStringPool.intern(names[i]) : ((e = (byte)(b & 0x3F)) > 0 ? names[i] + EXTENSION_TABLE[e] : names[i]);
            }
            return new NameBlock(directoryIds, names, types, this.isDirectoryFactory);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            NameBlock block = (NameBlock)object;
            int[] directoryIds = null;
            if (block.directoryIds.length != block.size) {
                directoryIds = new int[block.size];
                System.arraycopy(block.directoryIds, 0, directoryIds, 0, block.size);
            } else {
                directoryIds = block.directoryIds;
            }
            RunLengthEncodedIntArrayFactory.RUN_LENGTH_ENCODED_INT_ARRAY_FACTORY.disassemble((Object)directoryIds, output);
            byte[] bytes = new byte[block.size];
            for (int i = 0; i < block.size; ++i) {
                int lastDot;
                String name = block.names[i];
                int b = 0;
                if (!this.isDirectoryFactory && (lastDot = block.names[i].lastIndexOf(46)) != -1) {
                    int j;
                    String extension = block.names[i].substring(lastDot);
                    for (j = 1; j < EXTENSION_TABLE.length && !EXTENSION_TABLE[j].equals(extension); ++j) {
                    }
                    if (j < EXTENSION_TABLE.length) {
                        name = block.names[i].substring(0, lastDot);
                        b = (byte)j;
                    }
                }
                if (block.types[i] == FileChange.Type.BUFFER_MODIFIED) {
                    b = (byte)(b | 0xFFFFFFC0);
                } else if (block.types[i] == FileChange.Type.REMOVED) {
                    b = (byte)(b | 0xFFFFFF80);
                } else if (block.types[i] == FileChange.Type.ADDED) {
                    b = (byte)(b | 0x40);
                }
                bytes[i] = b;
                StringFactory.STRING_FACTORY.disassemble((Object)name, output);
            }
            output.write(bytes);
        }
    }
}

