/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.ide.file.FileChange;
import oracle.ide.file.FileTable;
import oracle.ide.file.FileTableVisitor;
import oracle.ide.file.InvalidFileTableException;
import oracle.ide.file.NameBlock;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.NameSpaceVisitor;
import oracle.ide.util.IntHashMap;
import oracle.javatools.assembly.AssemblyException;

final class NameStore {
    private static final String DIRECTORY_BLOCK_KEY = "paths";
    private static final String CHANGE_DETECTION_KEY = "token";
    private static final int FILE_BLOCK_SIZE = 50;
    private int size;
    private int numFileBlocks;
    private final FileTable fileTable;
    private final NameBlock dirBlock;
    private NameBlock[] fileBlocks;
    private byte[] changeDetectionToken;
    private Map<String, Map<String, Integer>> reverseMap;

    static NameStore getInstance(final FileTable fileTable, NameSpace namespace) throws InvalidFileTableException {
        final ArrayList fileBlocks = new ArrayList();
        final NameBlock[] dirBlock = new NameBlock[1];
        final int[] numFiles = new int[1];
        final byte[][] changeDetectionToken = new byte[1][];
        NameSpaceVisitor visitor = new NameSpaceVisitor(){

            public NameSpaceVisitor.Status visit(String key, byte[] data) throws InvalidFileTableException {
                try {
                    if (NameStore.DIRECTORY_BLOCK_KEY.equals(key)) {
                        dirBlock[0] = NameBlock.getDirectoryNameBlock(data);
                    } else if (NameStore.CHANGE_DETECTION_KEY.equals(key)) {
                        changeDetectionToken[0] = data;
                    } else {
                        NameBlock block = NameBlock.getFileNameBlock(data);
                        int blockNum = NameStore.getBlockNum(key);
                        int padding = blockNum - fileBlocks.size() + 1;
                        if (padding > 0) {
                            for (int i = 0; i < padding; ++i) {
                                fileBlocks.add(null);
                            }
                        }
                        fileBlocks.set(blockNum, block);
                        numFiles[0] = numFiles[0] + block.getSize();
                    }
                }
                catch (AssemblyException ee) {
                    throw new InvalidFileTableException(fileTable, (Throwable)ee);
                }
                return NameSpaceVisitor.Status.CONTINUE;
            }
        };
        try {
            namespace.visitRecords(visitor);
            if (dirBlock[0] != null) {
                NameBlock[] array = fileBlocks.toArray(new NameBlock[fileBlocks.size()]);
                NameStore.validateBlocks(dirBlock[0], array);
                return new NameStore(fileTable, dirBlock[0], array, numFiles[0], changeDetectionToken[0]);
            }
            return new NameStore(fileTable, NameBlock.getEmptyDirectoryBlock(), new NameBlock[0], 0, changeDetectionToken[0]);
        }
        catch (InvalidFileTableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidFileTableException(fileTable, (Throwable)e);
        }
    }

    private static void validateBlocks(NameBlock dirBlock, NameBlock[] fileBlocks) throws InvalidFileTableException {
        int maxParentId = dirBlock.getSize();
        NameStore.validateBlock(dirBlock, maxParentId);
        for (NameBlock block : fileBlocks) {
            NameStore.validateBlock(block, maxParentId);
        }
    }

    private static void validateBlock(NameBlock block, int maxParentId) throws InvalidFileTableException {
        int size = block.getSize();
        int[] parentIds = block.getParentIds();
        for (int i = 0; i < size; ++i) {
            if (parentIds[i] < maxParentId) continue;
            throw new InvalidFileTableException("Invalid parent ID " + parentIds[i]);
        }
    }

    private NameStore(FileTable fileTable, NameBlock dirBlock, NameBlock[] fileBlocks, int numFiles, byte[] changeDetectionToken) {
        this.fileTable = fileTable;
        this.dirBlock = dirBlock;
        this.fileBlocks = fileBlocks;
        this.size = numFiles;
        this.changeDetectionToken = changeDetectionToken;
        this.numFileBlocks = fileBlocks.length;
    }

    static String[] split(String s, char c) {
        int next;
        ArrayList<String> result = new ArrayList<String>(10);
        int last = 0;
        while ((next = s.indexOf(c, last)) != -1) {
            result.add(s.substring(last, next));
            last = next + 1;
        }
        return result.toArray(new String[result.size()]);
    }

    int getSize() {
        return this.size;
    }

    boolean hasChangedOnDisk(NameSpace namespace) {
        byte[] data = namespace.getRecord(CHANGE_DETECTION_KEY);
        return !Arrays.equals(data, this.changeDetectionToken);
    }

    String getFileName(int id) throws InvalidFileTableException {
        int blockNum = id / 50;
        if (blockNum >= this.numFileBlocks) {
            throw new InvalidFileTableException("no file block " + blockNum + " for ID " + id);
        }
        int i = id - blockNum * 50;
        NameBlock block = this.fileBlocks[blockNum];
        String[] names = block.getNames();
        if (i >= names.length) {
            throw new InvalidFileTableException("no data for ID " + id);
        }
        return names[i];
    }

    String getFilePath(int id) throws InvalidFileTableException {
        int blockNum = id / 50;
        if (blockNum >= this.numFileBlocks) {
            throw new InvalidFileTableException("no file block " + blockNum + " for ID " + id);
        }
        NameBlock block = this.fileBlocks[blockNum];
        StringBuilder builder = new StringBuilder(100);
        int i = id - blockNum * 50;
        String[] names = block.getNames();
        if (i >= names.length) {
            throw new InvalidFileTableException("no data for ID " + id);
        }
        this.getDirectoryPath(block.getParentIds()[i], builder);
        builder.append(names[i]);
        return builder.toString();
    }

    String getParentPath(int id) throws InvalidFileTableException {
        int blockNum = id / 50;
        if (blockNum >= this.numFileBlocks) {
            throw new InvalidFileTableException("no file block " + blockNum + " for ID " + id);
        }
        NameBlock block = this.fileBlocks[blockNum];
        StringBuilder builder = new StringBuilder(100);
        int i = id - blockNum * 50;
        String[] names = block.getNames();
        if (i >= names.length) {
            throw new InvalidFileTableException("no data for ID " + id);
        }
        this.getDirectoryPath(block.getParentIds()[i], builder);
        return builder.toString();
    }

    String getDirectoryPath(int id) throws InvalidFileTableException {
        StringBuilder builder = new StringBuilder();
        this.getDirectoryPath(id, builder);
        return builder.toString();
    }

    int getFileId(String relativePath) {
        int dirId;
        int lastSlash = relativePath.lastIndexOf(47);
        if (lastSlash < relativePath.length() - 1 && (dirId = this.getDirectoryId(relativePath.substring(0, lastSlash + 1))) != -1) {
            String filename = relativePath.substring(lastSlash + 1);
            for (int i = 0; i < this.numFileBlocks; ++i) {
                int j = this.fileBlocks[i].locate(dirId, filename);
                if (j == -1) continue;
                return i * 50 + j;
            }
        }
        return -1;
    }

    int getDirectoryId(int parentId, String name) {
        return this.dirBlock.locate(parentId, name);
    }

    int getDirectoryId(String relativePath) {
        String[] segments;
        int current = 0;
        for (String segment : segments = NameStore.split(relativePath, '/')) {
            if ((current = this.dirBlock.locate(current, segment)) != -1) continue;
            return -1;
        }
        return current;
    }

    int getClosestDirectoryId(String relativePath) {
        String[] segments;
        if (this.dirBlock.getSize() == 0) {
            return -1;
        }
        int current = 0;
        for (String segment : segments = NameStore.split(relativePath, '/')) {
            int next = this.dirBlock.locate(current, segment);
            if (next == -1) {
                return current;
            }
            current = next;
        }
        return current;
    }

    String[] getFilePaths() throws InvalidFileTableException {
        final String[] paths = new String[this.size];
        this.visitFiles(new FileTableVisitor(){
            private int i;

            @Override
            public FileTableVisitor.Result visitFile(int id, String parentPath, String fileName, FileChange.Type type) {
                paths[this.i++] = parentPath + fileName;
                return FileTableVisitor.Result.CONTINUE;
            }
        });
        return paths;
    }

    void visitFiles(FileTableVisitor visitor) throws InvalidFileTableException {
        int i;
        String[] dirCache = new String[this.dirBlock.getSize()];
        int[] parentIds = this.dirBlock.getParentIds();
        String[] names = this.dirBlock.getNames();
        if (dirCache.length > 0) {
            dirCache[0] = "";
        }
        for (i = 1; i < dirCache.length; ++i) {
            StringBuilder builder = new StringBuilder(100);
            builder.append(dirCache[parentIds[i]]);
            builder.append(names[i]);
            builder.append('/');
            dirCache[i] = builder.toString();
        }
        i = 0;
        for (int b = 0; b < this.numFileBlocks; ++b) {
            NameBlock block = this.fileBlocks[b];
            int size = block.getSize();
            parentIds = block.getParentIds();
            names = block.getNames();
            FileChange.Type[] types = block.getTypes();
            int f = 0;
            while (f < size && visitor.visitFile(i, dirCache[parentIds[f]], names[f], types[f]) == FileTableVisitor.Result.CONTINUE) {
                ++f;
                ++i;
            }
        }
    }

    void visitFiles(int id, FileTableVisitor visitor) throws InvalidFileTableException {
        String dirPath = this.getDirectoryPath(id);
        int i = 0;
        for (int b = 0; b < this.numFileBlocks; ++b) {
            NameBlock block = this.fileBlocks[b];
            int size = block.getSize();
            int[] parentIds = block.getParentIds();
            String[] names = block.getNames();
            FileChange.Type[] types = block.getTypes();
            int f = 0;
            while (f < size && (parentIds[f] != id || visitor.visitFile(i, dirPath, names[f], types[f]) == FileTableVisitor.Result.CONTINUE)) {
                ++f;
                ++i;
            }
        }
    }

    String[] getDirectoryPaths() throws InvalidFileTableException {
        int length = this.dirBlock.getSize() - 1;
        String[] paths = new String[length];
        for (int i = 1; i < length + 1; ++i) {
            paths[i - 1] = this.getDirectoryPath(i);
        }
        return paths;
    }

    private void getDirectoryPath(int id, StringBuilder builder) throws InvalidFileTableException {
        if (id != 0) {
            if (id >= this.dirBlock.getSize()) {
                throw new InvalidFileTableException("Invalid directory ID " + id);
            }
            this.getDirectoryPath(this.dirBlock.getParentIds()[id], builder);
            builder.append(this.dirBlock.getNames()[id]);
            builder.append('/');
        }
    }

    Collection<String> getSubdirectories(int id) {
        ArrayList<String> result = new ArrayList<String>(10);
        int[] parentIds = this.dirBlock.getParentIds();
        String[] names = this.dirBlock.getNames();
        for (int i = 0; i < parentIds.length; ++i) {
            if (parentIds[i] != id || i == id || this.isDirectoryRemoved(i)) continue;
            result.add(names[i]);
        }
        return result;
    }

    int addFile(int directoryId, String name) throws InvalidFileTableException {
        NameBlock lastBlock = null;
        if (this.numFileBlocks > 0) {
            lastBlock = this.fileBlocks[this.numFileBlocks - 1];
        }
        if (lastBlock == null || lastBlock.getSize() == 50) {
            lastBlock = NameBlock.getFileBlock(new int[50], new String[50], new FileChange.Type[50], 0);
            if (this.numFileBlocks == this.fileBlocks.length) {
                int oldCapacity = this.fileBlocks.length;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                this.fileBlocks = Arrays.copyOf(this.fileBlocks, newCapacity);
            }
            this.fileBlocks[this.numFileBlocks++] = lastBlock;
        }
        lastBlock.add(directoryId, name);
        if (this.reverseMap != null && !this.reverseMap.isEmpty()) {
            String path = this.getDirectoryPath(directoryId);
            this.reverseMap.get(path).put(name, this.size);
        }
        return this.size++;
    }

    int addDirectory(int parentId, String name) throws InvalidFileTableException {
        int id = this.dirBlock.getSize();
        this.dirBlock.add(parentId, name);
        if (this.reverseMap != null && !this.reverseMap.isEmpty()) {
            String path = this.getDirectoryPath(id);
            this.reverseMap.put(path, new HashMap());
        }
        return id;
    }

    void setFileChangeType(int id, FileChange.Type type) throws InvalidFileTableException {
        int blockNum = id / 50;
        if (blockNum >= this.numFileBlocks) {
            throw new InvalidFileTableException("no file block " + blockNum + " for ID " + id);
        }
        int i = id - blockNum * 50;
        this.fileBlocks[blockNum].setType(i, type);
    }

    boolean isDirectoryRemoved(int id) {
        return this.dirBlock.getType(id) == FileChange.Type.REMOVED;
    }

    FileChange.Type getFileChangeType(int id) throws InvalidFileTableException {
        int blockNum = id / 50;
        if (blockNum >= this.numFileBlocks) {
            throw new InvalidFileTableException("no file block " + blockNum + " for ID " + id);
        }
        int i = id - blockNum * 50;
        return this.fileBlocks[blockNum].getType(i);
    }

    void save(NameSpace namespace) throws InvalidFileTableException {
        try {
            boolean dirty = false;
            if (this.dirBlock.isDirty()) {
                dirty = true;
                this.dirBlock.putRecord(namespace, DIRECTORY_BLOCK_KEY);
            }
            for (int i = 0; i < this.numFileBlocks; ++i) {
                NameBlock block = this.fileBlocks[i];
                if (!block.isDirty()) continue;
                dirty = true;
                block.putRecord(namespace, NameStore.getBlockKey(i));
            }
            if (dirty) {
                this.changeDetectionToken = this.getChangeDetectionToken();
                namespace.putRecord(CHANGE_DETECTION_KEY, this.changeDetectionToken);
            }
        }
        catch (AssemblyException e) {
            throw new InvalidFileTableException(this.fileTable, (Throwable)e);
        }
    }

    IntHashMap removeUnvisited(IntHashMap visited) {
        IntHashMap removed = new IntHashMap();
        for (int i = 0; i < this.numFileBlocks; ++i) {
            this.fileBlocks[i].keepOnlyChildren(visited, removed);
        }
        this.dirBlock.keepOnly(visited);
        return removed;
    }

    IntHashMap removeUnvisited(IntHashMap visited, int dirId, boolean recurse) {
        IntHashMap removed = new IntHashMap();
        IntHashMap unvisited = this.dirBlock.getUnvisited(visited, dirId, recurse);
        if (!unvisited.isEmpty()) {
            for (int i = 0; i < this.numFileBlocks; ++i) {
                this.fileBlocks[i].removeChildren(unvisited, removed);
            }
            Set keys = unvisited.keySet();
            Iterator i$ = keys.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                this.dirBlock.setType(i, FileChange.Type.REMOVED);
            }
        }
        return removed;
    }

    Map<String, Integer> getFileMap() {
        int i;
        HashMap<String, Integer> map = new HashMap<String, Integer>(this.size);
        String[] fullPaths = new String[this.dirBlock.getSize()];
        int[] dirParentIds = this.dirBlock.getParentIds();
        String[] dirNames = this.dirBlock.getNames();
        if (fullPaths.length > 0) {
            fullPaths[0] = "";
            for (i = 1; i < fullPaths.length; ++i) {
                fullPaths[i] = fullPaths[dirParentIds[i]] + dirNames[i] + "/";
            }
        }
        for (i = 0; i < this.numFileBlocks; ++i) {
            NameBlock block = this.fileBlocks[i];
            int[] parentIds = block.getParentIds();
            String[] fileNames = block.getNames();
            int baseId = i * 50;
            for (int j = 0; j < block.getSize(); ++j) {
                map.put(fullPaths[parentIds[j]] + fileNames[j], baseId + j);
            }
        }
        return map;
    }

    Map<String, Integer> getFileMap(String path) {
        this.buildReverseMap();
        Map<String, Integer> map = this.reverseMap.get(path);
        if (map == null) {
            return Collections.emptyMap();
        }
        return new HashMap<String, Integer>(map);
    }

    void clearReverseMap() {
        this.reverseMap = null;
    }

    private void buildReverseMap() {
        if (this.reverseMap == null) {
            int i;
            this.reverseMap = new HashMap<String, Map<String, Integer>>();
            String[] fullPaths = new String[this.dirBlock.getSize()];
            int[] dirParentIds = this.dirBlock.getParentIds();
            String[] dirNames = this.dirBlock.getNames();
            if (fullPaths.length > 0) {
                fullPaths[0] = "";
                this.reverseMap.put("", new HashMap());
                for (i = 1; i < fullPaths.length; ++i) {
                    fullPaths[i] = fullPaths[dirParentIds[i]] + dirNames[i] + "/";
                    this.reverseMap.put(fullPaths[i], new HashMap());
                }
            }
            for (i = 0; i < this.numFileBlocks; ++i) {
                NameBlock block = this.fileBlocks[i];
                int[] parentIds = block.getParentIds();
                String[] fileNames = block.getNames();
                int baseId = i * 50;
                for (int j = 0; j < block.getSize(); ++j) {
                    this.reverseMap.get(fullPaths[parentIds[j]]).put(fileNames[j], baseId + j);
                }
            }
        }
    }

    private static final String getBlockKey(int blockNum) {
        return Integer.toString(blockNum, 36);
    }

    private static final int getBlockNum(String key) {
        return Integer.parseInt(key, 36);
    }

    private byte[] getChangeDetectionToken() {
        long l = System.nanoTime();
        byte[] b = new byte[8];
        b[7] = (byte)(l >>> 0);
        b[6] = (byte)(l >>> 8);
        b[5] = (byte)(l >>> 16);
        b[4] = (byte)(l >>> 24);
        b[3] = (byte)(l >>> 32);
        b[2] = (byte)(l >>> 40);
        b[1] = (byte)(l >>> 48);
        b[0] = (byte)(l >>> 56);
        return b;
    }
}

