/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.file;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.ideimpl.file.Utils;

public final class InvalidationRecord {
    private final URL directory;
    private final boolean directoryInvalid;
    private final boolean recursive;
    private final Map<URLKey, Boolean> files;
    private final Map<URLKey, URLKey> renameHints;

    public static InvalidationRecord get(URL directory, boolean recursive) {
        return new InvalidationRecord(directory, true, recursive, Collections.<URLKey, Boolean>emptyMap(), Collections.<URLKey, URLKey>emptyMap());
    }

    public static InvalidationRecord get(URL directory, URL file) {
        HashMap<URLKey, Boolean> files = new HashMap<URLKey, Boolean>();
        files.put(URLKey.getInstance((URL)file), false);
        return new InvalidationRecord(directory, false, false, files, Collections.<URLKey, URLKey>emptyMap());
    }

    public static InvalidationRecord get(URL directory, boolean recursive, URL file, URL renameHint) {
        Map<URLKey, URLKey> renameHints;
        URLKey fileKey = URLKey.getInstance((URL)file);
        HashMap<URLKey, Boolean> files = new HashMap<URLKey, Boolean>();
        files.put(fileKey, false);
        if (renameHint != null) {
            renameHints = new HashMap();
            renameHints.put(fileKey, URLKey.getInstance((URL)renameHint));
        } else {
            renameHints = Collections.emptyMap();
        }
        return new InvalidationRecord(directory, true, recursive, files, renameHints);
    }

    public static InvalidationRecord get(URL directory, URL file, boolean isBufferChange) {
        return InvalidationRecord.get(directory, URLKey.getInstance((URL)file), isBufferChange);
    }

    public static InvalidationRecord get(URL directory, URLKey file, boolean isBufferChange) {
        HashMap<URLKey, Boolean> files = new HashMap<URLKey, Boolean>();
        files.put(file, isBufferChange);
        return new InvalidationRecord(directory, false, false, files, Collections.<URLKey, URLKey>emptyMap());
    }

    private InvalidationRecord(URL directory, boolean directoryInvalid, boolean recursive, Map<URLKey, Boolean> files, Map<URLKey, URLKey> renameHints) {
        this.directory = directory;
        this.directoryInvalid = directoryInvalid;
        this.recursive = recursive;
        this.files = files;
        this.renameHints = renameHints;
    }

    public URL getDirectory() {
        return this.directory;
    }

    public boolean isDirectoryInvalid() {
        return this.directoryInvalid;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isSingleFileInvalid() {
        return !this.directoryInvalid && this.files.size() == 1;
    }

    public Map<URLKey, Boolean> getFiles() {
        return this.files;
    }

    public Map<URLKey, URLKey> getRenameHints() {
        return this.renameHints;
    }

    public InvalidationRecord mergeTo(InvalidationRecord other) {
        return InvalidationRecord.merge(this, other);
    }

    public boolean isFileInvalid(URLKey file, boolean isBufferChange) {
        Boolean b = this.files.get(file);
        return b != null && isBufferChange == b;
    }

    public boolean isDirectoryInvalid(boolean includeSubdirectories, URL renameHintOldURL, URL renameHintNewURL) {
        if (!this.directoryInvalid) {
            return false;
        }
        if (includeSubdirectories != this.recursive) {
            return false;
        }
        if (renameHintOldURL != null && renameHintNewURL != null) {
            if (this.renameHints.isEmpty()) {
                return false;
            }
            URLKey newURL = this.renameHints.get(URLKey.getInstance((URL)renameHintOldURL));
            if (newURL == null || !URLFileSystem.equals((URL)newURL.toURL(), (URL)renameHintNewURL)) {
                return false;
            }
        }
        return true;
    }

    private static InvalidationRecord merge(InvalidationRecord from, InvalidationRecord to) {
        Map<URLKey, URLKey> renameHints;
        Map<URLKey, Boolean> files;
        if (from.files.isEmpty() && to.files.isEmpty()) {
            files = Collections.emptyMap();
        } else if (from.files.isEmpty()) {
            files = to.files;
        } else if (to.files.isEmpty()) {
            files = from.files;
        } else {
            files = new HashMap<URLKey, Boolean>(to.files);
            for (Map.Entry<URLKey, Boolean> entry : from.files.entrySet()) {
                URLKey key = entry.getKey();
                boolean fromValue = entry.getValue();
                Boolean toValue = to.files.get(key);
                files.put(key, fromValue && (toValue == null || toValue != false));
            }
        }
        if (from.renameHints.isEmpty() && to.renameHints.isEmpty()) {
            renameHints = Collections.emptyMap();
        } else if (from.renameHints.isEmpty()) {
            renameHints = to.renameHints;
        } else if (to.renameHints.isEmpty()) {
            renameHints = from.renameHints;
        } else {
            renameHints = new HashMap<URLKey, URLKey>(from.renameHints);
            Map reversedFrom = Utils.reverse(renameHints);
            for (Map.Entry<URLKey, URLKey> entry : to.renameHints.entrySet()) {
                URLKey other = renameHints.get(entry.getValue());
                if (other != null) {
                    renameHints.remove(entry.getValue());
                    renameHints.put(entry.getKey(), other);
                    continue;
                }
                other = (URLKey)reversedFrom.get(entry.getKey());
                if (other != null) {
                    renameHints.put(other, entry.getValue());
                    continue;
                }
                renameHints.put(entry.getKey(), entry.getValue());
            }
        }
        boolean directoryInvalid = from.directoryInvalid || to.directoryInvalid;
        boolean recursive = from.recursive || to.recursive;
        return new InvalidationRecord(to.directory, directoryInvalid, recursive, files, renameHints);
    }
}

