/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.UUID;
import javax.swing.JMenuItem;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.views.SpatialDockableView;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.spatial.views.SpatialViewController;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.dbtools.spatial.views.tables.SpatialListReorderableTableWithTitleBar;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.layout.ViewId;
import oracle.sql.STRUCT;

public class SpatialShowGeometriesInMap
extends GridContextMenuItem {
    private static SpatialShowGeometriesInMap _instance;
    public static final String SPATIAL_SHOW_GEOMETRY_TITLE_IN_MAP = "SpatialShowGeometryInMap";
    public static final int SPATIAL_SHOW_GEOMETRY_ID_IN_MAP;
    public static IdeAction SPATIAL_SHOW_GEOMETRY_IN_MAP;
    private JEWTDialog dlg = null;
    private boolean anyColIsGeom = false;
    private String geoColname = "";
    SpatialListReorderableTableWithTitleBar targetTitledTable;
    String targetConnection;
    String raptorQueryTitle;
    String raptorSQL;
    UUID identifier;

    private SpatialShowGeometriesInMap() {
        this.initAction();
    }

    private void initAction() {
        if (SPATIAL_SHOW_GEOMETRY_IN_MAP == null) {
            SPATIAL_SHOW_GEOMETRY_IN_MAP = this.createAction(SPATIAL_SHOW_GEOMETRY_ID_IN_MAP, StringUtils.stripMnemonic((String)SpatialArb.getString("ShowGeometries")), null);
        }
    }

    public static SpatialShowGeometriesInMap getInstance() {
        if (_instance == null) {
            _instance = new SpatialShowGeometriesInMap();
        }
        return _instance;
    }

    protected boolean canShow(ContextMenu contextMenu) {
        this.anyColIsGeom = false;
        if (contextMenu.getContext().getEvent().getSource() instanceof ResultSetTable) {
            IResultSetTableModel iResultSetTableModel = (IResultSetTableModel)this._table.getModel();
            int n = iResultSetTableModel.getGridColumns().size();
            int n2 = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
            n2 = this._table.convertRowIndexToModel(n2);
            for (int i = 0; i <= n - 1 && !this.anyColIsGeom; ++i) {
                this.geoColname = iResultSetTableModel.getColumnName(i);
                int n3 = iResultSetTableModel.getColumnSqlType(i);
                if (n3 != 2002) continue;
                STRUCT sTRUCT = null;
                Object object = iResultSetTableModel.getValueAt(n2, i);
                try {
                    if (object instanceof STRUCT) {
                        sTRUCT = (STRUCT)object;
                    }
                    if (sTRUCT == null || !sTRUCT.getSQLTypeName().equals("MDSYS.SDO_GEOMETRY")) continue;
                    this.anyColIsGeom = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.anyColIsGeom;
    }

    protected void createAndShowMenu(ContextMenu contextMenu) {
        SpatialListReorderableTableWithTitleBar<?> spatialListReorderableTableWithTitleBar = SpatialUtil.getPanel().getSelectedTabPage();
        String string = null;
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)SPATIAL_SHOW_GEOMETRY_IN_MAP);
        jMenuItem.setText(SpatialArb.getString("ShowGeometriesInMap"));
        contextMenu.add((Component)jMenuItem);
        if (spatialListReorderableTableWithTitleBar != null) {
            string = spatialListReorderableTableWithTitleBar.getCombobox().getCurrentConnectionName();
        }
        IResultSetTableModel iResultSetTableModel = (IResultSetTableModel)this._table.getModel();
        if (string != null) {
            if (iResultSetTableModel.getConnectionName().equals(string)) {
                this.identifier = SpatialUtil.getPanel().getSelectedTabPage().getModel().getIdentifier();
                jMenuItem.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
            }
        } else {
            jMenuItem.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showGeometryShapeInMapRaptorized() {
        try {
            IResultSetTableModel iResultSetTableModel = (IResultSetTableModel)this._table.getModel();
            this.raptorSQL = iResultSetTableModel.getModifiedSql();
            this.targetConnection = iResultSetTableModel.getConnectionName();
            SpatialDockableView spatialDockableView = (SpatialDockableView)DockStation.getDockStation().findDockable(new ViewId("SPATIAL_VIEW_TYPE.SPATIAL_VIEW_ID"));
            if (spatialDockableView != null) {
                spatialDockableView.show();
                this.raptorQueryTitle = "Default";
                if (this.geoColname != null) {
                    this.raptorQueryTitle = this.geoColname;
                }
                String string = "";
                Color color = new Color(112, 112, 89);
                Color color2 = new Color(248, 249, 204);
                if (this.raptorSQL != null && this.raptorSQL.length() > 0) {
                    String[] stringArray = new String[]{};
                    QueryObject queryObject = new QueryObject(this.raptorQueryTitle, this.raptorSQL, color, color2, string, stringArray);
                    queryObject.setConnectionSourceName(this.targetConnection);
                    queryObject.setTabIdentifier(this.identifier.toString());
                    queryObject.setNewlyCreated();
                    queryObject.setPreselected(true);
                    SpatialUtil.getPanel().getSelectedTabPage().setConnectionAndInsertQuery(queryObject, queryObject.getConnectionSourceName(), Boolean.TRUE);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            SpatialViewController.getInstance().toggleToolbar();
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == SPATIAL_SHOW_GEOMETRY_ID_IN_MAP) {
            this.showGeometryShapeInMapRaptorized();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    static {
        SPATIAL_SHOW_GEOMETRY_ID_IN_MAP = Ide.findOrCreateCmdID((String)SPATIAL_SHOW_GEOMETRY_TITLE_IN_MAP);
        SPATIAL_SHOW_GEOMETRY_IN_MAP = null;
    }
}

