/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.dialogs.metadata.model;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.dialogs.metadata.model.SpatialDimension;

public class SpatialTableModel
extends AbstractTableModel {
    private static Vector dimList = null;

    public SpatialTableModel(Vector vector) {
        dimList = vector;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return dimList.size();
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return SpatialArb.getString("SpatialDimName");
        }
        if (n == 1) {
            return SpatialArb.getString("SpatialDimLowBoundary");
        }
        if (n == 2) {
            return SpatialArb.getString("SpatialDimUpperBoundary");
        }
        if (n == 3) {
            return SpatialArb.getString("SpatialDimTolerance");
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SpatialDimension spatialDimension = (SpatialDimension)dimList.get(n);
        if (n2 == 0) {
            return spatialDimension.getName();
        }
        if (n2 == 1) {
            return spatialDimension.getLowBoundary();
        }
        if (n2 == 2) {
            return spatialDimension.getUpperBoundary();
        }
        if (n2 == 3) {
            return spatialDimension.getTolerance();
        }
        return new Integer(n * n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        SpatialDimension spatialDimension = (SpatialDimension)dimList.get(n);
        if (n2 == 0) {
            spatialDimension.setName((String)object);
        } else if (n2 == 1) {
            spatialDimension.setLowBoundary((String)object);
        } else if (n2 == 2) {
            spatialDimension.setUpperBoundary((String)object);
        } else if (n2 == 3) {
            spatialDimension.setTolerance((String)object);
        }
    }
}

