/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.dialogs.validate.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.grid.RaptorGridTaskWrapper;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.dialogs.validate.model.SpatialValidationGrid;
import oracle.dbtools.spatial.dialogs.validate.model.ValidateGeometryModel;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;

public class ValidateGeometryView {
    private static final int FIELD_WIDTH = 150;
    private static final int FIELD_HEIGHT = 20;
    private Dimension defaultSize = new Dimension(150, 20);
    private JComboBox spatialColumn = new JComboBox();
    private JList idColumnsList = null;
    private JTextField tfName = new JTextField();
    private JTextField tolerance = new JTextField();
    private SpatialValidationGrid grid;
    private ValidateGeometryModel model;
    private JEWTDialog dlg = null;

    public ValidateGeometryView(ValidateGeometryModel validateGeometryModel) {
        this.model = validateGeometryModel;
    }

    public void refreshResultsPanel() {
        try {
            this.grid.refresh();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void closeResultsPanel() {
        try {
            this.grid.closeModel();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void enableSpatialColumn(boolean bl) {
        this.spatialColumn.setEnabled(bl);
    }

    private JPanel createRow(JLabel jLabel, Component component) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add(component, "Center");
        return jPanel;
    }

    public JPanel createMainPanel() {
        JLabel jLabel;
        JPanel jPanel = null;
        this.grid = new SpatialValidationGrid();
        jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createTitledBorder(SpatialArb.getString("ValidateGeometry")));
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 10, 10));
        JLabel jLabel2 = new JLabel(SpatialArb.getString("SpatialTableName"));
        jLabel2.setPreferredSize(this.defaultSize);
        this.tfName.setPreferredSize(this.defaultSize);
        this.tfName.setEditable(false);
        jPanel3.add(this.createRow(jLabel2, this.tfName));
        boolean bl = this.model.getDimValidation();
        if (!bl) {
            jLabel = new JLabel(StringUtils.stripMnemonic((String)SpatialArb.getString("Tolerance")));
            jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("Tolerance")));
            jLabel.setPreferredSize(this.defaultSize);
            this.tolerance.setPreferredSize(this.defaultSize);
            this.tolerance.setEditable(true);
            jLabel.setLabelFor(this.tolerance);
            jPanel3.add(this.createRow(jLabel, this.tolerance));
        }
        jLabel = new JLabel(StringUtils.stripMnemonic((String)SpatialArb.getString("SpatialColumnName")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("SpatialColumnName")));
        jLabel.setPreferredSize(this.defaultSize);
        this.spatialColumn.setPreferredSize(this.defaultSize);
        jLabel.setLabelFor(this.spatialColumn);
        jPanel3.add(this.createRow(jLabel, this.spatialColumn));
        jPanel2.add((Component)jPanel3, "North");
        JLabel jLabel3 = new JLabel(StringUtils.stripMnemonic((String)SpatialArb.getString("IdColumns")));
        jLabel3.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("IdColumns")));
        jLabel3.setPreferredSize(this.defaultSize);
        this.idColumnsList = new JList();
        jLabel3.setLabelFor(this.idColumnsList);
        JScrollPane jScrollPane = new JScrollPane(this.idColumnsList);
        jScrollPane.setPreferredSize(new Dimension(150, 100));
        jScrollPane.setSize(jScrollPane.getPreferredSize());
        jPanel2.add((Component)this.createRow(jLabel3, jScrollPane), "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(SpatialArb.getString("ValidationResults")));
        JScrollPane jScrollPane2 = new JScrollPane((Component)((Object)this.grid), 22, 30);
        jScrollPane2.setPreferredSize(new Dimension(150, 150));
        jScrollPane2.setSize(jScrollPane2.getPreferredSize());
        jPanel4.add(jScrollPane2);
        jPanel.add((Component)jPanel4, "Center");
        jPanel.add((Component)jPanel2, "North");
        jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        return jPanel;
    }

    public void decorateMainPanel() {
        String string;
        this.tfName.setText(this.model.getTableName());
        this.tolerance.setText(this.model.getTolerance());
        this.spatialColumn.removeAllItems();
        if (this.model.getIsColumnSelected()) {
            if (this.model.isSingleColumnSpatial()) {
                string = this.model.getCurrentColumn();
                this.spatialColumn.addItem(string);
                this.spatialColumn.setSelectedItem(string);
            }
        } else {
            for (int i = 0; i < this.model.getSpatialColumnSize(); ++i) {
                this.spatialColumn.addItem(this.model.getSpatialColumn(i));
            }
        }
        this.idColumnsList.setModel(this.model.getIdColsListModel());
        string = null;
        if (!this.model.getIsColumnSelected() && (string = this.model.getFirstColumn()) != null) {
            this.spatialColumn.setSelectedItem(string);
        }
    }

    public String getSpatialColumnValue() {
        return (String)this.spatialColumn.getSelectedItem();
    }

    public Object[] getIdColumnValues() {
        return this.idColumnsList.getSelectedValues();
    }

    public String getTolerance() {
        return this.tolerance.getText();
    }

    public void addSpatialColumnBoxListener(ActionListener actionListener) {
        this.spatialColumn.addActionListener(actionListener);
    }

    public void addToleranceListener(DocumentListener documentListener) {
        this.tolerance.getDocument().addDocumentListener(documentListener);
    }

    public void removeSpatialColumnBoxListener(ActionListener actionListener) {
        this.spatialColumn.removeActionListener(actionListener);
    }

    public void removeToleranceListener(DocumentListener documentListener) {
        this.tolerance.getDocument().removeDocumentListener(documentListener);
    }

    public boolean checkInput() {
        boolean bl = true;
        String string = this.model.getTolerance();
        try {
            Double d = Double.parseDouble(string);
            if (d <= 0.0) {
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (!bl) {
            this.showErrorDlg();
            return false;
        }
        if (this.model.toleranceOK()) {
            return true;
        }
        this.showErrorDlg();
        return false;
    }

    private void showErrorDlg() {
        PropertyPanel propertyPanel = new PropertyPanel();
        String string = SpatialArb.getString("SpatialError");
        JLabel jLabel = new JLabel(SpatialArb.getString("SpatialErrorInInputForTolerance"));
        propertyPanel.addSingleComp((JComponent)jLabel);
        propertyPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string, (int)1);
        this.dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidateGeometryView.this.dlg.dispose();
            }
        });
        Dimension dimension = propertyPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 100;
        this.dlg.setSize(n2, n);
        this.dlg.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public void showGrid() {
        this.closeResultsPanel();
        String string = this.model.getValidationSql();
        String string2 = this.model.getConnection();
        this.grid.setQuery(string2, string, null, null);
        try {
            this.grid.open(new RaptorGridTaskWrapper(SpatialArb.getString("ValidationResults"), IRaptorTaskRunMode.MODAL, true, null, null, null));
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }
}

