/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.ShowContextDialog;
import oracle.dbtools.spatial.mapviewer.components.AnnotatedGeometry;
import oracle.dbtools.spatial.mapviewer.components.MapGeometry;
import oracle.dbtools.spatial.mapviewer.components.MapGeometryCache;
import oracle.dbtools.spatial.mapviewer.components.MapViewerGeometryResultSet;
import oracle.dbtools.spatial.mapviewer.components.MapViewerRenderer;
import oracle.dbtools.spatial.views.SpatialViewController;
import oracle.dbtools.spatial.views.tables.SpatialReorderableTableModel;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.javatools.dialogs.MessageDialog;
import oracle.sdovis.XFViewPort;
import oracle.spatial.geometry.JGeometry;

public class GeomImgPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Point validGeometryPoint = null;
    private JGeometry validGeometry = null;
    private String validQuery = null;
    public static final int STATE_DEFAULT = 0;
    public static final int STATE_ZOOM_IN = 1;
    public static final int STATE_ZOOM_OUT = 2;
    public static final int STATE_ZOOM_FIT = 3;
    public static final int STATE_ZOOM_MARQUEE = 4;
    public static final int STATE_ZOOM_MARQUEE_DRAWIMAGE = 5;
    private final int PIXEL_SIZE = 3;
    private final Color SKY_BLUE = new Color(153, 204, 255);
    private int state = 0;
    private Toolbar toolbar;
    int toolbarHeight;
    private Color defaultBgColor;
    JScrollPane scrollPane;
    ScrollableMap scrollableMap;
    private GeomImgPanel geomImgPanel;
    private boolean isHighlighted;
    private SpatialReorderableTableModel tableModel;
    private MapGeometry[] highLightedGeoms;
    private MapViewerGeometryResultSet mvrs;
    private MapViewerRenderer geomRenderer;

    public GeomImgPanel(SpatialReorderableTableModel spatialReorderableTableModel) {
        this.tableModel = spatialReorderableTableModel;
        this.mvrs = spatialReorderableTableModel.getMapViewerResultSet();
        this.defaultBgColor = this.SKY_BLUE;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 400));
        this.setOpaque(true);
        this.toolbar = new Toolbar();
        SpatialViewController.getInstance().installVisualizationToolbar(this.toolbar);
        this.add((Component)this.toolbar, "North");
        this.toolbar.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.toolbar.setVisible(true);
        this.toolbar.setOpaque(true);
        this.toolbarHeight = 25;
        this.scrollPane = new JScrollPane();
        this.scrollableMap = new ScrollableMap(null, 10);
        this.scrollPane.setViewportView(this.scrollableMap);
        this.scrollPane.getViewport().setBackground(this.defaultBgColor);
        this.add((Component)this.scrollPane, "Center");
        this.geomImgPanel = this;
        this.geomRenderer = new MapViewerRenderer(this.defaultBgColor, this.mvrs);
        this.isHighlighted = false;
    }

    public void refreshMaps(MapGeometry[] mapGeometryArray) {
        this.scrollableMap.removeImage();
        if (mapGeometryArray == null || mapGeometryArray.length < 1) {
            return;
        }
        int n = mapGeometryArray.length;
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < n; ++i) {
            if (mapGeometryArray[i].getGeometries() == null || mapGeometryArray[i].getGeometries().length <= 0) continue;
            vector.add(i);
        }
        MapGeometry[] mapGeometryArray2 = new MapGeometry[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            mapGeometryArray2[i] = mapGeometryArray[(Integer)vector.get(i)];
        }
        if (mapGeometryArray2 == null || mapGeometryArray2.length < 1) {
            return;
        }
        int n2 = this.scrollableMap.getImageWidth();
        int n3 = this.scrollableMap.getImageHeight();
        if (this.isHighlighted()) {
            MapGeometry[] mapGeometryArray3 = new MapGeometry[1];
            MapGeometry mapGeometry = this.highLightedGeoms[this.highLightedGeoms.length - 1];
            mapGeometryArray3[0] = this.highLightedGeoms[0];
            this.scrollableMap.removeImage();
            this.scrollableMap.setPreferredSize(new Dimension(n2, n3));
            this.drawImageHighlight(mapGeometryArray3, mapGeometry, n2, n3);
        } else {
            MapGeometry[] mapGeometryArray4 = this.tableModel.getCurrentGeometries();
            if (mapGeometryArray4 != null && mapGeometryArray4.length > 0) {
                this.scrollableMap.removeImage();
                this.scrollableMap.setPreferredSize(new Dimension(n2, n3));
                this.drawImage(mapGeometryArray4, n2, n3);
            }
        }
        this.tableModel.setCurrentGeometries(mapGeometryArray);
    }

    private void drawImage(MapGeometry[] mapGeometryArray, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return;
        }
        try {
            this.geomRenderer = new MapViewerRenderer(this.defaultBgColor, this.mvrs);
            Image image = this.geomRenderer.getImage2(mapGeometryArray, n, n2);
            if (image == null) {
                return;
            }
            ImageIcon imageIcon = new ImageIcon(image);
            if (imageIcon == null) {
                return;
            }
            this.scrollableMap.setMap(imageIcon);
            System.gc();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            MessageDialog.error((Component)this, (Object)SpatialArb.getString("MapViewerZoomLimit"), (String)SpatialArb.getString("MapViewerWarning"), null);
        }
    }

    private void drawImageHighlight(MapGeometry[] mapGeometryArray, MapGeometry mapGeometry, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return;
        }
        try {
            this.geomRenderer = new MapViewerRenderer(this.defaultBgColor, this.mvrs);
            Image image = this.geomRenderer.getHighLightedImage(mapGeometryArray, mapGeometry, n, n2);
            ImageIcon imageIcon = new ImageIcon(image);
            if (imageIcon == null) {
                return;
            }
            this.scrollableMap.setMap(imageIcon);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            MessageDialog.error((Component)this, (Object)SpatialArb.getString("MapViewerZoomLimit"), (String)SpatialArb.getString("MapViewerWarning"), null);
        }
    }

    public void drawEmptyImage() {
        this.scrollableMap.removeImage();
    }

    public void removeImageFromPanel() {
        this.scrollableMap.removeImage();
        this.scrollableMap.setInitialMsg();
    }

    public void zoomIn() {
        int n = 50;
        this.setState(1);
        int n2 = this.scrollableMap.getImageWidth();
        int n3 = this.scrollableMap.getImageHeight();
        if (this.isHighlighted()) {
            MapGeometry[] mapGeometryArray = this.getMapGeometries();
            MapGeometry mapGeometry = this.highLightedGeoms[this.highLightedGeoms.length - 1];
            this.geomRenderer = new MapViewerRenderer(this.defaultBgColor, this.mvrs);
            Image image = this.geomRenderer.getHighLightedImage(mapGeometryArray, mapGeometry, n2 + n, n3 + n);
            Point point = this.geomRenderer.getHiLiteCoordinates();
            this.scrollableMap.setPreferredSize(new Dimension(n2 + n, n3 + n));
            this.setPanelImage(image);
        } else {
            MapGeometry[] mapGeometryArray = this.getMapGeometries();
            if (mapGeometryArray != null && mapGeometryArray.length > 0) {
                this.scrollableMap.setPreferredSize(new Dimension(n2 + n, n3 + n));
                this.drawImage(mapGeometryArray, n2 + n, n3 + n);
            }
        }
    }

    public void zoomOut() {
        int n = 50;
        this.setState(2);
        if (this.isHighlighted()) {
            MapGeometry[] mapGeometryArray = new MapGeometry[1];
            MapGeometry mapGeometry = this.highLightedGeoms[this.highLightedGeoms.length - 1];
            mapGeometryArray[0] = this.highLightedGeoms[0];
            MapGeometry[] mapGeometryArray2 = this.getMapGeometries();
            this.geomRenderer = new MapViewerRenderer(this.defaultBgColor, this.mvrs);
            int n2 = this.scrollableMap.getImageWidth();
            int n3 = this.scrollableMap.getImageHeight();
            Image image = this.geomRenderer.getHighLightedImage(mapGeometryArray2, mapGeometry, n2 - n, n3 - n);
            Point point = this.geomRenderer.getHiLiteCoordinates();
            this.scrollableMap.setPreferredSize(new Dimension(n2 - n, n3 - n));
            this.setPanelImage(image);
        } else {
            MapGeometry[] mapGeometryArray = this.getMapGeometries();
            if (mapGeometryArray != null && mapGeometryArray.length > 0) {
                int n4 = this.scrollableMap.getImageWidth();
                int n5 = this.scrollableMap.getImageHeight();
                this.scrollableMap.setPreferredSize(new Dimension(n4 - n, n5 - n));
                this.drawImage(mapGeometryArray, n4 - n, n5 - n);
            }
        }
    }

    public void zoomFit() {
        if (!this.scrollableMap.isImageSet() || this.getState() != 3) {
            return;
        }
        int n = this.scrollPane.getWidth();
        int n2 = this.scrollPane.getHeight();
        if (this.isHighlighted()) {
            MapGeometry[] mapGeometryArray = new MapGeometry[1];
            MapGeometry mapGeometry = this.highLightedGeoms[this.highLightedGeoms.length - 1];
            mapGeometryArray[0] = this.highLightedGeoms[0];
            this.scrollableMap.removeImage();
            this.scrollableMap.setPreferredSize(new Dimension(n, n2));
            this.drawImageHighlight(mapGeometryArray, mapGeometry, n, n2);
        } else {
            MapGeometry[] mapGeometryArray = this.tableModel.getCurrentGeometries();
            if (mapGeometryArray != null && mapGeometryArray.length > 0) {
                this.scrollableMap.removeImage();
                this.scrollableMap.setPreferredSize(new Dimension(n, n2));
                this.drawImage(mapGeometryArray, n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMarqueeZoomedImage(Rectangle rectangle) {
        Image image;
        Object object;
        Point point = new Point((int)rectangle.getX(), (int)rectangle.getY());
        Point point2 = new Point((int)rectangle.getX() + (int)rectangle.getWidth(), (int)rectangle.getY() + (int)rectangle.getHeight());
        MapGeometry[] mapGeometryArray = this.getMapGeometries();
        if (mapGeometryArray == null) {
            return;
        }
        int n = point.x;
        int n2 = point.y;
        int n3 = point2.x;
        int n4 = point2.y;
        double d = Math.abs(n4 - n2);
        double d2 = Math.abs(n3 - n);
        if (d == 0.0 || d2 == 0.0) {
            return;
        }
        int n5 = this.scrollableMap.getImageHeight();
        int n6 = this.scrollableMap.getImageWidth();
        int n7 = this.scrollPane.getHeight();
        int n8 = this.scrollPane.getWidth();
        double d3 = (double)n5 / d;
        double d4 = (double)n6 / d2;
        double d5 = Math.min(d3, d4);
        double[] dArray = this.getImageMBR();
        double d6 = dArray[2] - dArray[0];
        double d7 = dArray[3] - dArray[1];
        int n9 = Math.round((float)d5 * (float)this.scrollableMap.getImageWidth());
        int n10 = Math.round((float)((double)n9 * (d7 / d6)));
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = new BufferedImage(n9, n10, 1);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            n9 = this.scrollableMap.getImageWidth();
            n10 = this.scrollableMap.getImageHeight();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, outOfMemoryError.getStackTrace()[0].toString(), outOfMemoryError);
            MessageDialog.error((Component)this, (Object)SpatialArb.getString("MapViewerZoomLimit"), (String)SpatialArb.getString("MapViewerWarning"), null);
        }
        finally {
            bufferedImage = null;
            System.gc();
        }
        this.geomRenderer = new MapViewerRenderer(this.mvrs);
        if (this.isHighlighted) {
            object = this.highLightedGeoms[this.highLightedGeoms.length - 1];
            image = this.geomRenderer.generateClippedImage(mapGeometryArray, n9, n10, dArray, (MapGeometry)object);
        } else {
            image = this.geomRenderer.generateClippedImage(mapGeometryArray, n9, n10, dArray, null);
        }
        Point point3 = new Point(rectangle.x * n9 / n6, rectangle.y * n10 / n5);
        Point point4 = new Point(point2.x * n9 / n6, point2.y * n10 / n5);
        object = new Rectangle(point3.x, point3.y, point4.x - point3.x, point4.y - point3.y);
        this.scrollableMap.setPreferredSize(new Dimension(n9, n10));
        this.scrollableMap.setMapCenteredOn(new ImageIcon(image), (Rectangle)object);
    }

    public void setPanelImage(Image image) {
        this.scrollableMap.removeImage();
        this.scrollableMap.setMap(new ImageIcon(image));
    }

    public MapViewerRenderer getRenderer() {
        return this.geomRenderer;
    }

    public int getInnerWidth() {
        return this.scrollableMap.getImageWidth();
    }

    public int getInnerHeight() {
        return this.scrollableMap.getImageHeight();
    }

    public MapGeometry[] getMapGeometries() {
        MapGeometryCache mapGeometryCache = this.tableModel.getGeometryCache();
        return mapGeometryCache.getMapCache();
    }

    private int getLowestVisibleLayer() {
        MapGeometryCache mapGeometryCache = this.tableModel.getGeometryCache();
        return mapGeometryCache.getLowestVisibleLayer();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_mapview_html");
    }

    public Point getCurrentImageCenterPoint(Image image) {
        if (image == null) {
            return null;
        }
        return new Point(image.getWidth(null) / 2, image.getHeight(null) / 2);
    }

    public boolean isImageNull() {
        return !this.scrollableMap.isImageSet();
    }

    private double[] getImageMBR() {
        Object[] objectArray;
        Vector<AnnotatedGeometry> vector = new Vector<AnnotatedGeometry>();
        MapGeometry[] mapGeometryArray = this.getMapGeometries();
        if (mapGeometryArray == null) {
            return null;
        }
        for (int i = 0; i < mapGeometryArray.length; ++i) {
            objectArray = mapGeometryArray[i].getGeometries();
            for (int j = 0; j < objectArray.length; ++j) {
                vector.add(objectArray[j]);
            }
        }
        Object[] objectArray2 = new AnnotatedGeometry[vector.size()];
        vector.copyInto(objectArray2);
        objectArray = new double[objectArray2.length];
        double[] dArray = new double[objectArray2.length];
        double[] dArray2 = new double[objectArray2.length];
        double[] dArray3 = new double[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            double[] dArray4 = ((AnnotatedGeometry)objectArray2[i]).getGeometry().getMBR();
            objectArray[i] = (AnnotatedGeometry)dArray4[0];
            dArray[i] = dArray4[1];
            dArray2[i] = dArray4[2];
            dArray3[i] = dArray4[3];
        }
        double[] dArray5 = new double[4];
        Arrays.sort((double[])objectArray);
        dArray5[0] = (double)objectArray[0];
        Arrays.sort(dArray);
        dArray5[1] = dArray[0];
        Arrays.sort(dArray2);
        dArray5[2] = dArray2[objectArray2.length - 1];
        Arrays.sort(dArray3);
        dArray5[3] = dArray3[objectArray2.length - 1];
        vector = null;
        return dArray5;
    }

    private long getFreeHeapMemorySize() {
        long l = Runtime.getRuntime().freeMemory();
        return l;
    }

    private boolean isImageSizeAllowedInHeapMemory(int n, int n2) {
        long l = (long)n * (long)n2;
        long l2 = this.getFreeHeapMemorySize();
        long l3 = l2 / 3L;
        return l < l3;
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public void setHighlighted(MapGeometry[] mapGeometryArray) {
        if (mapGeometryArray == null || mapGeometryArray.length < 1) {
            this.isHighlighted = false;
            this.highLightedGeoms = null;
        } else {
            this.isHighlighted = true;
            this.highLightedGeoms = mapGeometryArray;
        }
    }

    protected void setStateDefault() {
        this.setState(0);
    }

    public void setState(int n) {
        this.state = n;
    }

    protected int getState() {
        return this.state;
    }

    private boolean isMarqueeZoomState() {
        return this.getState() == 4;
    }

    private void mapPanelMouseClicked(MouseEvent mouseEvent) {
        this.validGeometry = null;
        this.validQuery = null;
        if (mouseEvent.getButton() == 3) {
            Object[] objectArray;
            Point point = mouseEvent.getPoint();
            XFViewPort xFViewPort = new XFViewPort();
            xFViewPort.setDeviceView((Rectangle2D)new Rectangle2D.Double(2.0, 2.0, this.scrollableMap.getImageWidth(), this.scrollableMap.getImageHeight()));
            xFViewPort.setStrict(true);
            Vector<AnnotatedGeometry> vector = new Vector<AnnotatedGeometry>();
            MapGeometry[] mapGeometryArray = this.getMapGeometries();
            if (mapGeometryArray == null) {
                return;
            }
            for (int i = 0; i < mapGeometryArray.length; ++i) {
                objectArray = mapGeometryArray[i].getGeometries();
                for (int j = 0; j < objectArray.length; ++j) {
                    vector.add(objectArray[j]);
                }
            }
            Object[] objectArray2 = new AnnotatedGeometry[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = new double[objectArray2.length];
            double[] dArray = new double[objectArray2.length];
            double[] dArray2 = new double[objectArray2.length];
            double[] dArray3 = new double[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                double[] dArray4 = ((AnnotatedGeometry)objectArray2[i]).getGeometry().getMBR();
                objectArray[i] = (AnnotatedGeometry)dArray4[0];
                dArray[i] = dArray4[1];
                dArray2[i] = dArray4[2];
                dArray3[i] = dArray4[3];
            }
            double[] dArray5 = new double[4];
            Arrays.sort((double[])objectArray);
            dArray5[0] = (double)objectArray[0];
            Arrays.sort(dArray);
            dArray5[1] = dArray[0];
            Arrays.sort(dArray2);
            dArray5[2] = dArray2[objectArray2.length - 1];
            Arrays.sort(dArray3);
            dArray5[3] = dArray3[objectArray2.length - 1];
            double d = dArray5[2] - dArray5[0];
            double d2 = dArray5[3] - dArray5[1];
            xFViewPort.setDataView((Rectangle2D)new Rectangle2D.Double(dArray5[0], dArray5[1], d, d2));
            AffineTransform affineTransform = xFViewPort.getAffineTransform();
            Vector<GeomInfo> vector2 = new Vector<GeomInfo>();
            if (point.getX() <= (double)this.scrollableMap.getImageWidth() && point.getY() <= (double)this.scrollableMap.getImageHeight()) {
                MapGeometry[] mapGeometryArray2 = this.getMapGeometries();
                int n = this.getLowestVisibleLayer();
                for (int i = 0; i < mapGeometryArray2.length; ++i) {
                    AnnotatedGeometry[] annotatedGeometryArray = mapGeometryArray2[i].getGeometries();
                    int n2 = mapGeometryArray2[i].getLayerNumber();
                    for (int j = 0; j < annotatedGeometryArray.length; ++j) {
                        Shape shape = null;
                        if (annotatedGeometryArray[j].getGeometry().getType() == 1) {
                            double[] dArray6 = annotatedGeometryArray[j].getGeometry().getPoint();
                            Ellipse2D.Double double_ = new Ellipse2D.Double(dArray6[0], dArray6[1], 0.1f, 0.1f);
                            shape = affineTransform.createTransformedShape(double_);
                        } else {
                            shape = annotatedGeometryArray[j].getGeometry().createShape(affineTransform, true);
                        }
                        boolean bl = shape.contains(point);
                        if (!bl) continue;
                        vector2.add(new GeomInfo(i, j, shape.getBounds2D().getWidth() * shape.getBounds2D().getHeight()));
                    }
                    annotatedGeometryArray = null;
                }
                if (vector2 == null || vector2.size() == 0) {
                    return;
                }
                GeomInfo geomInfo = (GeomInfo)vector2.elementAt(0);
                for (int i = 1; i < vector2.size(); ++i) {
                    if (!(((GeomInfo)vector2.elementAt(i)).getGeomArea() < geomInfo.getGeomArea())) continue;
                    geomInfo = (GeomInfo)vector2.elementAt(i);
                }
                this.validGeometryPoint = point;
                this.validGeometry = (JGeometry)mapGeometryArray2[geomInfo.getMapNumber()].getGeometries()[geomInfo.getMapIndex()].getGeometry().clone();
                this.validQuery = new String(mapGeometryArray2[geomInfo.getMapNumber()].getQuery());
            }
            vector = null;
            vector2 = null;
        }
    }

    class ScrollableMap
    extends JLabel
    implements Scrollable,
    MouseMotionListener,
    MouseListener {
        private ImageIcon mapImage;
        private int maxUnitIncrement;
        private boolean missingPicture;
        private final boolean UP = true;
        private final boolean DOWN = false;
        private final boolean LEFT = true;
        private final boolean RIGHT = false;
        private int firstXCoord;
        private int firstYCoord;
        private int endXCoord;
        private int endYCoord;
        private ShowContextDialog showContextDialog;
        private JMenuItem menuItemShCtx;
        private JPopupMenu popup;

        public ScrollableMap(ImageIcon imageIcon, int n) {
            super(imageIcon);
            this.maxUnitIncrement = 1;
            this.missingPicture = false;
            this.UP = true;
            this.DOWN = false;
            this.LEFT = true;
            this.RIGHT = false;
            this.firstXCoord = 0;
            this.firstYCoord = 0;
            this.endXCoord = 0;
            this.endYCoord = 0;
            this.setPreferredSize(new Dimension(300, 350));
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(1);
            this.maxUnitIncrement = n;
            this.setupImage(imageIcon);
            this.setAutoscrolls(true);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.popup = new JPopupMenu();
            this.popup.setBackground(Color.white);
            this.popup.setVisible(true);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ScrollableMap.this.missingPicture) {
                        return;
                    }
                    if (GeomImgPanel.this.validQuery != null && GeomImgPanel.this.validGeometry != null && !ScrollableMap.this.missingPicture) {
                        ScrollableMap.this.showContextDialog = new ShowContextDialog((Frame)new JFrame(), true, GeomImgPanel.this.validQuery, GeomImgPanel.this.validGeometry);
                        ScrollableMap.this.showContextDialog.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent windowEvent) {
                            }
                        });
                        ScrollableMap.this.showContextDialog.setVisible(true);
                        ScrollableMap.this.showContextDialog.setGeometry(GeomImgPanel.this.validGeometry);
                        ScrollableMap.this.showContextDialog.setQuery(GeomImgPanel.this.validQuery);
                    }
                }
            };
            this.menuItemShCtx = new JMenuItem(SpatialArb.getString("MapViewerImagePanelShowGeometryContext"));
            this.menuItemShCtx.addActionListener(actionListener);
            this.menuItemShCtx.setEnabled(true);
            this.popup.add(this.menuItemShCtx);
        }

        public synchronized void removeImage() {
            this.menuItemShCtx.setEnabled(false);
            if (this.mapImage != null) {
                this.mapImage.getImage().flush();
                this.mapImage = null;
                this.missingPicture = true;
                this.setSize(this.getPreferredSize());
                System.gc();
                this.repaint();
            }
        }

        public boolean isImageSet() {
            return !this.missingPicture;
        }

        public int getImageWidth() {
            if (this.missingPicture) {
                return (int)GeomImgPanel.this.scrollPane.getSize().getWidth();
            }
            return this.mapImage.getImage().getWidth(null);
        }

        public int getImageHeight() {
            if (this.missingPicture) {
                return (int)GeomImgPanel.this.scrollPane.getSize().getHeight();
            }
            return this.mapImage.getImage().getHeight(null);
        }

        public void setInitialMsg() {
            this.removeIcon();
            this.setMap(null);
        }

        private void setupImage(ImageIcon imageIcon) {
            if (imageIcon == null) {
                this.missingPicture = true;
                this.setText(SpatialArb.getString("SPATIAL_MAPVIEWER_DEFAULT_MSG"));
                this.setPreferredSize(new Dimension(300, 350));
            } else {
                this.missingPicture = false;
                this.setText("");
                this.mapImage = imageIcon;
                this.setIcon(this.mapImage);
                this.menuItemShCtx.setEnabled(true);
            }
        }

        public void setMap(ImageIcon imageIcon) {
            this.setupImage(imageIcon);
        }

        public void removeIcon() {
            this.setIcon(null);
        }

        public void setMapCenteredOn(ImageIcon imageIcon, Rectangle rectangle) {
            if (imageIcon == null) {
                this.missingPicture = true;
                this.setText(SpatialArb.getString("SPATIAL_MAPVIEWER_DEFAULT_MSG"));
            } else {
                this.missingPicture = false;
                this.setText("");
                this.mapImage = imageIcon;
                this.setIcon(this.mapImage);
                this.menuItemShCtx.setEnabled(true);
                this.scrollRectToVisible(rectangle);
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            int n3 = 0;
            n3 = n == 0 ? rectangle.x : rectangle.y;
            if (n2 < 0) {
                int n4 = n3 - n3 / this.maxUnitIncrement * this.maxUnitIncrement;
                return n4 == 0 ? this.maxUnitIncrement : n4;
            }
            return (n3 / this.maxUnitIncrement + 1) * this.maxUnitIncrement - n3;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            if (n == 0) {
                return rectangle.width - this.maxUnitIncrement;
            }
            return rectangle.height - this.maxUnitIncrement;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.endXCoord = mouseEvent.getX();
            this.endYCoord = mouseEvent.getY();
            if (this.firstXCoord - n == 0 || this.firstYCoord - n2 == 0) {
                return;
            }
            Rectangle rectangle = this.getDragRectangle();
            if (!GeomImgPanel.this.isMarqueeZoomState() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.scrollRectToVisible(rectangle);
            } else {
                this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public Dimension getPreferredSize() {
            return super.getPreferredSize();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && GeomImgPanel.this.isMarqueeZoomState()) {
                GeomImgPanel.this.geomImgPanel.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                GeomImgPanel.this.geomImgPanel.setCursor(Cursor.getPredefinedCursor(13));
            }
            this.firstXCoord = mouseEvent.getX();
            this.firstYCoord = mouseEvent.getY();
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(this, this.firstXCoord, this.firstYCoord);
                GeomImgPanel.this.mapPanelMouseClicked(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && GeomImgPanel.this.isMarqueeZoomState()) {
                Rectangle rectangle = this.getMarqueeRectangle();
                GeomImgPanel.this.setMarqueeZoomedImage(rectangle);
            }
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(this, this.firstXCoord, this.firstYCoord);
                GeomImgPanel.this.mapPanelMouseClicked(mouseEvent);
            }
            GeomImgPanel.this.geomImgPanel.setCursor(Cursor.getPredefinedCursor(0));
            GeomImgPanel.this.setState(5);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        protected Rectangle getMarqueeRectangle() {
            int n;
            int n2 = this.endXCoord - this.firstXCoord;
            int n3 = this.endYCoord - this.firstYCoord;
            int n4 = this.firstXCoord;
            int n5 = this.firstYCoord;
            int n6 = this.endXCoord;
            int n7 = this.endYCoord;
            if (n2 <= 0) {
                n2 = 0 - n2;
                n = n6;
                n6 = n4;
                n4 = n;
            }
            if (n3 <= 0) {
                n3 = 0 - n3;
                n = n7;
                n7 = n5;
                n5 = n;
            }
            Rectangle rectangle = new Rectangle(n4, n5, n2, n3);
            return rectangle;
        }

        protected Rectangle getDragRectangle() {
            int n;
            int n2;
            int n3 = this.endXCoord - this.firstXCoord;
            int n4 = this.endYCoord - this.firstYCoord;
            int n5 = 0;
            int n6 = 0;
            int n7 = GeomImgPanel.this.scrollableMap.getImageWidth();
            int n8 = GeomImgPanel.this.scrollableMap.getImageHeight();
            Rectangle rectangle = GeomImgPanel.this.scrollableMap.getVisibleRect();
            n5 = rectangle.x;
            n7 = rectangle.x + (int)rectangle.getWidth();
            n6 = rectangle.y;
            n8 = rectangle.y + (int)rectangle.getHeight();
            int n9 = Math.abs(n3);
            int n10 = Math.abs(n4);
            if (n9 <= 0) {
                n9 = 1;
            }
            if (n10 <= 0) {
                n10 = 1;
            }
            if (n9 > n7) {
                n9 = n7;
            }
            if (n10 > n8) {
                n10 = n8;
            }
            if (n3 < 0) {
                n3 = n7 - this.firstXCoord + n9;
                n2 = this.firstXCoord;
                if (n2 < 0) {
                    n2 = 0;
                }
            } else {
                n3 = this.firstXCoord - n5;
                n2 = n5 - n9;
                if (n2 < 0) {
                    n2 = 0;
                }
            }
            if (n4 < 0) {
                n4 = n8 - this.firstYCoord + n10;
                n = this.firstYCoord;
                if (n < 0) {
                    n = 0;
                }
            } else {
                n4 = this.firstYCoord - n6;
                n = n6 - n10;
                if (n < 0) {
                    n = 0;
                }
            }
            Rectangle rectangle2 = new Rectangle(n2, n, n3, n4);
            return rectangle2;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.mapImage != null && GeomImgPanel.this.isMarqueeZoomState()) {
                Rectangle rectangle = this.getMarqueeRectangle();
                int n = (int)rectangle.getWidth();
                int n2 = (int)rectangle.getHeight();
                int n3 = (int)rectangle.getX();
                int n4 = (int)rectangle.getY();
                graphics.drawRect(n3, n4, n, n2);
                graphics.setColor(new Color(0.5f, 0.5f, 0.5f, 0.2f));
                graphics.fillRect(n3, n4, n, n2);
            }
            graphics.dispose();
        }
    }

    class GeomInfo {
        int map = 0;
        int index = 0;
        double area = 0.0;

        public GeomInfo(int n, int n2, double d) {
            this.map = n;
            this.index = n2;
            this.area = d;
        }

        public int getMapNumber() {
            return this.map;
        }

        public int getMapIndex() {
            return this.index;
        }

        public double getGeomArea() {
            return this.area;
        }

        public void print() {
            System.out.println("Map#=" + this.map + ", Index=" + this.index + ", area=" + this.area);
        }
    }
}

