/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LayoutStyle;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.spatial.SpatialArb;
import oracle.ide.Ide;
import oracle.ide.util.IdeUtil;

public class MapViewerColorDialog
extends JDialog {
    Color newColorChoice;
    Color oldColorChoice;
    private JColorChooser ColorChooser;
    private JButton cancelButton;
    private JButton okButton;

    public MapViewerColorDialog(Frame frame, boolean bl, Color color) {
        super(frame, bl);
        this.oldColorChoice = color;
        this.initComponents();
        this.setTitle(SpatialArb.getString("MapViewerColorDialogTitle"));
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this);
    }

    private void initComponents() {
        this.ColorChooser = new JColorChooser(this.oldColorChoice);
        this.okButton = new JButton();
        this.okButton.setName("OkButtonColorDialogMapViewer");
        this.cancelButton = new JButton();
        this.cancelButton.setName("CancelButtonColorDialogMapViewer");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                MapViewerColorDialog.this.formWindowClosed(windowEvent);
            }
        });
        this.okButton.setText(StringUtils.stripMnemonic((String)SpatialArb.getString("MapViewerColorDialogOK")));
        this.okButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("MapViewerColorDialogOK")));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapViewerColorDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setText(StringUtils.stripMnemonic((String)SpatialArb.getString("MapViewerColorDialogCancel")));
        this.cancelButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("MapViewerColorDialogCancel")));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapViewerColorDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ColorChooser, -2, -1, -2).addGroup(groupLayout.createSequentialGroup().addGap(76, 76, 76).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 177, Short.MAX_VALUE).addComponent(this.cancelButton).addGap(64, 64, 64)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.ColorChooser, -2, -1, -2).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(13, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowClosed(WindowEvent windowEvent) {
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.newColorChoice = this.ColorChooser.getColor();
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.newColorChoice = this.oldColorChoice;
        this.dispose();
    }

    public Color getSelectedColor() {
        return this.newColorChoice;
    }

    public Color getSelectedTranslucentColor() {
        this.newColorChoice.getRed();
        this.newColorChoice.getGreen();
        this.newColorChoice.getBlue();
        Color color = new Color(this.newColorChoice.getRed(), this.newColorChoice.getGreen(), this.newColorChoice.getBlue(), 128);
        return color;
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapViewerColorDialog mapViewerColorDialog = new MapViewerColorDialog((Frame)new JFrame(), true, Color.blue);
                mapViewerColorDialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                mapViewerColorDialog.setVisible(true);
            }
        });
    }
}

