/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer.components;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import oracle.dbtools.spatial.mapviewer.components.AnnotatedGeometry;
import oracle.dbtools.spatial.mapviewer.components.MapGeometry;
import oracle.dbtools.spatial.mapviewer.components.MapViewerGeometryResultSet;
import oracle.sdovis.XFViewPort;
import oracle.sdovis.style.StyleColor;
import oracle.spatial.geometry.JGeometry;

public class MapViewerRenderer {
    private Color sColor = null;
    private Color fColor = null;
    private final Color DEFAULT_STYLE_COLOR = new Color(112, 112, 89);
    private final Color DEFAULT_FILL_COLOR = new Color(248, 249, 204);
    private final Color DEFAULT_BG_COLOR = new Color(153, 204, 255);
    private Color backgroundColor;
    private int mapWidth = 0;
    private int mapHeight = 0;
    private int defaultMapWidth = 500;
    private int defaultMapHeight = 500;
    private MapViewerGeometryResultSet mvgrs = null;
    private Point hiLiteCoordinates = null;
    private final boolean DEBUG = false;

    public MapViewerRenderer(MapViewerGeometryResultSet mapViewerGeometryResultSet) {
        this.mvgrs = mapViewerGeometryResultSet;
        this.mapWidth = 500;
        this.mapHeight = 500;
    }

    public MapViewerRenderer(Color color, MapViewerGeometryResultSet mapViewerGeometryResultSet) {
        this.mvgrs = mapViewerGeometryResultSet;
        this.mapWidth = 500;
        this.mapHeight = 500;
        this.backgroundColor = color;
    }

    public void setStyleColor(Color color) {
        this.sColor = color;
    }

    public void setFillColor(Color color) {
        this.fColor = color;
    }

    public Color getStyleColor() {
        if (this.sColor == null) {
            return this.DEFAULT_STYLE_COLOR;
        }
        return this.sColor;
    }

    public Color getFillColor() {
        if (this.fColor == null) {
            return this.DEFAULT_FILL_COLOR;
        }
        return this.fColor;
    }

    public Color getDefaultStyleColor() {
        return this.DEFAULT_STYLE_COLOR;
    }

    public Color getDefaultFillColor() {
        return this.DEFAULT_FILL_COLOR;
    }

    public void setHiLiteCoordinates(Point point) {
        this.hiLiteCoordinates = point;
    }

    public Point getHiLiteCoordinates() {
        return this.hiLiteCoordinates;
    }

    public Point getZoomedHiLiteCoordinates(int n) {
        if (n <= 1) {
            return this.getHiLiteCoordinates();
        }
        return new Point(n * this.getHiLiteCoordinates().x, n * this.getHiLiteCoordinates().y);
    }

    public void setMapWidth(int n) {
        this.mapWidth = n;
    }

    public void setMapHeight(int n) {
        this.mapHeight = n;
    }

    public int getMapWidth() {
        if (this.mapWidth < this.defaultMapHeight) {
            this.mapWidth = this.defaultMapWidth;
        }
        return this.mapWidth;
    }

    public int getMapHeight() {
        if (this.mapHeight < this.defaultMapHeight) {
            this.mapHeight = this.defaultMapHeight;
        }
        return this.mapHeight;
    }

    public ImageIcon generateGeometryIcon(JGeometry jGeometry) {
        int n = this.getMapWidth();
        int n2 = this.getMapHeight();
        return this.generateGeometryIcon(jGeometry, n, n2);
    }

    private ImageIcon generateGeometryIcon(JGeometry jGeometry, int n, int n2) {
        StyleColor styleColor = new StyleColor(this.getFillColor(), this.getStyleColor());
        if (styleColor == null || jGeometry == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        if (this.backgroundColor == null) {
            graphics2D.setColor(this.DEFAULT_BG_COLOR);
        } else {
            graphics2D.setColor(this.backgroundColor);
        }
        graphics2D.fillRect(0, 0, n, n2);
        XFViewPort xFViewPort = new XFViewPort();
        xFViewPort.setDeviceView((Rectangle2D)new Rectangle2D.Double(2.0, 2.0, n, n2));
        double[] dArray = jGeometry.getMBR();
        double d = dArray[2] - dArray[0];
        double d2 = dArray[3] - dArray[1];
        xFViewPort.setStrict(true);
        xFViewPort.setDataView((Rectangle2D)new Rectangle2D.Double(dArray[0], dArray[1], d, d2));
        AffineTransform affineTransform = xFViewPort.getAffineTransform();
        Shape shape = jGeometry.createShape(affineTransform, true);
        try {
            styleColor.apply(null, graphics2D, shape, jGeometry.getType(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics2D.dispose();
        jGeometry = null;
        return new ImageIcon(bufferedImage);
    }

    public Image getEmptyImage(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.setColor(new Color(64, 64, 64));
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public Image getImage(ImageIcon imageIcon) {
        return imageIcon.getImage();
    }

    public Image getImage(JGeometry jGeometry) {
        ImageIcon imageIcon = this.generateGeometryIcon(jGeometry);
        Image image = this.getImage(imageIcon);
        return image;
    }

    public Image getImage(JGeometry jGeometry, int n, int n2) {
        ImageIcon imageIcon = this.generateGeometryIcon(jGeometry, n, n2);
        Image image = this.getImage(imageIcon);
        return image;
    }

    public Image getHighLightedImage(MapGeometry[] mapGeometryArray, MapGeometry mapGeometry, int n, int n2) {
        ImageIcon imageIcon = this.generatetHighLightedImageMapGeometryIcon(mapGeometryArray, mapGeometry, n, n2);
        Image image = this.getImage(imageIcon);
        return image;
    }

    public ImageIcon generatetHighLightedImageMapGeometryIcon(MapGeometry[] mapGeometryArray, MapGeometry mapGeometry, int n, int n2) {
        Object object;
        Object object2;
        Object object3;
        Color color;
        Object object4;
        int n3;
        Object[] objectArray2;
        double[] dArray = new double[4];
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        if (this.backgroundColor == null) {
            graphics2D.setColor(this.DEFAULT_BG_COLOR);
        } else {
            graphics2D.setColor(this.backgroundColor);
        }
        graphics2D.fillRect(0, 0, n, n2);
        Vector<AnnotatedGeometry> vector = new Vector<AnnotatedGeometry>();
        for (int i = 0; i < mapGeometryArray.length; ++i) {
            objectArray2 = mapGeometryArray[i].getGeometries();
            for (int j = 0; j < objectArray2.length; ++j) {
                vector.add(objectArray2[j]);
            }
        }
        Object[] objectArray3 = new AnnotatedGeometry[vector.size()];
        vector.copyInto(objectArray3);
        objectArray2 = new double[objectArray3.length];
        double[] dArray2 = new double[objectArray3.length];
        double[] dArray3 = new double[objectArray3.length];
        double[] dArray4 = new double[objectArray3.length];
        for (int i = 0; i < objectArray3.length; ++i) {
            double[] dArray5 = ((AnnotatedGeometry)objectArray3[i]).getGeometry().getMBR();
            objectArray2[i] = (AnnotatedGeometry)dArray5[0];
            dArray2[i] = dArray5[1];
            dArray3[i] = dArray5[2];
            dArray4[i] = dArray5[3];
        }
        Arrays.sort((double[])objectArray2);
        dArray[0] = (double)objectArray2[0];
        Arrays.sort(dArray2);
        dArray[1] = dArray2[0];
        Arrays.sort(dArray3);
        dArray[2] = dArray3[objectArray3.length - 1];
        Arrays.sort(dArray4);
        dArray[3] = dArray4[objectArray3.length - 1];
        double d = dArray[2] - dArray[0];
        double d2 = dArray[3] - dArray[1];
        if (d > d2) {
            n3 = n2;
            n2 = (int)(d2 / d * (double)n);
        } else {
            n3 = n;
            n = (int)(d / d2 * (double)n2);
        }
        if (n < 10 && n <= n2) {
            n = 10;
            n2 = (int)(d2 / d * (double)n);
        } else if (n2 < 10 && n2 <= n) {
            n2 = 10;
            n = (int)(d / d2 * (double)n2);
        }
        XFViewPort xFViewPort = new XFViewPort();
        xFViewPort.setDeviceView((Rectangle2D)new Rectangle2D.Double(2.0, 2.0, n, n2));
        xFViewPort.setStrict(true);
        xFViewPort.setDataView((Rectangle2D)new Rectangle2D.Double(dArray[0], dArray[1], d, d2));
        AffineTransform affineTransform = xFViewPort.getAffineTransform();
        Shape shape = null;
        for (int i = 0; i < mapGeometryArray.length; ++i) {
            object4 = mapGeometryArray[i].getGeometries();
            this.setStyleColor(mapGeometryArray[i].getLineColor());
            this.setFillColor(mapGeometryArray[i].getFillColor());
            color = new StyleColor(this.getFillColor(), this.getStyleColor());
            object3 = mapGeometryArray[i].getAnnotationColumn().trim();
            for (int j = 0; j < ((Object)object4).length; ++j) {
                if (((AnnotatedGeometry)object4[j]).getGeometry().getType() == 1) {
                    object2 = ((AnnotatedGeometry)object4[j]).getGeometry().getPoint();
                    object = new Ellipse2D.Double((double)object2[0], (double)object2[1], 0.1f, 0.1f);
                    shape = affineTransform.createTransformedShape((Shape)object);
                } else {
                    shape = ((AnnotatedGeometry)object4[j]).getGeometry().createShape(affineTransform, true);
                }
                try {
                    String[] stringArray;
                    color.apply(null, graphics2D, shape, ((AnnotatedGeometry)object4[j]).getGeometry().getType(), null);
                    if (object3 == null || ((String)object3).length() <= 0) continue;
                    object2 = "";
                    object = "";
                    for (String string : stringArray = ((AnnotatedGeometry)object4[j]).getAnnotations()) {
                        if (!string.startsWith((String)object3)) continue;
                        int n4 = ((String)object3).length();
                        object = string.substring(n4 + 1);
                    }
                    if (object != null && ((String)object).length() > 0) {
                        object2 = object;
                    }
                    if (((String)object2).length() <= 0) continue;
                    double[] dArray5 = this.getShapeCenter(((AnnotatedGeometry)object4[j]).getGeometry().getMBR());
                    Ellipse2D.Double double_ = new Ellipse2D.Double(dArray5[0], dArray5[1], 0.1f, 0.1f);
                    shape = affineTransform.createTransformedShape(double_);
                    graphics2D.drawString((String)object2, shape.getBounds().x, shape.getBounds().y);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
        AnnotatedGeometry[] annotatedGeometryArray = mapGeometry.getGeometries();
        object4 = mapGeometry.getLineColor();
        color = new Color(((Color)object4).getRed(), ((Color)object4).getGreen(), ((Color)object4).getBlue(), 128);
        object3 = mapGeometry.getFillColor();
        Color color2 = new Color(((Color)object3).getRed(), ((Color)object3).getGreen(), ((Color)object3).getBlue(), 128);
        this.setStyleColor(color);
        this.setFillColor(color2);
        object2 = new Color(1.0f, 1.0f, 0.0f, 0.5f);
        object = new StyleColor((Color)object2, Color.darkGray);
        for (int i = 0; i < annotatedGeometryArray.length; ++i) {
            if (annotatedGeometryArray[i].getGeometry().getType() == 1) {
                double[] dArray6 = annotatedGeometryArray[i].getGeometry().getPoint();
                Ellipse2D.Double double_ = new Ellipse2D.Double(dArray6[0], dArray6[1], 0.1f, 0.1f);
                shape = affineTransform.createTransformedShape(double_);
            } else {
                shape = annotatedGeometryArray[i].getGeometry().createShape(affineTransform, true);
            }
            try {
                object.apply(null, graphics2D, shape, annotatedGeometryArray[i].getGeometry().getType(), null);
                this.setHiLiteCoordinates(this.getShapeCenter(shape));
                continue;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        shape = null;
        vector = null;
        mapGeometryArray = null;
        mapGeometry = null;
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    /*
     * WARNING - void declaration
     */
    public Image generateClippedImage(MapGeometry[] mapGeometryArray, int n, int n2, double[] dArray, MapGeometry mapGeometry) {
        Object object;
        String[] stringArray;
        Color color;
        Object object2;
        Object object3;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        n = ((Image)bufferedImage).getWidth(null);
        n2 = ((Image)bufferedImage).getHeight(null);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        if (this.backgroundColor == null) {
            graphics2D.setColor(this.DEFAULT_BG_COLOR);
        } else {
            graphics2D.setColor(this.backgroundColor);
        }
        graphics2D.fillRect(0, 0, n, n2);
        XFViewPort xFViewPort = new XFViewPort();
        xFViewPort.setDeviceView((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, n, n2));
        xFViewPort.setStrict(true);
        Vector<AnnotatedGeometry> vector = new Vector<AnnotatedGeometry>();
        for (int i = 0; i < mapGeometryArray.length; ++i) {
            AnnotatedGeometry[] annotatedGeometryArray = mapGeometryArray[i].getGeometries();
            for (int j = 0; j < annotatedGeometryArray.length; ++j) {
                vector.add(annotatedGeometryArray[j]);
            }
        }
        Object[] objectArray = new AnnotatedGeometry[vector.size()];
        vector.copyInto(objectArray);
        double d = dArray[2] - dArray[0];
        double d2 = dArray[3] - dArray[1];
        xFViewPort.setDataView((Rectangle2D)new Rectangle2D.Double(dArray[0], dArray[1], d, d2));
        AffineTransform affineTransform = xFViewPort.getAffineTransform();
        Shape shape = null;
        for (int i = 0; i < mapGeometryArray.length; ++i) {
            object3 = mapGeometryArray[i].getGeometries();
            this.setStyleColor(mapGeometryArray[i].getLineColor());
            this.setFillColor(mapGeometryArray[i].getFillColor());
            object2 = mapGeometryArray[i].getAnnotationColumn().trim();
            color = new StyleColor(this.getFillColor(), this.getStyleColor());
            for (int j = 0; j < ((Object)object3).length; ++j) {
                if (((AnnotatedGeometry)object3[j]).getGeometry().getType() == 1) {
                    stringArray = (String[])((AnnotatedGeometry)object3[j]).getGeometry().getPoint();
                    object = new Ellipse2D.Double((double)stringArray[0], (double)stringArray[1], 0.1f, 0.1f);
                    shape = affineTransform.createTransformedShape((Shape)object);
                } else {
                    shape = ((AnnotatedGeometry)object3[j]).getGeometry().createShape(affineTransform, true);
                }
                try {
                    color.apply(null, graphics2D, shape, ((AnnotatedGeometry)object3[j]).getGeometry().getType(), null);
                    if (object2 == null || ((String)object2).length() <= 0) continue;
                    stringArray = ((AnnotatedGeometry)object3[j]).getAnnotations();
                    object = "";
                    for (String string : stringArray) {
                        if (!string.startsWith((String)object2)) continue;
                        String[] stringArray2 = string.split("=");
                        object = stringArray2[stringArray2.length - 1].trim();
                        break;
                    }
                    if (((String)object).length() <= 0) continue;
                    double[] dArray2 = this.getShapeCenter(((AnnotatedGeometry)object3[j]).getGeometry().getMBR());
                    Ellipse2D.Double double_ = new Ellipse2D.Double(dArray2[0], dArray2[1], 0.1f, 0.1f);
                    shape = affineTransform.createTransformedShape(double_);
                    graphics2D.drawString((String)object, shape.getBounds().x, shape.getBounds().y);
                    continue;
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
        if (mapGeometry != null) {
            void var24_32;
            AnnotatedGeometry[] annotatedGeometryArray = mapGeometry.getGeometries();
            object3 = mapGeometry.getLineColor();
            object2 = new Color(((Color)object3).getRed(), ((Color)object3).getGreen(), ((Color)object3).getBlue(), 128);
            color = mapGeometry.getFillColor();
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
            this.setStyleColor((Color)object2);
            this.setFillColor(color2);
            stringArray = new Color(1.0f, 1.0f, 0.0f, 0.5f);
            object = new StyleColor((Color)stringArray, Color.darkGray);
            boolean bl = false;
            while (var24_32 < annotatedGeometryArray.length) {
                if (annotatedGeometryArray[var24_32].getGeometry().getType() == 1) {
                    double[] dArray3 = annotatedGeometryArray[var24_32].getGeometry().getPoint();
                    Ellipse2D.Double double_ = new Ellipse2D.Double(dArray3[0], dArray3[1], 0.1f, 0.1f);
                    shape = affineTransform.createTransformedShape(double_);
                } else {
                    shape = annotatedGeometryArray[var24_32].getGeometry().createShape(affineTransform, true);
                }
                try {
                    object.apply(null, graphics2D, shape, annotatedGeometryArray[var24_32].getGeometry().getType(), null);
                    this.setHiLiteCoordinates(this.getShapeCenter(shape));
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                ++var24_32;
            }
        }
        shape = null;
        mapGeometry = null;
        vector = null;
        mapGeometryArray = null;
        graphics2D.dispose();
        return bufferedImage;
    }

    private double[] getShapeCenter(double[] dArray) {
        double[] dArray2 = new double[]{(dArray[0] + dArray[2]) / 2.0, (dArray[1] + dArray[3]) / 2.0};
        return dArray2;
    }

    private Point getShapeCenter(Shape shape) {
        Point point = new Point((int)shape.getBounds().getCenterX(), (int)shape.getBounds().getCenterY());
        return point;
    }

    public Image getImage2(MapGeometry[] mapGeometryArray, int n, int n2) {
        Arrays.sort(mapGeometryArray);
        double[] dArray = this.getFlattenMapMBR(mapGeometryArray);
        ImageIcon imageIcon = this.createFlattenMapImageIcon(mapGeometryArray, n, n2, dArray);
        if (imageIcon == null) {
            return null;
        }
        Image image = this.getImage(imageIcon);
        return image;
    }

    public double[] getFlattenMapMBR(MapGeometry[] mapGeometryArray) {
        Object[] objectArray;
        double[] dArray = new double[4];
        Vector<AnnotatedGeometry> vector = new Vector<AnnotatedGeometry>();
        for (int i = 0; i < mapGeometryArray.length; ++i) {
            objectArray = mapGeometryArray[i].getGeometries();
            for (int j = 0; j < objectArray.length; ++j) {
                vector.add(objectArray[j]);
            }
        }
        Object[] objectArray2 = new AnnotatedGeometry[vector.size()];
        vector.copyInto(objectArray2);
        objectArray = new double[objectArray2.length];
        double[] dArray2 = new double[objectArray2.length];
        double[] dArray3 = new double[objectArray2.length];
        double[] dArray4 = new double[objectArray2.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            double[] dArray5 = ((AnnotatedGeometry)objectArray2[i]).getGeometry().getMBR();
            objectArray[i] = (AnnotatedGeometry)dArray5[0];
            dArray2[i] = dArray5[1];
            dArray3[i] = dArray5[2];
            dArray4[i] = dArray5[3];
        }
        Arrays.sort((double[])objectArray);
        dArray[0] = (double)objectArray[0];
        Arrays.sort(dArray2);
        dArray[1] = dArray2[0];
        Arrays.sort(dArray3);
        dArray[2] = dArray3[objectArray2.length - 1];
        Arrays.sort(dArray4);
        dArray[3] = dArray4[objectArray2.length - 1];
        vector = null;
        return dArray;
    }

    public ImageIcon createFlattenMapImageIcon(MapGeometry[] mapGeometryArray, int n, int n2, double[] dArray) {
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = dArray[2] - dArray[0];
        double d4 = dArray[3] - dArray[1];
        if (d3 > d4) {
            n3 = (int)(d4 / d3 * (double)n);
            d = n3;
            d2 = n;
        } else {
            d = n2;
            n4 = (int)(d3 / d4 * (double)n2);
            d2 = n4;
        }
        n2 = (int)d;
        n = (int)d2;
        if (n < 10 && n <= n2) {
            n = 10;
            n2 = (int)(d4 / d3 * (double)n);
        } else if (n2 < 10 && n2 <= n) {
            n2 = 10;
            n = (int)(d3 / d4 * (double)n2);
        }
        XFViewPort xFViewPort = new XFViewPort();
        xFViewPort.setDeviceView((Rectangle2D)new Rectangle2D.Double(2.0, 2.0, n, n2));
        xFViewPort.setStrict(true);
        xFViewPort.setDataView((Rectangle2D)new Rectangle2D.Double(dArray[0], dArray[1], d3, d4));
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = new BufferedImage(n, n2, 1);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, outOfMemoryError.getStackTrace()[0].toString(), outOfMemoryError);
            return null;
        }
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        if (this.backgroundColor == null) {
            graphics2D.setColor(this.DEFAULT_BG_COLOR);
        } else {
            graphics2D.setColor(this.backgroundColor);
        }
        graphics2D.fillRect(0, 0, n, n2);
        AffineTransform affineTransform = xFViewPort.getAffineTransform();
        Shape shape = null;
        for (int i = 0; i < mapGeometryArray.length; ++i) {
            AnnotatedGeometry[] annotatedGeometryArray = mapGeometryArray[i].getGeometries();
            this.setStyleColor(mapGeometryArray[i].getLineColor());
            this.setFillColor(mapGeometryArray[i].getFillColor());
            String string = mapGeometryArray[i].getAnnotationColumn().trim();
            StyleColor styleColor = new StyleColor(this.getFillColor(), this.getStyleColor());
            for (int j = 0; j < annotatedGeometryArray.length; ++j) {
                Object object;
                Object[] objectArray;
                int n5 = annotatedGeometryArray[j].getGeometry().getType();
                if (n5 == 1) {
                    objectArray = annotatedGeometryArray[j].getGeometry().getPoint();
                    object = new Ellipse2D.Double(objectArray[0], objectArray[1], 0.1f, 0.1f);
                    shape = affineTransform.createTransformedShape((Shape)object);
                } else {
                    shape = annotatedGeometryArray[j].getGeometry().createShape(affineTransform, true);
                }
                try {
                    styleColor.apply(null, graphics2D, shape, n5, null);
                    if (string == null || string.length() <= 0) continue;
                    objectArray = annotatedGeometryArray[j].getAnnotations();
                    object = "";
                    for (double d5 : objectArray) {
                        if (!d5.startsWith(string)) continue;
                        String[] stringArray = d5.split("=");
                        object = stringArray[1].trim();
                        break;
                    }
                    if (((String)object).length() <= 0) continue;
                    double[] dArray2 = this.getShapeCenter(annotatedGeometryArray[j].getGeometry().getMBR());
                    Ellipse2D.Double double_ = new Ellipse2D.Double(dArray2[0], dArray2[1], 0.1f, 0.1f);
                    shape = affineTransform.createTransformedShape(double_);
                    graphics2D.drawString((String)object, shape.getBounds().x, shape.getBounds().y);
                    continue;
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
        shape = null;
        mapGeometryArray = null;
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }
}

