/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.persistence;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.ide.ExtensionRegistry;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QueryHistoryManager {
    private static File xmlFile;
    private static boolean initialized;
    private static DocumentBuilderFactory docFactory;
    private static DocumentBuilder docBuilder;
    private static Document actualDoc;
    private static TransformerFactory transformerFactory;
    private static Transformer transformer;
    private static DOMSource source;
    private static StreamResult result;
    private boolean isEnabled;

    public QueryHistoryManager() {
        this.startup();
    }

    public String getFilename() {
        return xmlFile.getName();
    }

    public boolean titleExists(QueryObject queryObject) {
        Node node = this.getTitledNode(queryObject);
        return node != null;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public synchronized boolean addRecord(QueryObject queryObject) {
        if (docFactory == null || docBuilder == null || actualDoc == null) {
            return false;
        }
        Node node = this.getTitledNode(queryObject);
        if (node != null) {
            return false;
        }
        Node node2 = actualDoc.getFirstChild();
        Element element = actualDoc.createElement("queryRecord");
        Attr attr = actualDoc.createAttribute("tabid");
        attr.setValue(queryObject.getTabIdentifier());
        element.setAttributeNode(attr);
        Attr attr2 = actualDoc.createAttribute("titleid");
        attr2.setValue(queryObject.getQueryTitle());
        element.setAttributeNode(attr2);
        Element element2 = actualDoc.createElement("selected");
        if (queryObject.isPreselected()) {
            element2.appendChild(actualDoc.createTextNode("TRUE"));
        } else {
            element2.appendChild(actualDoc.createTextNode("FALSE"));
        }
        Element element3 = actualDoc.createElement("connection");
        element3.appendChild(actualDoc.createTextNode(queryObject.getConnectionSourceName()));
        Element element4 = actualDoc.createElement("sql");
        element4.appendChild(actualDoc.createTextNode(queryObject.getQueryText()));
        Element element5 = actualDoc.createElement("srid");
        element5.appendChild(actualDoc.createTextNode(Integer.toString(queryObject.getSRID())));
        Element element6 = actualDoc.createElement("linecolor");
        element6.appendChild(actualDoc.createTextNode(Integer.toString(queryObject.getLineColor().getRGB())));
        Element element7 = actualDoc.createElement("fillcolor");
        element7.appendChild(actualDoc.createTextNode(Integer.toString(queryObject.getFillColor().getRGB())));
        Element element8 = actualDoc.createElement("annotation");
        element8.appendChild(actualDoc.createTextNode(queryObject.getAnnotatedColumn()));
        Element element9 = actualDoc.createElement("layer");
        element9.appendChild(actualDoc.createTextNode(Integer.toString(queryObject.getLayerNumber())));
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element5);
        element.appendChild(element4);
        element.appendChild(element6);
        element.appendChild(element8);
        element.appendChild(element7);
        element.appendChild(element9);
        node2.appendChild(element);
        this.writeToFile();
        return true;
    }

    public void editRecord(QueryObject queryObject) {
        Node node = this.getTitledNode(queryObject);
        if (queryObject.getNewTitle() != null && queryObject.getNewTitle().length() > 0) {
            queryObject.setQueryTitle(queryObject.getNewTitle());
            queryObject.setNewTitle(null);
        }
        if (node != null) {
            this.setRecordValues(queryObject, node);
        }
    }

    public void deleteRecord(QueryObject queryObject) {
        Node node = this.getTitledNode(queryObject);
        if (node != null) {
            Node node2 = actualDoc.getFirstChild();
            node2.removeChild(node);
            this.writeToFile();
        }
    }

    public void deleteAllTabRecords(String string) {
        Object object;
        List<Node> list = this.getAllQueryRecordNodes(string);
        if (list != null) {
            object = actualDoc.getFirstChild();
            for (Node object2 : list) {
                object.removeChild(object2);
            }
        }
        if ((object = this.getAllTabRecordNodes(string)) != null) {
            Node node = actualDoc.getFirstChild();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                node.removeChild(node2);
            }
        }
        this.writeToFile();
    }

    private void setRecordValues(QueryObject queryObject, Node node) {
        NodeList nodeList = node.getChildNodes();
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("titleid");
        node2.setTextContent(queryObject.getQueryTitle());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            String string = node3.getNodeName();
            if (string.equals("selected")) {
                if (queryObject.isPreselected()) {
                    node3.setTextContent("TRUE");
                } else {
                    node3.setTextContent("FALSE");
                }
            }
            if (string.equals("connection")) {
                node3.setTextContent(queryObject.getConnectionSourceName());
            }
            if (string.equals("sql")) {
                node3.setTextContent(queryObject.getQueryText());
            }
            if (string.equals("srid")) {
                node3.setTextContent(Integer.toString(queryObject.getSRID()));
            }
            if (string.equals("linecolor")) {
                node3.setTextContent(Integer.toString(queryObject.getLineColor().getRGB()));
            }
            if (string.equals("fillcolor")) {
                node3.setTextContent(Integer.toString(queryObject.getFillColor().getRGB()));
            }
            if (string.equals("annotation")) {
                if (queryObject.getAnnotatedColumn() != null && queryObject.getAnnotatedColumn().length() > 0) {
                    node3.setTextContent(queryObject.getAnnotatedColumn());
                } else {
                    NodeList nodeList2 = node3.getChildNodes();
                    if (nodeList2 != null && nodeList2.getLength() > 0) {
                        int n = 0;
                        while (i < nodeList2.getLength()) {
                            node3.removeChild(nodeList2.item(n));
                            ++i;
                        }
                    }
                    node3.setTextContent("*NULL");
                }
            }
            if (!string.equals("layer")) continue;
            node3.setTextContent(Integer.toString(queryObject.getLayerNumber()));
        }
        this.writeToFile();
    }

    private synchronized Node getTitledNode(QueryObject queryObject) {
        NodeList nodeList = actualDoc.getElementsByTagName("queryRecord");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = namedNodeMap.getNamedItem("tabid").getTextContent();
            String string2 = namedNodeMap.getNamedItem("titleid").getTextContent();
            String string3 = queryObject.getTabIdentifier();
            String string4 = queryObject.getQueryTitle();
            String string5 = queryObject.getConnectionSourceName();
            NodeList nodeList2 = node.getChildNodes();
            boolean bl = false;
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                if (!node2.getNodeName().equals("connection") || !node2.getTextContent().equals(string5)) continue;
                bl = true;
                break;
            }
            if (!string3.equals(string) || !string4.equals(string2) || !bl) continue;
            return node;
        }
        return null;
    }

    public void toggleActiveConnectionInTab(String string, String string2) {
        Node[] nodeArray;
        Object object;
        Object object2;
        Node[] nodeArray2 = this.getDistinctConnectionTabs(string, string2);
        if (nodeArray2 != null) {
            for (int i = 0; i < nodeArray2.length; ++i) {
                Node node = nodeArray2[i];
                object2 = node.getAttributes();
                object = object2.getNamedItem("insession");
                object.setTextContent("FALSE");
            }
            this.writeToFile();
        }
        if ((nodeArray = this.getConnectionTabs(string, string2)) != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                object2 = nodeArray[i];
                object = object2.getAttributes();
                Node node = object.getNamedItem("insession");
                node.setTextContent("TRUE");
            }
            this.writeToFile();
        } else {
            this.addTabRecord(string, string2);
        }
    }

    private Node[] getDistinctConnectionTabs(String string, String string2) {
        NodeList nodeList = actualDoc.getElementsByTagName("tabRecord");
        Node[] nodeArray = null;
        if (nodeList != null && nodeList.getLength() > 0) {
            int n;
            Node[] nodeArray2 = new Node[nodeList.getLength()];
            int n2 = 0;
            for (n = 0; n < nodeList.getLength(); ++n) {
                Node node = nodeList.item(n);
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string3 = namedNodeMap.getNamedItem("tabid").getTextContent();
                String string4 = namedNodeMap.getNamedItem("cnx").getTextContent();
                if (!string3.equals(string) || string4.equals(string2)) continue;
                nodeArray2[n2] = node;
                ++n2;
            }
            if (n2 > 0) {
                nodeArray = new Node[n2];
                for (n = 0; n < n2; ++n) {
                    nodeArray[n] = nodeArray2[n];
                }
            }
        }
        return nodeArray;
    }

    public String[] getPreviousSession() {
        NodeList nodeList = actualDoc.getElementsByTagName("tabRecord");
        String[] stringArray = null;
        String[] stringArray2 = null;
        int n = 0;
        if (nodeList != null && nodeList.getLength() > 0) {
            int n2;
            stringArray = new String[nodeList.getLength() * 2];
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                Node node = nodeList.item(n2);
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string = namedNodeMap.getNamedItem("tabid").getTextContent();
                String string2 = namedNodeMap.getNamedItem("cnx").getTextContent();
                String string3 = namedNodeMap.getNamedItem("insession").getTextContent();
                if (!string3.equals("TRUE")) continue;
                stringArray[n] = string;
                stringArray[++n] = string2;
                ++n;
            }
            if (n > 0) {
                stringArray2 = new String[n];
                for (n2 = 0; n2 < n; ++n2) {
                    stringArray2[n2] = stringArray[n2];
                }
            }
        } else {
            return new String[0];
        }
        return stringArray2;
    }

    private Node[] getConnectionTabs(String string, String string2) {
        NodeList nodeList = actualDoc.getElementsByTagName("tabRecord");
        Node[] nodeArray = null;
        if (nodeList != null && nodeList.getLength() > 0) {
            int n;
            Node[] nodeArray2 = new Node[nodeList.getLength()];
            int n2 = 0;
            for (n = 0; n < nodeList.getLength(); ++n) {
                Node node = nodeList.item(n);
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string3 = namedNodeMap.getNamedItem("tabid").getTextContent();
                String string4 = namedNodeMap.getNamedItem("cnx").getTextContent();
                if (!string3.equals(string) || !string4.equals(string2)) continue;
                nodeArray2[n2] = node;
                ++n2;
            }
            if (n2 > 0) {
                nodeArray = new Node[n2];
                for (n = 0; n < n2; ++n) {
                    nodeArray[n] = nodeArray2[n];
                }
            }
        }
        return nodeArray;
    }

    public void addTabRecord(String string, String string2) {
        Node[] nodeArray = this.getConnectionTabs(string, string2);
        if (nodeArray == null) {
            Node node = actualDoc.getFirstChild();
            Element element = actualDoc.createElement("tabRecord");
            Attr attr = actualDoc.createAttribute("tabid");
            attr.setValue(string);
            Attr attr2 = actualDoc.createAttribute("cnx");
            attr2.setValue(string2);
            Attr attr3 = actualDoc.createAttribute("insession");
            attr3.setValue("TRUE");
            element.setAttributeNode(attr);
            element.setAttributeNode(attr2);
            element.setAttributeNode(attr3);
            node.appendChild(element);
            this.writeToFile();
        }
    }

    private void loadDocument() {
        try {
            if (xmlFile.exists()) {
                actualDoc = docBuilder.parse(xmlFile);
            } else {
                this.createDocument();
            }
        }
        catch (SAXException sAXException) {
            this.createDocument();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private void createDocument() {
        actualDoc = docBuilder.newDocument();
        Element element = actualDoc.createElement("mapviewerhistory");
        actualDoc.appendChild(element);
        this.writeToFile();
    }

    private synchronized void writeToFile() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        try {
            transformer = transformerFactory.newTransformer();
            source = new DOMSource(actualDoc);
            result = new StreamResult(xmlFile.toURI().getPath());
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, transformerConfigurationException.getStackTrace()[0].toString(), transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, transformerException.getStackTrace()[0].toString(), transformerException);
        }
    }

    private void startup() {
        if (!initialized && xmlFile == null) {
            try {
                xmlFile = new File(ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.sqldeveloper.spatial").getFile() + "mapViewerQueryHistory.xml");
                xmlFile.createNewFile();
                xmlFile.setWritable(true);
                if (xmlFile.canWrite()) {
                    this.isEnabled = true;
                    docFactory = DocumentBuilderFactory.newInstance();
                    try {
                        docBuilder = docFactory.newDocumentBuilder();
                        this.loadDocument();
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, parserConfigurationException.getStackTrace()[0].toString(), parserConfigurationException);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, nullPointerException.getStackTrace()[0].toString(), nullPointerException);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        initialized = true;
    }

    private List<Node> getAllQueryRecordNodes(String string) {
        NodeList nodeList = actualDoc.getElementsByTagName("queryRecord");
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string2 = namedNodeMap.getNamedItem("tabid").getTextContent();
            if (!string.equals(string2)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    private List<Node> getAllTabRecordNodes(String string) {
        NodeList nodeList = actualDoc.getElementsByTagName("tabRecord");
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string2 = namedNodeMap.getNamedItem("tabid").getTextContent();
            if (!string.equals(string2)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    private Node[] getCnxAndTabNodes(String string, String string2) {
        int n;
        NodeList nodeList = actualDoc.getElementsByTagName("queryRecord");
        Node[] nodeArray = new Node[nodeList.getLength()];
        Node[] nodeArray2 = null;
        int n2 = 0;
        block0: for (n = 0; n < nodeList.getLength(); ++n) {
            Node node = nodeList.item(n);
            NamedNodeMap namedNodeMap = node.getAttributes();
            NodeList nodeList2 = node.getChildNodes();
            String string3 = namedNodeMap.getNamedItem("tabid").getTextContent();
            if (!string.equals(string3)) continue;
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node2 = nodeList2.item(i);
                if (!node2.getNodeName().equals("connection")) continue;
                String string4 = node2.getTextContent();
                if (!string2.equals(string4)) continue block0;
                nodeArray[n2] = node;
                ++n2;
                continue block0;
            }
        }
        if (n2 > 0) {
            nodeArray2 = new Node[n2];
            for (n = 0; n < n2; ++n) {
                nodeArray2[n] = nodeArray[n];
            }
        }
        return nodeArray2;
    }

    public QueryObject[] getQueryObjectsFromTab(String string, String string2) {
        QueryObject[] queryObjectArray = null;
        Node[] nodeArray = this.getCnxAndTabNodes(string, string2);
        if (nodeArray != null) {
            queryObjectArray = new QueryObject[nodeArray.length];
            int n = 0;
            for (Node node : nodeArray) {
                boolean bl = false;
                String string3 = "";
                String string4 = "";
                int n2 = -1;
                Color color = Color.darkGray;
                Color color2 = Color.lightGray;
                String string5 = "";
                int n3 = -1;
                NodeList nodeList = node.getChildNodes();
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string6 = namedNodeMap.getNamedItem("titleid").getTextContent();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string7;
                    Node node2 = nodeList.item(i);
                    String string8 = node2.getNodeName();
                    if (string8.equals("selected") && (string7 = node2.getTextContent()).equals("TRUE")) {
                        bl = true;
                    }
                    if (string8.equals("connection")) {
                        string3 = node2.getTextContent();
                    }
                    if (string8.equals("sql")) {
                        string4 = node2.getTextContent();
                    }
                    if (string8.equals("srid")) {
                        n2 = Integer.parseInt(node2.getTextContent());
                    }
                    if (string8.equals("linecolor")) {
                        color = new Color(Integer.parseInt(node2.getTextContent()));
                    }
                    if (string8.equals("fillcolor")) {
                        color2 = new Color(Integer.parseInt(node2.getTextContent()));
                    }
                    if (string8.equals("annotation") && (string5 = node2.getTextContent()).equals("*NULL")) {
                        string5 = "";
                    }
                    if (!string8.equals("layer")) continue;
                    n3 = Integer.parseInt(node2.getTextContent());
                }
                QueryObject queryObject = new QueryObject(string6, string4, color, color2, string5, n3, string);
                queryObject.setConnectionSourceName(string3);
                queryObject.setPreselected(bl);
                queryObjectArray[n] = queryObject;
                ++n;
            }
        }
        return queryObjectArray;
    }
}

