/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.tools;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JFrame;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.components.MapViewerGeometryResultSet;
import oracle.dbtools.spatial.tools.SpatialTool;
import oracle.dbtools.spatial.views.QueryEditDialog;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.icons.OracleIcons;

public class SpatialAddGeomQuery
extends SpatialTool {
    public static final String TYPE = "ADD_QUERY_LAYER";
    public static int ACTION = Ide.findOrCreateCmdID((String)"spatial_add_query_layer");

    public SpatialAddGeomQuery() {
        super(TYPE, 3);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == ACTION) {
            String string = SpatialUtil.getPanel().getSelectedTabPage().getCombobox().getCurrentConnectionName();
            if (!SpatialUtil.getPanel().getSelectedTabPage().isConnectionSet() && string != null && string.length() > 0) {
                SpatialUtil.getPanel().getSelectedTabPage().setConnectionAndReturnToTool(string, this);
                return true;
            }
            if (string == null || string.length() < 1 || string.equals("") || !SpatialUtil.getPanel().getSelectedTabPage().isConnectionSet()) {
                string = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), (String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), null, (boolean)true, (boolean)true);
                if (string != null && string.length() > 0) {
                    SpatialUtil.getPanel().getSelectedTabPage().setConnectionAndReturnToTool(string, this);
                }
                return true;
            }
            this.showNewQueryDialog();
            return true;
        }
        return false;
    }

    @Override
    public boolean isAlwaysEnabled() {
        return true;
    }

    private void showNewQueryDialog() {
        ArrayList arrayList = (ArrayList)SpatialUtil.getTableModel().getRowList();
        QueryEditDialog queryEditDialog = new QueryEditDialog((Frame)new JFrame(), true, arrayList);
        queryEditDialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        queryEditDialog.setVisible(true);
        String string = queryEditDialog.getQueryTitle();
        String string2 = queryEditDialog.getQueryText();
        String string3 = queryEditDialog.getAnnotatedColumnName();
        Color color = queryEditDialog.getFillColor();
        Color color2 = queryEditDialog.getLineColor();
        MapViewerGeometryResultSet mapViewerGeometryResultSet = SpatialUtil.getTableModel().getMapViewerResultSet();
        boolean bl = mapViewerGeometryResultSet.isValidSpatialQuery(string2.trim());
        if (string.length() > 0 && string2.length() > 0 && bl) {
            String[] stringArray = new String[]{};
            QueryObject queryObject = new QueryObject(string, string2, color2, color, string3, stringArray);
            queryObject.setNewlyCreated();
            queryObject.setConnectionSourceName(SpatialUtil.getPanel().getSelectedTabPage().getCurrentConnectionName());
            queryObject.setTabIdentifier(SpatialUtil.getTableModel().getIdentifier().toString());
            SpatialUtil.getPanel().getSelectedTabPage().setConnectionAndInsertQuery(queryObject, queryObject.getConnectionSourceName(), Boolean.FALSE);
        }
    }

    @Override
    public IdeAction getAction() {
        if (this._action == null) {
            this._action = IdeAction.get((int)ACTION, null, (String)SpatialArb.getString("SPATIAL_ADD_GEOMETRY_LABEL"), null, null, (Icon)OracleIcons.getIcon((String)"add.png"), null, (boolean)true);
            this._action.addController((Controller)this);
            this.setEnabled(true);
        }
        return this._action;
    }
}

