/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.tools;

import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.GeomImgPanel;
import oracle.dbtools.spatial.mapviewer.components.MapGeometry;
import oracle.dbtools.spatial.tools.SpatialTool;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.spatial.views.SpatialViewController;
import oracle.dbtools.spatial.views.tables.SpatialReorderableTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.icons.OracleIcons;

public class SpatialRefreshGeomQuery
extends SpatialTool {
    public static final String TYPE = "REFRESH_QUERY_LAYER";
    public static int ACTION = Ide.findOrCreateCmdID((String)"spatial_refresh_query_layer");
    private GeomImgPanel targetPanel;
    private SpatialReorderableTableModel targetTableModel;
    private MapGeometry[] mapGeometries;

    public SpatialRefreshGeomQuery() {
        super(TYPE, 3);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == ACTION) {
            this.targetPanel = SpatialUtil.getPanel().getSelectedImgPanel();
            this.targetTableModel = SpatialUtil.getTableModel();
            RaptorTask<Object> raptorTask = new RaptorTask<Object>("Drawing Geometry", true, IRaptorTaskRunMode.IDE_STATUSBAR){

                protected Object doWork() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SpatialRefreshGeomQuery.this.setEnabled(false);
                            SpatialRefreshGeomQuery.this.targetPanel.setState(0);
                            SpatialRefreshGeomQuery.access$102(SpatialRefreshGeomQuery.this, SpatialRefreshGeomQuery.this.targetTableModel.queryAllGeometries(false));
                            SpatialRefreshGeomQuery.this.targetPanel.setHighlighted(null);
                            SpatialRefreshGeomQuery.this.targetPanel.refreshMaps(SpatialRefreshGeomQuery.this.mapGeometries);
                            SpatialRefreshGeomQuery.this.targetPanel.repaint();
                        }
                    });
                    return null;
                }
            };
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SpatialViewController.getInstance().toggleToolbar();
                        }
                    });
                }

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SpatialViewController.getInstance().toggleToolbar();
                        }
                    });
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SpatialViewController.getInstance().toggleToolbar();
                        }
                    });
                }
            });
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
            return true;
        }
        return false;
    }

    @Override
    public boolean isAlwaysEnabled() {
        return false;
    }

    @Override
    public IdeAction getAction() {
        if (this._action == null) {
            this._action = IdeAction.get((int)ACTION, null, (String)SpatialArb.getString("SPATIAL_REFRESH_GEOMETRY_LABEL"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true);
            this._action.addController((Controller)this);
            this.setEnabled(true);
        }
        return this._action;
    }

    static /* synthetic */ MapGeometry[] access$102(SpatialRefreshGeomQuery spatialRefreshGeomQuery, MapGeometry[] mapGeometryArray) {
        spatialRefreshGeomQuery.mapGeometries = mapGeometryArray;
        return mapGeometryArray;
    }
}

