/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.MapViewerColorDialog;
import oracle.dbtools.spatial.mapviewer.components.MapViewerGeometryResultSet;
import oracle.dbtools.spatial.views.SpatialComboBoxLoader;
import oracle.dbtools.spatial.views.SpatialDelayedComboBox;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class QueryEditDialog
extends JDialog {
    private static Color lineDefaultColor = new Color(112, 112, 89);
    private static Color fillDefaultColor = new Color(248, 249, 204);
    private String queryTitleString = "";
    private String queryTextString = "";
    private Color lineColor;
    private Color fillColor;
    private String annotatedColumnName = "";
    private String notes = "";
    private static final boolean DEBUG = false;
    private ArrayList mapQueryList = null;
    boolean editMode = false;
    boolean cancelled = true;
    private JPanel MappSettingsPanel;
    private JButton cancelButton;
    private JPanel fillColorChooserPanel;
    private JLabel fillColorLabel;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JPanel lineColorChooserPanel;
    private JLabel lineColorLabel;
    private JLabel annotatedColumnLabel;
    private JButton okButton;
    private JScrollPane queryScrollPane;
    private JLabel queryTitleLabel;
    private JTextField queryTitleTextField;
    private JButton helpButton;
    private JPanel queryDialogPanel;
    private BasicEditorPane queryTextArea = EditorFactory.createIdeEditorPane();
    private LineGutterPlugin m_sqlGutter;
    private BasicDocument doc = new BasicDocument("foo.plsql");
    private SpatialDelayedComboBox delayedAnootationCombobox;
    private SpatialComboBoxLoader delayedComboLoader;
    private Vector<String> annotatedColumns = new Vector();

    public QueryEditDialog(Frame frame, boolean bl, ArrayList arrayList) {
        super(frame, bl);
        this.initComponents();
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this);
        this.mapQueryList = arrayList;
        this.editMode = false;
    }

    protected static Color getDefaultLineColor() {
        return lineDefaultColor;
    }

    protected static Color getDefaultFillColor() {
        return fillDefaultColor;
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.queryDialogPanel = new JPanel();
        this.queryTitleLabel = new JLabel();
        this.queryTitleTextField = new JTextField();
        this.queryScrollPane = new JScrollPane();
        this.MappSettingsPanel = new JPanel();
        this.lineColorChooserPanel = new JPanel();
        this.lineColorLabel = new JLabel();
        this.fillColorLabel = new JLabel();
        this.fillColorChooserPanel = new JPanel();
        this.annotatedColumnLabel = new JLabel();
        this.helpButton = new JButton();
        MapViewerGeometryResultSet mapViewerGeometryResultSet = SpatialUtil.getTableModel().getMapViewerResultSet();
        if (mapViewerGeometryResultSet == null) {
            System.err.println("Mvrs could not be fetched");
        }
        this.delayedComboLoader = new SpatialComboBoxLoader(mapViewerGeometryResultSet);
        this.delayedAnootationCombobox = new SpatialDelayedComboBox("AnnotationColumnLoader", "", this.delayedComboLoader);
        LineHighlightPlugin lineHighlightPlugin = new LineHighlightPlugin();
        GroupLayout groupLayout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.setDefaultCloseOperation(2);
        this.setTitle(SpatialArb.getString("MapViewerQueryEditDialogTitle"));
        this.setIconImage(SpatialArb.getImage("LAYER_ICON"));
        this.setBounds(new Rectangle(0, 0, 500, 300));
        this.setModal(true);
        this.setResizable(false);
        this.okButton.setText(StringUtils.stripMnemonic((String)SpatialArb.getString("MapViewerQueryEditDialogOK")));
        this.okButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("MapViewerQueryEditDialogOK")));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryEditDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.okButton.setName("OkButtonQueryEditDialogMapViewer");
        this.cancelButton.setText(StringUtils.stripMnemonic((String)SpatialArb.getString("MapViewerQueryEditDialogCancel")));
        this.cancelButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("MapViewerQueryEditDialogCancel")));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryEditDialog.this.cancelled = true;
                QueryEditDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setName("CancelButtonQueryEditDialogMapViewer");
        this.queryTitleLabel.setText(SpatialArb.getString("MapViewerQueryEditDialogMapTitle"));
        this.queryTitleTextField.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150)));
        this.queryScrollPane.setBorder(BorderFactory.createTitledBorder(null, SpatialArb.getString("MapViewerQueryEditDialogMapQuery"), 0, 0, null, new Color(0, 0, 0)));
        this.queryTextArea.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150)));
        this.queryTextArea.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                QueryEditDialog.this.delayedComboLoader.setQuery(QueryEditDialog.this.queryTextArea.getText().trim());
                QueryEditDialog.this.delayedAnootationCombobox.restart();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                QueryEditDialog.this.delayedComboLoader.setQuery(QueryEditDialog.this.queryTextArea.getText().trim());
                QueryEditDialog.this.delayedAnootationCombobox.restart();
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                QueryEditDialog.this.delayedComboLoader.setQuery(QueryEditDialog.this.queryTextArea.getText().trim());
                QueryEditDialog.this.delayedAnootationCombobox.restart();
            }
        });
        this.queryTextArea.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    QueryEditDialog.this.delayedComboLoader.setQuery(QueryEditDialog.this.queryTextArea.getText().trim());
                    QueryEditDialog.this.delayedAnootationCombobox.restart();
                    System.out.println("Setting: " + QueryEditDialog.this.queryTextArea.getText().trim());
                }
            }
        });
        this.queryScrollPane.setViewportView((Component)this.queryTextArea);
        this.queryScrollPane.setHorizontalScrollBarPolicy(32);
        this.queryScrollPane.setVerticalScrollBarPolicy(22);
        this.queryTextArea.installPlugin((EditorPlugin)lineHighlightPlugin);
        this.m_sqlGutter = new LineGutterPlugin();
        this.queryTextArea.installPlugin((EditorPlugin)this.m_sqlGutter);
        this.queryTextArea.setDocument((Document)this.doc);
        this.MappSettingsPanel.setBorder(BorderFactory.createTitledBorder(null, SpatialArb.getString("MapViewerQueryEditDialogMapStyles"), 0, 0, null, new Color(0, 0, 0)));
        this.lineColorChooserPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lineColorChooserPanel.setBackground(QueryEditDialog.getDefaultLineColor());
        this.lineColorChooserPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                QueryEditDialog.this.lineColorChooserPanelMouseClicked(mouseEvent);
            }
        });
        this.lineColorChooserPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == '\r' || c == '\n') {
                    QueryEditDialog.this.getLineColorChooserDialog();
                }
            }
        });
        this.lineColorChooserPanel.setFocusable(true);
        this.lineColorChooserPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                QueryEditDialog.this.lineColorChooserPanel.setBorder(BorderFactory.createLoweredBevelBorder());
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                QueryEditDialog.this.lineColorChooserPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.lineColorChooserPanel);
        this.lineColorChooserPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 36, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 33, Short.MAX_VALUE));
        this.lineColorLabel.setText(SpatialArb.getString("MapViewerQueryEditDialogLineColor"));
        this.fillColorLabel.setText(SpatialArb.getString("MapViewerQueryEditDialogFillColor"));
        this.fillColorChooserPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.fillColorChooserPanel.setBackground(QueryEditDialog.getDefaultFillColor());
        this.fillColorChooserPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                QueryEditDialog.this.fillColorChooserPanelMouseClicked(mouseEvent);
            }
        });
        this.fillColorChooserPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == '\r' || c == '\n') {
                    QueryEditDialog.this.getFillColorChooserDialog();
                }
            }
        });
        this.fillColorChooserPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                QueryEditDialog.this.fillColorChooserPanel.setBorder(BorderFactory.createLoweredBevelBorder());
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                QueryEditDialog.this.fillColorChooserPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
            }
        });
        this.fillColorChooserPanel.setFocusable(true);
        GroupLayout groupLayout3 = new GroupLayout(this.fillColorChooserPanel);
        this.fillColorChooserPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 35, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 31, Short.MAX_VALUE));
        this.annotatedColumnLabel.setText(SpatialArb.getString("MapViewerQueryEditDialogAnnotationColumn"));
        GroupLayout groupLayout4 = new GroupLayout(this.MappSettingsPanel);
        this.MappSettingsPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addGap(3, 3, 3).addComponent(this.delayedAnootationCombobox, 0, 80, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lineColorLabel, -1, -1, Short.MAX_VALUE).addComponent(this.fillColorLabel, -1, 58, Short.MAX_VALUE)).addGap(36, 36, 36).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lineColorChooserPanel, -2, -1, -2).addComponent(this.fillColorChooserPanel, -2, -1, -2))).addComponent(this.annotatedColumnLabel)).addGap(14, 14, 14)))));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lineColorChooserPanel, -2, -1, -2).addComponent(this.lineColorLabel)).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGap(25, 25, 25).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 48, Short.MAX_VALUE).addComponent(this.fillColorLabel).addGap(60, 60, 60).addComponent(this.annotatedColumnLabel).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.delayedAnootationCombobox, -2, -1, -2)).addGap(120, 120, 120)).addGroup(groupLayout4.createSequentialGroup().addGap(6, 6, 6).addComponent(this.fillColorChooserPanel, -2, -1, -2).addGap(2, 2, 2)).addGap(1, 1, 1))));
        GroupLayout groupLayout5 = new GroupLayout(this.queryDialogPanel);
        this.queryDialogPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addComponent(this.queryTitleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.queryTitleTextField, -1, 561, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addComponent(this.queryScrollPane, -1, 433, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MappSettingsPanel, -2, -1, -2))).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.queryTitleLabel).addComponent(this.queryTitleTextField, -2, 19, -2)).addGap(18, 18, 18).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MappSettingsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.queryScrollPane, -2, 326, -2)).addContainerGap()));
        this.helpButton.setText(StringUtils.stripMnemonic((String)SpatialArb.getString("MapViewerQueryEditDialogHelp")));
        this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("MapViewerQueryEditDialogHelp")));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryEditDialog.this.helpButtonActionPerformed(actionEvent);
            }
        });
        this.helpButton.setName("HelpButtonQueryEditDialogMapViewer");
        GroupLayout groupLayout6 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.queryDialogPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout6.createSequentialGroup().addContainerGap().addComponent(this.helpButton, -2, 89, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 297, Short.MAX_VALUE).addComponent(this.okButton, -2, 101, -2).addGap(18, 18, 18).addComponent(this.cancelButton, -2, 118, -2).addContainerGap()));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addComponent(this.queryDialogPanel, -2, 377, -2).addGap(18, 18, 18).addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.helpButton)).addContainerGap(23, Short.MAX_VALUE)));
        this.pack();
    }

    private void annotationColumnComboBoxActionPerformed(ActionEvent actionEvent) {
        ItemSelectable itemSelectable = (ItemSelectable)actionEvent.getSource();
        this.annotatedColumnName = this.selectedString(itemSelectable);
    }

    private String selectedString(ItemSelectable itemSelectable) {
        Object[] objectArray = itemSelectable.getSelectedObjects();
        return objectArray.length == 0 ? "null" : (String)objectArray[0];
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.queryTitleString = this.queryTitleTextField.getText().trim();
        if (this.queryTitleString == null || this.queryTitleString.length() == 0) {
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)SpatialArb.getString("SpatialError13514"), (String)SpatialArb.getString("MapViewerQueryEditDialogMapTitleErrorTitle"), null);
            return;
        }
        if (!this.editMode & this.checkDuplicatesTitles(this.queryTitleString)) {
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)SpatialArb.getString("SpatialError13515"), (String)SpatialArb.getString("MapViewerQueryTitleUniqnessError"), null);
            return;
        }
        this.queryTextString = this.semiColonCheck(this.queryTextArea.getText().trim());
        MapViewerGeometryResultSet mapViewerGeometryResultSet = SpatialUtil.getTableModel().getMapViewerResultSet();
        boolean bl = mapViewerGeometryResultSet.isValidSpatialQuery(this.queryTextString);
        if (!bl) {
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)SpatialArb.getString("ADD_QUERY_EMPTY_TITLE_OR_QUERY_WARNING"), (String)"", null);
            return;
        }
        this.lineColor = this.lineColorChooserPanel.getBackground();
        this.fillColor = this.fillColorChooserPanel.getBackground();
        this.annotatedColumnName = (String)this.delayedAnootationCombobox.getSelectedItem();
        this.cancelled = false;
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancelDialog();
    }

    private void cancelDialog() {
        this.queryTitleString = "";
        this.queryTextString = "";
        this.cancelled = true;
        this.dispose();
    }

    private void fillColorChooserPanelMouseClicked(MouseEvent mouseEvent) {
        this.getFillColorChooserDialog();
    }

    private void getFillColorChooserDialog() {
        Color color = this.fillColorChooserPanel.getBackground();
        System.out.println("Initial color: " + color.toString());
        MapViewerColorDialog mapViewerColorDialog = new MapViewerColorDialog((Frame)new JFrame(), true, color);
        mapViewerColorDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        mapViewerColorDialog.setVisible(true);
        Color color2 = mapViewerColorDialog.getSelectedColor();
        if (color2 != null) {
            this.fillColorChooserPanel.setBackground(color2);
        } else {
            this.fillColorChooserPanel.setBackground(color);
        }
        this.setFillColor(color2);
    }

    private void lineColorChooserPanelMouseClicked(MouseEvent mouseEvent) {
        this.getLineColorChooserDialog();
    }

    private void getLineColorChooserDialog() {
        Color color = this.lineColorChooserPanel.getBackground();
        MapViewerColorDialog mapViewerColorDialog = new MapViewerColorDialog((Frame)new JFrame(), true, color);
        mapViewerColorDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        mapViewerColorDialog.setVisible(true);
        Color color2 = mapViewerColorDialog.getSelectedColor();
        if (color2 != null) {
            this.lineColorChooserPanel.setBackground(color2);
        } else {
            this.lineColorChooserPanel.setBackground(color);
        }
        this.setLineColor(color2);
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        HelpSystem.getHelpSystem().showHelp(this.getHelpInfo());
    }

    public String getQueryTitle() {
        return this.queryTitleString;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public String getQueryText() {
        return this.queryTextString;
    }

    public String getAnnotatedColumnName() {
        return this.annotatedColumnName;
    }

    public void setQueryTitle(String string) {
        this.queryTitleString = string;
    }

    public void setQueryText(String string) {
        this.queryTextString = this.semiColonCheck(string);
    }

    public void setAnnotatedColumn(String string) {
        this.annotatedColumnName = string;
    }

    public void updateFields(String string, String string2) {
        this.queryTitleTextField.setText(string);
        this.queryTextArea.setText(this.semiColonCheck(string2));
    }

    public void updateFields(String string, String string2, Color color, Color color2) {
        this.queryTitleTextField.setText(string);
        this.queryTextArea.setText(this.semiColonCheck(string2));
        this.lineColorChooserPanel.setBackground(color);
        this.fillColorChooserPanel.setBackground(color2);
    }

    public void updateFields(String string, String string2, Color color, Color color2, String string3) {
        this.queryTitleTextField.setText(string);
        this.queryTextArea.setText(this.semiColonCheck(string2));
        this.lineColorChooserPanel.setBackground(color);
        this.fillColorChooserPanel.setBackground(color2);
    }

    private String semiColonCheck(String string) {
        if (string.trim().endsWith(";")) {
            string = string.replace(";", "");
        }
        return string;
    }

    private String getColumnNames(String string) {
        String[] stringArray = null;
        String string2 = new String();
        String string3 = string.toUpperCase();
        if (string3.trim().startsWith("SELECT")) {
            if (!(string3 = string3.replace("SELECT", "")).contains("FROM")) {
                return null;
            }
            string3 = string3.substring(0, string3.indexOf("FROM")).trim();
            for (String string4 : stringArray = string3.split(",")) {
                System.out.println("col=" + string4);
                string4 = string4.trim();
                if (string4.contains(" ")) {
                    string4 = string4.split(" ")[1].trim();
                }
                string2 = string2 + string4.trim() + "\n";
            }
        }
        return string2.trim();
    }

    private String[] getColumnNamesArray(String string) {
        String string2 = this.getColumnNames(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split("\n");
        String[] stringArray2 = new String[1 + stringArray.length];
        System.arraycopy(new String[]{" "}, 0, stringArray2, 0, 1);
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    public String getNotes() {
        return this.notes;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setNotes(String string) {
        this.notes = string;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_mapquery_html");
    }

    private boolean checkDuplicatesTitles(String string) {
        for (int i = 0; i < this.mapQueryList.size(); ++i) {
            QueryObject queryObject = (QueryObject)this.mapQueryList.get(i);
            if (!queryObject.getQueryTitle().equals(string)) continue;
            return true;
        }
        return false;
    }
}

