/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.spatial.mapviewer.components.MapViewerGeometryResultSet;
import oracle.dbtools.spatial.views.SpatialDelayedComboBox;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.util.Logger;

public class SpatialComboBoxLoader {
    private LoaderTask _loaderTask;
    private boolean _taskStarted;
    private String queryString;
    private MapViewerGeometryResultSet mapViewerGeomRs;
    private static boolean connected;

    public SpatialComboBoxLoader(MapViewerGeometryResultSet mapViewerGeometryResultSet) {
        this.mapViewerGeomRs = mapViewerGeometryResultSet;
    }

    public void setQuery(String string) {
        this.queryString = string;
    }

    private String semiColonCheck(String string) {
        if (string.trim().endsWith(";")) {
            string = string.replace(";", "");
        }
        return string;
    }

    void init(SpatialDelayedComboBox spatialDelayedComboBox, Object object) {
        this._loaderTask = new LoaderTask(spatialDelayedComboBox, object);
        this._taskStarted = false;
    }

    public String getConnectionName() {
        return "";
    }

    public void start() {
        if (!this._taskStarted) {
            RaptorTaskManager.getInstance().addTask((RaptorTask)this._loaderTask);
            this._taskStarted = true;
        }
    }

    public void addListener(IRaptorTaskListener iRaptorTaskListener) {
        this._loaderTask.getDescriptor().addListener(iRaptorTaskListener);
    }

    public List<Object> getComboContents() throws TaskException {
        ArrayList<Object> arrayList = null;
        if (this.queryString == null || this.queryString.length() < 1) {
            return Collections.emptyList();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                connected = SpatialUtil.getPanel().getSelectedTabPage().isConnectionSet();
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        if (connected) {
            this.queryString = this.semiColonCheck(this.queryString);
            Object[] objectArray = this.mapViewerGeomRs.getColumnNames(this.queryString);
            if (objectArray == null || objectArray.length <= 0) {
                return Collections.emptyList();
            }
            Arrays.sort(objectArray);
            arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
        }
        return arrayList;
    }

    private class LoaderTask
    extends DatabaseQueryTask<List<Object>> {
        private static final String NAME_SFX = " SpatialDelayedLoadingComboBox.Loader";
        private SpatialDelayedComboBox _combo;
        private Object _value;

        public LoaderTask(SpatialDelayedComboBox spatialDelayedComboBox, Object object) {
            super(spatialDelayedComboBox.getName() + NAME_SFX, IRaptorTaskRunMode.NO_GUI, false, true, true);
            this.getDescriptor().addListener((IRaptorTaskListener)new WaitOver());
            this._combo = spatialDelayedComboBox;
            this._value = object;
        }

        public String getConnectionName() {
            return SpatialComboBoxLoader.this.getConnectionName();
        }

        public String getQuery() {
            return this.getDescriptor().getName();
        }

        protected List<Object> doWork() throws TaskException {
            try {
                return SpatialComboBoxLoader.this.getComboContents();
            }
            catch (TaskException taskException) {
                throw taskException;
            }
            catch (Exception exception) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                throw new TaskException((Throwable)exception);
            }
        }

        protected void invokeLater() {
            try {
                this._combo.populate((List)this.getResult(), this._value);
            }
            catch (Exception exception) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
            }
        }

        private class WaitOver
        extends RaptorTaskAdapter {
            private WaitOver() {
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        LoaderTask.this.invokeLater();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }
}

