/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.raptor.controls.ITabCloseListner;
import oracle.dbtools.raptor.controls.RaptorDnD;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.GeomImgPanel;
import oracle.dbtools.spatial.persistence.QueryHistoryManager;
import oracle.dbtools.spatial.views.SpatialCustomTabbedPanel;
import oracle.dbtools.spatial.views.SpatialViewController;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.dbtools.spatial.views.tables.SpatialListReorderableTableWithTitleBar;
import oracle.dbtools.spatial.views.tables.SpatialReorderableTableModel;
import oracle.dbtools.spatial.views.tables.SpatialTabPanel;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ideimpl.explorer.dnd.MultiTransferable;
import oracle.javatools.db.DBException;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;

public class SpatialPanel
extends JPanel {
    static final long serialVersionUID = 1L;
    private static final String TAB_NAME = SpatialArb.getString("TAB_NAME");
    private boolean _init = false;
    private Integer _nameSuffix = 1;
    private ArrayList<ITabCloseListner> closeListeners = new ArrayList();
    private ArrayList<SpatialListReorderableTableWithTitleBar> reorderableTables = new ArrayList();
    private ArrayList<GeomImgPanel> imagePanels = new ArrayList();
    private ArrayList<Integer> panelPositions = new ArrayList();
    private SpatialCustomTabbedPanel _innerTabbedPane = new SpatialCustomTabbedPanel();
    private Toolbar _toolbar;
    private JSplitPane middleSplitPanel = new JSplitPane();
    private int lastTabIndex;
    private Connections connections;
    private DropTargetListener dropTargetListener;
    private DropTarget dropTarget;
    protected String objectName;
    private QueryHistoryManager historyManager;
    private String[] raptorTaskCnx;
    private String[] raptorTaskTId;
    private HashMap tabCnxHashMap;
    final transient ITabCloseListner closeListener = new ITabCloseListner(){

        public void tabClosed() {
            DefaultListModel defaultListModel = SpatialPanel.this._innerTabbedPane.getTabModel();
            ArrayList<SpatialListReorderableTableWithTitleBar> arrayList = new ArrayList<SpatialListReorderableTableWithTitleBar>();
            boolean[] blArray = new boolean[SpatialPanel.this.reorderableTables.size()];
            int n = 0;
            for (SpatialListReorderableTableWithTitleBar spatialListReorderableTableWithTitleBar : SpatialPanel.this.reorderableTables) {
                boolean bl = false;
                blArray[n] = true;
                for (int i = defaultListModel.size() - 1; i >= 0; --i) {
                    Object e = defaultListModel.getElementAt(i);
                    if (!(e instanceof DefaultCustomTabPage) || ((DefaultCustomTabPage)e).getUserObject() != spatialListReorderableTableWithTitleBar.getTabPanel()) continue;
                    bl = true;
                    blArray[n] = false;
                    break;
                }
                if (!bl) {
                    arrayList.add(spatialListReorderableTableWithTitleBar);
                }
                ++n;
            }
            for (SpatialListReorderableTableWithTitleBar spatialListReorderableTableWithTitleBar : arrayList) {
                spatialListReorderableTableWithTitleBar.getModel().eraseTabHistory(spatialListReorderableTableWithTitleBar.getModel().getIdentifier().toString());
                SpatialPanel.this.reorderableTables.remove((Object)spatialListReorderableTableWithTitleBar);
            }
            if (SpatialPanel.this.reorderableTables.isEmpty()) {
                SpatialPanel.this.setPanels(new JPanel(new GridBagLayout()), new JPanel(new GridBagLayout()));
                SpatialPanel.this.middleSplitPanel.setDividerSize(0);
            } else {
                for (int i = 0; i < blArray.length; ++i) {
                    if (!blArray[i]) continue;
                    SpatialPanel.this.imagePanels.remove(i);
                    SpatialPanel.this.panelPositions.remove(i);
                }
            }
        }
    };

    public SpatialPanel() {
        super(new GridBagLayout());
    }

    public void initialize() {
        if (!this._init) {
            UIUtils.addIdeKeyBindings((JComponent)this, (int)1, (String)"oracle/dbtools/spatial/accelerators.xml");
            this.lastTabIndex = 0;
            this._init = true;
            this.closeListeners.add(this.closeListener);
            this._toolbar = new Toolbar();
            SpatialViewController.getInstance().installToolbar(this.getToolbar());
            this.add((Component)this._toolbar, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this._innerTabbedPane.getTabs(), new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.middleSplitPanel, new GridBagConstraints(0, 2, 5, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dropTargetListener = new MapViewerDropTargetListener();
            this.dropTarget = new DropTarget(this, 1, this.dropTargetListener, true);
            this.connections = Connections.getInstance();
            this.connections.addConnectionDisconnectListener(new ConnectionDisconnectListener(){

                public void checkDisconnect(ConnectionDetails connectionDetails) {
                }

                public void connectionDisconnected(ConnectionDetails connectionDetails) {
                    SpatialViewController.getInstance().toggleToolbar();
                    for (SpatialListReorderableTableWithTitleBar spatialListReorderableTableWithTitleBar : SpatialPanel.this.reorderableTables) {
                        if (!spatialListReorderableTableWithTitleBar.getCombobox().getCurrentConnectionName().equals(connectionDetails.getQualifiedConnectionName())) continue;
                        spatialListReorderableTableWithTitleBar.disconnect();
                    }
                }
            });
            this.historyManager = new QueryHistoryManager();
            this._innerTabbedPane.addChangeListener(new TabChangeListener());
            this.restoreSessionTabs();
        }
    }

    private void restoreSessionTabs() {
        String[] stringArray = this.historyManager.getPreviousSession();
        if (stringArray == null || stringArray.length == 0) {
            this.addTab();
        } else {
            int n = (int)Math.floor(stringArray.length / 2);
            this.raptorTaskCnx = new String[n];
            this.raptorTaskTId = new String[n];
            this.tabCnxHashMap = new HashMap();
            for (int i = 0; i < n; ++i) {
                int n2 = i * 2;
                int n3 = n2 + 1;
                String string = stringArray[n2];
                String string2 = stringArray[n3];
                this.tabCnxHashMap.put(string, string2);
                this.raptorTaskCnx[i] = string2;
                this.raptorTaskTId[i] = string;
                this.addTab(string, string2);
            }
        }
    }

    private void addTab(String string, String string2) {
        String string3 = TAB_NAME;
        string3 = string3 + " " + this._nameSuffix.toString();
        this._nameSuffix = this._nameSuffix + 1;
        SpatialReorderableTableModel spatialReorderableTableModel = new SpatialReorderableTableModel(UUID.fromString(string));
        SpatialListReorderableTableWithTitleBar<QueryObject> spatialListReorderableTableWithTitleBar = new SpatialListReorderableTableWithTitleBar<QueryObject>(spatialReorderableTableModel, string3);
        this.reorderableTables.add(spatialListReorderableTableWithTitleBar);
        this._innerTabbedPane.addTab(null, string3, spatialListReorderableTableWithTitleBar.getTabPanel(), this.closeListeners);
        this.setSelectedIndex(this._innerTabbedPane.getTabModel().getSize() - 1);
        GeomImgPanel geomImgPanel = new GeomImgPanel(spatialReorderableTableModel);
        this.imagePanels.add(geomImgPanel);
        this.setPanels(this.imagePanels.get(this.imagePanels.size() - 1), this._innerTabbedPane.getContent());
        this.lastTabIndex = this._innerTabbedPane.getTabModel().getSize() - 1;
        this.panelPositions.add(this.middleSplitPanel.getDividerLocation());
        this.getSelectedTabPage().setTabPageConnection(string2);
    }

    public void addTab() {
        String string = TAB_NAME;
        string = string + " " + this._nameSuffix.toString();
        this._nameSuffix = this._nameSuffix + 1;
        SpatialReorderableTableModel spatialReorderableTableModel = new SpatialReorderableTableModel();
        SpatialListReorderableTableWithTitleBar<QueryObject> spatialListReorderableTableWithTitleBar = new SpatialListReorderableTableWithTitleBar<QueryObject>(spatialReorderableTableModel, string);
        this.reorderableTables.add(spatialListReorderableTableWithTitleBar);
        this._innerTabbedPane.addTab(null, string, spatialListReorderableTableWithTitleBar.getTabPanel(), this.closeListeners);
        this.setSelectedIndex(this._innerTabbedPane.getTabModel().getSize() - 1);
        GeomImgPanel geomImgPanel = new GeomImgPanel(spatialReorderableTableModel);
        this.imagePanels.add(geomImgPanel);
        GeomImgPanel geomImgPanel2 = this.imagePanels.get(this._innerTabbedPane.getTabModel().getSize() - 1);
        geomImgPanel2.drawEmptyImage();
        this.setPanels(geomImgPanel2, this._innerTabbedPane.getContent());
        geomImgPanel2.removeImageFromPanel();
        this.lastTabIndex = this._innerTabbedPane.getTabModel().getSize() - 1;
        this.panelPositions.add(this.middleSplitPanel.getDividerLocation());
        SpatialViewController.getInstance().toggleToolbar();
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    private void setPanels(Component component, Component component2) {
        this.middleSplitPanel.setRightComponent(component2);
        this.middleSplitPanel.setLeftComponent(component);
        this.setupLeftPanel();
    }

    private void setupLeftPanel() {
        this.middleSplitPanel.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.middleSplitPanel.setDividerLocation(300);
        this.middleSplitPanel.setDividerSize(3);
        this.middleSplitPanel.setContinuousLayout(true);
    }

    private void restorePanelAt(int n) {
        this.middleSplitPanel.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.middleSplitPanel.setDividerSize(3);
        this.middleSplitPanel.setContinuousLayout(true);
        if (this.panelPositions.size() > 0 && this.panelPositions.get(n) != null) {
            this.middleSplitPanel.setDividerLocation(this.panelPositions.get(n));
        }
    }

    public SpatialReorderableTableModel getTableModel(String string) {
        for (SpatialListReorderableTableWithTitleBar spatialListReorderableTableWithTitleBar : this.reorderableTables) {
            if (!string.equals(spatialListReorderableTableWithTitleBar.getTabLabel())) continue;
            return spatialListReorderableTableWithTitleBar.getModel();
        }
        return null;
    }

    public SpatialReorderableTableModel getTableModel() {
        return this.getSelectedModel();
    }

    public SpatialReorderableTableModel getSelectedModel() {
        return this.getModel(this._innerTabbedPane.getSelectedIndex());
    }

    public GeomImgPanel getSelectedImgPanel() {
        return this.getImgPanel(this._innerTabbedPane.getSelectedIndex());
    }

    private GeomImgPanel getImgPanel(int n) {
        GeomImgPanel geomImgPanel = null;
        if (n >= 0) {
            geomImgPanel = this.imagePanels.get(n);
        }
        return geomImgPanel;
    }

    private SpatialReorderableTableModel getModel(int n) {
        DefaultCustomTabPage defaultCustomTabPage;
        SpatialTabPanel spatialTabPanel;
        if (n >= 0 && (spatialTabPanel = (SpatialTabPanel)(defaultCustomTabPage = (DefaultCustomTabPage)this._innerTabbedPane.getTabModel().get(n)).getUserObject()) != null) {
            ReorderableTableWithTitleBar reorderableTableWithTitleBar = spatialTabPanel.getReorderableTableWithTitleBar();
            SpatialListReorderableTableWithTitleBar<?> spatialListReorderableTableWithTitleBar = this.getTabPage(reorderableTableWithTitleBar);
            return spatialListReorderableTableWithTitleBar.getModel();
        }
        return null;
    }

    public SpatialListReorderableTableWithTitleBar<?> getTabPage(ReorderableTableWithTitleBar reorderableTableWithTitleBar) {
        for (SpatialListReorderableTableWithTitleBar spatialListReorderableTableWithTitleBar : this.reorderableTables) {
            ReorderableTableWithTitleBar reorderableTableWithTitleBar2 = spatialListReorderableTableWithTitleBar.getReorderableTableWithTitleBar();
            if (reorderableTableWithTitleBar2 != reorderableTableWithTitleBar) continue;
            return spatialListReorderableTableWithTitleBar;
        }
        return null;
    }

    public SpatialListReorderableTableWithTitleBar<?> getSelectedTabPage() {
        int n = this._innerTabbedPane.getSelectedIndex();
        if (n >= 0) {
            return this.getTabPage(n);
        }
        return null;
    }

    private SpatialListReorderableTableWithTitleBar<?> getTabPage(int n) {
        DefaultCustomTabPage defaultCustomTabPage;
        SpatialTabPanel spatialTabPanel;
        ReorderableTableWithTitleBar reorderableTableWithTitleBar;
        if (n >= 0 && (reorderableTableWithTitleBar = (spatialTabPanel = (SpatialTabPanel)(defaultCustomTabPage = (DefaultCustomTabPage)this._innerTabbedPane.getTabModel().get(n)).getUserObject()).getReorderableTableWithTitleBar()) != null) {
            return this.getTabPage(reorderableTableWithTitleBar);
        }
        return null;
    }

    public String getSelecetedTabPageName() {
        return this._innerTabbedPane.getSelectedPageLabel();
    }

    public void setSelectedTabPagName(String string) {
        SpatialListReorderableTableWithTitleBar<?> spatialListReorderableTableWithTitleBar = this.getSelectedTabPage();
        if (spatialListReorderableTableWithTitleBar != null) {
            this._innerTabbedPane.renameSelectedPage(string);
        }
    }

    public ArrayList<SpatialListReorderableTableWithTitleBar> getTabPages() {
        return this.reorderableTables;
    }

    public ArrayList<String> getTabPageNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SpatialListReorderableTableWithTitleBar spatialListReorderableTableWithTitleBar : this.reorderableTables) {
            arrayList.add(spatialListReorderableTableWithTitleBar.getTabLabel());
        }
        return arrayList;
    }

    public ArrayList<SpatialReorderableTableModel> getTableModels() {
        ArrayList<SpatialReorderableTableModel> arrayList = new ArrayList<SpatialReorderableTableModel>();
        for (SpatialListReorderableTableWithTitleBar spatialListReorderableTableWithTitleBar : this.reorderableTables) {
            arrayList.add(spatialListReorderableTableWithTitleBar.getModel());
        }
        return arrayList;
    }

    public JTable getTable() {
        return this.getSelectedModel().getTable();
    }

    private int getTabCount() {
        return this._innerTabbedPane.getNumberOfTabs();
    }

    private int getSelectedTab() {
        return this._innerTabbedPane.getSelectedIndex();
    }

    private void setSelectedIndex(int n) {
        this._innerTabbedPane.setSelectedIndex(n);
    }

    class MapViewerDropTargetListener
    implements DropTargetListener {
        private String currentCnxName;
        private ObjectNode objNode;
        private String type;
        private String objName;
        private DatabaseConnection draggedConn;

        MapViewerDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(1);
            Transferable transferable = dropTargetDragEvent.getTransferable();
            try {
                List list = RaptorDnD.getTransferableNodes((Transferable[])new Transferable[]{transferable});
                for (int i = 0; i < list.size(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = list.get(i) instanceof MultiTransferable ? (DefaultMutableTreeNode)((MultiTransferable)list.get(i)).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR) : (DefaultMutableTreeNode)list.get(i);
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (object instanceof DatabaseConnection) {
                        if (!Connections.getInstance().isOracle(((DatabaseConnection)object).getConnectionName())) {
                            this.draggedConn = (DatabaseConnection)object;
                            this.type = "CNX";
                            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                        } else {
                            dropTargetDragEvent.rejectDrag();
                        }
                        break;
                    }
                    if (!(object instanceof ObjectNode)) continue;
                    this.objNode = (ObjectNode)object;
                    this.objName = this.objNode.getObjectName();
                    this.type = this.objNode.getObjectType();
                    try {
                        if (!Connections.getInstance().isOracle(Connections.getInstance().getConnection(this.objNode.getConnectionName()))) {
                            dropTargetDragEvent.rejectDrag();
                            break;
                        }
                        this.currentCnxName = SpatialPanel.this.getSelectedTabPage().getCombobox().getCurrentConnectionName();
                        if (this.currentCnxName.equals("")) {
                            throw new Exception(SpatialArb.getString("SpatialError13512"));
                        }
                        if (!this.currentCnxName.equals("") && !this.currentCnxName.equals(this.objNode.getConnectionName())) {
                            throw new Exception(SpatialArb.getString("SpatialError13513"));
                        }
                        if (this.type == null && !this.type.equals("TABLE") && !this.type.equals("VIEW")) {
                            dropTargetDragEvent.rejectDrag();
                            break;
                        }
                        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                        continue;
                    }
                    catch (DBException dBException) {
                        dropTargetDragEvent.rejectDrag();
                    }
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                dropTargetDragEvent.rejectDrag();
            }
            catch (IOException iOException) {
                dropTargetDragEvent.rejectDrag();
            }
            catch (Exception exception) {
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (this.draggedConn != null && this.type.equals("CNX")) {
                String string = this.draggedConn.getQualifiedConnectionName();
                String string2 = SpatialPanel.this.getSelectedTabPage().getCurrentConnectionName();
                if (string.length() > 0 && !string.equals(string2)) {
                    SpatialPanel.this.getSelectedTabPage().setTabPageConnection(string);
                }
            } else if (this.objName != null && this.objName.length() > 0) {
                String string = this.objName;
                String string3 = "SELECT * FROM " + this.objName;
                String string4 = "";
                Color color = new Color(112, 112, 89);
                Color color2 = new Color(248, 249, 204);
                if (string.length() > 0) {
                    String[] stringArray = new String[]{};
                    QueryObject queryObject = new QueryObject(string, string3, color, color2, string4, stringArray);
                    queryObject.setConnectionSourceName(SpatialPanel.this.getSelectedTabPage().getCurrentConnectionName());
                    UUID uUID = SpatialPanel.this.getSelectedTabPage().getModel().getIdentifier();
                    queryObject.setTabIdentifier(uUID.toString());
                    queryObject.setNewlyCreated();
                    SpatialPanel.this.getSelectedTabPage().setConnectionAndInsertQuery(queryObject, queryObject.getConnectionSourceName(), false);
                }
            }
        }
    }

    class TabChangeListener
    implements ChangeListener {
        TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SpatialViewController.getInstance().setModelEnable(!SpatialPanel.this.getTableModel().getRowList().isEmpty());
            if (SpatialPanel.this.panelPositions.size() > SpatialPanel.this.lastTabIndex) {
                SpatialPanel.this.panelPositions.set(SpatialPanel.this.lastTabIndex, SpatialPanel.this.middleSplitPanel.getDividerLocation());
            }
            if (SpatialPanel.this._innerTabbedPane.getSelectedIndex() < SpatialPanel.this.imagePanels.size()) {
                SpatialPanel.this.middleSplitPanel.setLeftComponent((Component)SpatialPanel.this.imagePanels.get(SpatialPanel.this._innerTabbedPane.getSelectedIndex()));
                SpatialPanel.this.restorePanelAt(SpatialPanel.this._innerTabbedPane.getSelectedIndex());
                SpatialPanel.this.lastTabIndex = SpatialPanel.this._innerTabbedPane.getSelectedIndex();
                SpatialViewController.getInstance().toggleToolbar();
            }
        }
    }
}

