/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.spatial.tools.ISpatialTool;
import oracle.dbtools.spatial.tools.SpatialToolRegistry;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;

public class SpatialViewController
implements ActionListener,
ContextMenuListener {
    private boolean modelEnable = false;

    private SpatialViewController() {
    }

    public static synchronized SpatialViewController getInstance() {
        return SingletonHolder.instance;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void installToolbar(Toolbar toolbar) {
        List<String> list = SpatialToolRegistry.getTypes(0);
        for (String string : list) {
            ISpatialTool iSpatialTool = SpatialToolRegistry.getTool(string);
            IdeAction ideAction = iSpatialTool.getAction();
            ideAction.setEnabled(iSpatialTool.isEnabled());
            this.handleButton(ideAction, toolbar, iSpatialTool.isVisible());
        }
    }

    public void installVisualizationToolbar(Toolbar toolbar) {
        List<String> list = SpatialToolRegistry.getTypes(2);
        for (String string : list) {
            ISpatialTool iSpatialTool = SpatialToolRegistry.getTool(string);
            IdeAction ideAction = iSpatialTool.getAction();
            ideAction.setEnabled(iSpatialTool.isEnabled());
            this.handleButton(ideAction, toolbar, iSpatialTool.isVisible());
        }
    }

    public void installGeometryToolbar(Toolbar toolbar) {
        List<String> list = SpatialToolRegistry.getTypes(3);
        for (String string : list) {
            ISpatialTool iSpatialTool = SpatialToolRegistry.getTool(string);
            IdeAction ideAction = iSpatialTool.getAction();
            ideAction.setEnabled(iSpatialTool.isEnabled());
            this.handleButton(ideAction, toolbar, iSpatialTool.isVisible());
        }
    }

    public void toggleToolbar() {
        List<String> list = SpatialToolRegistry.getTypes();
        block4: for (String string : list) {
            ISpatialTool iSpatialTool = SpatialToolRegistry.getTool(string);
            if (iSpatialTool.isAlwaysEnabled()) continue;
            switch (iSpatialTool.getGroup()) {
                case 0: {
                    iSpatialTool.setEnabled(!SpatialUtil.getPanel().getSelectedModel().isEmpty());
                    continue block4;
                }
                case 2: {
                    iSpatialTool.setEnabled(!SpatialUtil.getPanel().getSelectedImgPanel().isImageNull());
                    continue block4;
                }
            }
            if (SpatialUtil.getPanel().getSelectedTabPage().isConnectionSet()) {
                if (iSpatialTool.getType().equals("DELETE_QUERY_LAYER")) {
                    if (SpatialUtil.getTableModel().getRowCount() > 0 && SpatialUtil.getTableModel().getSelectedRowCount() > 0) {
                        iSpatialTool.setEnabled(true);
                    } else {
                        iSpatialTool.setEnabled(false);
                    }
                }
                if (!iSpatialTool.getType().equals("REFRESH_QUERY_LAYER")) continue;
                if (SpatialUtil.getTableModel().getActiveItemList().size() > 0) {
                    iSpatialTool.setEnabled(true);
                    continue;
                }
                iSpatialTool.setEnabled(false);
                continue;
            }
            iSpatialTool.setEnabled(false);
        }
    }

    private void handleButton(IdeAction ideAction, Toolbar toolbar, boolean bl) {
        JComponent jComponent = (JComponent)ideAction.getValue("BUTTON");
        jComponent = toolbar.add((ToggleAction)ideAction);
        jComponent.setVisible(bl);
        jComponent.setName(ideAction.getValue("Name").toString());
        jComponent.setFocusable(true);
        ideAction.putValue("BUTTON", (Object)jComponent);
        UIUtils.setupAccelerator((IdeAction)ideAction, (String)"oracle/dbtools/spatial/accelerators.xml");
    }

    public void setModelEnable(boolean bl) {
        this.modelEnable = bl;
    }

    private static class SingletonHolder {
        public static final SpatialViewController instance = new SpatialViewController();

        private SingletonHolder() {
        }
    }
}

