/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.views.tables;

import java.awt.Color;
import java.util.List;

public class QueryObject
implements Comparable<QueryObject> {
    public static int DEFAULT_TYPE = 0;
    private static Color DEFAULT_LINE_COLOR = new Color(112, 112, 89);
    private static Color DEFAULT_FILL_COLOR = new Color(248, 249, 204);
    private static int DEFAULT_LAYER_NUMBER = -1;
    private int type = DEFAULT_TYPE;
    private String connectionSourceName;
    private boolean isConnectionOracle = true;
    private boolean isPreselected = true;
    private String queryTitle;
    private String queryText;
    private Color lineColor;
    private Color fillColor;
    private String notes;
    private String annotatedColumn;
    private int layerNumber;
    private int srid;
    private String[] candidateColumns;
    private String tabIdentifier;
    private boolean isNewlyCreated;
    private String newTitle;

    public QueryObject(String string, String string2, String[] stringArray) {
        this.queryTitle = string;
        this.queryText = string2;
        this.lineColor = DEFAULT_LINE_COLOR;
        this.fillColor = DEFAULT_FILL_COLOR;
        this.annotatedColumn = "";
        this.notes = "";
        this.layerNumber = DEFAULT_LAYER_NUMBER;
        this.candidateColumns = stringArray;
    }

    public QueryObject(String string, String string2, Color color, Color color2, String string3, String[] stringArray) {
        this.queryTitle = string;
        this.queryText = string2;
        this.lineColor = color;
        this.fillColor = color2;
        this.annotatedColumn = string3;
        this.notes = "";
        this.layerNumber = DEFAULT_LAYER_NUMBER;
        this.candidateColumns = stringArray;
    }

    public QueryObject(String string, String string2, Color color, Color color2, String string3, int n, String string4) {
        this.queryTitle = string;
        this.queryText = string2;
        this.lineColor = color;
        this.fillColor = color2;
        this.annotatedColumn = string3;
        this.notes = "";
        this.layerNumber = DEFAULT_LAYER_NUMBER;
        this.layerNumber = n;
        this.tabIdentifier = string4;
    }

    public String getNewTitle() {
        return this.newTitle;
    }

    public void setNewTitle(String string) {
        this.newTitle = string;
    }

    public String[] getCandidateAnnotation() {
        return this.candidateColumns;
    }

    public void setCandidateColumns(String[] stringArray) {
        this.candidateColumns = stringArray;
    }

    public int getType() {
        return this.type;
    }

    public boolean isConnectionOracle() {
        return this.isConnectionOracle;
    }

    public String getConnectionSourceName() {
        return this.connectionSourceName;
    }

    public void setConnectionSourceName(String string) {
        this.connectionSourceName = string;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public void setQueryText(String string) {
        this.queryText = string;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public int getLayerNumber() {
        return this.layerNumber;
    }

    public void setQueryTitle(String string) {
        this.queryTitle = string;
    }

    public String getQueryTitle() {
        return this.queryTitle;
    }

    public boolean isInList(List<QueryObject> list) {
        for (QueryObject queryObject : list) {
            if (!this.equals(queryObject)) continue;
            return true;
        }
        return false;
    }

    public void setPreselected(boolean bl) {
        this.isPreselected = bl;
    }

    public boolean isPreselected() {
        return this.isPreselected;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setLayerNumber(int n) {
        this.layerNumber = n;
    }

    public void setLineStyle(Color color) {
        this.lineColor = color;
    }

    public void setAnnotatedColumn(String string) {
        this.annotatedColumn = string;
    }

    public String getAnnotatedColumn() {
        return this.annotatedColumn;
    }

    public String getTabIdentifier() {
        return this.tabIdentifier;
    }

    public void setTabIdentifier(String string) {
        this.tabIdentifier = string;
    }

    public int getSRID() {
        return this.srid;
    }

    public void setSRID(int n) {
        this.srid = n;
    }

    public void setNewlyCreated() {
        this.isNewlyCreated = true;
    }

    public boolean isUserCreated() {
        return this.isNewlyCreated;
    }

    public void printInfo() {
        System.out.println("Name: " + this.getQueryTitle());
        System.out.println("NewName: " + this.getNewTitle());
        System.out.println("Query: " + this.getQueryText());
        System.out.println("Annot: " + this.getAnnotatedColumn());
        System.out.println("Layer: " + this.getLayerNumber());
        System.out.println("******************************");
    }

    @Override
    public int compareTo(QueryObject queryObject) {
        return Integer.valueOf(this.layerNumber).compareTo(queryObject.getLayerNumber());
    }
}

