/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.views.tables;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.ui.table.ListReorderableTableModel;
import oracle.dbtools.raptor.ui.table.ListReorderableTableWithTitleBar;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.spatial.mapviewer.components.MapGeometry;
import oracle.dbtools.spatial.mapviewer.components.MapViewerGeometryResultSet;
import oracle.dbtools.spatial.tools.ISpatialTool;
import oracle.dbtools.spatial.tools.SpatialAddGeomQuery;
import oracle.dbtools.spatial.tools.SpatialToolRegistry;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.spatial.views.SpatialViewController;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.dbtools.spatial.views.tables.SpatialListReorderableTableWithTitleBar;
import oracle.dbtools.spatial.views.tables.SpatialReorderableTableModel;
import oracle.dbtools.spatial.views.tables.SpatialTabPanel;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.javatools.db.DBException;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;

public class SpatialListReorderableTableWithTitleBar<T>
extends ListReorderableTableWithTitleBar<T> {
    private static final long serialVersionUID = 1L;
    private SpatialReorderableTableModel _model;
    private SpatialTabPanel _tabPanel;
    private String _tabLabel;
    Toolbar geomToolbar;
    SpatialDBConnectionCombobox databaseSelector;
    private String currentlySelectedConnection;
    private String previousRaptorCnx;
    private boolean raptorTaskResult;

    public SpatialListReorderableTableWithTitleBar(ListReorderableTableModel<T> listReorderableTableModel, String string) {
        super(listReorderableTableModel);
        this._model = (SpatialReorderableTableModel)listReorderableTableModel;
        this._tabLabel = string;
        this._tabPanel.setTabLabel(this._tabLabel);
    }

    public void initTablePanel() {
        super.initTablePanel();
        TableToolbar tableToolbar = this.getReorderableTableWithTitleBar().getTableToolbar();
        tableToolbar.removeAll();
        tableToolbar.setAddVisible(true);
        this.geomToolbar = new Toolbar();
        SpatialViewController.getInstance().installGeometryToolbar(this.geomToolbar);
        tableToolbar.add((Component)this.geomToolbar, (Object)"Before");
        this.databaseSelector = new SpatialDBConnectionCombobox();
        this.databaseSelector.getJComboBox().setSelectedIndex(-1);
        JComboBox jComboBox = this.databaseSelector.getJComboBox();
        tableToolbar.add((Component)jComboBox, (Object)"After");
        ((SpatialReorderableTableModel)super.getListTableModel()).setToolbar(tableToolbar);
        ReorderableTableWithTitleBar reorderableTableWithTitleBar = this.getReorderableTableWithTitleBar();
        this._tabPanel = new SpatialTabPanel(reorderableTableWithTitleBar);
    }

    public void setConnectionAndInsertQuery(QueryObject queryObject, String string, boolean bl) {
        if (bl) {
            this.databaseSelector.setCurrentConnectionAndInsertQuery(string, queryObject, bl);
        } else {
            this.databaseSelector.setCurrentConnectionAndInsertQuery(string, queryObject);
        }
    }

    public void setTabPageConnection(String string) {
        this.databaseSelector.setCurrentConnection(string);
    }

    public void setConnectionAndReturnToTool(String string, ISpatialTool iSpatialTool) {
        this.databaseSelector.setCurrentConnectionAndDo(string, iSpatialTool);
    }

    public SpatialTabPanel getTabPanel() {
        return this._tabPanel;
    }

    public SpatialReorderableTableModel getModel() {
        return this._model;
    }

    public String getTabLabel() {
        return this._tabLabel;
    }

    public void setTabLabel(String string) {
        this._tabPanel.setTabLabel(string);
    }

    public Toolbar getToolbar() {
        return this.geomToolbar;
    }

    public synchronized boolean isConnectionSet() {
        MapViewerGeometryResultSet mapViewerGeometryResultSet = this.getModel().getMapViewerResultSet();
        if (mapViewerGeometryResultSet.getDatabaseConnection() != null && this.raptorTaskResult) {
            return true;
        }
        mapViewerGeometryResultSet.setDatabaseConnection(null);
        this.raptorTaskResult = false;
        return false;
    }

    public String getCurrentConnectionName() {
        return this.databaseSelector.getCurrentConnectionName();
    }

    public boolean setGridPreferredConnection(String string) {
        if (string != null && string.length() > 0) {
            try {
                Connection connection = Connections.getInstance().getConnection(string);
                MapViewerGeometryResultSet mapViewerGeometryResultSet = this.getModel().getMapViewerResultSet();
                mapViewerGeometryResultSet.setDatabaseConnection(connection);
            }
            catch (DBException dBException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                this.disconnect();
                return false;
            }
        }
        return true;
    }

    public DBConnectionComboBox getCombobox() {
        return this.databaseSelector;
    }

    public void disconnect() {
        this.getModel().getMapViewerResultSet().setDatabaseConnection(null);
        this.getModel().setEditable(false);
        this.databaseSelector.disconnect();
    }

    class SpatialDBConnectionCombobox
    extends DBConnectionComboBox {
        RaptorTaskAdapter onTaskFinished;
        private RaptorTask<Object> setTableConnection;
        private RaptorTask<Object> prepareAndInsertObject;
        private RaptorTask<Object> returnTotool;
        private int preparedSrid;
        private String[] preparedCandidates;
        private String queryText;
        private boolean drawAfterInsert;
        oracle.dbtools.spatial.views.tables.SpatialListReorderableTableWithTitleBar$SpatialDBConnectionCombobox.SimpleInsertor insertAfter;
        oracle.dbtools.spatial.views.tables.SpatialListReorderableTableWithTitleBar$SpatialDBConnectionCombobox.DelayedInsertor waintAndInsertAfter;
        ISpatialTool whereToReturn;

        public SpatialDBConnectionCombobox() {
            this.returnTotool = new RaptorTask<Object>("Returning to tool", true, IRaptorTaskRunMode.IDE_STATUSBAR){

                protected Object doWork() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SpatialDBConnectionCombobox.this.whereToReturn != null) {
                                IdeAction ideAction = SpatialToolRegistry.getTool(SpatialDBConnectionCombobox.this.whereToReturn.getType()).getAction();
                                SpatialAddGeomQuery spatialAddGeomQuery = (SpatialAddGeomQuery)SpatialToolRegistry.getTool(SpatialDBConnectionCombobox.this.whereToReturn.getType());
                                spatialAddGeomQuery.handleEvent(ideAction, Context.newIdeContext());
                            }
                            SpatialDBConnectionCombobox.this.whereToReturn = null;
                        }
                    });
                    return null;
                }
            };
            this.setTableConnection = new RaptorTask<Object>("Setting connection", true, IRaptorTaskRunMode.IDE_STATUSBAR){

                protected Object doWork() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SpatialListReorderableTableWithTitleBar.this.getModel().setEditable(false);
                            SpatialListReorderableTableWithTitleBar.this.raptorTaskResult = SpatialListReorderableTableWithTitleBar.this.setGridPreferredConnection(SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection);
                            if (SpatialListReorderableTableWithTitleBar.this.raptorTaskResult) {
                                SpatialListReorderableTableWithTitleBar.this.getModel().removeAll();
                                SpatialListReorderableTableWithTitleBar.this.getModel().setEditable(true);
                                SpatialListReorderableTableWithTitleBar.this.getModel().toggleActiveConnectionHistory(SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection);
                                SpatialListReorderableTableWithTitleBar.this.getModel().replaceHistoryTask(SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection);
                            }
                            SpatialViewController.getInstance().toggleToolbar();
                        }
                    });
                    return null;
                }
            };
            this.prepareAndInsertObject = new RaptorTask<Object>("Setting up query object", true, IRaptorTaskRunMode.IDE_STATUSBAR){

                protected Object doWork() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SpatialDBConnectionCombobox.access$302(SpatialDBConnectionCombobox.this, SpatialListReorderableTableWithTitleBar.this.getModel().getMapViewerResultSet().getColumnNames(SpatialDBConnectionCombobox.this.queryText));
                            Vector<Integer[]> vector = SpatialListReorderableTableWithTitleBar.this.getModel().getMapViewerResultSet().getQuerySRIDS(SpatialDBConnectionCombobox.this.queryText);
                            boolean bl = false;
                            SpatialDBConnectionCombobox.this.preparedSrid = -1;
                            if (vector != null) {
                                Integer[] integerArray = vector.get(0);
                                bl = SpatialListReorderableTableWithTitleBar.this.getModel().getMapViewerResultSet().isSRIDUnique(integerArray[0], vector);
                                if (bl) {
                                    SpatialDBConnectionCombobox.this.preparedSrid = integerArray[0];
                                }
                            }
                        }
                    });
                    return null;
                }
            };
            this.setTableConnection.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    SpatialUtil.getTableModel().setEditable(false);
                    SpatialViewController.getInstance().toggleToolbar();
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
                    if (SpatialListReorderableTableWithTitleBar.this.previousRaptorCnx == null) {
                        SpatialListReorderableTableWithTitleBar.this.databaseSelector.getJComboBox().setSelectedIndex(-1);
                    } else {
                        SpatialListReorderableTableWithTitleBar.this.databaseSelector.setCurrentConnection(SpatialListReorderableTableWithTitleBar.this.previousRaptorCnx);
                    }
                }

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    SpatialViewController.getInstance().toggleToolbar();
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
                    if (SpatialListReorderableTableWithTitleBar.this.previousRaptorCnx == null) {
                        SpatialListReorderableTableWithTitleBar.this.databaseSelector.getJComboBox().setSelectedIndex(-1);
                    } else {
                        SpatialListReorderableTableWithTitleBar.this.databaseSelector.setCurrentConnection(SpatialListReorderableTableWithTitleBar.this.previousRaptorCnx);
                    }
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SpatialListReorderableTableWithTitleBar.this.isConnectionSet()) {
                                SpatialListReorderableTableWithTitleBar.this.previousRaptorCnx = SpatialListReorderableTableWithTitleBar.this.databaseSelector.getCurrentConnectionName();
                            }
                            SpatialViewController.getInstance().toggleToolbar();
                        }
                    });
                }
            });
            this.getJComboBox().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    int n = itemEvent.getStateChange();
                    if (n == 1) {
                        String string = (String)itemEvent.getItem();
                        SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection = string;
                        if (SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection != null && SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection.length() > 0) {
                            RaptorTaskManager.getInstance().addTask(SpatialDBConnectionCombobox.this.setTableConnection);
                        }
                    }
                }
            });
        }

        public RaptorTask getTask() {
            return this.setTableConnection;
        }

        public void addConnection(String string) {
            if (Connections.getInstance().isOracle(string)) {
                SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection = string;
                super.addConnection(string);
                this.setCurrentConnection(string);
            }
        }

        public void setCurrentConnectionAndDo(String string, ISpatialTool iSpatialTool) {
            if (iSpatialTool != null) {
                this.whereToReturn = iSpatialTool;
                this.setTableConnection.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (SpatialListReorderableTableWithTitleBar.this.isConnectionSet() && SpatialDBConnectionCombobox.this.whereToReturn != null) {
                                    RaptorTaskManager.getInstance().addTask(SpatialDBConnectionCombobox.this.returnTotool);
                                }
                                SpatialViewController.getInstance().toggleToolbar();
                            }
                        });
                    }
                });
            }
            this.addConnection(string);
        }

        public void setCurrentConnectionAndInsertQuery(String string, QueryObject queryObject) {
            this.insertAfter = new SimpleInsertor(queryObject);
            this.queryText = queryObject.getQueryText();
            this.prepareAndInsertObject.getDescriptor().addListener((IRaptorTaskListener)this.insertAfter);
            if (this.getCurrentConnectionName().equals(string)) {
                RaptorTaskManager.getInstance().addTask(this.prepareAndInsertObject);
            } else {
                this.waintAndInsertAfter = new DelayedInsertor();
                this.setTableConnection.getDescriptor().addListener((IRaptorTaskListener)this.waintAndInsertAfter);
                super.setCurrentConnection(string);
            }
        }

        public void setCurrentConnectionAndInsertQuery(String string, QueryObject queryObject, boolean bl) {
            this.insertAfter = new SimpleInsertor(queryObject);
            this.queryText = queryObject.getQueryText();
            this.prepareAndInsertObject.getDescriptor().addListener((IRaptorTaskListener)this.insertAfter);
            if (bl) {
                int n = SpatialUtil.getTableModel().getRowCount();
                for (int i = 0; i < n; ++i) {
                    SpatialUtil.getTableModel().setValueAt(false, i, 0);
                }
                this.drawAfterInsert = true;
            }
            if (this.getCurrentConnectionName().equals(string)) {
                RaptorTaskManager.getInstance().addTask(this.prepareAndInsertObject);
            } else {
                this.waintAndInsertAfter = new DelayedInsertor();
                this.setTableConnection.getDescriptor().addListener((IRaptorTaskListener)this.waintAndInsertAfter);
                super.setCurrentConnection(string);
            }
        }

        private void disconnect() {
            this.setCurrentConnection(null);
        }

        static /* synthetic */ String[] access$302(SpatialDBConnectionCombobox spatialDBConnectionCombobox, String[] stringArray) {
            spatialDBConnectionCombobox.preparedCandidates = stringArray;
            return stringArray;
        }

        class DelayedInsertor
        extends RaptorTaskAdapter {
            DelayedInsertor() {
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialDBConnectionCombobox.this.setTableConnection.getDescriptor().removeListener((IRaptorTaskListener)SpatialDBConnectionCombobox.this.waintAndInsertAfter);
                    }
                });
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialDBConnectionCombobox.this.setTableConnection.getDescriptor().removeListener((IRaptorTaskListener)SpatialDBConnectionCombobox.this.waintAndInsertAfter);
                    }
                });
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialDBConnectionCombobox.this.setTableConnection.getDescriptor().removeListener((IRaptorTaskListener)SpatialDBConnectionCombobox.this.waintAndInsertAfter);
                        RaptorTaskManager.getInstance().addTask(SpatialDBConnectionCombobox.this.prepareAndInsertObject);
                    }
                });
            }
        }

        class SimpleInsertor
        extends RaptorTaskAdapter {
            private QueryObject theObject = null;

            public SimpleInsertor(QueryObject queryObject) {
                this.theObject = queryObject;
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialDBConnectionCombobox.this.prepareAndInsertObject.getDescriptor().removeListener((IRaptorTaskListener)SpatialDBConnectionCombobox.this.insertAfter);
                    }
                });
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialDBConnectionCombobox.this.prepareAndInsertObject.getDescriptor().removeListener((IRaptorTaskListener)SpatialDBConnectionCombobox.this.insertAfter);
                    }
                });
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialDBConnectionCombobox.this.prepareAndInsertObject.getDescriptor().removeListener((IRaptorTaskListener)SpatialDBConnectionCombobox.this.insertAfter);
                        SimpleInsertor.this.theObject.setSRID(SpatialDBConnectionCombobox.this.preparedSrid);
                        SimpleInsertor.this.theObject.setCandidateColumns(SpatialDBConnectionCombobox.this.preparedCandidates);
                        SimpleInsertor.this.theObject.setLayerNumber(SpatialListReorderableTableWithTitleBar.this.getModel().getRowCount());
                        SpatialListReorderableTableWithTitleBar.this.getModel().addRow(SimpleInsertor.this.theObject);
                        SpatialDBConnectionCombobox.access$302(SpatialDBConnectionCombobox.this, new String[0]);
                        SpatialDBConnectionCombobox.this.preparedSrid = -1;
                        SpatialDBConnectionCombobox.this.queryText = "";
                        if (SpatialDBConnectionCombobox.this.drawAfterInsert) {
                            SpatialDBConnectionCombobox.this.drawAfterInsert = false;
                            MapGeometry[] mapGeometryArray = SpatialUtil.getTableModel().queryAllGeometries(false);
                            SpatialUtil.getPanel().getSelectedImgPanel().setHighlighted(null);
                            SpatialUtil.getPanel().getSelectedImgPanel().refreshMaps(mapGeometryArray);
                        }
                        SpatialUtil.getTableModel().setEditable(true);
                        SpatialViewController.getInstance().toggleToolbar();
                    }
                });
            }
        }
    }
}

