/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.views.tables;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.SquareIconButton;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditor;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorFactory;
import oracle.dbtools.raptor.ui.table.ListReorderableTableModel;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.components.AnnotatedGeometry;
import oracle.dbtools.spatial.mapviewer.components.MapGeometry;
import oracle.dbtools.spatial.mapviewer.components.MapGeometryCache;
import oracle.dbtools.spatial.mapviewer.components.MapViewerGeometryResultSet;
import oracle.dbtools.spatial.persistence.QueryHistoryManager;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.spatial.views.SpatialViewController;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.TableToolbar;

public class SpatialReorderableTableModel
extends ListReorderableTableModel<QueryObject> {
    private static final long serialVersionUID = 1L;
    private static final String[] cols = new String[]{SpatialArb.getString("SPATIAL_TABLE_ACTIVE"), SpatialArb.getString("SPATIAL_TABLE_MAP_TITLE"), SpatialArb.getString("SPATIAL_TABLE_SQL_SENTENCE"), SpatialArb.getString("SPATIAL_TABLE_ANNOTATION"), SpatialArb.getString("SPATIAL_TABLE_LINE"), SpatialArb.getString("SPATIAL_TABLE_LINE_STYLE"), SpatialArb.getString("SPATIAL_TABLE_FILL")};
    private static final String[] ttps = new String[]{SpatialArb.getString("SPATIAL_TABLE_ACTIVE_TTP"), SpatialArb.getString("SPATIAL_TABLE_MAP_TITLE_TTP"), SpatialArb.getString("SPATIAL_TABLE_SQL_SENTENCE_TTP"), SpatialArb.getString("SPATIAL_TABLE_ANNOTATION_TTP"), SpatialArb.getString("SPATIAL_TABLE_LINE_TTP"), SpatialArb.getString("SPATIAL_TABLE_LINE_STYLE_TTP"), SpatialArb.getString("SPATIAL_TABLE_FILL_TTP")};
    private static final int ACTIVE = 0;
    private static final int NAME = 1;
    private static final int FILL = 6;
    private static final int LINE = 4;
    private static final int LINE_STY = 5;
    private static final int ANNOTATION = 3;
    private static final int SQL_SENTENCE = 2;
    private TableToolbar _toolbar;
    private GenericTable _table;
    MapGeometry[] currentGeometries = null;
    MapGeometryCache mapCache;
    private MapViewerGeometryResultSet mvResultSet;
    private QueryHistoryManager historyManager;
    private boolean restorationOk = true;
    private QueryObject[] restoredObjects;
    private String rTabId;
    private String rQCnx;
    private UUID modelId;

    public SpatialReorderableTableModel() {
        super(cols, ttps);
        this.setRowList(new ArrayList());
        this.mapCache = new MapGeometryCache();
        this.mvResultSet = new MapViewerGeometryResultSet();
        this.historyManager = new QueryHistoryManager();
        this.modelId = UUID.randomUUID();
    }

    public SpatialReorderableTableModel(UUID uUID) {
        super(cols, ttps);
        this.setRowList(new ArrayList());
        this.mapCache = new MapGeometryCache();
        this.mvResultSet = new MapViewerGeometryResultSet();
        this.historyManager = new QueryHistoryManager();
        this.modelId = uUID;
    }

    public void setToolbar(TableToolbar tableToolbar) {
        this._toolbar = tableToolbar;
    }

    public void setTable(JTable jTable) {
        super.setTable(jTable);
        this._table = (GenericTable)jTable;
        this.setEditable(true);
        jTable.setSurrendersFocusOnKeystroke(true);
        jTable.setSelectionMode(2);
        jTable.setCellSelectionEnabled(false);
        jTable.setRowSelectionAllowed(true);
        if (jTable instanceof GenericTable) {
            GenericTable genericTable = (GenericTable)jTable;
            genericTable.setSelectAllEnabled(true);
            genericTable.setColumnSelectorAvailable(true);
        }
        jTable.getColumnModel().getColumn(4).setCellRenderer(new ColorCellRenderer());
        jTable.getColumnModel().getColumn(4).setCellEditor(new ColorCellEditor());
        jTable.getColumnModel().getColumn(6).setCellRenderer(new ColorCellRenderer());
        jTable.getColumnModel().getColumn(6).setCellEditor(new ColorCellEditor());
        jTable.getColumnModel().getColumn(5).setCellRenderer(new ColorCellRenderer());
        jTable.getColumnModel().removeColumn(jTable.getColumnModel().getColumn(5));
        jTable.getColumnModel().getColumn(2).setCellEditor(new QueryCellEditor());
        jTable.getColumnModel().getColumn(3).setCellEditor(new AnnotationCellEditor());
        jTable.getColumnModel().getColumn(1).setCellEditor(new TitleCellEditor());
    }

    protected Object getValueAt(QueryObject queryObject, int n) {
        switch (n) {
            case 0: {
                SpatialViewController.getInstance().toggleToolbar();
                return queryObject.isPreselected();
            }
            case 1: {
                return queryObject.getQueryTitle();
            }
            case 6: {
                return queryObject.getFillColor();
            }
            case 4: {
                return queryObject.getLineColor();
            }
            case 5: {
                return queryObject.getLineColor();
            }
            case 3: {
                return queryObject.getAnnotatedColumn();
            }
            case 2: {
                return queryObject.getQueryText();
            }
        }
        return null;
    }

    protected void setValueAt(Object object, QueryObject queryObject, int n) {
        switch (n) {
            case 0: {
                this.historyManager.deleteRecord(queryObject);
                queryObject.setPreselected((Boolean)object);
                this.historyManager.addRecord(queryObject);
                break;
            }
            case 1: {
                this.historyManager.deleteRecord(queryObject);
                queryObject.setQueryTitle((String)object);
                this.historyManager.addRecord(queryObject);
                break;
            }
            case 2: {
                this.historyManager.deleteRecord(queryObject);
                queryObject.setQueryText((String)object);
                this.historyManager.addRecord(queryObject);
                break;
            }
            case 6: {
                this.historyManager.deleteRecord(queryObject);
                queryObject.setFillColor((Color)object);
                this.historyManager.addRecord(queryObject);
                break;
            }
            case 5: {
                this.historyManager.deleteRecord(queryObject);
                queryObject.setLineStyle((Color)object);
                this.historyManager.addRecord(queryObject);
                break;
            }
            case 3: {
                this.historyManager.deleteRecord(queryObject);
                queryObject.setAnnotatedColumn((String)object);
                this.historyManager.addRecord(queryObject);
                break;
            }
            case 4: {
                this.historyManager.deleteRecord(queryObject);
                queryObject.setLineColor((Color)object);
                this.historyManager.addRecord(queryObject);
                break;
            }
        }
    }

    protected boolean isCellEditable(QueryObject queryObject, int n) {
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 6: {
                return true;
            }
            case 5: {
                return false;
            }
            case 3: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    public QueryObject getRow(int n) {
        List list = this.getRowList();
        for (QueryObject queryObject : list) {
            if (queryObject.getType() != n) continue;
            return queryObject;
        }
        return null;
    }

    public List<QueryObject> addRow(QueryObject queryObject) {
        ArrayList<QueryObject> arrayList;
        Object[] objectArray = new Object[1];
        if (!(queryObject = this.getUniqueTitle(queryObject)).isInList(arrayList = new ArrayList<QueryObject>(this.getRowList())) && this.getIdentifier().toString().equals(queryObject.getTabIdentifier())) {
            queryObject.setLayerNumber(this.getRowList().size());
            objectArray[0] = queryObject;
            super.addRow(objectArray);
            this.historyManager.addRecord((QueryObject)objectArray[0]);
        }
        return this.getRowList();
    }

    public boolean isEmpty() {
        return this._rowList.isEmpty();
    }

    private synchronized QueryObject getUniqueTitle(QueryObject queryObject) {
        String string;
        boolean bl = true;
        int n = 0;
        String string2 = string = queryObject.getQueryTitle();
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.getRowList();
        for (QueryObject queryObject2 : list) {
            arrayList.add(queryObject2.getQueryTitle());
        }
        bl = arrayList.contains(queryObject.getQueryTitle());
        while (bl) {
            string2 = string + "_" + n;
            bl = arrayList.contains(string2);
            ++n;
        }
        queryObject.setNewTitle(string2);
        queryObject.setQueryTitle(string2);
        return queryObject;
    }

    private synchronized boolean isTitleInTable(String string) {
        List list = this.getRowList();
        for (QueryObject queryObject : list) {
            if (!queryObject.getQueryTitle().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void removeRow(int n) {
        List list = this.getRowList();
        QueryObject queryObject = (QueryObject)list.get(n);
        this.historyManager.deleteRecord(queryObject);
        super.removeRow(n);
    }

    public void moveRow(int n, int n2, int n3) {
        super.moveRow(n, n2, n3);
        List list = this.getRowList();
        for (int i = 0; i < list.size(); ++i) {
            QueryObject queryObject = (QueryObject)list.get(i);
            this.historyManager.deleteRecord(queryObject);
            queryObject.setLayerNumber(i);
            this.historyManager.addRecord(queryObject);
        }
    }

    public void removeAll() {
        super.removeAll();
    }

    public boolean isSaved() {
        return false;
    }

    public String getSaveAs() {
        return "save.file";
    }

    public void setSaveAs(String string) {
    }

    public void setSaveAsEnconding(String string) {
    }

    public synchronized MapGeometry[] queryAllGeometries(boolean bl) {
        Vector<MapGeometry> vector = new Vector<MapGeometry>();
        CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList(this.getRowList());
        for (QueryObject queryObject : copyOnWriteArrayList) {
            String string = queryObject.getQueryText();
            Color color = queryObject.getLineColor();
            Color color2 = queryObject.getFillColor();
            String string2 = queryObject.getAnnotatedColumn();
            boolean bl2 = bl ? true : queryObject.isPreselected();
            int n = queryObject.getLayerNumber();
            if (!this.mvResultSet.isValidSpatialQuery(string)) {
                string = null;
            }
            if (string == null || !bl2) continue;
            try {
                this.mvResultSet.setQuery(string);
                AnnotatedGeometry[] annotatedGeometryArray = this.mvResultSet.getGeometryObjects();
                if (annotatedGeometryArray == null || annotatedGeometryArray.length <= 0) continue;
                for (int i = 0; i < annotatedGeometryArray.length; ++i) {
                    if (annotatedGeometryArray[i] == null) continue;
                    MapGeometry mapGeometry = new MapGeometry(string, color, color2, annotatedGeometryArray, string2, n);
                    vector.add(mapGeometry);
                }
            }
            catch (Exception exception) {
                vector = null;
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Error generating map: " + exception.getMessage()), (String)"", null);
            }
        }
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new MapGeometry[vector.size()];
        vector.copyInto(objectArray);
        Arrays.sort(objectArray);
        vector = null;
        this.mapCache.setMapCache((MapGeometry[])objectArray);
        this.setCurrentGeometries((MapGeometry[])objectArray);
        return objectArray;
    }

    public MapGeometry[] getCurrentGeometries() {
        return this.currentGeometries;
    }

    public void setCurrentGeometries(MapGeometry[] mapGeometryArray) {
        this.currentGeometries = mapGeometryArray;
    }

    public MapGeometryCache getGeometryCache() {
        return this.mapCache;
    }

    public MapViewerGeometryResultSet getMapViewerResultSet() {
        return this.mvResultSet;
    }

    private QueryObject[] getQueryObjectsFromHistoryEasy(String string, String string2) {
        QueryObject[] queryObjectArray = this.historyManager.getQueryObjectsFromTab(string, string2);
        if (queryObjectArray != null && queryObjectArray.length > 0) {
            Connection connection = this.mvResultSet.getDatabaseConnection();
            if (connection != null) {
                for (QueryObject queryObject : queryObjectArray) {
                    String[] stringArray = this.mvResultSet.getColumnNames(queryObject.getQueryText());
                    if (stringArray == null || stringArray.length <= 0) continue;
                    queryObject.setCandidateColumns(stringArray);
                }
                this.restorationOk = true;
            } else {
                this.restorationOk = false;
            }
        }
        return queryObjectArray;
    }

    public List<QueryObject> getActiveItemList() {
        List list = this.getRowList();
        ArrayList<QueryObject> arrayList = new ArrayList<QueryObject>();
        for (QueryObject queryObject : list) {
            if (!queryObject.isPreselected()) continue;
            arrayList.add(queryObject);
        }
        return arrayList;
    }

    public UUID getIdentifier() {
        return this.modelId;
    }

    public boolean didRestorationWentOk() {
        return this.restorationOk;
    }

    public void eraseTabHistory(String string) {
        this.historyManager.deleteAllTabRecords(string);
    }

    public void replaceHistoryTask(String string) {
        this.rTabId = this.getIdentifier().toString();
        this.rQCnx = string;
        this.removeAll();
        SpatialUtil.getPanel().getSelectedImgPanel().removeImageFromPanel();
        this.restoredObjects = this.getQueryObjectsFromHistoryEasy(this.rTabId, this.rQCnx);
        if (this.restoredObjects != null && this.restoredObjects.length > 0) {
            Arrays.sort(this.restoredObjects);
            this.restoreHistory(this.restoredObjects);
        }
    }

    private void restoreHistory(QueryObject[] queryObjectArray) {
        if (queryObjectArray.length > 0 && queryObjectArray != null) {
            Arrays.sort(queryObjectArray);
        }
        this.setRowList(Arrays.asList(queryObjectArray));
    }

    public void saveTabInSession(String string) {
        this.historyManager.addTabRecord(this.getIdentifier().toString(), string);
    }

    public void toggleActiveConnectionHistory(String string) {
        this.historyManager.toggleActiveConnectionInTab(this.getIdentifier().toString(), string);
    }

    class AnnotationCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        String annotatedColumn;
        JComboBox columnBox;
        String[] columns;

        AnnotationCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.annotatedColumn;
            this.annotatedColumn = null;
            return string;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Object object2;
            this.annotatedColumn = "";
            List list = SpatialReorderableTableModel.this.getRowList();
            Object e = list.get(n);
            if (e instanceof QueryObject) {
                object2 = (QueryObject)e;
                this.columns = ((QueryObject)object2).getCandidateAnnotation();
            }
            this.columnBox = new JComboBox(new DefaultComboBoxModel());
            if (this.columns != null && this.columns.length > 0) {
                this.columnBox.setModel(new DefaultComboBoxModel<String>(this.columns));
            }
            this.columnBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AnnotationCellEditor.this.annotatedColumn = (String)AnnotationCellEditor.this.columnBox.getSelectedItem();
                    if (AnnotationCellEditor.this.annotatedColumn == null) {
                        AnnotationCellEditor.this.annotatedColumn = "";
                    }
                }
            });
            object2 = new JPanel(new BorderLayout());
            ((Container)object2).add(this.columnBox);
            return object2;
        }
    }

    class QueryCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        String revisitedQuery;
        JLabel holdingLabel;
        String prevQuery;
        PopupCellEditor popupEditor;
        JButton editBtn;
        JTable theTable;

        QueryCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            int n = SpatialReorderableTableModel.this.getTable().getEditingRow();
            String string = ((QueryObject)SpatialReorderableTableModel.this.getRowList().get(n)).getQueryText();
            if (SpatialReorderableTableModel.this.mvResultSet.isValidSpatialQuery(this.revisitedQuery)) {
                String[] stringArray = SpatialReorderableTableModel.this.mvResultSet.getColumnNames(this.revisitedQuery);
                ((QueryObject)SpatialReorderableTableModel.this.getRowList().get(n)).setCandidateColumns(stringArray);
                String string2 = this.revisitedQuery;
                this.revisitedQuery = null;
                return string2;
            }
            if (this.revisitedQuery != null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)SpatialArb.getString("SPATIAL_NEW_QUERY_DLG_ERR_TEXT"), (String)"", null);
                this.revisitedQuery = null;
            }
            return string;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.prevQuery = object.toString();
            this.holdingLabel = new JLabel(this.prevQuery);
            String string = (String)SpatialUtil.getPanel().getSelectedTabPage().getCombobox().getJComboBox().getSelectedItem();
            this.popupEditor = PopupCellEditorFactory.getPopupCellEditor((String)string, (int)12);
            this.popupEditor.setConnection(SpatialReorderableTableModel.this.mvResultSet.getDatabaseConnection());
            this.popupEditor.setEditable(true);
            this.popupEditor.setValue((Object)this.prevQuery);
            this.editBtn = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
            this.editBtn.setName("EditCell");
            this.editBtn.setMargin(new Insets(2, 2, 2, 2));
            this.editBtn.setFocusable(true);
            this.editBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    QueryCellEditor.this.popupEditor.setValue((Object)QueryCellEditor.this.prevQuery);
                    QueryCellEditor.this.handlePopupEdit(QueryCellEditor.this.popupEditor);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (QueryCellEditor.this.theTable.isVisible()) {
                                QueryCellEditor.this.theTable.requestFocusInWindow();
                            }
                        }
                    });
                }
            });
            this.theTable = jTable;
            JPanel jPanel = new JPanel(new BorderLayout()){
                private static final long serialVersionUID = 1L;

                @Override
                public void requestFocus() {
                    QueryCellEditor.this.editBtn.requestFocusInWindow();
                    if (QueryCellEditor.this.editBtn.isFocusOwner()) {
                        QueryCellEditor.this.editBtn.doClick();
                    }
                }
            };
            jPanel.add("Center", this.holdingLabel);
            jPanel.add("After", this.editBtn);
            this.holdingLabel.setText(this.prevQuery);
            return jPanel;
        }

        public void handlePopupEdit(final PopupCellEditor popupCellEditor) {
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)popupCellEditor.getComponent(), (Component)popupCellEditor.getDefaultComponent(), (String)"Edit query");
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                        String string = popupCellEditor.validateValue();
                        String string2 = (String)popupCellEditor.getValue();
                        if (string == null) {
                            QueryCellEditor.this.revisitedQuery = QueryCellEditor.this.stripSemicolon(string2);
                            QueryCellEditor.this.stopCellEditing();
                        } else {
                            QueryCellEditor.this.cancelCellEditing();
                        }
                    }
                }
            });
            jEWTDialog.setOKButtonEnabled(true);
            popupCellEditor.setPopupDialog(jEWTDialog);
            WizardLauncher.runDialog((JDialog)jEWTDialog);
            popupCellEditor.dismissPopupEditor();
            SpatialReorderableTableModel.this._table.requestFocusInWindow();
        }

        private String stripSemicolon(String string) {
            int n = string.length();
            if (string.lastIndexOf(59) == n - 1) {
                return string.substring(0, n);
            }
            return string;
        }
    }

    class TitleCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        String revisitedTitle;
        JPanel holdingPanel;
        JTextField holdingTextField = new JTextField();
        String prevTitle;

        public TitleCellEditor() {
            this.holdingPanel = new JPanel(new BorderLayout()){

                @Override
                public void requestFocus() {
                    TitleCellEditor.this.holdingTextField.requestFocus();
                }
            };
        }

        @Override
        public Object getCellEditorValue() {
            this.revisitedTitle = this.holdingTextField.getText().trim();
            if (this.revisitedTitle == "" || this.revisitedTitle.length() == 0) {
                this.revisitedTitle = this.prevTitle;
            } else if (SpatialReorderableTableModel.this.isTitleInTable(this.revisitedTitle)) {
                this.revisitedTitle = this.prevTitle;
            }
            return this.revisitedTitle;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.prevTitle = (String)jTable.getValueAt(n, n2);
            this.holdingTextField.setText(this.prevTitle);
            this.holdingTextField.setEnabled(true);
            this.holdingPanel.add("Center", this.holdingTextField);
            return this.holdingPanel;
        }
    }

    class ColorCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1473864321417753465L;
        private Color selectedColor;
        private JFrame dialogContainer;
        private JButton delegateButton;
        private JPanel holdingPanel;
        private Color fallbackColor;
        private JLabel colorLabel;
        private JTable theTable;

        ColorCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            if (this.selectedColor == null) {
                return this.fallbackColor;
            }
            Color color = this.selectedColor;
            this.selectedColor = null;
            return color;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.theTable = jTable;
            this.fallbackColor = (Color)object;
            this.dialogContainer = new JFrame();
            this.delegateButton = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
            this.delegateButton.setFocusable(true);
            this.holdingPanel = new JPanel(new BorderLayout()){

                @Override
                public void requestFocus() {
                    ColorCellEditor.this.delegateButton.requestFocusInWindow();
                    if (ColorCellEditor.this.delegateButton.isFocusOwner()) {
                        ColorCellEditor.this.delegateButton.doClick();
                    }
                }
            };
            this.colorLabel = new JLabel();
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColorCellEditor.this.selectedColor = JColorChooser.showDialog(ColorCellEditor.this.delegateButton, "Pick a new color", ColorCellEditor.this.fallbackColor);
                    if (ColorCellEditor.this.selectedColor != null) {
                        ColorCellEditor.this.colorLabel.setBackground(ColorCellEditor.this.selectedColor);
                        ColorCellEditor.this.holdingPanel.setBackground(ColorCellEditor.this.selectedColor);
                        ColorCellEditor.this.stopCellEditing();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ColorCellEditor.this.theTable.isVisible()) {
                                ColorCellEditor.this.theTable.requestFocusInWindow();
                            }
                        }
                    });
                }
            };
            this.delegateButton.setMargin(new Insets(2, 2, 2, 2));
            this.delegateButton.addActionListener(actionListener);
            this.colorLabel.setBackground(this.fallbackColor);
            this.holdingPanel.setBackground(this.fallbackColor);
            this.holdingPanel.add("Center", this.colorLabel);
            this.holdingPanel.add("East", this.delegateButton);
            return this.holdingPanel;
        }
    }

    class ColorCellRenderer
    extends Component
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private JPanel holdingPanel = new JPanel(new BorderLayout());
        private JLabel colorLabel = new JLabel();

        public ColorCellRenderer() {
            this.colorLabel.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = (Color)object;
            this.colorLabel.setBackground(color);
            this.holdingPanel.add("Center", this.colorLabel);
            this.holdingPanel.setToolTipText(color.toString());
            return this.holdingPanel;
        }
    }
}

