/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controller;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.LogManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.TextBufferTracker;
import oracle.ide.model.TextNode;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.vcs.VCSManager;
import oracle.ideimpl.controller.CommandExecutionTracker;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.CanceledException;
import oracle.javatools.util.ChangeSupport;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.javatools.util.TypeMap;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.controller.DialogFactory;
import oracle.jdeveloper.controller.NodeActionControllerBundle;
import oracle.jdeveloper.controller.NodeActionDelegate;
import oracle.jdeveloper.refactoring.util.MakeWritableHelper;

public class NodeActionController
implements Controller {
    public static final String SINGLE_SELECTION_TEMPLATE_TEXT = "single-selection-template-text";
    public static final String MULTIPLE_SELECTION_TEXT = "multiple-selection-text";
    private TypeMap delegates = new TypeMap();
    private static final Log LOG = new Log("controller");
    private static final FormatBundle bundle = new FormatBundle(NodeActionControllerBundle.class);

    public void addDelegate(Class nodeClass, Class delegateClass) {
        if (!Node.class.isAssignableFrom(nodeClass)) {
            throw new IllegalArgumentException(nodeClass + " not instanceof Node");
        }
        if (!NodeActionDelegate.class.isAssignableFrom(delegateClass)) {
            throw new IllegalArgumentException(delegateClass + " not instanceof NodeActionDelegate");
        }
        if (this.delegates.get(nodeClass) != null) {
            throw new IllegalArgumentException("delegate for " + nodeClass + " already added");
        }
        this.delegates.put(nodeClass, (Object)delegateClass);
    }

    public boolean update(IdeAction action, Context context) {
        boolean enabled;
        boolean handled;
        LOG.trace("updating {0} for {1}", (Object)this, (Object)context);
        String name = null;
        try {
            name = (String)action.getValue("NoCtxName");
        }
        catch (NullPointerException npe) {
            Log.error((String)"null action!", (Object)npe);
            return false;
        }
        if (name == null) {
            name = (String)action.getValue("Name");
            action.putValue("NoCtxName", (Object)name);
        }
        Node node = context.getNode();
        Element[] selection = context.getSelection();
        if (context.getView() instanceof CodeEditor) {
            int[] nArray;
            CodeEditor editor;
            String text = (String)action.getValue(SINGLE_SELECTION_TEMPLATE_TEXT);
            if (text != null) {
                name = MessageFormat.format(text, node.getShortLabel());
            }
            if ((editor = (CodeEditor)context.getView()) == null) {
                nArray = null;
            } else {
                int[] nArray2 = new int[2];
                nArray2[0] = editor.getSelectionStart();
                nArray = nArray2;
                nArray2[1] = editor.getSelectionEnd();
            }
            int[] textSelection = nArray;
            handled = this.isHandled(context);
            enabled = this.isEnabled(context, null, textSelection, action);
        } else if (selection.length >= 1) {
            String text;
            if (selection.length > 1) {
                text = (String)action.getValue(MULTIPLE_SELECTION_TEXT);
                if (text != null) {
                    name = text;
                }
            } else {
                text = (String)action.getValue(SINGLE_SELECTION_TEMPLATE_TEXT);
                if (text != null) {
                    name = MessageFormat.format(text, selection[0].getShortLabel());
                }
            }
            if (this.isContainer(selection[0]) || selection[0] instanceof Node) {
                handled = true;
                enabled = true;
                Context childContext = new Context(context);
                for (int i = 0; i < selection.length; ++i) {
                    if (!this.isContainer(selection[i])) {
                        if (selection[i] instanceof Node) {
                            childContext.setNode((Node)selection[i]);
                            handled = this.isHandled(childContext);
                            enabled = enabled && this.isEnabled(childContext, null, null, action);
                        } else {
                            LOG.trace("element {0} not a container or node", i);
                            handled = false;
                            enabled = false;
                        }
                    }
                    if (handled) {
                        continue;
                    }
                    break;
                }
            } else {
                handled = node != null;
                for (int i = 0; handled && i < selection.length; ++i) {
                    if (!this.isContainer(selection[i]) && !(selection[i] instanceof Node)) continue;
                    handled = false;
                    LOG.trace("element {0} is a container or node", i);
                }
                if (handled) {
                    handled = this.isHandled(context);
                    enabled = this.isEnabled(context, selection, null, action);
                } else {
                    enabled = false;
                }
            }
        } else if (node != null) {
            String text = (String)action.getValue(SINGLE_SELECTION_TEMPLATE_TEXT);
            if (text != null) {
                name = MessageFormat.format(text, node.getShortLabel());
            }
            handled = this.isHandled(context);
            enabled = this.isEnabled(context, null, null, action);
        } else {
            handled = false;
            enabled = false;
        }
        LOG.trace("action enabled {0}, label {1}", enabled, (Object)name);
        action.setEnabled(enabled);
        action.putValue("Name", (Object)name);
        return handled;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Collection urls;
        if (!this.update(action, context)) {
            return false;
        }
        LOG.trace("handling event for {0} on {1}", (Object)action, (Object)context);
        LinkedHashMap<URLKey, NodeHandler> handlers = new LinkedHashMap<URLKey, NodeHandler>();
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        Element[] selection = context.getSelection();
        if (context.getView() instanceof CodeEditor) {
            CodeEditor editor = (CodeEditor)context.getView();
            int[] textSelection = new int[]{editor.getSelectionStart(), editor.getSelectionEnd()};
            this.queueNode(context, null, textSelection, action, handlers);
        } else if (selection.length >= 1) {
            if (this.isContainer(selection[0]) || selection[0] instanceof Node) {
                for (int i = 0; i < selection.length; ++i) {
                    if (this.isContainer(selection[i])) {
                        this.queueContainer(selection[i], project, workspace, action, handlers);
                        continue;
                    }
                    if (!(selection[i] instanceof Node)) continue;
                    Context childContext = new Context(context);
                    childContext.setNode((Node)selection[i]);
                    this.queueNode(childContext, null, null, action, handlers);
                }
            } else {
                this.queueNode(context, selection, null, action, handlers);
            }
        } else if (context.getNode() != null) {
            this.queueNode(context, selection, null, action, handlers);
        }
        if (handlers.isEmpty()) {
            this.showMessageDialog("no-files", null, false);
            return true;
        }
        LinkedHashSet<URLKey> readOnlyUnversioned = new LinkedHashSet<URLKey>();
        LinkedHashSet<URLKey> readOnlyVersioned = new LinkedHashSet<URLKey>();
        Iterator i = handlers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            URLKey key = (URLKey)entry.getKey();
            NodeHandler handler = (NodeHandler)entry.getValue();
            URL url = handler.url;
            if (URLFileSystem.isReadOnly((URL)url)) {
                VCSManager vcs = VCSManager.getVCSManager();
                if (vcs == null || !vcs.isVersioned(url)) {
                    readOnlyUnversioned.add(key);
                    i.remove();
                } else {
                    readOnlyVersioned.add(key);
                }
            }
            handler.dirty = handler.context.getNode().isDirty();
        }
        LOG.trace("{0} read-only unversioned, {1} read-only versioned, {2} writable", readOnlyUnversioned.size(), readOnlyVersioned.size(), handlers.size());
        if (readOnlyVersioned.isEmpty() && handlers.isEmpty()) {
            this.showFileListDialog(readOnlyUnversioned, "no-mutable", false);
            return true;
        }
        if (!readOnlyUnversioned.isEmpty() && !this.showFileListDialog(readOnlyUnversioned, "skip-immutable", true)) {
            return true;
        }
        if (!readOnlyVersioned.isEmpty() && !MakeWritableHelper.makeWritable(urls = URLKey.asURLs(readOnlyVersioned))) {
            return true;
        }
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null) {
            List editors = editorManager.getAllEditors();
            for (int i2 = 0; i2 < editors.size(); ++i2) {
                CodeEditor codeEditor;
                Context editorContext;
                URL url;
                NodeHandler handler;
                Editor editor = (Editor)editors.get(i2);
                if (!(editor instanceof CodeEditor) || (handler = (NodeHandler)handlers.get(URLKey.getInstance((URL)(url = (editorContext = (codeEditor = (CodeEditor)editor).getContext()).getNode().getURL())))) == null) continue;
                handler.open = true;
                NodeHandler.access$402(handler, new int[]{codeEditor.getSelectionStart(), codeEditor.getSelectionEnd()});
            }
        }
        NodeActionCommand command = new NodeActionCommand((String)action.getValue("NoCtxName"), (String)action.getValue("Name"), context, handlers);
        try {
            CommandProcessor.getInstance().invoke((Command)command);
        }
        catch (Throwable e) {
            throw new UnexpectedExceptionError(e);
        }
        return true;
    }

    private boolean showFileListDialog(Set<URLKey> files, String prefix, boolean cancelable) {
        if (files.size() == 1) {
            URL url = files.iterator().next().toURL();
            String fileName = URLFileSystem.getFileName((URL)url);
            String directoryName = URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)url));
            return this.showMessageDialog(prefix, new Object[]{fileName, directoryName}, cancelable);
        }
        DialogFactory dialog = new DialogFactory();
        JButton okButton = dialog.addOkButton(null);
        if (cancelable) {
            dialog.addCancelButton(null);
        }
        JPanel content = new JPanel(new GridBagLayout());
        dialog.setContent(content);
        dialog.setTitle(bundle.get(prefix + ".dialog.title"));
        content.setAlignmentX(0.0f);
        content.setAlignmentY(0.0f);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 1;
        String message = bundle.get(prefix + ".dialog.n.message", new Object[]{new Integer(files.size())});
        JComponent top = NodeActionController.createTextArea(message);
        content.add((Component)top, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets.top = 5;
        Object[] fileNames = files.toArray();
        for (int i = 0; i < fileNames.length; ++i) {
            fileNames[i] = URLFileSystem.getPlatformPathName((URL)((URLKey)fileNames[i]).toURL());
        }
        JList<Object> fileList = new JList<Object>(fileNames);
        fileList.setVisibleRowCount(8);
        JScrollPane fileScrollPane = new JScrollPane(fileList);
        constraints.gridheight = 0;
        ++constraints.gridy;
        content.add((Component)fileScrollPane, constraints);
        ++constraints.gridy;
        content.add(Box.createVerticalGlue(), constraints);
        return okButton == dialog.show();
    }

    private boolean showMessageDialog(String prefix, Object[] parameters, boolean cancelable) {
        if (!Ide.getIdeArgs().getCreateUI()) {
            return true;
        }
        DialogFactory dialog = new DialogFactory();
        JButton okButton = dialog.addOkButton(null);
        if (cancelable) {
            dialog.addCancelButton(null);
        }
        dialog.setTitle(bundle.get(prefix + ".dialog.title"));
        String message = bundle.get(prefix + ".dialog.message", parameters);
        JComponent content = NodeActionController.createTextArea(message);
        content.setAlignmentX(0.0f);
        content.setAlignmentY(0.0f);
        dialog.setContent(content);
        dialog.setInitialFocus(okButton);
        return okButton == dialog.show();
    }

    private static int showAbortDialog(String prefix, URL url, Throwable exception, String[] choices) {
        int i;
        String fileName = null;
        String directoryName = null;
        if (url != null) {
            fileName = URLFileSystem.getFileName((URL)url);
            directoryName = URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)url));
        }
        final DialogFactory dialog = new DialogFactory();
        dialog.setDefaultCloseButtonIgnored(true);
        final JButton okButton = dialog.addOkButton(null);
        okButton.setEnabled(false);
        JPanel content = new JPanel(new GridBagLayout());
        dialog.setContent(content);
        dialog.setTitle(bundle.get(prefix + ".dialog.title"));
        content.setAlignmentX(0.0f);
        content.setAlignmentY(0.0f);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        JComponent top = NodeActionController.createTextArea(bundle.get(prefix + ".dialog.message", new Object[]{fileName, directoryName, exception}));
        content.add((Component)top, constraints);
        constraints.gridx = 1;
        content.add(Box.createHorizontalGlue(), constraints);
        constraints.gridx = 0;
        constraints.insets.top = 5;
        constraints.fill = 2;
        final JRadioButton[] buttons = new JRadioButton[choices.length];
        ButtonGroup group = new ButtonGroup();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = false;
                for (int i = 0; i < buttons.length; ++i) {
                    enabled |= buttons[i].isSelected();
                }
                okButton.setEnabled(enabled);
                dialog.setDefaultCloseButtonIgnored(!enabled);
            }
        };
        for (i = 0; i < buttons.length; ++i) {
            buttons[i] = new JRadioButton(bundle.get(choices[i], new Object[]{fileName}));
            ++constraints.gridy;
            content.add((Component)buttons[i], constraints);
            group.add(buttons[i]);
            buttons[i].addActionListener(listener);
        }
        ++constraints.gridy;
        content.add(Box.createVerticalGlue(), constraints);
        dialog.show();
        for (i = 0; i < buttons.length; ++i) {
            if (!buttons[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    private static JComponent createTextArea(String message) {
        JEditorPane textArea = new JEditorPane("text/html", "<html><body>" + message + "</body></html>");
        textArea.setEditable(false);
        textArea.setOpaque(false);
        textArea.setForeground(UIManager.getColor("Label.foreground"));
        textArea.setBackground(UIManager.getColor("Label.background"));
        Font font = textArea.getFont();
        int width = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
        StyleSheet stylesheet = ((HTMLDocument)textArea.getDocument()).getStyleSheet();
        stylesheet.addRule("body {font-size: " + font.getSize() + "pt;" + "font-family: " + font.getFamily() + ";" + "font-weight: " + (font.isBold() ? "bold" : "normal") + ";" + "font-style: " + (font.isItalic() ? "italic" : "normal") + ";" + "color: #" + Integer.toHexString(textArea.getForeground().getRGB() & 0xFFFFFF) + "width: " + width + "px;" + "max-width: " + width + "px;" + "}");
        textArea.setBorder(null);
        textArea.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        return textArea;
    }

    private boolean isContainer(Element element) {
        if (element instanceof Workspaces) {
            return true;
        }
        if (element instanceof Workspace) {
            return true;
        }
        if (element instanceof Project) {
            return true;
        }
        return element instanceof RelativeDirectoryContextFolder;
    }

    protected NodeActionDelegate getDelegate(Node node) {
        Class<?> nodeClass = node.getClass();
        Class delegateClass = (Class)this.delegates.get(nodeClass);
        if (delegateClass == null) {
            LOG.trace("getting no delegate for {0}", nodeClass);
            return null;
        }
        try {
            LOG.trace("getting delegate {0} for {1}", (Object)delegateClass, nodeClass);
            return (NodeActionDelegate)delegateClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedExceptionError((Throwable)e);
        }
    }

    private boolean isHandled(Context context) {
        return this.delegates.get(context.getNode().getClass()) != null;
    }

    private boolean isEnabled(Context context, Element[] elements, int[] text, IdeAction action) {
        boolean enabled = false;
        Node node = context.getNode();
        NodeActionDelegate delegate = this.getDelegate(node);
        if (delegate != null) {
            enabled = delegate.isEnabled(action, context, elements, text);
        }
        return enabled;
    }

    protected void queueContainer(Element element, Project project, Workspace workspace, IdeAction action, Map<URLKey, NodeHandler> queue) {
        if (element instanceof Workspaces) {
            Iterator i = element.getChildren();
            while (i.hasNext()) {
                this.queueContainer((Element)i.next(), null, null, action, queue);
            }
        } else if (element instanceof Workspace) {
            Iterator i = element.getChildren();
            while (i.hasNext()) {
                this.queueContainer((Element)i.next(), null, (Workspace)element, action, queue);
            }
        } else if (element instanceof Project) {
            WorkingSets sets;
            WorkingSet ws;
            project = (Project)element;
            WorkingSet set = null;
            if (workspace != null && (ws = (sets = WorkingSets.getInstance((Workspace)workspace)).getCurrentWorkingSet()) != sets.getWorkingSet(WorkingSets.ALL_FILES_WORKING_SET_LABEL)) {
                set = ws;
            }
            Iterator iterator = set != null && set.getPatternFilters(project) != null ? ProjectContent.getInstance((PropertyStorage)project).getAllContents().nodeIterator("", new IntersectedFilters(set.getPatternFilters(project))) : project.getChildren();
            while (iterator.hasNext()) {
                this.queueContainer((Element)iterator.next(), project, workspace, action, queue);
            }
        } else if (element instanceof RelativeDirectoryContextFolder) {
            Iterator i = element.getChildren();
            while (i.hasNext()) {
                this.queueContainer((Element)i.next(), project, workspace, action, queue);
            }
        } else if (element instanceof Node) {
            Node node = (Node)element;
            Context context = new Context(null, workspace, project, node);
            this.queueNode(context, null, null, action, queue);
        }
    }

    private void queueNode(Context context, Element[] elements, int[] text, IdeAction action, Map<URLKey, NodeHandler> queue) {
        NodeActionDelegate delegate;
        Node node = context.getNode();
        URL url = node.getURL();
        URLKey key = URLKey.getInstance((URL)url);
        if (!queue.containsKey(key) && (delegate = this.getDelegate(node)) != null && delegate.isEnabled(action, context, elements, text)) {
            LOG.trace("queueing {0} delegating to {1}", (Object)url, (Object)delegate);
            NodeHandler handler = new NodeHandler();
            handler.action = action;
            NodeHandler.access$2102(handler, elements);
            NodeHandler.access$2202(handler, text);
            handler.context = context;
            handler.url = url;
            handler.delegate = delegate;
            if (node instanceof TextNode) {
                handler.version = TextBufferTracker.getTracker((TextNode)((TextNode)node)).getVersion();
            }
            queue.put(key, handler);
        }
    }

    static /* synthetic */ int access$800(String x0, URL x1, Throwable x2, String[] x3) {
        return NodeActionController.showAbortDialog(x0, x1, x2, x3);
    }

    private static class ProgressDialog {
        private JLabel majorLabel = new JLabel("Initializing");
        private JProgressBar bar;
        private JLabel minorLabel;
        private DialogFactory dialog;

        public ProgressDialog(String title, int minimum, int maximum) {
            this.bar = new JProgressBar(minimum, maximum);
            this.minorLabel = new JLabel(" ");
            JPanel content = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 17;
            content.add((Component)this.majorLabel, constraints);
            ++constraints.gridy;
            content.add((Component)this.bar, constraints);
            ++constraints.gridy;
            content.add((Component)this.minorLabel, constraints);
            ++constraints.gridy;
            content.add(Box.createHorizontalStrut(450), constraints);
            this.dialog = new DialogFactory();
            this.dialog.setTitle(title);
            this.dialog.setContent(content);
        }

        public void setColumns(int columns) {
            int em = this.majorLabel.getFontMetrics(this.majorLabel.getFont()).charWidth('m');
            Dimension size = new Dimension(columns * em, this.majorLabel.getPreferredSize().height);
            this.majorLabel.setPreferredSize(size);
            this.minorLabel.setPreferredSize(size);
        }

        public void setMajorLabelText(String text) {
            if (text != null) {
                this.majorLabel.setText(text);
            }
        }

        public void setProgress(int progress) {
            if (progress >= this.bar.getMinimum() && progress <= this.bar.getMaximum()) {
                this.bar.setValue(progress);
            }
        }

        public void setMinorLabelText(String text) {
            if (text != null) {
                this.minorLabel.setText(text);
            }
        }

        public void addCancelAction(ActionListener listener) {
            this.dialog.addCancelAction(listener);
        }

        public void show() {
            this.dialog.show();
        }

        public void hide() {
            this.dialog.hide();
        }
    }

    private static class ProgressMonitor {
        private String title;
        private ProgressDialog dialog;
        private boolean synchronous;
        private Runnable task;
        private ProgressModel model;
        private Throwable exception;

        public ProgressMonitor(String title) {
            this.title = title;
        }

        public boolean isSynchronous() {
            return this.synchronous;
        }

        public void setSynchronous(boolean synchronous) {
            this.synchronous = synchronous;
        }

        public Throwable execute(Runnable task, int delay, ProgressModel model) {
            LOG.trace("monitor execute");
            this.task = task;
            this.model = model;
            this.exception = null;
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    ProgressMonitor.this.modelChanged();
                }
            });
            if (this.synchronous) {
                this.execute();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitor.this.execute();
                    }
                });
                this.start();
            }
            return this.exception;
        }

        private void modelChanged() {
            if (this.dialog != null) {
                this.dialog.setMajorLabelText(this.model.getMajorStep());
                this.dialog.setProgress(this.model.getProgress());
                this.dialog.setMinorLabelText(this.model.getMinorStep());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute() {
            LOG.trace("monitor execute  task");
            try {
                this.task.run();
                LOG.trace("task completed");
            }
            catch (Throwable e) {
                try {
                    this.exception = e;
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProgressMonitor.this.finish();
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        private void start() {
            LOG.trace("monitor start, {0}", (Object)this.dialog);
            if (this.dialog == null) {
                this.dialog = new ProgressDialog(this.title, this.model.getMinimum(), this.model.getMaximum());
                this.dialog.setColumns(80);
                this.dialog.addCancelAction(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ProgressMonitor.this.cancel();
                    }
                });
            }
            this.dialog.setMajorLabelText(this.model.getMajorStep());
            this.dialog.setProgress(this.model.getProgress());
            this.dialog.setMinorLabelText(this.model.getMinorStep());
            this.dialog.show();
        }

        private void cancel() {
            LOG.trace("monitor cancel");
            this.model.setCanceled(true);
        }

        private void finish() {
            LOG.trace("monitor finish");
            if (this.dialog != null) {
                this.dialog.hide();
            }
        }
    }

    private static class ProgressModel {
        private int minimum;
        private int maximum = 100;
        private int progress;
        private String majorStep;
        private String minorStep;
        private ChangeSupport support = new ChangeSupport((Object)this);
        private boolean canceled;

        public ProgressModel() {
        }

        public ProgressModel(int minimum, int maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
            this.progress = minimum;
        }

        public void addChangeListener(ChangeListener listener) {
            this.support.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.support.removeChangeListener(listener);
        }

        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public synchronized int getMinimum() {
            return this.minimum;
        }

        public synchronized void setMinimum(int minimum) {
            this.minimum = minimum;
            this.support.fireStateChanged();
        }

        public synchronized int getMaximum() {
            return this.maximum;
        }

        public synchronized void setMaximum(int maximum) {
            this.maximum = maximum;
            this.support.fireStateChanged();
        }

        public synchronized int getProgress() {
            return this.progress;
        }

        public synchronized void setProgress(int progress) {
            this.progress = progress;
            this.support.fireStateChanged();
        }

        public synchronized String getMajorStep() {
            return this.majorStep;
        }

        public synchronized void setMajorStep(String majorStep) {
            this.majorStep = majorStep;
            this.support.fireStateChanged();
        }

        public synchronized String getMinorStep() {
            return this.minorStep;
        }

        public synchronized void setMinorStep(String minorStep) {
            this.minorStep = minorStep;
            this.support.fireStateChanged();
        }

        public synchronized void set(String majorStep, int progress, String minorStep) {
            if (majorStep != null) {
                this.majorStep = majorStep;
            }
            if (progress >= this.minimum && progress < this.maximum) {
                this.progress = progress;
            }
            if (minorStep != null) {
                this.minorStep = minorStep;
            }
            this.support.fireStateChanged();
        }
    }

    private static class NodeHandler {
        private IdeAction action;
        private Context context;
        private URL url;
        private Element[] elementSelection;
        private int[] textSelection;
        private int version = -1;
        private NodeActionDelegate delegate;
        private boolean open = false;
        private int[] initialSelection = null;
        private boolean dirty = false;
        private boolean saved = false;

        private NodeHandler() {
        }

        public void doAction() throws Exception {
            LOG.trace("invoking delegate {0} doAction for {1}", (Object)this.delegate, (Object)this.url);
            this.context.getNode().ensureOpen();
            int[] newSelection = this.delegate.doAction(this.context, this.elementSelection, this.textSelection, this.action);
            if (this.context.getBoolean("NavigationManager.VETO_NAVIGATION")) {
                return;
            }
            int selS = 0;
            int selE = 0;
            if (this.textSelection != null && this.textSelection.length > 1) {
                selS = this.textSelection[0];
                selE = this.textSelection[1];
            }
            if (this.context.getNode() instanceof TextNode && this.version > -1) {
                int[] adj = new int[2];
                TextBufferTracker.getTracker((TextNode)((TextNode)this.context.getNode())).adjustOffsetLength(selS, selE - selS, this.version, adj);
                selS = adj[0];
                selE = adj[0] + adj[1];
            }
            if (newSelection != null && newSelection.length == 2) {
                this.changeSelection(this.context.getWorkspace(), this.context.getProject(), this.url, newSelection[0], newSelection[1] - newSelection[0]);
            } else if (this.textSelection != null && this.textSelection.length == 2) {
                this.changeSelection(this.context.getWorkspace(), this.context.getProject(), this.url, selS, selE - selS);
            }
        }

        public void undoAction() {
            LOG.trace("invoking delegate {0} undoAction for {1}", (Object)this.delegate, (Object)this.url);
            this.context.getNode().ensureOpen();
            this.delegate.undoAction(this.context, this.elementSelection, this.textSelection, this.action);
            if (this.textSelection != null && this.textSelection.length == 2) {
                this.changeSelection(this.context.getWorkspace(), this.context.getProject(), this.url, this.textSelection[0], this.textSelection[1] - this.textSelection[0]);
            }
        }

        public String toString() {
            return "NodeHandler " + URLFileSystem.getFileName((URL)this.url);
        }

        private void changeSelection(Workspace workspace, Project project, URL url, int offset, int length) {
            Ide.setActiveWorkspace((Workspace)workspace);
            Ide.setActiveProject((Project)project);
            Node node = NodeFactory.find((URL)url);
            Context context = new Context(null, workspace, project, node);
            OffsetNavigationPoint point = new OffsetNavigationPoint(context, offset, length);
            try {
                NavigationManager navigator = NavigationManager.getNavigationManager();
                if (navigator != null) {
                    navigator.navigateTo((NavigationPoint)point);
                }
            }
            catch (Exception e) {
                Log.error((String)"opening {0} failed: {1}", (Object)context, (Object)e);
            }
        }

        static /* synthetic */ int[] access$402(NodeHandler x0, int[] x1) {
            x0.initialSelection = x1;
            return x1;
        }

        static /* synthetic */ Element[] access$2102(NodeHandler x0, Element[] x1) {
            x0.elementSelection = x1;
            return x1;
        }

        static /* synthetic */ int[] access$2202(NodeHandler x0, int[] x1) {
            x0.textSelection = x1;
            return x1;
        }
    }

    private static class NodeActionCommand
    extends Command {
        private String label;
        private Map<URLKey, NodeHandler> handlersToDo;
        private Map<URLKey, NodeHandler> handlersToUndo = new LinkedHashMap<URLKey, NodeHandler>();
        private Set<URLKey> handlersSkipped = new LinkedHashSet<URLKey>();
        private Node[] nodes;
        private ProgressMonitor progress;
        private ProgressModel model;
        private boolean reverting;
        private boolean msgLogWindowLogging;
        private boolean global = false;

        public NodeActionCommand(String name, String label, Context context, Map<URLKey, NodeHandler> handlers) {
            super(Ide.findOrCreateCmdID((String)name), handlers.size() > 1 ? 3 : 0, name);
            this.setContext(context);
            this.label = label;
            this.handlersToDo = handlers;
            Node node = context.getNode();
            this.msgLogWindowLogging = node instanceof Project || node instanceof Workspace;
            this.global = !(context.getView() instanceof Editor);
        }

        public boolean isGlobal() {
            return this.global;
        }

        public Node[] getAffectedNodes() {
            if (this.handlersToDo.size() == 1) {
                return null;
            }
            if (this.nodes == null) {
                this.nodes = new Node[this.handlersToDo.size()];
                int index = 0;
                for (NodeHandler handler : this.handlersToDo.values()) {
                    this.nodes[index++] = handler.context.getNode();
                }
            }
            return this.nodes;
        }

        private void advance(String major, String minor) {
            if (this.model.isCanceled()) {
                this.reverting = true;
                throw new CanceledException();
            }
            this.model.set(major, this.model.getProgress() + 1, minor);
        }

        private void revert(String major, String minor) {
            this.model.set(major, this.model.getProgress() - 1, minor);
        }

        private void log(String message) {
            if (Ide.getIdeArgs().getCreateUI()) {
                LogManager.getLogManager().getMsgPage().log((Object)(message + '\n'));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public int doit() throws Exception {
            block22: {
                this.getAffectedNodes();
                if (this.msgLogWindowLogging) {
                    this.log(NodeActionController.access$500().get("status.doing", new Object[]{this.label}));
                }
                this.reverting = false;
                this.handlersSkipped.clear();
                this.model = new ProgressModel();
                this.progress = new ProgressMonitor(this.label);
                this.progress.setSynchronous(this.handlersToDo.size() <= 1);
                runnable /* !! */  = new Do();
                CommandExecutionTracker.commandExecutionTracker().start(this.label);
                block13: while (true) {
                    block14: while (true) {
                        block23: {
                            NodeActionController.access$700().trace("starting execution using {0}", (Object)runnable /* !! */ );
                            this.model.setCanceled(false);
                            this.model.setMaximum(this.handlersToDo.size());
                            exception = this.progress.execute(runnable /* !! */ , 0, this.model);
                            if (exception == null) {
                                exception = runnable /* !! */ .getException();
                            }
                            NodeActionController.access$700().trace("completed execution, exception {0}", (Object)exception);
                            if (exception == null) {
                                status = this.reverting != false ? 1 : 0;
                                break block22;
                            }
                            this.reverting = false;
                            if (!(exception instanceof CanceledException)) break block23;
                            choices = new String[]{"cancel.cancel.button.label", "cancel.stop.button.label", "cancel.continue.button.label"};
                            switch (NodeActionController.access$800("cancel", null, null, choices)) {
                                case 0: {
                                    this.reverting = true;
                                    runnable /* !! */  = new Undo();
                                    break;
                                }
                                case 1: {
                                    status = 0;
                                    break block22;
                                }
                            }
                            ** GOTO lbl-1000
                        }
                        iterator = this.handlersToDo.keySet().iterator();
                        key = iterator.next();
                        url = key.toURL();
                        choices = new String[]{"modification-failed.cancel.button.label", "modification-failed.stop.button.label", "modification-failed.retry.button.label", "modification-failed.skip.button.label"};
                        switch (NodeActionController.access$800("modification-failed", url, exception, choices)) {
                            case 0: {
                                this.reverting = true;
                                runnable /* !! */  = new Undo();
                                ** GOTO lbl59
                            }
                            case 1: {
                                status = 0;
                                ** break;
lbl52:
                                // 1 sources

                                break block22;
                            }
                            case 2: {
                                ** GOTO lbl59
                            }
                            case 3: {
                                iterator.remove();
                                this.handlersSkipped.add(key);
                            }
lbl59:
                            // 4 sources

                            default: lbl-1000:
                            // 2 sources

                            {
                                if (runnable /* !! */  instanceof Do) {
                                    this.log(NodeActionController.access$500().get("status.continuing", new Object[]{this.label}));
                                    continue block13;
                                }
                                this.log(NodeActionController.access$500().get("status.cancelling", new Object[]{this.label}));
                                continue block14;
                            }
                        }
                        break;
                    }
                    break;
                }
                finally {
                    CommandExecutionTracker.commandExecutionTracker().end();
                }
            }
            if (runnable /* !! */  instanceof Do) {
                if (this.msgLogWindowLogging) {
                    this.log(NodeActionController.access$500().get("status.completed", new Object[]{this.label}));
                }
            } else {
                this.log(NodeActionController.access$500().get("status.cancelled", new Object[]{this.label}));
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public int undo() throws Exception {
            block22: {
                if (this.msgLogWindowLogging) {
                    this.log(NodeActionController.access$500().get("status.undoing", new Object[]{this.label}));
                }
                this.reverting = false;
                this.handlersSkipped.clear();
                this.model = new ProgressModel();
                this.progress = new ProgressMonitor(this.label);
                this.progress.setSynchronous(this.handlersToUndo.size() <= 1);
                runnable /* !! */  = new Undo();
                CommandExecutionTracker.commandExecutionTracker().start(this.label);
                block13: while (true) {
                    block14: while (true) {
                        block23: {
                            NodeActionController.access$700().trace("starting execution using {0}", (Object)runnable /* !! */ );
                            this.model.setCanceled(false);
                            this.model.setMaximum(this.handlersToUndo.size());
                            exception = this.progress.execute(runnable /* !! */ , 0, this.model);
                            if (exception == null) {
                                exception = runnable /* !! */ .getException();
                            }
                            NodeActionController.access$700().trace("completed execution, exception {0}", (Object)exception);
                            if (exception == null) {
                                status = this.reverting != false ? 1 : 0;
                                break block22;
                            }
                            this.reverting = false;
                            if (!(exception instanceof CanceledException)) break block23;
                            choices = new String[]{"cancel-undo.cancel.button.label", "cancel-undo.stop.button.label", "cancel-undo.continue.button.label"};
                            switch (NodeActionController.access$800("cancel-undo", null, null, choices)) {
                                case 0: {
                                    this.reverting = true;
                                    runnable /* !! */  = new Do();
                                    break;
                                }
                                case 1: {
                                    status = 0;
                                    break block22;
                                }
                            }
                            ** GOTO lbl-1000
                        }
                        iterator = this.handlersToUndo.keySet().iterator();
                        key = iterator.next();
                        url = key.toURL();
                        choices = new String[]{"unmodification-failed.cancel.button.label", "unmodification-failed.stop.button.label", "unmodification-failed.retry.button.label", "unmodification-failed.skip.button.label"};
                        switch (NodeActionController.access$800("unmodification-failed", url, exception, choices)) {
                            case 0: {
                                this.reverting = true;
                                runnable /* !! */  = new Do();
                                ** GOTO lbl57
                            }
                            case 1: {
                                status = 0;
                                ** break;
lbl50:
                                // 1 sources

                                break block22;
                            }
                            case 2: {
                                ** GOTO lbl57
                            }
                            case 3: {
                                iterator.remove();
                                this.handlersSkipped.add(key);
                            }
lbl57:
                            // 4 sources

                            default: lbl-1000:
                            // 2 sources

                            {
                                if (runnable /* !! */  instanceof Undo) {
                                    this.log(NodeActionController.access$500().get("status.continuing-undo", new Object[]{this.label}));
                                    continue block13;
                                }
                                this.log(NodeActionController.access$500().get("status.cancelling-undo", new Object[]{this.label}));
                                continue block14;
                            }
                        }
                        break;
                    }
                    break;
                }
                finally {
                    CommandExecutionTracker.commandExecutionTracker().end();
                }
            }
            if (runnable /* !! */  instanceof Undo) {
                if (this.msgLogWindowLogging) {
                    this.log(NodeActionController.access$500().get("status.completed-undo", new Object[]{this.label}));
                }
            } else {
                this.log(NodeActionController.access$500().get("status.cancelled-undo", new Object[]{this.label}));
            }
            return status;
        }

        private class Undo
        extends Task {
            private Undo() {
            }

            @Override
            public void execute() throws Exception {
                URL url = null;
                Iterator i = NodeActionCommand.this.handlersToUndo.values().iterator();
                while (i.hasNext()) {
                    NodeHandler handler = (NodeHandler)i.next();
                    url = handler.url;
                    if (NodeActionCommand.this.handlersSkipped.contains(URLKey.getInstance((URL)url))) continue;
                    if (!NodeActionCommand.this.reverting) {
                        NodeActionCommand.this.advance(bundle.get("undo.process.major.label"), bundle.get("undo.process.minor.label", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    } else {
                        NodeActionCommand.this.revert(bundle.get("undo.process.major.reverting, label"), bundle.get("undo.process.minor.reverting.label", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    }
                    handler.undoAction();
                    i.remove();
                    NodeActionCommand.this.handlersToDo.put(URLKey.getInstance((URL)url), handler);
                    if (!handler.saved) continue;
                    try {
                        handler.context.getNode().save();
                        NodeActionCommand.this.log(bundle.get("status.saved", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    }
                    catch (IOException e) {
                        NodeActionCommand.this.log(bundle.get("status.save-failed", new Object[]{URLFileSystem.getPlatformPathName((URL)url), e}));
                    }
                    handler.saved = false;
                }
            }
        }

        private class Do
        extends Task {
            private Do() {
            }

            @Override
            public void execute() throws Exception {
                URL url = null;
                Collection nodeHandlers = NodeActionCommand.this.handlersToDo.values();
                int nodeHandlersSize = nodeHandlers.size();
                Iterator i = nodeHandlers.iterator();
                while (i.hasNext()) {
                    boolean saveNode;
                    NodeHandler handler = (NodeHandler)i.next();
                    url = handler.url;
                    if (NodeActionCommand.this.handlersSkipped.contains(URLKey.getInstance((URL)url))) continue;
                    if (!NodeActionCommand.this.reverting) {
                        NodeActionCommand.this.advance(bundle.get("do.process.major.label"), bundle.get("do.process.minor.label", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    } else {
                        NodeActionCommand.this.revert(bundle.get("do.process.major.reverting, label"), bundle.get("do.process.minor.reverting.label", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    }
                    handler.saved = false;
                    handler.doAction();
                    i.remove();
                    NodeActionCommand.this.handlersToUndo.put(URLKey.getInstance((URL)url), handler);
                    boolean bl = saveNode = !handler.dirty;
                    if (saveNode && nodeHandlersSize == 1) {
                        Node activeNode;
                        Editor currentEditor = EditorManager.getEditorManager().getCurrentEditor();
                        Context context = currentEditor == null ? null : currentEditor.getContext();
                        Node node = activeNode = context == null ? null : context.getNode();
                        if (activeNode == handler.context.getNode()) {
                            saveNode = false;
                        }
                    }
                    if (!saveNode) continue;
                    try {
                        LOG.trace("saving {0}", (Object)url);
                        handler.context.getNode().save();
                        handler.saved = true;
                        NodeActionCommand.this.log(bundle.get("status.saved", new Object[]{URLFileSystem.getPlatformPathName((URL)url)}));
                    }
                    catch (IOException e) {
                        LOG.trace("exception saving {0}: {1}", (Object)url, (Object)e);
                        NodeActionCommand.this.log(bundle.get("status.save-failed", new Object[]{URLFileSystem.getPlatformPathName((URL)url), e}));
                    }
                }
            }
        }

        private abstract class Task
        implements Runnable {
            private Throwable exception;

            private Task() {
            }

            @Override
            public final void run() {
                this.exception = null;
                try {
                    this.execute();
                }
                catch (Throwable e) {
                    this.exception = e;
                }
            }

            public Throwable getException() {
                return this.exception;
            }

            protected abstract void execute() throws Exception;
        }
    }
}

