/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ide.vcs.VCSManager;
import oracle.ide.vcs.VCSTask;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.resource.RefactoringArb;

public class MakeWritableHelper {
    private static String dialogTitle = RefactoringArb.getString(522);

    public static boolean setReadOnly(URL url, boolean readOnly) {
        boolean ret = false;
        String[] cmdarray = null;
        String platformPathName = URLFileSystem.getPlatformPathName((URL)url);
        String osName = System.getProperty("os.name", "").toLowerCase();
        if (osName.startsWith("windows")) {
            cmdarray = new String[]{"ATTRIB", readOnly ? "+R" : "-R", '\"' + platformPathName + '\"'};
        } else if (osName.equals("linux") || osName.startsWith("mac os")) {
            cmdarray = new String[]{"chmod", readOnly ? "u-w" : "u+w", '\"' + platformPathName + '\"'};
        }
        if (cmdarray != null) {
            Runtime runtime = Runtime.getRuntime();
            try {
                Node node;
                Process process = runtime.exec(cmdarray);
                if (process.waitFor() == 0 && (ret = new File(platformPathName).canWrite()) && (node = NodeFactory.find((URL)url)) instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    textNode.isReadOnly();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static boolean makeWritable(URL[] urls, String title) {
        return MakeWritableHelper.makeWritable(Arrays.asList(urls), title);
    }

    public static boolean makeWritable(Collection<URL> urls, String title) {
        String savedDialogTitle = dialogTitle;
        dialogTitle = title;
        boolean res = MakeWritableHelper.makeWritable(urls);
        dialogTitle = savedDialogTitle;
        return res;
    }

    public static boolean makeWritable(URL[] urls) {
        return MakeWritableHelper.makeWritable(Arrays.asList(urls));
    }

    public static boolean makeWritable(Collection<URL> urls) {
        ArrayList<URL> readOnly = new ArrayList<URL>(urls.size());
        for (URL url : urls) {
            if (!URLFileSystem.isReadOnly((URL)url)) continue;
            readOnly.add(url);
        }
        return MakeWritableHelper.checkout(readOnly) && MakeWritableHelper.setReadWrite(readOnly);
    }

    private static boolean showMessage(Collection<URL> urls, String message) {
        boolean ret = false;
        Vector<String> names = new Vector<String>();
        for (URL url : urls) {
            String platformPathName = URLFileSystem.getPlatformPathName((URL)url);
            names.add(platformPathName);
        }
        Collections.sort(names);
        JList list = new JList(names);
        JScrollPane scrollPane = new JScrollPane(list);
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)scrollPane, (String)message);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)scrollPane, "Center");
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), dialogTitle, 3);
        dialog.setContent((Component)panel);
        dialog.setDefaultButton(1);
        ret = dialog.runDialog();
        return ret;
    }

    private static boolean checkout(Collection<URL> urls) {
        if (urls.isEmpty()) {
            return true;
        }
        Object versioned = new Object();
        IdentityHashMap<URL, Object> versionedUrls = new IdentityHashMap<URL, Object>();
        for (URL url : urls) {
            if (!VCSManager.getVCSManager().isVersioned(url)) continue;
            versionedUrls.put(url, versioned);
        }
        URL[] u = versionedUrls.keySet().toArray(new URL[versionedUrls.size()]);
        if (u.length == 0) {
            return true;
        }
        if (!Ide.getIdeArgs().getCreateUI() || !EventQueue.isDispatchThread()) {
            boolean ret = VCSManager.getVCSManager().checkOut(u);
            if (ret) {
                urls.clear();
            }
            return ret;
        }
        boolean ret = false;
        VCSTask task = new VCSTask(u){};
        Future vcsTask = VCSManager.getVCSManager().checkOutUsingUI(task);
        boolean showProgress = false;
        boolean wasCancelled = false;
        try {
            ret = (Boolean)vcsTask.get(200L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            showProgress = true;
        }
        catch (CancellationException e) {
            wasCancelled = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (showProgress) {
            class MyRunnable
            implements Runnable {
                private ProgressBar _progressBar;
                private volatile boolean _results;
                private volatile boolean _wasCanceled;
                final /* synthetic */ Future val$vcsTask;

                public MyRunnable(Component component) {
                    this.val$vcsTask = component;
                    this._progressBar = new ProgressBar((Component)parent, RefactoringArb.getString(525), (Runnable)this, true);
                }

                public boolean start() {
                    this._progressBar.start(RefactoringArb.getString(526), "");
                    this._wasCanceled = this._progressBar.hasUserCancelled();
                    return this._results;
                }

                public boolean wasCancelled() {
                    return this._wasCanceled;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (true) {
                            if (this._progressBar.hasUserCancelled()) {
                                this._wasCanceled = true;
                                if (this.val$vcsTask.cancel(true)) {
                                    break;
                                }
                            }
                            try {
                                this._results = (Boolean)this.val$vcsTask.get(100L, TimeUnit.MILLISECONDS);
                            }
                            catch (TimeoutException e) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (CancellationException e) {
                        this._wasCanceled = true;
                    }
                    catch (ExecutionException e) {
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        this._progressBar.setDoneStatus();
                    }
                }
            }
            MyRunnable myRunnable = new MyRunnable((Component)Ide.getMainWindow(), vcsTask);
            ret = myRunnable.start();
            wasCancelled = myRunnable.wasCancelled();
        }
        if (!ret) {
            if (!wasCancelled) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)RefactoringArb.getString(528), (String)RefactoringArb.getString(527), null);
            }
        } else {
            Iterator<URL> iterator = urls.iterator();
            while (iterator.hasNext()) {
                if (!versionedUrls.containsKey(iterator.next())) continue;
                iterator.remove();
            }
        }
        return ret;
    }

    private static boolean setReadWrite(Collection<URL> urls) {
        boolean ret = false;
        if (urls.size() > 0) {
            boolean canMakeWritable;
            boolean headless = !Ide.getIdeArgs().getCreateUI();
            boolean bl = canMakeWritable = headless || MakeWritableHelper.showMessage(urls, RefactoringArb.getString(523));
            if (canMakeWritable) {
                ret = true;
                int i = 0;
                Iterator<URL> itr = urls.iterator();
                while (ret && itr.hasNext()) {
                    URL url = itr.next();
                    if (URLFileSystem.setReadOnly((URL)url, (boolean)false)) {
                        itr.remove();
                    } else if (MakeWritableHelper.setReadOnly(url, false)) {
                        itr.remove();
                    } else {
                        if (!headless) {
                            String message = RefactoringArb.format(524, new Object[]{URLFileSystem.getPlatformPathName((URL)url)});
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)message, (String)RefactoringArb.getString(522), null);
                        }
                        ret = false;
                    }
                    ++i;
                }
            }
        } else {
            ret = true;
        }
        return ret;
    }
}

