/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.resources;

import java.awt.BorderLayout;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.model.ContentSetPanel;
import oracle.jdeveloper.resource.JProjectArb;

public class GenericPanel
extends ProjectSettingsTraversablePanel {
    private final ContentSetPanel _contentSetPanel = new ContentSetPanel();
    private final String _dataKey;
    private final String _propertyKey;
    private final String[] _propertyKeys;

    public GenericPanel(String dataKey, String propertyKey, String listLabel) {
        this._contentSetPanel.setContentSetLabel(listLabel);
        this.setLayout(new BorderLayout());
        this.add(this._contentSetPanel, "Center");
        this._dataKey = dataKey;
        this._propertyKeys = new String[]{propertyKey};
        this._propertyKey = this._dataKey != null ? this._dataKey + "/" + propertyKey : propertyKey;
    }

    public GenericPanel(String propertyKey, String listLabel) {
        this(null, propertyKey, listLabel);
    }

    public static Navigable getNavigable(String shortLabel, String contentSetKey) {
        String listLabel = JProjectArb.format((int)151, (Object)shortLabel);
        return new Navigable(shortLabel, GenericPanel.class, new Class[]{String.class, String.class}, new Object[]{contentSetKey, listLabel}, null);
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        PropertyStorage propertyData = GenericPanel.getPropertyData((Namespace)tc);
        HashStructure hash = propertyData.getProperties();
        HashStructure contentSetHash = hash.getOrCreateHashStructure(this._propertyKey);
        ContentSet contentSet = new ContentSet(contentSetHash);
        Project project = (Project)tc.find("Project");
        this._contentSetPanel.loadFrom(project, contentSet);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        try {
            this._contentSetPanel.saveContentSet();
        }
        catch (ContentSetPanel.EmptyContentSetException ex) {
            PropertyStorage propertyData = GenericPanel.getPropertyData((Namespace)dataContext);
            HashStructure hash = propertyData.getProperties();
            HashStructure contentSetHash = hash.getOrCreateHashStructure(this._propertyKey);
            ContentSet contentSet = new ContentSet(contentSetHash);
            contentSet.getURLPath().setEntries(null);
            contentSet.getPatternFilters().setFilters(null);
            contentSet.removeAllContentSets();
        }
    }

    public String getHelpID() {
        return "f1_resourcesprojsettings_html";
    }

    public String[] getPropertyKeys() {
        return this._propertyKeys;
    }

    public String getDataKey() {
        return this._dataKey;
    }
}

