/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.util;

import java.util.Hashtable;
import sun.io.CharacterEncoding;

public class CharacterEncodingMapping {
    static Hashtable mJdkToIanaMap = new Hashtable(80);

    private CharacterEncodingMapping() {
    }

    public static String convertIanaToJdk(String ianaName) {
        String jdkName = CharacterEncoding.aliasName((String)ianaName);
        if (jdkName == null) {
            // empty if block
        }
        return jdkName;
    }

    public static String convertJdkToIana(String jdkName) {
        int astind;
        String ianaName = (String)mJdkToIanaMap.get(jdkName);
        if (ianaName != null && (astind = ianaName.indexOf(42)) != -1) {
            ianaName = ianaName.substring(0, ianaName.length() - 1);
        }
        return ianaName;
    }

    static {
        mJdkToIanaMap.put("Cp280", "CP280");
        mJdkToIanaMap.put("Cp500", "CP500");
        mJdkToIanaMap.put("Cp775", "CP775");
        mJdkToIanaMap.put("JIS", "ISO-2022-JP");
        mJdkToIanaMap.put("Cp278", "CP278");
        mJdkToIanaMap.put("Cp277", "IBM277");
        mJdkToIanaMap.put("Cp273", "CP273");
        mJdkToIanaMap.put("MS950", "BIG5");
        mJdkToIanaMap.put("8859_9", "ISO-8859-9");
        mJdkToIanaMap.put("8859_8", "ISO-8859-8");
        mJdkToIanaMap.put("Cp437", "CP437");
        mJdkToIanaMap.put("8859_7", "ISO-8859-7");
        mJdkToIanaMap.put("8859_6", "ISO-8859-6");
        mJdkToIanaMap.put("8859_5", "ISO-8859-5");
        mJdkToIanaMap.put("ISO2022CN", "ISO-2022-CN*");
        mJdkToIanaMap.put("UTF8", "UTF-8");
        mJdkToIanaMap.put("8859_4", "ISO-8859-4");
        mJdkToIanaMap.put("Big5", "BIG5");
        mJdkToIanaMap.put("8859_3", "ISO-8859-3");
        mJdkToIanaMap.put("8859_2", "ISO-8859-2");
        mJdkToIanaMap.put("8859_1", "ISO-8859-1");
        mJdkToIanaMap.put("EUC_KR", "EUC-KR");
        mJdkToIanaMap.put("Cp871", "CP871");
        mJdkToIanaMap.put("MS949", "EUC-KR");
        mJdkToIanaMap.put("Cp870", "CP870");
        mJdkToIanaMap.put("ISO8859_9", "ISO-8859-9");
        mJdkToIanaMap.put("KOI8_R", "KOI8-R");
        mJdkToIanaMap.put("ISO8859_8", "ISO-8859-8");
        mJdkToIanaMap.put("ISO8859_7", "ISO-8859-7");
        mJdkToIanaMap.put("ISO8859_6", "ISO-8859-6");
        mJdkToIanaMap.put("Cp869", "CP869");
        mJdkToIanaMap.put("Cp424", "CP424");
        mJdkToIanaMap.put("ISO8859_5", "ISO-8859-5");
        mJdkToIanaMap.put("Cp868", "CP868");
        mJdkToIanaMap.put("ISO8859_4", "ISO-8859-4");
        mJdkToIanaMap.put("ISO8859_3", "ISO-8859-3");
        mJdkToIanaMap.put("Cp866", "CP866");
        mJdkToIanaMap.put("ASCII", "US-ASCII");
        mJdkToIanaMap.put("ISO8859_2", "ISO8859-2");
        mJdkToIanaMap.put("Cp865", "CP865");
        mJdkToIanaMap.put("Cp420", "CP420");
        mJdkToIanaMap.put("ISO8859_1", "ISO-8859-1");
        mJdkToIanaMap.put("Cp864", "CP864");
        mJdkToIanaMap.put("Cp863", "CP863");
        mJdkToIanaMap.put("EUC_JP", "EUC-JP");
        mJdkToIanaMap.put("Cp862", "CP862");
        mJdkToIanaMap.put("Cp861", "CP861");
        mJdkToIanaMap.put("Cp860", "CP860");
        mJdkToIanaMap.put("Cp037", "CP037");
        mJdkToIanaMap.put("MS932", "SHIFT_JIS");
        mJdkToIanaMap.put("Cp918", "CP918");
        mJdkToIanaMap.put("MS874", "WINDOWS-874");
        mJdkToIanaMap.put("EUC_TW", "EUC-TW");
        mJdkToIanaMap.put("Cp857", "CP857");
        mJdkToIanaMap.put("Cp855", "CP855");
        mJdkToIanaMap.put("Cp852", "CP852");
        mJdkToIanaMap.put("EUCJIS", "EUC-JP");
        mJdkToIanaMap.put("Cp850", "CP850");
        mJdkToIanaMap.put("Cp1258", "WINDOWS-1258");
        mJdkToIanaMap.put("Cp1257", "WINDOWS-1257");
        mJdkToIanaMap.put("SJIS", "SHIFT_JIS");
        mJdkToIanaMap.put("Cp1256", "WINDOWS-1256");
        mJdkToIanaMap.put("KSC5601", "EUC-KR");
        mJdkToIanaMap.put("Cp1255", "WINDOWS-1255");
        mJdkToIanaMap.put("Cp1254", "WINDOWS-1254");
        mJdkToIanaMap.put("Cp1253", "WINDOWS-1253");
        mJdkToIanaMap.put("Cp1252", "WINDOWS-1252");
        mJdkToIanaMap.put("Cp1251", "WINDOWS-1251");
        mJdkToIanaMap.put("Cp1250", "WINDOWS-1250");
        mJdkToIanaMap.put("Cp297", "CP297");
        mJdkToIanaMap.put("ISO2022KR", "ISO-2022-KR*");
        mJdkToIanaMap.put("EUC_CN", "EUC-CN");
        mJdkToIanaMap.put("GBK", "GBK*");
        mJdkToIanaMap.put("Cp1026", "CP1026");
        mJdkToIanaMap.put("ISO2022JP", "ISO-2022-JP");
        mJdkToIanaMap.put("Cp285", "CP285");
        mJdkToIanaMap.put("Cp284", "CP284");
    }
}

