/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone;

import java.io.IOException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.dialogs.actions.RemoteDebug;
import oracle.dbtools.raptor.navigator.ContextSupport;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.utils.ProjectTracker;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;

public class RaptorContextSupport
extends ContextSupport
implements TreeSelectionListener {
    private TreePath[] m_sel = new TreePath[0];
    private Project m_currentProj;

    public Workspace getWorkspace() {
        return ProjectTracker.getGlobalWorkspace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProject(String string) {
        Class<RaptorContextSupport> clazz = RaptorContextSupport.class;
        synchronized (RaptorContextSupport.class) {
            Workspace workspace = this.getWorkspace();
            Project project = ProjectTracker.getProject((String)string);
            String string2 = RunConfigurations.getActiveName((Project)project, (Workspace)workspace);
            RunConfiguration runConfiguration = RunConfigurations.getRunConfigurationByName((Project)project, (String)string2);
            if (runConfiguration == null) {
                runConfiguration = new RunConfiguration();
                runConfiguration.setName(string2);
                RunConfigurations.addRunConfiguration((Project)project, (Workspace)workspace, (RunConfiguration)runConfiguration);
                RunConfigurations.setActiveRunConfiguration((Project)project, (Workspace)workspace, (RunConfiguration)runConfiguration);
                runConfiguration.setCompileBeforeRun(false);
                runConfiguration = RemoteDebug.getRemoteDebugConfiguration((Workspace)workspace, (Project)project);
                runConfiguration.setConnectionName(string);
                try {
                    project.save();
                    workspace.save();
                }
                catch (IOException iOException) {
                    Logger.severe(ContextSupport.class, (Throwable)iOException);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return project;
        }
    }

    public void attach(NavigatorWindow navigatorWindow) {
        navigatorWindow.getTree().getTree().addTreeSelectionListener((TreeSelectionListener)this);
    }

    public void updateContext(Context context) {
        context.setProject(this.m_currentProj);
        context.setWorkspace(this.getWorkspace());
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        AbstractConnectionNode abstractConnectionNode;
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
        TreePath[] treePathArray2 = new TreePath[this.m_sel.length + treePathArray.length];
        int n = 0;
        block4: for (TreePath treePath : this.m_sel) {
            for (TreePath treePath2 : treePathArray) {
                if (!treePath.equals(treePath2)) continue;
                if (treeSelectionEvent.isAddedPath(treePath2)) break;
                continue block4;
            }
            treePathArray2[n++] = treePath;
        }
        for (TreePath treePath : treePathArray) {
            if (!treeSelectionEvent.isAddedPath(treePath)) continue;
            treePathArray2[n++] = treePath;
        }
        if (n < treePathArray2.length) {
            abstractConnectionNode = treePathArray2;
            treePathArray2 = new TreePath[n];
            System.arraycopy(abstractConnectionNode, 0, treePathArray2, 0, n);
        }
        this.m_sel = treePathArray2;
        abstractConnectionNode = null;
        switch (this.m_sel.length) {
            case 0: {
                break;
            }
            case 1: {
                NavigatorTreeNode navigatorTreeNode = (NavigatorTreeNode)this.m_sel[0].getLastPathComponent();
                if (navigatorTreeNode == null) break;
                abstractConnectionNode = (AbstractConnectionNode)navigatorTreeNode.findAncestorElement(AbstractConnectionNode.class, true);
                break;
            }
            default: {
                for (TreePath treePath : this.m_sel) {
                    NavigatorTreeNode navigatorTreeNode = (NavigatorTreeNode)treePath.getLastPathComponent();
                    if (navigatorTreeNode == null) continue;
                    AbstractConnectionNode abstractConnectionNode2 = (AbstractConnectionNode)navigatorTreeNode.findAncestorElement(AbstractConnectionNode.class, true);
                    if (abstractConnectionNode == null) {
                        abstractConnectionNode = abstractConnectionNode2;
                        continue;
                    }
                    if (abstractConnectionNode2 == abstractConnectionNode) continue;
                    abstractConnectionNode = null;
                }
            }
        }
        this.m_currentProj = abstractConnectionNode != null ? this.getProject(abstractConnectionNode.getQualifiedConnectionName()) : null;
        this.getWorkspace().setActiveProject(this.m_currentProj);
    }
}

