/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone.actions;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.standalone.actions.ResetPasswordPanel;
import oracle.dbtools.raptor.standalone.connection.ConnectionUtils;
import oracle.dbtools.raptor.standalone.connection.RaptorConnectionCreator;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class ResetPasswordAction
extends AbstractMenuAction {
    private static final Logger LOGGER = Logger.getLogger(ResetPasswordAction.class.getName());
    private static Boolean s_ociAvailable;

    private static boolean isOCIAvailable() {
        if (s_ociAvailable == null) {
            s_ociAvailable = Connections.isOCIDriverAvailable();
        }
        return s_ociAvailable;
    }

    public boolean isEnabled(Context context) {
        boolean bl = false;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length == 1 && elementArray[0] instanceof DatabaseConnection) {
            bl = !((DatabaseConnection)elementArray[0]).isConnectionOpen() ? ResetPasswordAction.isOCIAvailable() : true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getConnectionName();
        Element element = dBObject.getElement();
        if (((DatabaseConnection)element).isConnectionOpen()) {
            bl2 = true;
        } else if (ResetPasswordAction.isOCIAvailable()) {
            bl3 = true;
        } else {
            return;
        }
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        String string2 = properties.getProperty("user");
        Connection connection = null;
        try {
            if (ResetPasswordPanel.promptForNewPassword(properties)) {
                Object object;
                Properties properties2 = new Properties();
                properties2.putAll((Map<?, ?>)properties);
                if (bl3) {
                    properties2.setProperty("customUrl", ConnectionUtils.getOCIUrl((Properties)properties2));
                    object = new RaptorConnectionCreator();
                    connection = object.getConnection(properties2);
                } else if (bl2) {
                    connection = dBObject.getConnection();
                    bl = this.setPassword(connection, properties2);
                } else {
                    return;
                }
                if (connection != null && (bl3 || bl2 && bl) && ModelUtil.areEqual((Object)string2, (Object)properties.getProperty("user")) && Boolean.valueOf(properties.getProperty("SavePassword", Boolean.TRUE.toString())).booleanValue()) {
                    properties.setProperty("password", properties.getProperty("OCINewPassword"));
                    properties.remove("OCINewPassword");
                    object = Connections.getStoreName((String)string);
                    String string3 = Connections.getConnectionName((String)string);
                    DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore((String)object);
                    try {
                        databaseConnections.updateConnection(string3, string3, properties, true);
                    }
                    catch (ConnectionException connectionException) {
                        LOGGER.log(Level.SEVERE, connectionException.getLocalizedMessage());
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Exception)sQLException, (String)string);
        }
        finally {
            if (connection != null && bl3) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setArgs(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setPassword(Connection connection, Properties properties) {
        boolean bl = true;
        Statement statement = null;
        String string = properties.getProperty("user");
        String string2 = properties.getProperty("password");
        String string3 = properties.getProperty("OCINewPassword");
        try {
            statement = connection.prepareStatement("alter user " + string + " identified by " + string3 + " replace " + string2);
            statement.executeUpdate();
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }
}

