/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.standalone.ExtrasArb;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public class ResetPasswordPanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1642744822415693833L;
    private JTextField m_fldUser = new JTextField();
    private JLabel m_lblOrigPasswd = new JLabel();
    private JPasswordField m_fldOrigPasswd = new JPasswordField();
    private JPasswordField m_fldNewPasswd = new JPasswordField();
    private JPasswordField m_fldConfirmpasswd = new JPasswordField();

    public ResetPasswordPanel() {
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_reset_expired_password_html");
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_fldUser, (String)CreateDialogArb.getString((String)"CONNECT_LABEL_USERNAME"));
        ResourceUtils.resLabel((JLabel)this.m_lblOrigPasswd, (Component)this.m_fldOrigPasswd, (String)ExtrasArb.getString((String)"RESET_PWD_CURR"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_fldNewPasswd, (String)CreateDialogArb.getString((String)"EXPIRE_PWD_NEW_PWD"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_fldConfirmpasswd, (String)CreateDialogArb.getString((String)"EXPIRE_PWD_CONFIRM_PWD"));
        this.m_fldUser.setColumns(30);
        this.add(jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_fldUser, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblOrigPasswd, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.m_fldOrigPasswd, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(jLabel2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.m_fldNewPasswd, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(jLabel3, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 5), 0, 0));
        this.add(this.m_fldConfirmpasswd, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(15, 0, 0, 0), 0, 0));
    }

    public void init(Properties properties) {
        String string = properties.getProperty("user");
        this.m_fldUser.setText(string != null ? string : "");
        this.m_fldOrigPasswd.setText("");
    }

    public static boolean promptForNewPassword(final Properties properties) {
        final ResetPasswordPanel resetPasswordPanel = new ResetPasswordPanel();
        resetPasswordPanel.init(properties);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)((Object)resetPasswordPanel), (Component)resetPasswordPanel.getInitialFocus(), (String)CreateDialogArb.getString((String)"EXPIRE_PASSWORD_TITLE"));
        jEWTDialog.setResizable(true);
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    try {
                        resetPasswordPanel.commit(properties);
                    }
                    catch (TraversalException traversalException) {
                        traversalException.showMessageDialog((Component)((Object)resetPasswordPanel));
                        throw new PropertyVetoException("no", propertyChangeEvent);
                    }
                }
            }
        });
        return WizardLauncher.runDialog((JDialog)jEWTDialog);
    }

    private JTextField getInitialFocus() {
        return ModelUtil.hasLength((String)this.m_fldUser.getText()) ? this.m_fldOrigPasswd : this.m_fldUser;
    }

    public void commit(Properties properties) throws TraversalException {
        String string = this.m_fldUser.getText();
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(ExtrasArb.getString((String)"RESET_PWD_MISSING_USERNAME"));
        }
        properties.setProperty("user", string);
        char[] cArray = this.m_fldOrigPasswd.getPassword();
        String string2 = cArray != null ? new String(cArray) : "";
        string2 = string2.trim();
        if (string2.length() == 0) {
            this.m_fldOrigPasswd.setText("");
            throw new TraversalException(ExtrasArb.getString((String)"RESET_PWD_MISSING_ORIG"));
        }
        properties.setProperty("password", string2);
        char[] cArray2 = this.m_fldNewPasswd.getPassword();
        String string3 = cArray2 != null ? new String(cArray2) : new String();
        string3 = string3.trim();
        if (string3.length() == 0) {
            this.m_fldNewPasswd.setText("");
            throw new TraversalException(CreateDialogArb.getString((String)"CONNECT_INFO_ERROR_PWD"));
        }
        char[] cArray3 = this.m_fldConfirmpasswd.getPassword();
        String string4 = cArray3 != null ? new String(cArray3) : new String();
        if ((string4 = string4.trim()).length() == 0) {
            this.m_fldConfirmpasswd.setText("");
            throw new TraversalException(CreateDialogArb.getString((String)"EXPIRE_PWD_ERROR_CONFIRM_PASSWD"));
        }
        if (!string3.equals(string4)) {
            throw new TraversalException(CreateDialogArb.getString((String)"EXPIRE_PWD_ERROR_CONFIRM_PWD_MISMATCH"));
        }
        properties.setProperty("OCINewPassword", string3);
    }
}

